/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.util;

import java.awt.Color;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class ColorParser {
    private static String[] colorNames = new String[]{"black", "blue", "cyan", "darkgray", "gray", "green", "lightgray", "magenta", "orange", "pink", "red", "white", "yellow"};
    private static Color[] colorValues = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    protected StreamTokenizer st;
    protected int currentToken;
    protected ParseException exception;
    protected Color color;

    public Color getColor() {
        return this.color;
    }

    public boolean parse(String string) {
        this.clear();
        StringReader stringReader = new StringReader(string);
        this.st = new StreamTokenizer(stringReader);
        return this.parse();
    }

    public boolean parse(StreamTokenizer streamTokenizer) {
        this.clear();
        this.st = streamTokenizer;
        return this.parse();
    }

    public ParseException getException() {
        return this.exception;
    }

    protected void clear() {
        this.color = null;
        this.exception = null;
        this.st = null;
    }

    protected boolean parse() {
        boolean bl = false;
        this.nextToken();
        try {
            this.parseColor();
        }
        catch (ParseException parseException) {
            bl = true;
            this.exception = parseException;
        }
        return bl;
    }

    protected void parseColor() throws ParseException {
        int n;
        int n2;
        if (this.currentToken == -3) {
            String string = this.st.sval;
            for (int i = 0; i < colorNames.length; ++i) {
                if (!colorNames[i].equalsIgnoreCase(string)) continue;
                this.color = colorValues[i];
                return;
            }
            throw new ParseException("Unrecognized color: " + string);
        }
        if (this.currentToken == -2) {
            n2 = (int)this.st.nval;
            this.nextToken();
            if (this.currentToken != -2) {
                throw new ParseException("green color value expected");
            }
            n = (int)this.st.nval;
            this.nextToken();
            if (this.currentToken != -2) {
                throw new ParseException("blue color value expected");
            }
        } else {
            throw new ParseException("color name or integer read component value expected");
        }
        int n3 = (int)this.st.nval;
        this.nextToken();
        this.color = new Color(n2, n, n3);
    }

    protected void nextToken() {
        try {
            this.currentToken = this.st.nextToken();
        }
        catch (IOException iOException) {
            this.currentToken = -1;
        }
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = -3238291717656084862L;

        public ParseException(String string) {
            super(string);
        }
    }
}

