/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import java.util.Enumeration;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import megamek.client.ui.AWT.boardview3d.MoveStepModel;
import megamek.client.ui.AWT.boardview3d.ViewTransform;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.MovePath;
import megamek.common.MoveStep;

class MoveGroup
extends BranchGroup {
    IGame game;
    ViewTransform currentView;
    MovePath cur;

    public MoveGroup(IGame iGame, ViewTransform viewTransform) {
        this.game = iGame;
        this.currentView = viewTransform;
        this.setCapability(14);
        this.setCapability(13);
        this.setPickable(false);
    }

    public void clear() {
        Enumeration enumeration = this.getAllChildren();
        while (enumeration.hasMoreElements()) {
            ((BranchGroup)enumeration.nextElement()).detach();
        }
        this.cur = null;
    }

    public void set(MovePath movePath) {
        this.clear();
        if (movePath == null) {
            return;
        }
        this.cur = movePath;
        IBoard iBoard = this.game.getBoard();
        int n = 0;
        Enumeration<MoveStep> enumeration = movePath.getSteps();
        while (enumeration.hasMoreElements()) {
            MoveStep moveStep = enumeration.nextElement();
            this.addChild((Node)new MoveStepModel(moveStep, n++, iBoard.getHex(moveStep.getPosition()), this.currentView));
        }
    }

    void setView(ViewTransform viewTransform) {
        this.currentView = viewTransform;
        this.set(this.cur);
    }
}

