/*
 * joystick plugin for VDR
 *
 * plugin.c - main plugin class
 *
 * Copyright (C) 2003 Andreas Regel <andreas.regel@powarman.de>
 *
 * This code is distributed under the terms and conditions of the
 * GNU GENERAL PUBLIC LICENSE. See the file COPYING for details.
 */

#include <getopt.h>
#include <vdr/plugin.h>

#include "joystick.h"
#include "mappings.h"
#include "setup.h"

static const char *VERSION       = "0.0.3";
static const char *DESCRIPTION   = "use a joystick as a remote.";
static const char *MAINMENUENTRY = NULL;

class cPluginJoystick : public cPlugin
{
private:
	// Add any member variables or functions you may need here.
	cJoystickRemote *joy;
public:
	cPluginJoystick(void);
	virtual ~cPluginJoystick();
	virtual const char *Version(void) { return VERSION; }
	virtual const char *Description(void) { return DESCRIPTION; }
	virtual const char *CommandLineHelp(void);
	virtual bool ProcessArgs(int argc, char *argv[]);
	virtual bool Start(void);
	virtual void Housekeeping(void);
	virtual const char *MainMenuEntry(void) { return MAINMENUENTRY; }
	virtual cOsdObject *MainMenuAction(void);
	virtual cMenuSetupPage *SetupMenu(void);
	virtual bool SetupParse(const char *Name, const char *Value);
};

cPluginJoystick::cPluginJoystick(void)
{
	// Initialize any member variables here.
	// DON'T DO ANYTHING ELSE THAT MAY HAVE SIDE EFFECTS, REQUIRE GLOBAL
	// VDR OBJECTS TO EXIST OR PRODUCE ANY OUTPUT!
}

cPluginJoystick::~cPluginJoystick()
{
	// Clean up after yourself!
}

const char *cPluginJoystick::CommandLineHelp(void)
{
	// Return a string that describes all known command line options.
	return "  -d DEV,   --device=DEV   use DEV as the joystick device (default is /dev/js0)\n";
}

bool cPluginJoystick::ProcessArgs(int argc, char *argv[])
{
	// Implement command line argument processing here if applicable.
	static struct option long_options[] = {
		{ "device", required_argument, NULL, 'd' },
		{ NULL }
	};

	int c;
	while ((c = getopt_long(argc, argv, "d:", long_options, NULL)) != -1)
	{
		switch (c)
		{
			case 'd':
				strcpy(JoystickSetup.device, optarg);
				break;
			default:
				return false;
		}
	}
	return true;
}

bool cPluginJoystick::Start(void)
{
	Mappings.Load(AddDirectory(cPlugin::ConfigDirectory("joystick"), "mappings.conf"), true);
	// Start any background activities the plugin shall perform.
	joy = new cJoystickRemote();
	return true;
}

void cPluginJoystick::Housekeeping(void)
{
	// Perform any cleanup or other regular tasks.
}

cOsdObject *cPluginJoystick::MainMenuAction(void)
{
	// Perform the action when selected from the main VDR menu.
	return NULL;
}

cMenuSetupPage *cPluginJoystick::SetupMenu(void)
{
	// Return a setup menu in case the plugin supports one.
	return NULL;
}

bool cPluginJoystick::SetupParse(const char *Name, const char *Value)
{
	// Parse your own setup parameters and store their values.
	return false;
}

VDRPLUGINCREATOR(cPluginJoystick); // Don't touch this!
