/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.lookup.InterpolatorStringLookup;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.apache.commons.text.lookup.StringLookupFactoryTest;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class InterpolatorStringLookupTest {
    private static final String TESTKEY = "TestKey";
    private static final String TESTKEY2 = "TestKey2";
    private static final String TESTVAL = "TestValue";

    @AfterAll
    public static void afterAll() {
        System.clearProperty(TESTKEY);
        System.clearProperty(TESTKEY2);
    }

    @BeforeAll
    public static void beforeAll() {
        System.setProperty(TESTKEY, TESTVAL);
        System.setProperty(TESTKEY2, TESTVAL);
    }

    private void assertLookupNotEmpty(StringLookup lookup, String key) {
        String value = lookup.lookup(key);
        Assertions.assertNotNull((Object)value);
        Assertions.assertFalse((boolean)value.isEmpty());
    }

    private void check(StringLookup lookup) {
        String value = lookup.lookup("sys:TestKey");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("env:PATH");
        Assertions.assertNotNull((Object)value);
        value = lookup.lookup("date:yyyy-MM-dd");
        Assertions.assertNotNull((Object)value, (String)"No Date");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String today = format.format(new Date());
        Assertions.assertEquals((Object)value, (Object)today);
        this.assertLookupNotEmpty(lookup, "java:version");
        this.assertLookupNotEmpty(lookup, "java:runtime");
        this.assertLookupNotEmpty(lookup, "java:vm");
        this.assertLookupNotEmpty(lookup, "java:os");
        this.assertLookupNotEmpty(lookup, "java:locale");
        this.assertLookupNotEmpty(lookup, "java:hardware");
    }

    @Test
    public void testLookup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, TESTVAL);
        InterpolatorStringLookup lookup = new InterpolatorStringLookup(StringLookupFactory.INSTANCE.mapStringLookup(map));
        String value = lookup.lookup(TESTKEY);
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("ctx:TestKey");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("sys:TestKey");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("BadKey");
        Assertions.assertNull((Object)value);
        value = lookup.lookup("ctx:TestKey");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
    }

    @Test
    public void testLookupKeys() {
        InterpolatorStringLookup lookup = new InterpolatorStringLookup((Map)null);
        Map stringLookupMap = lookup.getStringLookupMap();
        StringLookupFactoryTest.assertDefaultKeys(stringLookupMap);
    }

    @Test
    public void testLookupWithDefaultInterpolator() {
        this.check((StringLookup)new InterpolatorStringLookup());
    }

    @Test
    public void testLookupWithNullDefaultInterpolator() {
        this.check((StringLookup)new InterpolatorStringLookup((StringLookup)null));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)InterpolatorStringLookup.INSTANCE.lookup(null));
    }

    @Test
    public void testToString() {
        Assertions.assertFalse((boolean)new InterpolatorStringLookup().toString().isEmpty());
    }
}

