/*
 * Decompiled with CFR 0.152.
 */
package newsplugin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Locale;

public class News
implements Comparable<News> {
    public static final String TYPE_NONE = "None";
    public static final String TYPE_ALL = "All";
    public static final String TYPE_TV_BROWSER = "TV-Browser";
    public static final String TYPE_TV_ANDROID = "Android";
    public static final String TYPE_TV_DESKTOP = "Desktop";
    public static final String TYPE_TV_WEBSITE = "Website";
    private static final String LANGUAGE_SEPARATOR = "###de###_###en###";
    private Date mTime;
    private String mType;
    private String mAuthor;
    private String mTitle;
    private String mText;
    private String mEngTitle;
    private String mEngText;

    public News(Date time, String author, String type, String title, String text, String engTitle, String engText) {
        this.mTime = time;
        this.mAuthor = author;
        this.mType = type;
        this.mTitle = title;
        this.mText = text;
        this.mEngTitle = engTitle != null ? engTitle : "";
        this.mEngText = engText != null ? engText : "";
    }

    public Date getTime() {
        return this.mTime;
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public String getTitle() {
        if (this.mEngTitle.trim().length() > 0 && !Locale.getDefault().getLanguage().equals(Locale.GERMAN.getLanguage())) {
            return this.mEngTitle;
        }
        return this.mTitle;
    }

    public String getText() {
        if (this.mEngText.trim().length() > 0 && !Locale.getDefault().getLanguage().equals(Locale.GERMAN.getLanguage())) {
            return this.mEngText;
        }
        return this.mText;
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeObject(this.mTime);
        out.writeObject(String.valueOf(this.mAuthor) + ";;" + this.mType);
        if (this.mEngTitle.trim().length() > 0) {
            out.writeObject(String.valueOf(this.mTitle) + LANGUAGE_SEPARATOR + this.mEngTitle);
        } else {
            out.writeObject(this.mTitle);
        }
        if (this.mEngText.trim().length() > 0) {
            out.writeObject(String.valueOf(this.mText) + LANGUAGE_SEPARATOR + this.mEngText);
        } else {
            out.writeObject(this.mText);
        }
    }

    public static News readData(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        int n;
        Date time = (Date)in.readObject();
        String author = (String)in.readObject();
        String title = (String)in.readObject();
        String text = (String)in.readObject();
        String engTitle = null;
        String engText = null;
        String type = TYPE_NONE;
        if (author.contains(";;")) {
            String[] parts = author.split(";;");
            author = parts[0].trim();
            type = parts[1].trim();
        }
        if ((n = title.indexOf(LANGUAGE_SEPARATOR)) != -1) {
            engTitle = title.substring(n + LANGUAGE_SEPARATOR.length());
            title = title.substring(0, n);
        }
        if ((n = text.indexOf(LANGUAGE_SEPARATOR)) != -1) {
            engText = text.substring(n + LANGUAGE_SEPARATOR.length());
            text = text.substring(0, n);
        }
        return new News(time, author, type, title, text, engTitle, engText);
    }

    @Override
    public int compareTo(News other) {
        return this.mTime.compareTo(other.mTime);
    }

    public boolean isAcceptableType(String type) {
        boolean accept;
        boolean bl = accept = this.mType.equals(TYPE_NONE) || type.equals(TYPE_ALL);
        if (!accept) {
            accept = type.equals(TYPE_TV_BROWSER) ? this.mType.equals(TYPE_TV_BROWSER) || this.mType.equals(TYPE_TV_ANDROID) || this.mType.equals(TYPE_TV_DESKTOP) : this.mType.equals(type);
        }
        return accept;
    }
}

