/*
 * Decompiled with CFR 0.152.
 */
package util.ui.html;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class ExtendedHTMLDocument
extends HTMLDocument {
    protected static final HTML.Tag COMP_TAG = new HTML.Tag("comp"){};
    protected ArrayList<Component> mKnownCompList;

    public ExtendedHTMLDocument(StyleSheet ss) {
        super(ss);
    }

    public String createCompTag(Component comp) {
        int index;
        if (this.mKnownCompList == null) {
            this.mKnownCompList = new ArrayList();
        }
        if ((index = this.mKnownCompList.indexOf(comp)) == -1) {
            this.mKnownCompList.add(comp);
            index = this.mKnownCompList.size() - 1;
        }
        return "<" + COMP_TAG.toString() + " index=\"" + index + "\">";
    }

    @Override
    public HTMLEditorKit.ParserCallback getReader(int pos) {
        return this.getReader(pos, 0, 0, null);
    }

    @Override
    public HTMLEditorKit.ParserCallback getReader(int pos, int popDepth, int pushDepth, HTML.Tag insertTag) {
        return new ExtendedHTMLReader(pos, popDepth, pushDepth, insertTag);
    }

    protected void handleCompTag(HTML.Tag tag, MutableAttributeSet attributeSet, Vector<DefaultStyledDocument.ElementSpec> parseBuffer) {
        if (this.mKnownCompList == null) {
            return;
        }
        String indexAsString = (String)attributeSet.getAttribute("index");
        if (indexAsString != null) {
            try {
                int index = Integer.parseInt(indexAsString);
                Component comp = this.mKnownCompList.get(index);
                this.addComponent(parseBuffer, comp);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    protected void addComponent(Vector<DefaultStyledDocument.ElementSpec> parseBuffer, Component comp) {
        SimpleAttributeSet sas = new SimpleAttributeSet();
        sas.addAttribute(StyleConstants.ComponentAttribute, comp);
        sas.addAttribute(StyleConstants.NameAttribute, "component");
        DefaultStyledDocument.ElementSpec es = new DefaultStyledDocument.ElementSpec(sas.copyAttributes(), 3, new char[]{' '}, 0, 1);
        parseBuffer.addElement(es);
    }

    protected class ExtendedHTMLReader
    extends HTMLDocument.HTMLReader {
        private HTMLDocument.HTMLReader.TagAction mCompAction;

        public ExtendedHTMLReader(int offset, int popDepth, int pushDepth, HTML.Tag insertTag) {
            super(ExtendedHTMLDocument.this, offset, popDepth, pushDepth, insertTag);
            this.mCompAction = new HTMLDocument.HTMLReader.TagAction(){

                @Override
                public void start(HTML.Tag tag, MutableAttributeSet attributeSet) {
                    Vector pBuffer = ExtendedHTMLReader.this.parseBuffer;
                    ExtendedHTMLDocument.this.handleCompTag(tag, attributeSet, pBuffer);
                }
            };
            this.registerTag(COMP_TAG, this.mCompAction);
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attributeSet, int pos) {
            if (tag.toString().equals(COMP_TAG.toString())) {
                this.mCompAction.start(tag, attributeSet);
            } else {
                super.handleSimpleTag(tag, attributeSet, pos);
            }
        }
    }
}

