/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalToolTipUI;

public class ToolTipWithIcon
extends JToolTip {
    ImageIcon icon;

    public ToolTipWithIcon(ImageIcon icon) {
        this.icon = icon;
        this.setUI(new IconToolTipUI());
    }

    public ToolTipWithIcon(ImageIcon icon, String text) {
        this(icon);
        this.setTipText(text);
    }

    public ToolTipWithIcon(MetalToolTipUI toolTipUI) {
        this.setUI(toolTipUI);
    }

    private class IconToolTipUI
    extends MetalToolTipUI {
        private IconToolTipUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            FontMetrics metrics = c.getFontMetrics(c.getFont());
            Dimension size = c.getSize();
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
            g.setColor(c.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            int x = 3;
            if (ToolTipWithIcon.this.icon != null) {
                ToolTipWithIcon.this.icon.paintIcon(c, g, 1, 1);
                x += ToolTipWithIcon.this.icon.getIconWidth() + 1;
            }
            g.setColor(c.getForeground());
            String text = ((JToolTip)c).getTipText();
            if (text != null && text.length() > 0) {
                g.drawString(text, x, metrics.getHeight());
            }
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            String tipText = ((JToolTip)c).getTipText();
            if (ToolTipWithIcon.this.icon == null && (tipText == null || tipText.length() == 0)) {
                return new Dimension(0, 0);
            }
            FontMetrics metrics = c.getFontMetrics(c.getFont());
            if (tipText == null) {
                tipText = "";
            }
            int width = SwingUtilities.computeStringWidth(metrics, tipText);
            int height = metrics.getHeight() + 4;
            if (ToolTipWithIcon.this.icon != null) {
                width += ToolTipWithIcon.this.icon.getIconWidth() + 2;
                int iconHeight = ToolTipWithIcon.this.icon.getIconHeight() + 2;
                if (iconHeight > height) {
                    height = iconHeight;
                }
            }
            if (ToolTipWithIcon.this.icon != null && tipText.length() > 0) {
                width += 6;
            }
            if (ToolTipWithIcon.this.isMinimumSizeSet()) {
                Dimension minSize = ToolTipWithIcon.this.getMinimumSize();
                if (width < minSize.width) {
                    width = minSize.width;
                }
                if (height < minSize.height) {
                    height = minSize.height;
                }
            }
            return new Dimension(width, height);
        }
    }
}

