/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class LineNumberHeader
extends JComponent {
    private int maxLines = 0;
    private int borderWidth = 2;
    private boolean borderLine = false;
    private JTextComponent textComponent;
    private FontMetrics metrics;

    public LineNumberHeader(JTextComponent textArea, int borderWidth, boolean borderLine) {
        this(textArea);
        this.borderWidth = Math.max(0, borderWidth);
        this.borderLine = borderLine;
    }

    public LineNumberHeader(JTextComponent textArea) {
        this.textComponent = textArea;
        this.register();
    }

    private void register() {
        this.textComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LineNumberHeader.this.setLines();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LineNumberHeader.this.setLines();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LineNumberHeader.this.setLines();
            }
        });
        this.textComponent.addPropertyChangeListener("font", e -> this.setMetrics());
        this.setMetrics();
        this.setLines();
    }

    private void setMetrics() {
        Font refFont = null;
        Document doc = this.textComponent.getDocument();
        if (doc instanceof DefaultStyledDocument) {
            DefaultStyledDocument myDoc = (DefaultStyledDocument)doc;
            refFont = myDoc.getFont(myDoc.getDefaultRootElement().getElement(0).getAttributes());
        } else {
            refFont = this.textComponent.getFont();
        }
        this.metrics = this.textComponent.getFontMetrics(refFont);
        this.revalidate();
        this.repaint();
    }

    private void setLines() {
        int newLines = this.textComponent instanceof JTextArea ? ((JTextArea)this.textComponent).getLineCount() : this.textComponent.getDocument().getDefaultRootElement().getElementCount();
        if (newLines != this.maxLines) {
            if (newLines / 10 != this.maxLines / 10) {
                this.revalidate();
            }
            this.maxLines = newLines;
            this.repaint(this.getVisibleRect());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.metrics.stringWidth(Integer.toString(this.maxLines));
        int h = this.metrics.getHeight();
        return new Dimension(w + 2 * this.borderWidth, this.maxLines * h + this.textComponent.getMargin().top + this.textComponent.getMargin().bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        int start;
        super.paint(g);
        g.setFont(this.metrics.getFont());
        g.setColor(Color.DARK_GRAY);
        int w = this.metrics.stringWidth(Integer.toString(this.maxLines));
        int h = this.metrics.getHeight();
        int x = this.getWidth() - this.borderWidth - w;
        int y = this.textComponent.getMargin().top + this.metrics.getAscent();
        Rectangle rect = g.getClipBounds();
        if (rect.y > y) {
            y = rect.y / h * h + y;
        }
        if ((start = y / h) == 0) {
            start = 1;
        }
        int end = Math.min(this.maxLines, rect.height / h + start);
        for (int i = start; i <= end; ++i) {
            String s = Integer.toString(i);
            int sw = this.metrics.stringWidth(s);
            g.drawString(s, x + w - sw, y);
            y += h;
        }
        if (this.borderLine) {
            g.drawLine(this.getWidth() - 1, rect.y, this.getWidth() - 1, rect.y + rect.height);
        }
    }
}

