/*
 * Decompiled with CFR 0.152.
 */
package util.paramhandler;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import util.i18n.Localizer;
import util.paramhandler.ParamCheckDialog;
import util.paramhandler.ParamHelpDialog;
import util.paramhandler.ParamLibrary;
import util.ui.UiUtilities;

public class ParamInputField
extends JPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ParamInputField.class);
    private JTextArea mParamText;
    private ParamLibrary mParamLibrary;

    public ParamInputField(String text) {
        this(text, false);
    }

    public ParamInputField(String text, boolean singleLine) {
        this(new ParamLibrary(), text, singleLine);
    }

    public ParamInputField(ParamLibrary library, String text) {
        this(library, text, false);
    }

    public ParamInputField(ParamLibrary library, String text, boolean singleLine) {
        this.mParamLibrary = library;
        if (this.mParamLibrary == null) {
            this.mParamLibrary = new ParamLibrary();
        }
        this.createGui(text, singleLine);
    }

    private void createGui(String text, boolean singleLine) {
        FormLayout layout = new FormLayout("fill:min:grow, 3dlu, default, 3dlu, default, 3dlu, default", "fill:20dlu:grow, 3dlu, default");
        this.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        this.mParamText = new JTextArea();
        this.mParamText.setText(text);
        if (singleLine) {
            this.mParamText.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 10) {
                        ke.consume();
                    }
                }
            });
            JScrollPane scroll = new JScrollPane(this.mParamText, 20, 31);
            this.add((Component)scroll, cc.xyw(1, 1, layout.getColumnCount()));
        } else {
            this.mParamText.setLineWrap(true);
            this.add((Component)new JScrollPane(this.mParamText), cc.xyw(1, 1, layout.getColumnCount()));
        }
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(mLocalizer.msg("insert", "Insert"));
        List<String> functions = Arrays.asList(this.mParamLibrary.getPossibleFunctions());
        Collections.sort(functions);
        for (String string : functions) {
            items.add(string + "()");
        }
        List<String> keys = Arrays.asList(this.mParamLibrary.getPossibleKeys());
        Collections.sort(keys);
        for (String key : keys) {
            items.add(key);
        }
        JComboBox<String> jComboBox = new JComboBox<String>(items.toArray(new String[items.size()]));
        this.add(jComboBox, cc.xy(layout.getColumnCount() - 4, 3));
        jComboBox.addActionListener(e -> {
            if (insert.getSelectedIndex() > 0) {
                int selEnd;
                boolean inFunction = false;
                Object newText = insert.getSelectedItem().toString();
                int selStart = this.mParamText.getSelectionStart();
                if (selStart > 0) {
                    try {
                        if (this.mParamText.getText(selStart - 1, 1).equals("(")) {
                            inFunction = true;
                        }
                    }
                    catch (BadLocationException e11) {
                        e11.printStackTrace();
                    }
                }
                if ((selEnd = this.mParamText.getSelectionEnd()) < this.mParamText.getText().length()) {
                    try {
                        if (this.mParamText.getText(selEnd + 1, 1).equals(")")) {
                            inFunction = true;
                        }
                    }
                    catch (BadLocationException e12) {
                        e12.printStackTrace();
                    }
                }
                if (!inFunction) {
                    newText = "{" + (String)newText + "}";
                }
                this.mParamText.insert((String)newText, selStart);
                int lastBrace = ((String)newText).lastIndexOf(41);
                if (lastBrace > 0 && ((String)newText).length() - lastBrace <= 2) {
                    this.mParamText.setCaretPosition(this.mParamText.getSelectionStart() - (((String)newText).length() - lastBrace));
                }
                this.mParamText.requestFocus();
            }
        });
        JButton check = new JButton(mLocalizer.msg("check", "Check"));
        check.addActionListener(arg0 -> {
            Window bestparent = UiUtilities.getBestDialogParent(this);
            ParamCheckDialog dialog = new ParamCheckDialog(bestparent, this.mParamLibrary, this.mParamText.getText());
            dialog.setVisible(true);
        });
        this.add((Component)check, cc.xy(layout.getColumnCount() - 2, 3));
        JButton help = new JButton(Localizer.getLocalization("i18n_help"));
        help.addActionListener(e -> {
            Window bestparent = UiUtilities.getBestDialogParent(this);
            ParamHelpDialog dialog = new ParamHelpDialog(bestparent, this.mParamLibrary);
            dialog.setVisible(true);
        });
        this.add((Component)help, cc.xy(layout.getColumnCount(), 3));
    }

    public String getText() {
        return this.mParamText.getText();
    }

    public void setText(String text) {
        this.mParamText.setText(text);
    }

    @Override
    public String toString() {
        return this.getText();
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        this.mParamText.addFocusListener(listener);
    }
}

