/*
 * Decompiled with CFR 0.152.
 */
package util.io.stream;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.io.IOUtilities;
import util.io.stream.BufferedReaderProcessor;
import util.io.stream.BufferedWriterProcessor;
import util.io.stream.InputStreamProcessor;
import util.io.stream.ObjectInputStreamProcessor;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.OutputStreamProcessor;
import util.io.stream.PrintStreamProcessor;

public class StreamUtilities {
    private static final Logger LOG = Logger.getLogger(StreamUtilities.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void inputStream(IInputStreamMethod inputMethod, InputStreamProcessor processor) throws IOException {
        block19: {
            IOException processException = null;
            InputStream input = null;
            BufferedInputStream bufferedStream = null;
            try {
                input = inputMethod.openInputStream();
                bufferedStream = new BufferedInputStream(input);
                processor.process(bufferedStream);
            }
            catch (IOException e) {
                processException = e;
            }
            finally {
                if (bufferedStream != null) {
                    try {
                        bufferedStream.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (processException == null) break block19;
                throw processException;
            }
        }
    }

    public static void inputStream(final File file, InputStreamProcessor processor) throws IOException {
        StreamUtilities.inputStream(new IInputStreamMethod(){

            @Override
            public InputStream openInputStream() throws IOException {
                return new FileInputStream(file);
            }
        }, processor);
    }

    public static void inputStream(final URLConnection urlConnection, InputStreamProcessor processor) throws IOException {
        StreamUtilities.inputStream(new IInputStreamMethod(){

            @Override
            public InputStream openInputStream() throws IOException {
                return urlConnection.getInputStream();
            }
        }, processor);
    }

    public static void inputStream(final InputStream inputStream, InputStreamProcessor processor) throws IOException {
        StreamUtilities.inputStream(new IInputStreamMethod(){

            @Override
            public InputStream openInputStream() throws IOException {
                return inputStream;
            }
        }, processor);
    }

    public static void inputStreamIgnoringExceptions(String fileName, InputStreamProcessor processor) {
        StreamUtilities.inputStreamIgnoringExceptions(new File(fileName), processor);
    }

    public static void inputStreamIgnoringExceptions(File file, InputStreamProcessor processor) {
        try {
            StreamUtilities.inputStream(file, processor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void inputStream(String fileName, InputStreamProcessor processor) throws IOException {
        StreamUtilities.inputStream(new File(fileName), processor);
    }

    public static void inputStream(final URL url, InputStreamProcessor processor) throws IOException {
        StreamUtilities.inputStream(new IInputStreamMethod(){

            @Override
            public InputStream openInputStream() throws IOException {
                return IOUtilities.getStream(url);
            }
        }, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bufferedReader(File file, BufferedReaderProcessor processor) throws IOException {
        block19: {
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            IOException processException = null;
            try {
                fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                processor.process(bufferedReader);
            }
            catch (IOException e) {
                processException = e;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (processException == null) break block19;
                throw processException;
            }
        }
    }

    public static void bufferedReaderIgnoringExceptions(File file, BufferedReaderProcessor processor) {
        try {
            StreamUtilities.bufferedReader(file, processor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void bufferedReader(String fileName, BufferedReaderProcessor processor) throws IOException {
        StreamUtilities.bufferedReader(new File(fileName), processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outputStream(IOutputStreamMethod outputMethod, OutputStreamProcessor processor) throws IOException {
        block19: {
            IOException processException = null;
            OutputStream output = null;
            FilterOutputStream bufferedStream = null;
            try {
                output = outputMethod.openOutputStream();
                bufferedStream = new BufferedOutputStream(output);
                processor.process(bufferedStream);
            }
            catch (IOException e) {
                processException = e;
            }
            finally {
                if (bufferedStream != null) {
                    try {
                        bufferedStream.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (processException == null) break block19;
                throw processException;
            }
        }
    }

    public static void outputStream(final File file, OutputStreamProcessor processor) throws IOException {
        StreamUtilities.outputStream(new IOutputStreamMethod(){

            @Override
            public OutputStream openOutputStream() throws IOException {
                return new FileOutputStream(file);
            }
        }, processor);
    }

    public static void outputStream(String fileName, OutputStreamProcessor processor) throws IOException {
        StreamUtilities.outputStream(new File(fileName), processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void objectOutputStream(File file, ObjectOutputStreamProcessor processor) throws IOException {
        block26: {
            IOException processException = null;
            ObjectOutputStream objectStream = null;
            FileOutputStream fileStream = null;
            FilterOutputStream bufferedStream = null;
            try {
                fileStream = new FileOutputStream(file);
                bufferedStream = new BufferedOutputStream(fileStream);
                objectStream = new ObjectOutputStream(bufferedStream);
                processor.process(objectStream);
            }
            catch (IOException e) {
                processException = e;
            }
            finally {
                if (objectStream != null) {
                    try {
                        objectStream.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (bufferedStream != null) {
                    try {
                        bufferedStream.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (processException == null) break block26;
                throw processException;
            }
        }
    }

    public static void objectOutputStreamIgnoringExceptions(File file, ObjectOutputStreamProcessor processor) {
        try {
            StreamUtilities.objectOutputStream(file, processor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bufferedWriter(File file, BufferedWriterProcessor processor) throws IOException {
        block19: {
            FileWriter fileWriter = null;
            BufferedWriter bufferedWriter = null;
            IOException processException = null;
            try {
                fileWriter = new FileWriter(file);
                bufferedWriter = new BufferedWriter(fileWriter);
                processor.process(bufferedWriter);
            }
            catch (IOException e) {
                processException = e;
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (processException == null) break block19;
                throw processException;
            }
        }
    }

    public static void bufferedWriterIgnoringExceptions(File file, BufferedWriterProcessor processor) {
        try {
            StreamUtilities.bufferedWriter(file, processor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void objectInputStream(File file, ObjectInputStreamProcessor processor) throws IOException {
        StreamUtilities.objectInputStream(file, 0, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void objectInputStream(File file, int bufferSize, ObjectInputStreamProcessor processor) throws IOException {
        block26: {
            IOException processException = null;
            ObjectInputStream objectStream = null;
            FileInputStream fileStream = null;
            BufferedInputStream bufferedStream = null;
            try {
                fileStream = new FileInputStream(file);
                bufferedStream = bufferSize > 0 ? new BufferedInputStream(fileStream, bufferSize) : new BufferedInputStream(fileStream);
                objectStream = new ObjectInputStream(bufferedStream);
                processor.process(objectStream);
            }
            catch (IOException e) {
                processException = e;
            }
            finally {
                if (objectStream != null) {
                    try {
                        objectStream.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (bufferedStream != null) {
                    try {
                        bufferedStream.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (processException == null) break block26;
                throw processException;
            }
        }
    }

    public static void objectInputStreamIgnoringExceptions(File file, ObjectInputStreamProcessor processor) {
        StreamUtilities.objectInputStreamIgnoringExceptions(file, 0, processor);
    }

    public static void objectInputStreamIgnoringExceptions(File file, int bufferSize, ObjectInputStreamProcessor processor) {
        try {
            StreamUtilities.objectInputStream(file, bufferSize, processor);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Problem reading from file: " + file.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStream(File file, boolean autoFlush, String encoding, PrintStreamProcessor processor) throws IOException {
        block13: {
            IOException processException = null;
            PrintStream printStream = null;
            FileOutputStream fileStream = null;
            try {
                fileStream = new FileOutputStream(file);
                printStream = encoding != null ? new PrintStream((OutputStream)fileStream, autoFlush, encoding) : new PrintStream(fileStream, autoFlush);
                processor.process(printStream);
            }
            catch (IOException e) {
                processException = e;
            }
            finally {
                if (printStream != null) {
                    printStream.close();
                }
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (IOException e) {
                        processException = processException != null ? new IOException(processException) : e;
                    }
                }
                if (processException == null) break block13;
                throw processException;
            }
        }
    }

    public static void printStream(File file, PrintStreamProcessor processor) throws IOException {
        StreamUtilities.printStream(file, false, null, processor);
    }

    static interface IOutputStreamMethod {
        public OutputStream openOutputStream() throws IOException;
    }

    static interface IInputStreamMethod {
        public InputStream openInputStream() throws IOException;
    }
}

