/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ProgramFieldType;
import devplugin.ProgramInfoHelper;
import devplugin.SettingsTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.icontheme.InfoIconTheme;
import tvbrowser.core.icontheme.InfoThemeLoader;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.ui.filter.dlgs.EditFilterDlg;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.util.ColorButton;
import tvbrowser.ui.settings.util.ColorLabel;
import util.i18n.Localizer;
import util.settings.ProgramFieldTypeArrayProperty;
import util.settings.StringArrayProperty;
import util.ui.EnhancedPanelBuilder;
import util.ui.OrderChooser;
import util.ui.UiUtilities;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemRendererCenterComponentIf;

public class ProgramPanelSettingsTab
implements SettingsTab {
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(ProgramPanelSettingsTab.class);
    private static final String PICTURE_ICON_NAME = LOCALIZER.msg("hasPicure", "Has picture");
    private OrderChooser<IconPlugin> mIconPluginOCh;
    private OrderChooser<Object> mInfoTextOCh;
    private OrderChooser<IconPlugin> mIconPluginOChAlt;
    private OrderChooser<Object> mInfoTextOChAlt;
    private ColorLabel mProgramItemOnAirColorLb;
    private ColorLabel mProgramItemProgressColorLb;
    private ColorLabel mProgramItemKeyboardSelectedLb;
    private JCheckBox mAllowProgramImportance;
    private JCheckBox mBorderForOnAirPrograms;
    private JCheckBox mGradientHighlighting;
    private ArrayList<IconPlugin> mFormatIcons;
    private JCheckBox mHyphenator;
    private JCheckBox mShowOriginalTitles;
    private JCheckBox mSmootherScrolling;
    private JCheckBox mCutLongTitlesCB;
    private JSpinner mCutLongTitlesSelection;
    private JSpinner mDescriptionLines;
    private JLabel mCutLongTitlesLabel;
    private JCheckBox mShortProgramsCB;
    private JSpinner mShortProgramsMinutes;
    private JLabel mShortProgramsLabel;

    @Override
    public JPanel createSettingsPanel() {
        EnhancedPanelBuilder panel = new EnhancedPanelBuilder("5dlu, fill:50dlu:grow, 3dlu, fill:50dlu:grow, 3dlu");
        panel.border(Borders.DIALOG);
        panel.addSeparatorRow(LOCALIZER.msg("pluginIcons", "Plugin icons"), 1, 2);
        IconPlugin[] allPluginArr = this.getAvailableIconPlugins();
        IconPlugin[] pluginOrderArr = this.getSelectedIconPlugins(allPluginArr, Settings.ProgramPanel.ICON_PLUGINS);
        this.mIconPluginOCh = this.createIconPluginChooser(allPluginArr, pluginOrderArr);
        pluginOrderArr = this.getSelectedIconPlugins(allPluginArr, Settings.ProgramPanel.ICON_PLUGINS_ALTERNATIVE);
        this.mIconPluginOChAlt = this.createIconPluginChooser(allPluginArr, pluginOrderArr);
        panel.add(DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("infoText", "Info text")), 4, 2);
        ProgramFieldType[] allTypeArr = this.getAvailableTypes();
        ProgramFieldType[] typeOrderArr = Settings.ProgramPanel.INFO_FIELDS.getProgramFieldTypeArray();
        String[] separators = Settings.ProgramPanel.INFO_FIELDS_SEPARATORS.getStringArray();
        this.mInfoTextOCh = new OrderChooser<ProgramFieldType>(typeOrderArr, allTypeArr);
        for (int i = separators.length - 1; i >= 0; --i) {
            String[] splitSeparators;
            if (separators[i].replace(" ", "").length() <= 0) continue;
            for (String sep : splitSeparators = separators[i].split(";#;")) {
                if (sep.equals(" - ")) continue;
                this.mInfoTextOCh.addElement(sep, i + 1, true);
            }
        }
        JButton addLineBreak = new JButton(IconLoader.getInstance().getIconFromTheme("actions", "add-line-break", 22));
        addLineBreak.setToolTipText(LOCALIZER.msg("addLineBreakTooltip", "Adds line break"));
        addLineBreak.addActionListener(e -> this.mInfoTextOCh.addElement("\n", this.mInfoTextOCh.getSelectedIndex() + 1, true));
        this.mInfoTextOCh.addButton(addLineBreak);
        typeOrderArr = Settings.ProgramPanel.INFO_FIELDS_ALTERNATIVE.getProgramFieldTypeArray();
        separators = Settings.ProgramPanel.INFO_FIELDS_SEPARATORS_ALTERNATIVE.getStringArray();
        this.mInfoTextOChAlt = new OrderChooser<ProgramFieldType>(typeOrderArr, allTypeArr);
        JButton addLineBreakAlt = new JButton(IconLoader.getInstance().getIconFromTheme("actions", "add-line-break", 22));
        addLineBreakAlt.setToolTipText(LOCALIZER.msg("addLineBreakTooltip", "Adds line break"));
        addLineBreakAlt.addActionListener(e -> this.mInfoTextOChAlt.addElement("\n", this.mInfoTextOChAlt.getSelectedIndex() + 1, true));
        this.mInfoTextOChAlt.addButton(addLineBreakAlt);
        for (int i = separators.length - 1; i >= 0; --i) {
            String[] splitSeparators;
            if (separators[i].replace(" ", "").length() <= 0) continue;
            for (String sep : splitSeparators = separators[i].split(";#;")) {
                if (sep.equals(" - ")) continue;
                this.mInfoTextOChAlt.addElement(sep, i + 1, true);
            }
        }
        this.mShowOriginalTitles = new JCheckBox(LOCALIZER.msg("showOriginalTitles", "Show original title, if available, instead of title"), Settings.ProgramPanel.ORIGINIAL_TITLES_SHOW.getBoolean());
        EnhancedPanelBuilder filterPanel = new EnhancedPanelBuilder(new FormLayout("default", "default"));
        JButton editFilter = new JButton("Filter editieren...");
        editFilter.addActionListener(e -> {
            UserFilter filter = GenericFilterMap.getInstance().getGenericInternalFilter("_programPanel");
            EditFilterDlg editFilter1 = new EditFilterDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), FilterList.getInstance(), filter, false);
            if (editFilter1.getOkWasPressed()) {
                GenericFilterMap.getInstance().updateGenericInternalFilter("_programPanel", filter);
            }
        });
        filterPanel.addFull(editFilter);
        panel.addRow("top:default");
        panel.addRow();
        panel.add(UiUtilities.createHelpTextArea(LOCALIZER.msg("pluginIcons.description", "Select what icons will be shown in the program table below the start time.")), CC.xywh((int)2, (int)(panel.getRowCount() - 2), (int)1, (int)3));
        panel.add(UiUtilities.createHelpTextArea(LOCALIZER.msg("infoText.description", "Select the information and its order to show at the programs.")), CC.xyw((int)4, (int)(panel.getRowCount() - 2), (int)1));
        panel.add(this.mShowOriginalTitles, 4);
        panel.addSeparatorRow("Standard", 2, 3);
        panel.addGrowingRow(this.mIconPluginOCh, 2);
        panel.add(this.mInfoTextOCh, 4);
        panel.addSeparatorRow(LOCALIZER.msg("filterDisplay", "Alternative display with filter"), 2, 3);
        panel.addRow(filterPanel.getPanel(), 2, 3);
        panel.addGrowingRow(this.mIconPluginOChAlt, 2);
        panel.add(this.mInfoTextOChAlt, 4);
        panel.addParagraph(LOCALIZER.msg("layout", "Layout"));
        EnhancedPanelBuilder layoutPanel = new EnhancedPanelBuilder(new FormLayout("default,3dlu,default,3dlu,default"));
        this.mCutLongTitlesCB = new JCheckBox(LOCALIZER.msg("cutTitle", "Cut long titles"), Settings.ProgramPanel.TITLE_CUT.getBoolean());
        this.mCutLongTitlesSelection = new JSpinner(new SpinnerNumberModel(Settings.ProgramPanel.TITLE_CUT_LINES.getInt(), 1, 3, 1));
        this.mCutLongTitlesLabel = new JLabel(LOCALIZER.msg("lines", "Lines"));
        layoutPanel.addRow(false, (Component)this.mCutLongTitlesCB, 1);
        layoutPanel.add(this.mCutLongTitlesSelection, 3);
        layoutPanel.add(this.mCutLongTitlesLabel, 5);
        this.mCutLongTitlesCB.addActionListener(e -> {
            this.mCutLongTitlesSelection.setEnabled(this.mCutLongTitlesCB.isSelected());
            this.mCutLongTitlesLabel.setEnabled(this.mCutLongTitlesCB.isSelected());
        });
        this.mCutLongTitlesCB.getActionListeners()[0].actionPerformed(null);
        this.mDescriptionLines = new JSpinner(new SpinnerNumberModel(Settings.ProgramPanel.MAX_LINES.getInt(), 1, 5, 1));
        layoutPanel.addLabelRow("3dlu,default", LOCALIZER.msg("shortDescription", "Short description"), 1);
        layoutPanel.add(this.mDescriptionLines, 3);
        layoutPanel.add(new JLabel(LOCALIZER.msg("lines", "Lines")), 5);
        this.mShortProgramsCB = new JCheckBox(LOCALIZER.msg("shortPrograms", "If duration less than"), Settings.ProgramPanel.DESCRIPTION_LIMIT_BY_DURATION.getBoolean());
        this.mShortProgramsMinutes = new JSpinner(new SpinnerNumberModel(Settings.ProgramPanel.DESCRIPTION_LIMIT_BY_DURATION_MINUTES.getInt(), 1, 30, 1));
        this.mShortProgramsLabel = new JLabel(LOCALIZER.msg("shortPrograms2", "minutes, then hide description"));
        layoutPanel.addRow("3dlu,default", (Component)this.mShortProgramsCB, 1);
        layoutPanel.add(this.mShortProgramsMinutes, 3);
        layoutPanel.add(this.mShortProgramsLabel, 5);
        this.mShortProgramsCB.addActionListener(e -> {
            this.mShortProgramsMinutes.setEnabled(this.mShortProgramsCB.isSelected());
            this.mShortProgramsLabel.setEnabled(this.mShortProgramsCB.isSelected());
        });
        this.mShortProgramsCB.getActionListeners()[0].actionPerformed(null);
        panel.addRowFull(layoutPanel.getPanel(), 2);
        panel.addParagraph(LOCALIZER.msg("Colors", "Colors"));
        this.mGradientHighlighting = new JCheckBox(LOCALIZER.msg("color.programGradientHighlighting", "Highlight programs with gradient colors"), Settings.ProgramPanel.HIGHLIGHTING_COLOR_GRADIENT.getBoolean());
        panel.addRow(this.mGradientHighlighting, 2, 3);
        this.mAllowProgramImportance = new JCheckBox(LOCALIZER.msg("color.allowTransparency", "Allow plugins to set the transparency of a program"), Settings.ProgramPanel.TRANSPARENCY_ALLOW.getBoolean());
        panel.addRow(this.mAllowProgramImportance, 2, 3);
        this.mBorderForOnAirPrograms = new JCheckBox(LOCALIZER.msg("color.programOnAirWithBorder", "Border for programs on air"), Settings.ProgramPanel.BORDER_ON_AIR_PROGRAMS_SHOW.getBoolean());
        panel.addRow(this.mBorderForOnAirPrograms, 2, 3);
        EnhancedPanelBuilder colors = new EnhancedPanelBuilder(new FormLayout("default, 5dlu, default, 5dlu, default, 5dlu, default"));
        Color programItemProgressColor = Settings.ProgramPanel.COLOR_ON_AIR_DARK.getColor();
        Color programItemOnAirColor = Settings.ProgramPanel.COLOR_ON_AIR_LIGHT.getColor();
        Color programItemKeyboardSelectedColor = Settings.ProgramPanel.COLOR_KEYBOARD_SELECTED.getColor();
        Color programItemDefaultProgressColor = Settings.ProgramPanel.COLOR_ON_AIR_DARK.getDefaultColor();
        Color programItemDefaultOnAirColor = Settings.ProgramPanel.COLOR_ON_AIR_LIGHT.getDefaultColor();
        Color programItemDefaultKeyboardSelectedColor = Settings.ProgramPanel.COLOR_KEYBOARD_SELECTED.getDefaultColor();
        colors.addLabelRow(LOCALIZER.msg("color.programOnAir", "Background color for programs on air"), 1);
        this.mProgramItemOnAirColorLb = new ColorLabel(programItemOnAirColor);
        colors.add(this.mProgramItemOnAirColorLb, 3);
        this.mProgramItemOnAirColorLb.setStandardColor(programItemDefaultOnAirColor);
        colors.add(new ColorButton(this.mProgramItemOnAirColorLb), 5);
        colors.addLabelRow("3dlu, default", LOCALIZER.msg("color.programProgress", "Progress bar for programs on air"), 1);
        this.mProgramItemProgressColorLb = new ColorLabel(programItemProgressColor);
        colors.add(this.mProgramItemProgressColorLb, 3);
        this.mProgramItemProgressColorLb.setStandardColor(programItemDefaultProgressColor);
        colors.add(new ColorButton(this.mProgramItemProgressColorLb), 5);
        colors.addLabelRow("3dlu, default", LOCALIZER.msg("color.keyboardSelected", "Color for programs selected by keyboard"), 1);
        this.mProgramItemKeyboardSelectedLb = new ColorLabel(programItemKeyboardSelectedColor);
        colors.add(this.mProgramItemKeyboardSelectedLb, 3);
        this.mProgramItemKeyboardSelectedLb.setStandardColor(programItemDefaultKeyboardSelectedColor);
        colors.add(new ColorButton(this.mProgramItemKeyboardSelectedLb), 5);
        panel.addRow(colors.getPanel(), 2, panel.getColumnCount() - 1);
        JEditorPane programTableLink = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("programTableLink", "<html>Font color configurable in <a href=\"\">program table settings</a></html>"), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    PluginManagerImpl.getInstance().showSettings("#programtablelook");
                }
            }
        });
        panel.addRowFull(programTableLink, 2);
        panel.addParagraph(LOCALIZER.msg("text", "Text"));
        this.mHyphenator = new JCheckBox(LOCALIZER.msg("hyphenation", "Use hyphenation"), Settings.ProgramPanel.HYPHENATION.getBoolean());
        panel.addRow(this.mHyphenator, 2, panel.getColumnCount() - 1);
        panel.addParagraph(LOCALIZER.msg("scrolling", "Scrolling"));
        this.mSmootherScrolling = new JCheckBox(LOCALIZER.msg("scrolling.smoother", "Smoother scrolling in lists with programs"), Settings.ProgramPanel.SMOOTHER_SCROLLING.getBoolean());
        panel.addRow(this.mSmootherScrolling, 2, panel.getColumnCount() - 1);
        return panel.getPanel();
    }

    private OrderChooser<IconPlugin> createIconPluginChooser(IconPlugin[] allPluginArr, IconPlugin[] pluginOrderArr) {
        return new OrderChooser<IconPlugin>(pluginOrderArr, allPluginArr, IconPlugin.class, new SelectableItemRendererCenterComponentIf<IconPlugin>(){
            private DefaultListCellRenderer mRenderer = new DefaultListCellRenderer();

            @Override
            public JPanel createCenterPanel(JList<? extends SelectableItem<IconPlugin>> list, IconPlugin value, int index, boolean isSelected, boolean isEnabled, JScrollPane parentScrollPane, int leftColumnWidth) {
                DefaultListCellRenderer label = (DefaultListCellRenderer)this.mRenderer.getListCellRendererComponent(list, value, index, isSelected, false);
                IconPlugin iconPlugin = value;
                label.setIcon(iconPlugin.getIcon());
                label.setHorizontalAlignment(10);
                label.setVerticalAlignment(0);
                label.setOpaque(false);
                JPanel panel = new JPanel(new BorderLayout());
                if (isSelected && isEnabled) {
                    panel.setOpaque(true);
                    panel.setForeground(list.getSelectionForeground());
                    panel.setBackground(list.getSelectionBackground());
                } else {
                    panel.setOpaque(false);
                    panel.setForeground(list.getForeground());
                    panel.setBackground(list.getBackground());
                }
                panel.add((Component)label, "West");
                return panel;
            }

            @Override
            public void calculateSize(JList<? extends SelectableItem<IconPlugin>> list, int index, JPanel contentPane) {
            }
        });
    }

    private IconPlugin[] getAvailableIconPlugins() {
        ArrayList<IconPlugin> list = new ArrayList<IconPlugin>();
        list.addAll(this.getFormatIconNames());
        list.add(new IconPlugin(PICTURE_ICON_NAME, (Icon)InfoThemeLoader.getInstance().getIconThemeForIDOrDefault(Settings.LookAndFeel.INFO_ICON_THEME_ID.getString()).getInfoIcon(InfoIconTheme.INFO_HAS_PICTURE)));
        for (PluginProxy plugin : PluginProxyManager.getInstance().getActivatedPlugins()) {
            String iconText = plugin.getProgramTableIconText();
            if (iconText == null) continue;
            Icon[] icons = plugin.getProgramTableIcons(PluginManagerImpl.getInstance().getExampleProgram());
            Icon icon = icons != null && icons.length > 0 ? icons[0] : null;
            list.add(new IconPlugin(plugin, icon));
        }
        return list.toArray(new IconPlugin[list.size()]);
    }

    private IconPlugin[] getSelectedIconPlugins(IconPlugin[] allArr, StringArrayProperty prop) {
        String[] selPluginArr = prop.getStringArray();
        ArrayList<IconPlugin> list = new ArrayList<IconPlugin>();
        for (String selectedPluginId : selPluginArr) {
            for (IconPlugin iconPlugin : allArr) {
                String pluginId = iconPlugin.getId();
                if (!selectedPluginId.equals(pluginId)) continue;
                list.add(iconPlugin);
                break;
            }
            if (!selectedPluginId.equals("info.id")) continue;
            list.addAll(this.getFormatIconNames());
        }
        return list.toArray(new IconPlugin[list.size()]);
    }

    private List<IconPlugin> getFormatIconNames() {
        if (this.mFormatIcons == null) {
            this.mFormatIcons = new ArrayList();
            Icon[] infoIcons = ProgramInfoHelper.getInfoIcons();
            String[] infoMessages = ProgramInfoHelper.getInfoIconMessages();
            for (int i = 0; i < infoIcons.length; ++i) {
                if (infoIcons[i] == null) continue;
                this.mFormatIcons.add(new IconPlugin(LOCALIZER.msg("formatIcon", "Format: {0}", infoMessages[i]), infoIcons[i]));
            }
        }
        return this.mFormatIcons;
    }

    private ProgramFieldType[] getAvailableTypes() {
        ArrayList<ProgramFieldType> typeList = new ArrayList<ProgramFieldType>();
        Iterator<ProgramFieldType> typeIter = ProgramFieldType.getTypeIterator();
        while (typeIter.hasNext()) {
            ProgramFieldType type = typeIter.next();
            if (type.getFormat() == 2 || type == ProgramFieldType.INFO_TYPE || type == ProgramFieldType.PICTURE_DESCRIPTION_TYPE || type == ProgramFieldType.PICTURE_COPYRIGHT_TYPE) continue;
            typeList.add(type);
        }
        return typeList.toArray(new ProgramFieldType[typeList.size()]);
    }

    private void savePluginIcons(OrderChooser<IconPlugin> chooser, StringArrayProperty prop) {
        List<IconPlugin> iconPluginArr = chooser.getOrderList();
        String[] pluginIdArr = new String[iconPluginArr.size()];
        for (int i = 0; i < iconPluginArr.size(); ++i) {
            pluginIdArr[i] = iconPluginArr.get(i).getId();
        }
        prop.setStringArray(pluginIdArr);
    }

    private void saveInfoText(OrderChooser<Object> chooser, ProgramFieldTypeArrayProperty prop, StringArrayProperty separators) {
        List<Object> infoFieldArr = chooser.getOrderList();
        ArrayList<ProgramFieldType> fieldTypeList = new ArrayList<ProgramFieldType>();
        ArrayList<String> separatorList = new ArrayList<String>();
        for (int i = 0; i < infoFieldArr.size(); ++i) {
            if (!(infoFieldArr.get(i) instanceof ProgramFieldType)) continue;
            fieldTypeList.add((ProgramFieldType)infoFieldArr.get(i));
            if (i >= infoFieldArr.size() - 1) continue;
            if (infoFieldArr.get(i + 1) instanceof String) {
                StringBuilder separator = new StringBuilder();
                separator.append(infoFieldArr.get(++i));
                int j = i + 1;
                while (j < infoFieldArr.size() && infoFieldArr.get(j) instanceof String) {
                    separator.append(";#;").append(infoFieldArr.get(j));
                    ++j;
                    ++i;
                }
                separatorList.add(separator.toString());
                continue;
            }
            separatorList.add(" - ");
        }
        prop.setProgramFieldTypeArray(fieldTypeList.toArray(new ProgramFieldType[fieldTypeList.size()]));
        separators.setStringArray(separatorList.toArray(new String[separatorList.size()]));
    }

    @Override
    public void saveSettings() {
        this.savePluginIcons(this.mIconPluginOCh, Settings.ProgramPanel.ICON_PLUGINS);
        this.savePluginIcons(this.mIconPluginOChAlt, Settings.ProgramPanel.ICON_PLUGINS_ALTERNATIVE);
        this.saveInfoText(this.mInfoTextOCh, Settings.ProgramPanel.INFO_FIELDS, Settings.ProgramPanel.INFO_FIELDS_SEPARATORS);
        this.saveInfoText(this.mInfoTextOChAlt, Settings.ProgramPanel.INFO_FIELDS_ALTERNATIVE, Settings.ProgramPanel.INFO_FIELDS_SEPARATORS_ALTERNATIVE);
        Settings.ProgramPanel.ORIGINIAL_TITLES_SHOW.setBoolean(this.mShowOriginalTitles.isSelected());
        Settings.ProgramPanel.BORDER_ON_AIR_PROGRAMS_SHOW.setBoolean(this.mBorderForOnAirPrograms.isSelected());
        Settings.ProgramPanel.HIGHLIGHTING_COLOR_GRADIENT.setBoolean(this.mGradientHighlighting.isSelected());
        Settings.ProgramPanel.COLOR_ON_AIR_DARK.setColor(this.mProgramItemProgressColorLb.getColor());
        Settings.ProgramPanel.COLOR_ON_AIR_LIGHT.setColor(this.mProgramItemOnAirColorLb.getColor());
        Settings.ProgramPanel.COLOR_KEYBOARD_SELECTED.setColor(this.mProgramItemKeyboardSelectedLb.getColor());
        Settings.ProgramPanel.TRANSPARENCY_ALLOW.setBoolean(this.mAllowProgramImportance.isSelected());
        Settings.ProgramPanel.HYPHENATION.setBoolean(this.mHyphenator.isSelected());
        Settings.ProgramPanel.SMOOTHER_SCROLLING.setBoolean(this.mSmootherScrolling.isSelected());
        Settings.ProgramPanel.TITLE_CUT.setBoolean(this.mCutLongTitlesCB.isSelected());
        Settings.ProgramPanel.TITLE_CUT_LINES.setInt((Integer)this.mCutLongTitlesSelection.getValue());
        Settings.ProgramPanel.MAX_LINES.setInt((Integer)this.mDescriptionLines.getValue());
        Settings.ProgramPanel.DESCRIPTION_LIMIT_BY_DURATION.setBoolean(this.mShortProgramsCB.isSelected());
        Settings.ProgramPanel.DESCRIPTION_LIMIT_BY_DURATION_MINUTES.setInt((Integer)this.mShortProgramsMinutes.getValue());
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Program display");
    }

    private static class IconPlugin {
        private PluginProxy mPlugin;
        private String mName;
        private Icon mIcon;

        public IconPlugin(PluginProxy plugin, Icon icon) {
            this.mPlugin = plugin;
            this.mIcon = icon;
        }

        public Icon getIcon() {
            return this.mIcon;
        }

        public IconPlugin(String name, Icon icon) {
            this.mName = name;
            this.mPlugin = null;
            this.mIcon = icon;
        }

        public String getId() {
            if (this.mPlugin != null) {
                return this.mPlugin.getId();
            }
            if (this.mName != null && this.mName.compareTo(PICTURE_ICON_NAME) == 0) {
                return "picture.id";
            }
            Icon[] infoIcons = ProgramInfoHelper.getInfoIcons();
            String[] infoMessages = ProgramInfoHelper.getInfoIconMessages();
            for (int i = 0; i < infoIcons.length; ++i) {
                if (infoIcons[i] == null || !LOCALIZER.msg("formatIcon", "Format: {0}", infoMessages[i]).equals(this.mName)) continue;
                return "FORMAT_" + i;
            }
            return null;
        }

        public String toString() {
            if (this.mPlugin != null) {
                return this.mPlugin.getProgramTableIconText();
            }
            return this.mName;
        }
    }
}

