/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.CancelableSettingsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import tvbrowser.core.PluginLoader;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.io.IOUtilities;
import util.ui.CustomComboBoxRenderer;
import util.ui.EnhancedPanelBuilder;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemList;
import util.ui.customizableitems.SelectableItemRendererCenterComponentIf;

public class LocaleSettingsTab
implements CancelableSettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(LocaleSettingsTab.class);
    private static final Logger LOG = Logger.getLogger(LocaleSettingsTab.class.getName());
    private JPanel mSettingsPn;
    private JComboBox<Object> mLanguageCB;
    private JComboBox<String> mTimezoneCB;
    private JComboBox<Object> mFirstDayOfWeek;
    private JLabel mTimezoneLB;
    private JRadioButton mTwelveHourFormat;
    private JRadioButton mTwentyfourHourFormat;
    private static boolean SOMETHING_CHANGED = false;
    private static int START_LANGUAGE_INDEX;
    private static int START_TIME_ZONE_INDEX;
    private static boolean TWELVE_HOUR_FORMAT_IS_SELECTED;
    private static int FIRST_DAY_OF_WEEK_INDEX;

    @Override
    public JPanel createSettingsPanel() {
        this.mSettingsPn = new JPanel((LayoutManager)new FormLayout("5dlu, pref, 3dlu, default, 5dlu, default, fill:3dlu:grow, 3dlu", "default, 5dlu, default, 10dlu, default, 5dlu, default, 10dlu, default, 5dlu, default, 2dlu, default, 10dlu, default, 5dlu, default, fill:3dlu:grow, default"));
        this.mSettingsPn.setBorder(Borders.DIALOG);
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("titleLanguage", "Locale")), CC.xyw((int)1, (int)1, (int)7));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("language", "Language:")), CC.xy((int)2, (int)3));
        Locale[] allLocales = LOCALIZER.getAllAvailableLocales();
        ArrayList<Locale> localesList = new ArrayList<Locale>(Arrays.asList(allLocales));
        this.mLanguageCB = new JComboBox<Locale>(allLocales);
        this.mSettingsPn.add(this.mLanguageCB, CC.xy((int)4, (int)3));
        this.mLanguageCB.setRenderer(new CustomComboBoxRenderer(this.mLanguageCB.getRenderer()){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object name = ((Locale)value).getDisplayName((Locale)value);
                name = String.valueOf(((String)name).charAt(0)).toUpperCase() + ((String)name).substring(1);
                return this.getBackendRenderer().getListCellRendererComponent(list, name, index, isSelected, cellHasFocus);
            }
        });
        JButton downloadLanguages = new JButton(LOCALIZER.msg("downloadLanguages", "Install additional languages"));
        downloadLanguages.addActionListener(e -> this.downloadAdditionalLanguages());
        this.mSettingsPn.add((Component)downloadLanguages, CC.xy((int)6, (int)3));
        this.selectLanguageFromSettings(localesList);
        Object[] zoneIds = new String[]{};
        try {
            zoneIds = TimeZone.getAvailableIDs();
            Arrays.sort(zoneIds);
        }
        catch (Exception e2) {
            int i;
            zoneIds = new String[24];
            zoneIds[12] = "GMT+0";
            for (i = 0; i < 12; ++i) {
                zoneIds[i] = "GMT-" + Math.abs(i - 12);
            }
            for (i = 1; i < 12; ++i) {
                zoneIds[i + 12] = "GMT+" + i;
            }
            LOG.log(Level.INFO, "TimeZone IDs not available, use default values", e2);
        }
        this.mTimezoneCB = new JComboBox<Object>(zoneIds);
        this.selectTimeZoneFromSettings((String[])zoneIds);
        this.mTimezoneLB = new JLabel(LOCALIZER.msg("timezone", "Timezone:"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("titleTimezone", "Locale")), CC.xyw((int)1, (int)5, (int)7));
        this.mSettingsPn.add((Component)this.mTimezoneLB, CC.xy((int)2, (int)7));
        this.mSettingsPn.add(this.mTimezoneCB, CC.xyw((int)4, (int)7, (int)3));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("titleTimeFormat", "Time format")), CC.xyw((int)1, (int)9, (int)7));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("timeFormat", "Time format:")), CC.xy((int)2, (int)11));
        this.mTwentyfourHourFormat = new JRadioButton(LOCALIZER.msg("twentyFour", "24 hour format"));
        this.mTwelveHourFormat = new JRadioButton(LOCALIZER.msg("twelve", "12 hour format"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.mTwentyfourHourFormat);
        group.add(this.mTwelveHourFormat);
        this.mSettingsPn.add((Component)this.mTwentyfourHourFormat, CC.xy((int)4, (int)11));
        this.mSettingsPn.add((Component)this.mTwelveHourFormat, CC.xy((int)4, (int)13));
        if (Settings.Locales.TWELVE_HOUR_FORMAT.getBoolean()) {
            this.mTwelveHourFormat.setSelected(true);
        } else {
            this.mTwentyfourHourFormat.setSelected(true);
        }
        this.mFirstDayOfWeek = new JComboBox();
        this.mFirstDayOfWeek.addItem(2);
        this.mFirstDayOfWeek.addItem(3);
        this.mFirstDayOfWeek.addItem(4);
        this.mFirstDayOfWeek.addItem(5);
        this.mFirstDayOfWeek.addItem(6);
        this.mFirstDayOfWeek.addItem(7);
        this.mFirstDayOfWeek.addItem(1);
        this.mFirstDayOfWeek.setRenderer(new CustomComboBoxRenderer(this.mFirstDayOfWeek.getRenderer()){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Calendar cal = Calendar.getInstance();
                cal.set(7, (Integer)value);
                return this.getBackendRenderer().getListCellRendererComponent(list, cal.getDisplayName(7, 2, Locale.getDefault()), index, isSelected, cellHasFocus);
            }
        });
        this.mFirstDayOfWeek.setSelectedItem(Settings.Locales.FIRST_DAY_OF_WEEK.getInt());
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("firstDayOfWeek", "First day of week")), CC.xyw((int)1, (int)15, (int)7));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("firstDayOfWeek", "First day of week") + ":"), CC.xy((int)2, (int)17));
        this.mSettingsPn.add(this.mFirstDayOfWeek, CC.xyw((int)4, (int)17, (int)3));
        if (!SOMETHING_CHANGED) {
            START_LANGUAGE_INDEX = this.mLanguageCB.getSelectedIndex();
            START_TIME_ZONE_INDEX = this.mTimezoneCB.getSelectedIndex();
            TWELVE_HOUR_FORMAT_IS_SELECTED = this.mTwelveHourFormat.isSelected();
            FIRST_DAY_OF_WEEK_INDEX = this.mFirstDayOfWeek.getSelectedIndex();
        }
        ItemListener itemListener = e -> {
            SOMETHING_CHANGED = this.mLanguageCB.getSelectedIndex() != START_LANGUAGE_INDEX || this.mTimezoneCB.getSelectedIndex() != START_TIME_ZONE_INDEX || TWELVE_HOUR_FORMAT_IS_SELECTED && !this.mTwelveHourFormat.isSelected() || !TWELVE_HOUR_FORMAT_IS_SELECTED && !this.mTwentyfourHourFormat.isSelected() || this.mFirstDayOfWeek.getSelectedIndex() != FIRST_DAY_OF_WEEK_INDEX;
            Settings.setRestartInfo(LocaleSettingsTab.class.getCanonicalName(), SOMETHING_CHANGED);
        };
        this.mLanguageCB.addItemListener(itemListener);
        this.mTimezoneCB.addItemListener(itemListener);
        this.mTwelveHourFormat.addItemListener(itemListener);
        this.mTwentyfourHourFormat.addItemListener(itemListener);
        this.mFirstDayOfWeek.addItemListener(itemListener);
        return this.mSettingsPn;
    }

    private void selectLanguageFromSettings(ArrayList<Locale> localesList) {
        String variant;
        String country;
        String language;
        Locale loc;
        if (localesList == null) {
            Locale[] allLocales = LOCALIZER.getAllAvailableLocales();
            localesList = new ArrayList<Locale>(Arrays.asList(allLocales));
        }
        if (localesList.contains(loc = new Locale(language = Settings.Locales.LANGUAGE.getString(), country = Settings.Locales.COUNTRY.getString(), variant = Settings.Locales.VARIANT.getString()))) {
            this.mLanguageCB.setSelectedItem(loc);
        } else {
            loc = new Locale(language, country);
            if (localesList.contains(loc)) {
                this.mLanguageCB.setSelectedItem(loc);
            } else {
                loc = new Locale(language);
                if (localesList.contains(loc)) {
                    this.mLanguageCB.setSelectedItem(loc);
                }
            }
        }
    }

    private void selectTimeZoneFromSettings(String[] zoneIds) {
        String zone;
        if (zoneIds == null) {
            zoneIds = new String[]{};
            try {
                zoneIds = TimeZone.getAvailableIDs();
                Arrays.sort(zoneIds);
            }
            catch (Exception e) {
                int i;
                zoneIds = new String[24];
                zoneIds[12] = "GMT+0";
                for (i = 0; i < 12; ++i) {
                    zoneIds[i] = "GMT-" + Math.abs(i - 12);
                }
                for (i = 1; i < 12; ++i) {
                    zoneIds[i + 12] = "GMT+" + i;
                }
                LOG.log(Level.INFO, "TimeZone IDs not available, use default values", e);
            }
        }
        if ((zone = Settings.Locales.TIMEZONE.getString()) == null) {
            try {
                zone = TimeZone.getDefault().getID();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < zoneIds.length; ++i) {
            if (!zoneIds[i].equals(zone)) continue;
            this.mTimezoneCB.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public void saveSettings() {
        Locale loc = (Locale)this.mLanguageCB.getSelectedItem();
        Settings.Locales.LANGUAGE.setString(loc.getLanguage());
        Settings.Locales.COUNTRY.setString(loc.getCountry());
        Settings.Locales.VARIANT.setString(loc.getVariant());
        try {
            Settings.Locales.TIMEZONE.setString((String)this.mTimezoneCB.getSelectedItem());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Settings.Locales.TWELVE_HOUR_FORMAT.setBoolean(this.mTwelveHourFormat.isSelected());
        if (SOMETHING_CHANGED) {
            PluginLoader.getInstance().deleteAllPluginProxies();
        }
        Settings.Locales.FIRST_DAY_OF_WEEK.setInt((Integer)this.mFirstDayOfWeek.getSelectedItem());
    }

    @Override
    public void cancel() {
        this.selectLanguageFromSettings(null);
        this.selectTimeZoneFromSettings(null);
        SOMETHING_CHANGED = this.mLanguageCB.getSelectedIndex() != START_LANGUAGE_INDEX || this.mTimezoneCB.getSelectedIndex() != START_TIME_ZONE_INDEX || TWELVE_HOUR_FORMAT_IS_SELECTED != Settings.Locales.TWELVE_HOUR_FORMAT.getBoolean() || ((Integer)this.mFirstDayOfWeek.getSelectedItem()).intValue() != Settings.Locales.FIRST_DAY_OF_WEEK.getInt();
        Settings.setRestartInfo(LocaleSettingsTab.class.getCanonicalName(), SOMETHING_CHANGED);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("apps", "preferences-desktop-locale", 16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("locale", "Locale");
    }

    private void downloadAdditionalLanguages() {
        int option = JOptionPane.showConfirmDialog(this.mSettingsPn, LOCALIZER.msg("downloadInfo", "TV-Browser will try to find additional languages, therefor an internet connection is needed.\nDo you wish to proceed?"));
        if (option == 0) {
            ArrayList<LocaleLink> availableLocales = new ArrayList<LocaleLink>();
            try {
                String siteText = new String(IOUtilities.loadFileFromHttpServer(new URL("https://www.tvbrowser.org/downloads/lang/index.php")));
                Pattern p = Pattern.compile("<li><a href=\"([^\"]*)\">([^<]*)</a></li>");
                Matcher matcher = p.matcher(siteText);
                int pos = 0;
                while (matcher.find(pos)) {
                    String link = matcher.group(1);
                    String lang = matcher.group(2);
                    Locale loc = Localizer.getLocaleForString(lang);
                    boolean installed = false;
                    for (int i = 0; i < this.mLanguageCB.getItemCount(); ++i) {
                        if (!loc.equals(this.mLanguageCB.getItemAt(i))) continue;
                        installed = true;
                        break;
                    }
                    availableLocales.add(new LocaleLink(loc, link, installed));
                    pos = matcher.end();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (availableLocales.isEmpty()) {
                JOptionPane.showMessageDialog(this.mSettingsPn, LOCALIZER.msg("noAdditionalLang", "No additional languages available."));
            } else {
                this.showLanguageDownloadDialog(availableLocales);
            }
        }
    }

    private void showLanguageDownloadDialog(ArrayList<LocaleLink> availableLocales) {
        Collections.sort(availableLocales, new Comparator<LocaleLink>(){

            @Override
            public int compare(LocaleLink o1, LocaleLink o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("default:grow,default,5dlu,default"));
        pb.border(Borders.DIALOG);
        final JDialog dialog = new JDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()));
        dialog.setTitle(LOCALIZER.msg("downloadLanguages", "Install additional languages"));
        dialog.setContentPane(pb.getPanel());
        SelectableItemList<LocaleLink> list = new SelectableItemList<LocaleLink>(new LocaleLink[0], availableLocales.toArray(new LocaleLink[availableLocales.size()]));
        list.addCenterRendererComponent(LocaleLink.class, new SelectableItemRendererCenterComponentIf<LocaleLink>(){

            @Override
            public JPanel createCenterPanel(JList<? extends SelectableItem<LocaleLink>> list, LocaleLink value, int index, boolean isSelected, boolean isEnabled, JScrollPane parentScrollPane, int leftColumnWidth) {
                JLabel label = new JLabel(value.toString());
                if (value.isInstalled()) {
                    label.setFont(label.getFont().deriveFont(1));
                }
                if (isSelected) {
                    label.setForeground(list.getSelectionForeground());
                } else {
                    label.setForeground(list.getForeground());
                }
                JPanel panel = new JPanel(new BorderLayout());
                panel.setOpaque(false);
                panel.add((Component)label, "Center");
                return panel;
            }

            @Override
            public void calculateSize(JList<? extends SelectableItem<LocaleLink>> list, int index, JPanel contentPane) {
            }
        });
        pb.addLabelRowFull(false, LOCALIZER.msg("additionalLanguagesFound", "The following languages were found:"));
        pb.addLabelRowFull(false, LOCALIZER.msg("additionalLanguagesInfo", "(Bold language are installed but have possibly been updated.)"));
        pb.addRowFull("3dlu,fill:default:grow", list);
        JButton download = new JButton(LOCALIZER.msg("downloadSelectedLanguages", "Download selected languages"));
        download.setEnabled(false);
        download.addActionListener(e -> {
            for (LocaleLink localeLink : list.getSelectionList()) {
                if (!localeLink.download()) continue;
                this.mLanguageCB.addItem(localeLink.getLocale());
            }
            dialog.dispose();
        });
        JButton close = new JButton(Localizer.getLocalization("i18n_close"));
        close.addActionListener(e -> dialog.dispose());
        pb.addRow(download, 2);
        pb.add(close, 4);
        WindowClosingIf windowClosing = new WindowClosingIf(){

            @Override
            public JRootPane getRootPane() {
                return dialog.getRootPane();
            }

            @Override
            public void close() {
                dialog.dispose();
            }
        };
        list.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                download.setEnabled(!list.getSelectionList().isEmpty());
            }
        });
        UiUtilities.registerForClosing(windowClosing);
        Settings.layoutWindow("languageDownloadDialog", dialog, new Dimension(400, 300));
        dialog.setVisible(true);
    }

    private class LocaleLink {
        private Locale mLocale;
        private String mLink;
        private boolean mInstalledLanguage;

        public LocaleLink(Locale locale, String link, boolean installedLangauge) {
            this.mLocale = locale;
            this.mLink = link;
            this.mInstalledLanguage = installedLangauge;
        }

        public String toString() {
            String value = this.mLocale.getDisplayName(this.mLocale);
            return String.valueOf(value.charAt(0)).toUpperCase() + value.substring(1);
        }

        public boolean download() {
            File dir = new File(Settings.getUserSettingsDirName() + "/languages/");
            if (!dir.isDirectory()) {
                dir.mkdirs();
            }
            try {
                IOUtilities.saveStream(IOUtilities.getStream(new URL(this.mLink)), new File(dir, this.mLink.substring(this.mLink.lastIndexOf("/") + 1)));
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public Locale getLocale() {
            return this.mLocale;
        }

        public boolean isInstalled() {
            return this.mInstalledLanguage;
        }
    }
}

