/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe.searchfield;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Plugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.searchfield.SearchFilter;
import tvbrowser.ui.mainframe.searchfield.SearchTextField;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.io.stream.ObjectInputStreamProcessor;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.SearchForm;
import util.ui.SearchFormSettings;
import util.ui.SearchHelper;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.persona.Persona;

public class SearchField
extends JPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SearchField.class);
    private SearchTextField mText;
    private SearchFormSettings mSearchFormSettings;
    private JLabel mSearchButton;
    private JLabel mGoOrCancelButton;
    private static final String SETTINGS_FILE = "searchfield.SearchField.dat";
    private boolean mGoButton;
    private JPanel mSearchParent = new JPanel(new BorderLayout());
    final JPanel panel = new JPanel(new BorderLayout(3, 0));
    private FocusListener mPersonaFocusListener;

    public SearchField() {
        this.readSearchFormSettings();
        this.createGui();
        this.mGoButton = true;
    }

    private void readSearchFormSettings() {
        try {
            String home = Plugin.getPluginManager().getTvBrowserSettings().getTvBrowserUserHome();
            File settingsFile = new File(home, SETTINGS_FILE);
            if (!settingsFile.canRead()) {
                this.createDefaultSearchFormSettings();
                return;
            }
            StreamUtilities.objectInputStream(settingsFile, new ObjectInputStreamProcessor(){

                @Override
                public void process(ObjectInputStream inputStream) throws IOException {
                    try {
                        SearchField.this.mSearchFormSettings = new SearchFormSettings(inputStream);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            this.createDefaultSearchFormSettings();
        }
    }

    private void saveSearchFormSettings() {
        String home = Plugin.getPluginManager().getTvBrowserSettings().getTvBrowserUserHome();
        File settingsFile = new File(home, SETTINGS_FILE);
        StreamUtilities.objectOutputStreamIgnoringExceptions(settingsFile, new ObjectOutputStreamProcessor(){

            @Override
            public void process(ObjectOutputStream outputStream) throws IOException {
                SearchField.this.mSearchFormSettings.writeData(outputStream);
            }
        });
    }

    private void createDefaultSearchFormSettings() {
        this.mSearchFormSettings = new SearchFormSettings("");
        this.mSearchFormSettings.setNrDays(0);
    }

    private void createGui() {
        this.mSearchParent.setOpaque(true);
        this.panel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(2, 2, 1, 2)));
        this.mText = new SearchTextField(15);
        this.mPersonaFocusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                Color c = UIManager.getColor("List.background");
                SearchField.this.mSearchParent.setBackground(new Color(c.getRed(), c.getGreen(), c.getBlue(), 180));
                SearchField.this.mSearchParent.setOpaque(false);
                SwingUtilities.invokeLater(() -> {
                    SearchField.this.mSearchParent.setOpaque(true);
                    SearchField.this.panel.repaint();
                });
            }

            @Override
            public void focusGained(FocusEvent e) {
                SearchField.this.mSearchParent.setBackground(UIManager.getColor("TextField.background"));
            }
        };
        if (UiUtilities.isNimbusLookAndFeel()) {
            this.mText.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 1, 2)));
        }
        if (UiUtilities.isGTKLookAndFeel()) {
            this.mText.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        } else {
            this.mText.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        this.mText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SearchField.this.mGoOrCancelButton.setVisible(SearchField.this.mText.getText().length() != 0 && !SearchField.this.mText.getText().equals(SearchTextField.mLocalizer.ellipsisMsg("search", "Search")));
            }
        });
        this.mText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    SearchField.this.mGoOrCancelButton.setVisible(e.getDocument().getLength() > 0 && !e.getDocument().getText(0, e.getDocument().getLength() - 1).equals(SearchTextField.mLocalizer.ellipsisMsg("search", "Search")));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    SearchField.this.mGoOrCancelButton.setVisible(e.getDocument().getLength() > 0 && !e.getDocument().getText(0, e.getDocument().getLength() - 1).equals(SearchTextField.mLocalizer.ellipsisMsg("search", "Search")));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.mText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SearchField.this.startSearch();
                }
            }
        });
        ImageIcon search = new ImageIcon(TVBrowserIcons.search(16).getImage()){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.paintIcon(c, g, x, y);
                int x1 = x + super.getIconWidth() + 2;
                int y1 = y + this.getIconHeight() / 2 - 1;
                int[] xPoints = new int[]{x1, x1 + 3, x1 + 6};
                int[] yPoints = new int[]{y1, y1 + 4, y1};
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Color.gray);
                g.fillPolygon(xPoints, yPoints, 3);
                g.setColor(Color.gray);
                g.drawPolygon(xPoints, yPoints, 3);
            }

            @Override
            public int getIconWidth() {
                return super.getIconWidth() + 11;
            }
        };
        this.mSearchButton = new JLabel(search);
        this.mSearchButton.setBorder(BorderFactory.createEmptyBorder());
        this.mSearchButton.setFocusable(false);
        this.mSearchButton.setRequestFocusEnabled(false);
        this.mSearchButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SearchField.this.showConfigureDialog(SearchField.this.mText);
            }
        });
        this.mSearchButton.setToolTipText(mLocalizer.msg("preferences.tooltip", "Click to change search preferences"));
        this.mGoOrCancelButton = new JLabel(IconLoader.getInstance().getIconFromTheme("action", "media-playback-start", 16));
        this.mGoOrCancelButton.setBorder(BorderFactory.createEmptyBorder());
        this.mGoOrCancelButton.setVisible(false);
        this.mGoOrCancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SearchField.this.mGoButton) {
                    SearchField.this.startSearch();
                } else {
                    SearchField.this.cancelPressed();
                }
            }
        });
        this.setSearchButton();
        this.mText.setEditable(true);
        this.panel.setOpaque(false);
        this.mText.setOpaque(false);
        this.updatePersona();
        this.panel.add((Component)this.mSearchButton, "West");
        this.panel.add((Component)this.mText, "Center");
        this.panel.add((Component)this.mGoOrCancelButton, "East");
        this.mSearchParent.add((Component)this.panel, "Center");
        this.setLayout((LayoutManager)new FormLayout("80dlu, 2dlu", "fill:pref:grow, pref, fill:pref:grow"));
        this.add((Component)this.mSearchParent, new CellConstraints().xy(1, 2));
    }

    private void startSearch() {
        this.mSearchFormSettings.setSearchText(this.mText.getText());
        if (this.mSearchFormSettings.getNrDays() == 0) {
            if (this.mText.getText().length() > 0) {
                try {
                    SearchFilter filter = SearchFilter.getInstance();
                    filter.setSearch(this.mSearchFormSettings);
                    MainFrame.getInstance().setProgramFilter(filter);
                    this.setCancelButton();
                    SwingUtilities.invokeLater(() -> this.mText.setCaretPosition(this.mText.getText().length()));
                }
                catch (TvBrowserException e1) {
                    e1.printStackTrace();
                }
            } else {
                SearchFilter.getInstance().deactivateSearch();
                MainFrame.getInstance().setProgramFilter(FilterManagerImpl.getInstance().getDefaultFilter());
                this.setSearchButton();
            }
        } else {
            SearchHelper.search((Component)this.mText, this.mSearchFormSettings, new ProgramPanelSettings(new PluginPictureSettings(0), false), true);
        }
    }

    protected void cancelPressed() {
        this.mText.setText("");
        SearchFilter.getInstance().deactivateSearch();
        MainFrame.getInstance().setProgramFilter(FilterManagerImpl.getInstance().getDefaultFilter());
        this.setSearchButton();
        this.mGoOrCancelButton.setVisible(false);
        this.mText.focusLost(null);
    }

    protected void showConfigureDialog(final SearchTextField textField) {
        final SearchForm form = new SearchForm(false, false, true);
        form.setSearchFormSettings(this.mSearchFormSettings);
        final JDialog configure = new JDialog(MainFrame.getInstance(), mLocalizer.msg("settingsTitle", "Search-Settings"), false);
        configure.setUndecorated(true);
        JPanel panel = (JPanel)configure.getContentPane();
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), Borders.DLU4));
        panel.setLayout((LayoutManager)new FormLayout("fill:pref:grow, 3dlu, pref", "pref, fill:3dlu:grow, pref"));
        form.setParentDialog(configure);
        CellConstraints cc = new CellConstraints();
        panel.add((Component)form, cc.xyw(1, 1, 3));
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        ok.addActionListener(e -> {
            configure.setVisible(false);
            this.mSearchFormSettings = form.getSearchFormSettings();
            this.saveSearchFormSettings();
            textField.requestFocusInWindow();
            textField.selectAll();
        });
        panel.add((Component)ok, cc.xy(3, 3));
        UiUtilities.registerForClosing(new WindowClosingIf(){

            @Override
            public void close() {
                configure.removeWindowListener(configure.getWindowListeners()[0]);
                configure.setVisible(false);
                textField.requestFocusInWindow();
                textField.selectAll();
            }

            @Override
            public JRootPane getRootPane() {
                return configure.getRootPane();
            }
        });
        configure.pack();
        configure.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                if (!form.isSearchFieldsSelectionDialogVisible()) {
                    ((JDialog)e.getSource()).setVisible(false);
                    SearchField.this.mSearchFormSettings = form.getSearchFormSettings();
                    SearchField.this.saveSearchFormSettings();
                }
            }
        });
        Point p = this.mSearchButton.getLocationOnScreen();
        if (MainFrame.getInstance().getToolbar().getToolbarLocation().compareTo("North") == 0) {
            configure.setLocation(p.x - configure.getWidth() + this.mSearchButton.getWidth(), p.y + this.mSearchButton.getHeight());
        } else {
            configure.setLocation(p.x, p.y - configure.getHeight());
        }
        configure.setVisible(true);
    }

    public void deactivateSearch() {
        this.mText.setText("");
        this.setSearchButton();
        this.mText.focusLost(null);
        this.mGoOrCancelButton.setVisible(false);
    }

    private void setSearchButton() {
        this.mGoButton = true;
        this.mGoOrCancelButton.setIcon(IconLoader.getInstance().getIconFromTheme("action", "media-playback-start", 16));
        this.mGoOrCancelButton.setToolTipText(mLocalizer.msg("start.tooltip", "Start search"));
    }

    private void setCancelButton() {
        this.mGoButton = false;
        this.mGoOrCancelButton.setIcon(IconLoader.getInstance().getIconFromTheme("action", "process-stop", 16));
        this.mGoOrCancelButton.setToolTipText(mLocalizer.msg("cancel.tooltip", "Cancel search"));
    }

    public void updatePersona() {
        if (Persona.getInstance().getHeaderImage() != null) {
            Color c = UIManager.getColor("List.background");
            this.mSearchParent.setBackground(new Color(c.getRed(), c.getGreen(), c.getBlue(), 180));
            this.mText.addFocusListener(this.mPersonaFocusListener);
        } else {
            this.mSearchParent.setBackground(UIManager.getColor("TextField.background"));
            this.mText.removeFocusListener(this.mPersonaFocusListener);
        }
    }
}

