/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.configassistant;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import tvbrowser.TVBrowser;
import tvbrowser.core.ChannelList;
import tvbrowser.core.tvdataservice.ChannelGroupManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.ui.configassistant.AbstractCardPanel;
import tvbrowser.ui.configassistant.AuthenticationChannelCardPanel;
import tvbrowser.ui.configassistant.CardPanel;
import tvbrowser.ui.configassistant.PrevNextButtons;
import tvbrowser.ui.configassistant.StatusPanel;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.progress.Progress;
import util.ui.progress.ProgressWindow;

class NetworkSuccessPanel
extends AbstractCardPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(NetworkSuccessPanel.class);
    private JPanel mContent;
    private JPanel mCardPanel;
    private AuthenticationChannelCardPanel mAuthentication;
    private CardPanel mSubscribeChannelPanel;

    public NetworkSuccessPanel(PrevNextButtons btns, JPanel cardPanel, AuthenticationChannelCardPanel authentication, CardPanel subscribeChannelPanel) {
        super(btns);
        this.mAuthentication = authentication;
        this.mSubscribeChannelPanel = subscribeChannelPanel;
        this.mCardPanel = cardPanel;
    }

    @Override
    public JPanel getPanel() {
        this.mContent = new JPanel(new BorderLayout());
        this.mContent.add((Component)new StatusPanel(0), "North");
        JPanel content = new JPanel((LayoutManager)new FormLayout("fill:pref:grow, fill:300dlu:grow, fill:pref:grow", "fill:pref:grow, pref, fill:pref:grow"));
        content.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        content.add((Component)UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("success", "Success")), cc.xy(2, 2));
        this.mContent.add((Component)content, "Center");
        return this.mContent;
    }

    @Override
    public boolean onNext() {
        boolean result;
        if (TvDataServiceProxyManager.getInstance().getDataServices().length < 1) {
            TVBrowser.loadDataServicesAtStartup();
        }
        boolean bl = result = TvDataServiceProxyManager.getInstance().getDataServices().length >= 1;
        if (result) {
            this.mAuthentication.createPanel();
            if (!this.mAuthentication.isNeeded()) {
                final ProgressWindow win = new ProgressWindow(MainFrame.getInstance());
                win.run(new Progress(){

                    @Override
                    public void run() {
                        ChannelGroupManager.getInstance().checkForAvailableGroupsAndChannels(win);
                    }
                });
                ChannelList.reload();
                ChannelList.initSubscribedChannels();
            } else {
                this.mCardPanel.add((Component)this.mAuthentication.getPanel(), this.mAuthentication.toString());
                this.setNext(this.mAuthentication);
                this.mAuthentication.setNext(this.mSubscribeChannelPanel);
            }
        } else {
            UiUtilities.showMessageDialogOnMouseScreen(mLocalizer.msg("noDataService.msg", "No data plugin was installed.\nYou will need to install at least\none data plugin for TV-Browser to work.\n\nGoing back to previous step."), mLocalizer.msg("noDataService.title", "No data plugin installed."), 1);
        }
        return result;
    }
}

