/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.Program;
import devplugin.ProgramReceiveTarget;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.extras.reminderplugin.FrameReminders;
import tvbrowser.extras.reminderplugin.ReminderConstants;
import tvbrowser.extras.reminderplugin.ReminderFrame;
import tvbrowser.extras.reminderplugin.ReminderList;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderSettings;
import util.exc.ErrorHandler;
import util.i18n.Localizer;
import util.io.ExecutionHandler;
import util.paramhandler.ParamParser;

public class ReminderTimerListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ReminderTimerListener.class);
    private static final Logger mLog = Logger.getLogger(ReminderTimerListener.class.getName());
    private ReminderSettings mSettings;
    private ReminderList mReminderList;

    public ReminderTimerListener(ReminderSettings settings, ReminderList reminderList) {
        this.mSettings = settings;
        this.mReminderList = reminderList;
    }

    public void timeEvent(ArrayList<ReminderListItem> reminders) {
        ArrayList<ReminderListItem> notExpired = new ArrayList<ReminderListItem>(reminders.size());
        for (ReminderListItem reminderListItem : reminders) {
            if (reminderListItem.getProgramItem().getProgram().isExpired()) continue;
            notExpired.add(reminderListItem);
        }
        reminders = notExpired;
        if (reminders.isEmpty()) {
            return;
        }
        if (this.mSettings.isSet("usesound")) {
            ReminderPlugin.playSound(this.mSettings.get("soundfile"));
        }
        if (this.mSettings.isSet("usebeep")) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.mSettings.isSet("showFrameReminders") || this.mSettings.isSet("usemsgbox")) {
            HashMap sortedReminders = new HashMap(reminders.size());
            for (ReminderListItem reminder : reminders) {
                ArrayList<ReminderListItem> list;
                int time = reminder.getProgram().getStartTime();
                if (reminder.getProgram().isOnAir() || reminder.getProgram().isExpired()) {
                    time = -1;
                }
                if ((list = (ArrayList<ReminderListItem>)sortedReminders.get(time)) == null) {
                    list = new ArrayList<ReminderListItem>();
                    sortedReminders.put(time, list);
                }
                list.add(reminder);
            }
            Set set = sortedReminders.keySet();
            Object[] timeSortedKeys = set.toArray(new Integer[set.size()]);
            Arrays.sort(timeSortedKeys);
            for (int i = timeSortedKeys.length - 1; i >= 0; --i) {
                ArrayList singleTimeReminders = (ArrayList)sortedReminders.get(timeSortedKeys[i]);
                if (this.mSettings.isSet("showFrameReminders")) {
                    FrameReminders.getInstance().addReminders(this.mReminderList, singleTimeReminders);
                    continue;
                }
                if (!this.mSettings.isSet("usemsgbox")) continue;
                new ReminderFrame(this.mReminderList, singleTimeReminders, this.getAutoCloseReminderTime(singleTimeReminders));
            }
        } else {
            for (ReminderListItem reminderListItem : reminders) {
                this.mReminderList.removeWithoutChecking(reminderListItem.getProgramItem());
                this.mReminderList.blockProgram(reminderListItem.getProgram());
            }
        }
        if (this.mSettings.isSet("useexec")) {
            String fName = this.mSettings.get("execfile").trim();
            if (StringUtils.isNotEmpty((CharSequence)fName)) {
                for (ReminderListItem reminder : reminders) {
                    ParamParser parser = new ParamParser();
                    String fParam = parser.analyse(this.mSettings.get("execparam"), reminder.getProgram());
                    try {
                        ExecutionHandler executionHandler = new ExecutionHandler(fParam, fName);
                        executionHandler.execute();
                    }
                    catch (Exception exc) {
                        String msg = mLocalizer.msg("error.2", "Error executing reminder program!\n({0})", fName, exc);
                        ErrorHandler.handle(msg, exc);
                    }
                }
            } else {
                mLog.warning("Reminder program name is not defined!");
            }
        }
        ProgramReceiveTarget[] targets = ReminderPlugin.getInstance().getClientPluginsTargets();
        ArrayList<Program> arrayList = new ArrayList<Program>();
        for (ReminderListItem reminder : reminders) {
            arrayList.add(reminder.getProgram());
        }
        for (ProgramReceiveTarget target : targets) {
            target.getReceifeIfForIdOfTarget().receivePrograms(0, arrayList.toArray(new Program[arrayList.size()]), target);
        }
        SwingUtilities.invokeLater(() -> new Thread("Update reminder tree"){

            @Override
            public void run() {
                this.setPriority(1);
                ReminderPlugin.getInstance().updateRootNode(true);
            }
        }.start());
    }

    private int getAutoCloseReminderTime(ArrayList<ReminderListItem> reminders) {
        int result = 0;
        for (ReminderListItem reminder : reminders) {
            result = Math.max(result, ReminderConstants.getAutoCloseReminderTime(reminder.getProgram()));
        }
        return result;
    }
}

