/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.dlgs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import tvbrowser.extras.favoritesplugin.core.Exclusion;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.wizards.ExcludeWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import util.i18n.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class ExclusionPanel
extends JPanel {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ExclusionPanel.class);
    private JList<Exclusion> mExclusionsList;
    private JButton mNewExclusionBtn;
    private JButton mEditExclusionBtn;
    private JButton mDeleteExclusionBtn;
    private boolean mWasAdded = false;
    private boolean mWasEditedOrDeleted = false;

    public ExclusionPanel(Exclusion[] exclusions, Window parent, Favorite favorite) {
        this.setLayout((LayoutManager)new FormLayout("1dlu, 100dlu:grow, 3dlu, pref", "default, 3dlu, default, 3dlu, default, fill:0dlu:grow, 2dlu"));
        CellConstraints cc = new CellConstraints();
        DefaultListModel<Exclusion> listModel = new DefaultListModel<Exclusion>();
        this.mExclusionsList = new JList(listModel);
        Arrays.sort(exclusions);
        for (Exclusion exclusion : exclusions) {
            listModel.addElement(exclusion);
        }
        this.mExclusionsList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateExclusionListButtons();
            }
        });
        this.mExclusionsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() >= 2 && ExclusionPanel.this.mEditExclusionBtn.isEnabled()) {
                    ExclusionPanel.this.mEditExclusionBtn.getActionListeners()[0].actionPerformed(null);
                }
            }
        });
        this.add((Component)new JScrollPane(this.mExclusionsList), cc.xywh(2, 1, 1, 6));
        ImageIcon newIcon = TVBrowserIcons.newIcon(16);
        ImageIcon editIcon = TVBrowserIcons.edit(16);
        ImageIcon deleteIcon = TVBrowserIcons.delete(16);
        this.mNewExclusionBtn = new JButton(newIcon);
        this.mEditExclusionBtn = new JButton(editIcon);
        this.mDeleteExclusionBtn = new JButton(deleteIcon);
        this.mNewExclusionBtn.setMargin(UiUtilities.ZERO_INSETS);
        this.mEditExclusionBtn.setMargin(UiUtilities.ZERO_INSETS);
        this.mDeleteExclusionBtn.setMargin(UiUtilities.ZERO_INSETS);
        this.mNewExclusionBtn.setToolTipText(LOCALIZER.msg("tooltip.newExclusion", "New exclusion criteria"));
        this.mEditExclusionBtn.setToolTipText(LOCALIZER.msg("tooltip.editExclusion", "Edit exclusion criteria"));
        this.mDeleteExclusionBtn.setToolTipText(LOCALIZER.msg("tooltip.deleteExclusion", "Delete exclusion criteria"));
        this.add((Component)this.mNewExclusionBtn, cc.xy(4, 1));
        this.add((Component)this.mEditExclusionBtn, cc.xy(4, 3));
        this.add((Component)this.mDeleteExclusionBtn, cc.xy(4, 5));
        this.mNewExclusionBtn.addActionListener(e -> {
            WizardHandler handler = new WizardHandler(parent, new ExcludeWizardStep(favorite));
            Exclusion exclusion = (Exclusion)handler.show();
            if (exclusion != null) {
                ((DefaultListModel)this.mExclusionsList.getModel()).addElement(exclusion);
                this.mWasAdded = true;
            }
        });
        this.mEditExclusionBtn.addActionListener(e -> {
            Exclusion oldExclusion = this.mExclusionsList.getSelectedValue();
            WizardHandler handler = new WizardHandler(parent, new ExcludeWizardStep(favorite, oldExclusion));
            Exclusion newExclusion = (Exclusion)handler.show();
            if (newExclusion != null) {
                int inx = this.mExclusionsList.getSelectedIndex();
                ((DefaultListModel)this.mExclusionsList.getModel()).setElementAt(newExclusion, inx);
                this.mWasEditedOrDeleted = true;
            }
        });
        this.mDeleteExclusionBtn.addActionListener(e -> {
            Exclusion exclusion = this.mExclusionsList.getSelectedValue();
            if (exclusion != null) {
                ((DefaultListModel)this.mExclusionsList.getModel()).removeElement(exclusion);
                this.mWasEditedOrDeleted = true;
            }
        });
        this.updateExclusionListButtons();
    }

    private void updateExclusionListButtons() {
        Exclusion selectedItem = this.mExclusionsList.getSelectedValue();
        this.mEditExclusionBtn.setEnabled(selectedItem != null);
        this.mDeleteExclusionBtn.setEnabled(selectedItem != null);
    }

    public Exclusion[] getExclusions() {
        int exclCnt = ((DefaultListModel)this.mExclusionsList.getModel()).size();
        Object[] exclArr = new Exclusion[exclCnt];
        ((DefaultListModel)this.mExclusionsList.getModel()).copyInto(exclArr);
        return exclArr;
    }

    public boolean wasChanged() {
        return this.mWasEditedOrDeleted || this.mWasAdded;
    }

    public boolean wasAdded() {
        return this.mWasAdded;
    }

    public boolean wasEditedOrDeleted() {
        return this.mWasEditedOrDeleted;
    }
}

