/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.core;

import devplugin.Channel;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramFilter;
import devplugin.ProgramReceiveTarget;
import devplugin.ProgramSearcher;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.common.LimitationConfiguration;
import tvbrowser.extras.common.ReminderConfiguration;
import tvbrowser.extras.favoritesplugin.FavoriteConfigurator;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.favoritesplugin.core.Exclusion;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.program.ProgramUtilities;
import util.ui.SearchFormSettings;

public abstract class Favorite {
    public static final String SEPARATOR = "#!#?#";
    private ArrayList<Program> mPrograms;
    private ArrayList<Program> mNewPrograms;
    private String mName;
    private ReminderConfiguration mReminderConfiguration;
    private LimitationConfiguration mLimitationConfiguration;
    private boolean mRemindAfterDownload;
    private ArrayList<Exclusion> mExclusionList;
    private ProgramReceiveTarget[] mForwardPluginArr;
    protected SearchFormSettings mSearchFormSettings;
    private HashMap<String, ReminderInfo> mRemovedPrograms;
    private ArrayList<Program> mRemovedProgramsList;
    private ArrayList<Program> mRemovedBlacklistPrograms;
    private boolean mNewProgramsWasRequested;
    private boolean mProvideFilter;
    private long mFilterKey;
    private int mDefaultReminderMinutes;
    private AtomicInteger mLoadDeferredProgramsThreadCount = new AtomicInteger(0);
    private ArrayList<Program> mBlackList;

    public Favorite() {
        String[] stringArray;
        if (FavoritesPlugin.getInstance().isAutoSelectingReminder()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "window";
        } else {
            stringArray = new String[]{};
        }
        this.mReminderConfiguration = new ReminderConfiguration(stringArray);
        this.mLimitationConfiguration = new LimitationConfiguration();
        this.mPrograms = new ArrayList(0);
        this.mNewPrograms = new ArrayList(0);
        this.mRemovedPrograms = new HashMap(0);
        this.mRemovedProgramsList = new ArrayList(0);
        this.mRemovedBlacklistPrograms = new ArrayList(0);
        this.mExclusionList = null;
        this.mBlackList = null;
        this.mNewProgramsWasRequested = false;
        this.mFilterKey = 0L;
        this.mDefaultReminderMinutes = -31;
        this.mForwardPluginArr = new ProgramReceiveTarget[0];
        this.handleNewGlobalReceiveTargets(new ProgramReceiveTarget[0]);
    }

    public Favorite(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this();
        int version = in.readInt();
        this.mName = (String)in.readObject();
        this.mReminderConfiguration = new ReminderConfiguration(in);
        this.mLimitationConfiguration = new LimitationConfiguration(in);
        this.mRemindAfterDownload = in.readBoolean();
        int exclSize = in.readInt();
        if (exclSize > 0) {
            this.mExclusionList = new ArrayList();
        }
        for (int i = 0; i < exclSize; ++i) {
            Exclusion exclusion = new Exclusion(in);
            if (exclusion.isInvalid()) continue;
            this.mExclusionList.add(exclusion);
        }
        int cnt = in.readInt();
        this.mForwardPluginArr = new ProgramReceiveTarget[cnt];
        for (int i = 0; i < cnt; ++i) {
            if (version <= 2) {
                String id = (String)in.readObject();
                this.mForwardPluginArr[i] = ProgramReceiveTarget.createDefaultTargetForProgramReceiveIfId(id);
                continue;
            }
            this.mForwardPluginArr[i] = new ProgramReceiveTarget(in);
        }
        if (version < 4) {
            this.handleNewGlobalReceiveTargets(new ProgramReceiveTarget[0]);
        }
        int size = in.readInt();
        this.mPrograms = new ArrayList(size);
        this.readProgramsToList(this.mPrograms, size, in, version);
        if (version >= 2) {
            size = in.readInt();
            if (size > 0) {
                this.mBlackList = new ArrayList(size);
                this.readProgramsToList(this.mBlackList, size, in, version);
            }
        } else {
            this.mBlackList = null;
        }
        if (this.mBlackList != null) {
            Collections.sort(this.mBlackList, ProgramUtilities.getProgramComparator());
        }
        this.mRemovedPrograms = new HashMap(0);
        this.mRemovedProgramsList = new ArrayList(0);
        if (version > 4) {
            this.mProvideFilter = in.readBoolean();
            this.mFilterKey = in.readLong();
        } else {
            this.mFilterKey = 0L;
            this.mProvideFilter = false;
        }
        if (version > 5) {
            this.mDefaultReminderMinutes = in.readInt();
        }
        if (version > 6 && (size = in.readInt()) > 0) {
            this.mNewPrograms = new ArrayList(size);
            this.readProgramsToList(this.mNewPrograms, size, in, version);
            this.mNewProgramsWasRequested = true;
        }
    }

    private void readProgramsToList(final ArrayList<Program> list, int size, ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        final ArrayList<DeferredProgram> deferredPrograms = new ArrayList<DeferredProgram>();
        for (int i = 0; i < size; ++i) {
            deferredPrograms.add(new DeferredProgram(version, in));
        }
        Thread loadDeferredProgramsThread = new Thread("LOAD DEFERRED FAVORITE PROGRAMS"){

            @Override
            public void run() {
                Favorite.this.mLoadDeferredProgramsThreadCount.incrementAndGet();
                for (DeferredProgram d : deferredPrograms) {
                    Program[] program = d.getPrograms();
                    if (program == null) continue;
                    for (Program p : program) {
                        if (p == null || list.contains(p)) continue;
                        list.add(p);
                    }
                }
                Favorite.this.mLoadDeferredProgramsThreadCount.decrementAndGet();
            }
        };
        loadDeferredProgramsThread.start();
    }

    public abstract String getTypeID();

    public abstract String getTypeName();

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public LimitationConfiguration getLimitationConfiguration() {
        return this.mLimitationConfiguration;
    }

    public ReminderConfiguration getReminderConfiguration() {
        return this.mReminderConfiguration;
    }

    public void setRemindAfterDownload(boolean b) {
        this.mRemindAfterDownload = b;
    }

    public boolean isRemindAfterDownload() {
        return this.mRemindAfterDownload;
    }

    public void setForwardPlugins(ProgramReceiveTarget[] pluginArr) {
        this.mForwardPluginArr = pluginArr;
    }

    public ProgramReceiveTarget[] getForwardPlugins() {
        return this.mForwardPluginArr;
    }

    public void handleNewGlobalReceiveTargets(ProgramReceiveTarget[] oldDefaultTargets) {
        ProgramReceiveTarget[] defaultTargets = FavoritesPlugin.getInstance().getDefaultClientPluginsTargets();
        ArrayList<ProgramReceiveTarget> newTargets = new ArrayList<ProgramReceiveTarget>(defaultTargets.length);
        for (ProgramReceiveTarget target : defaultTargets) {
            newTargets.add(target);
        }
        for (ProgramReceiveTarget target : this.mForwardPluginArr) {
            if (this.arrayContains(oldDefaultTargets, target) || this.arrayContains(defaultTargets, target)) continue;
            newTargets.add(target);
        }
        this.mForwardPluginArr = newTargets.toArray(new ProgramReceiveTarget[newTargets.size()]);
    }

    private boolean arrayContains(ProgramReceiveTarget[] targetArr, ProgramReceiveTarget target) {
        if (targetArr != null && target != null) {
            for (ProgramReceiveTarget arrayEntry : targetArr) {
                if (arrayEntry == null || !arrayEntry.getReceiveIfId().equals(target.getReceiveIfId()) || !arrayEntry.getTargetId().equals(target.getTargetId())) continue;
                return true;
            }
        }
        return false;
    }

    public Program[] getPrograms() {
        this.waitForDeferredPrograms();
        Program[] programs = this.mPrograms.toArray(new Program[0]);
        if (programs.length > 0) {
            Arrays.sort(programs, ProgramUtilities.getProgramComparator());
        }
        return programs;
    }

    public Program[] getNewPrograms() {
        this.mNewProgramsWasRequested = true;
        this.waitForDeferredPrograms();
        for (int i = this.mNewPrograms.size() - 1; i >= 0; --i) {
            Program test = this.mNewPrograms.get(i);
            if (test != null) {
                Program[] newProgs = Plugin.getPluginManager().getPrograms(this.mNewPrograms.get(i).getUniqueID());
                Program newProg = null;
                if (newProgs != null) {
                    for (Program check : newProgs) {
                        if (!check.getTitle().equals(test.getTitle())) continue;
                        newProg = check;
                        break;
                    }
                }
                if (newProg != null && newProg.getProgramState() == 0 && !newProg.isExpired()) {
                    this.mNewPrograms.set(i, newProg);
                    continue;
                }
                this.mNewPrograms.remove(i);
                continue;
            }
            this.mNewPrograms.remove(i);
        }
        Program[] programs = this.mNewPrograms.toArray(new Program[this.mNewPrograms.size()]);
        if (programs.length > 0) {
            Arrays.sort(programs, ProgramUtilities.getProgramComparator());
        }
        return programs;
    }

    public void handleContainingPrograms(Program[] progs) {
        for (Program p : progs) {
            if (!this.mPrograms.contains(p)) continue;
            p.mark(FavoritesPluginProxy.getInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(7);
        out.writeObject(this.mName);
        this.mReminderConfiguration.store(out);
        this.mLimitationConfiguration.store(out);
        out.writeBoolean(this.mRemindAfterDownload);
        if (this.mExclusionList == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.mExclusionList.size());
            for (Exclusion exclusion : this.mExclusionList) {
                exclusion.writeData(out);
            }
        }
        out.writeInt(this.mForwardPluginArr.length);
        for (ProgramReceiveTarget receiveTarget : this.mForwardPluginArr) {
            receiveTarget.writeData(out);
        }
        ArrayList<Program> arrayList = this.mPrograms;
        synchronized (arrayList) {
            out.writeInt(this.mPrograms.size());
            for (Program p : this.mPrograms) {
                out.writeUTF(p.getUniqueID());
            }
        }
        if (this.mBlackList == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.mBlackList.size());
            for (Program p : this.mBlackList) {
                out.writeUTF(p.getUniqueID());
            }
        }
        out.writeBoolean(this.mProvideFilter);
        out.writeLong(this.mFilterKey);
        out.writeInt(this.mDefaultReminderMinutes);
        out.writeInt(this.mNewPrograms.size());
        for (Program p : this.mNewPrograms) {
            out.writeUTF(p.getUniqueID());
        }
        this.internalWriteData(out);
    }

    public Exclusion[] getExclusions() {
        if (this.mExclusionList == null) {
            return new Exclusion[0];
        }
        return this.mExclusionList.toArray(new Exclusion[this.mExclusionList.size()]);
    }

    public void setReminderMinutesDefault(int minutes) {
        this.mDefaultReminderMinutes = minutes;
    }

    public int getReminderMinutesDefault() {
        return this.mDefaultReminderMinutes;
    }

    public void addExclusion(Exclusion exclusion) {
        if (this.mExclusionList == null) {
            this.mExclusionList = new ArrayList(1);
        }
        this.mExclusionList.add(exclusion);
        try {
            this.refreshPrograms(FavoritesPlugin.getInstance().isShowingNewFoundPrograms());
            FavoritesPlugin.getInstance().updateRootNode(true);
        }
        catch (TvBrowserException exc) {
            ErrorHandler.handle("Could not update favorites.", exc);
        }
        this.updateManageDialog();
    }

    public void removeExclusion(Exclusion exclusion) {
        if (this.mExclusionList == null) {
            return;
        }
        this.mExclusionList.remove(exclusion);
    }

    public void setExclusions(Exclusion[] exclusionArr) {
        if (this.mExclusionList == null) {
            this.mExclusionList = new ArrayList(exclusionArr.length);
        } else {
            this.mExclusionList.clear();
        }
        this.mExclusionList.addAll(Arrays.asList(exclusionArr));
    }

    public boolean contains(Program prog) {
        return (this.mBlackList == null || !this.mBlackList.contains(prog)) && this.mPrograms.contains(prog);
    }

    private Program[] filterByLimitations(Program ... progArr) {
        Exclusion[] globalExclusions = FavoritesPlugin.getInstance().getGlobalExclusions();
        Exclusion[] exclusions = new Exclusion[this.getExclusions().length + globalExclusions.length];
        System.arraycopy(globalExclusions, 0, exclusions, 0, globalExclusions.length);
        System.arraycopy(this.getExclusions(), 0, exclusions, globalExclusions.length, exclusions.length - globalExclusions.length);
        ArrayList<Program> list = new ArrayList<Program>();
        int allowedDayOfWeek = this.getLimitationConfiguration().getDayLimit();
        for (Program program : progArr) {
            boolean isExcluded = false;
            for (Exclusion exclusion : exclusions) {
                if (!exclusion.isProgramExcluded(program)) continue;
                isExcluded = true;
                break;
            }
            if (!isExcluded && this.getLimitationConfiguration().isLimitedByTime()) {
                if (ProgramUtilities.isNotInTimeRange(this.getLimitationConfiguration().getTimeFrom(), this.getLimitationConfiguration().getTimeTo(), program)) {
                    isExcluded = true;
                } else if (allowedDayOfWeek != -1) {
                    Calendar cal = program.getDate().getCalendar();
                    int dayOfWeek = cal.get(7);
                    if (allowedDayOfWeek == -2) {
                        if (dayOfWeek != 1 && dayOfWeek != 7) {
                            isExcluded = true;
                        }
                    } else if (allowedDayOfWeek == -3) {
                        if (dayOfWeek == 1 || dayOfWeek == 7) {
                            isExcluded = true;
                        }
                    } else if (allowedDayOfWeek != dayOfWeek) {
                        isExcluded = true;
                    }
                }
            }
            if (isExcluded) continue;
            list.add(program);
        }
        return list.toArray(new Program[list.size()]);
    }

    public void updatePrograms() throws TvBrowserException {
        this.updatePrograms(false, true);
    }

    public void updatePrograms(boolean send) throws TvBrowserException {
        this.updatePrograms(false, send);
    }

    public void updatePrograms(boolean dataUpdate, boolean sendToPlugins) throws TvBrowserException {
        this.updatePrograms(this.internalSearchForPrograms(), dataUpdate, sendToPlugins);
    }

    public void refreshPrograms(boolean noNewProgramsUpdate) throws TvBrowserException {
        this.updatePrograms(this.mPrograms.toArray(new Program[this.mPrograms.size()]), false, false, noNewProgramsUpdate);
    }

    private void updatePrograms(Program[] progs, boolean dataUpdate, boolean send) throws TvBrowserException {
        this.updatePrograms(progs, dataUpdate, send, false);
    }

    private void updatePrograms(Program[] progs, boolean dataUpdate, boolean send, boolean noNewProgramsUpdate) throws TvBrowserException {
        int i;
        Program[] newProgList = this.filterByLimitations(progs);
        Comparator<Program> comparator = ProgramUtilities.getProgramComparator();
        Arrays.sort(newProgList, comparator);
        Program[] p1 = this.mPrograms.toArray(new Program[this.mPrograms.size()]);
        Arrays.sort(p1, comparator);
        ArrayList<Program> resultList = new ArrayList<Program>();
        ArrayList<Program> newPrograms = new ArrayList<Program>();
        int inx1 = 0;
        int inx2 = 0;
        while (inx1 < p1.length && inx2 < newProgList.length) {
            if (comparator.compare(p1[inx1], newProgList[inx2]) < 0) {
                this.unmarkProgram(p1[inx1]);
                ++inx1;
                continue;
            }
            if (comparator.compare(p1[inx1], newProgList[inx2]) > 0) {
                this.markProgram(newProgList[inx2], this.mDefaultReminderMinutes);
                newPrograms.add(newProgList[inx2]);
                resultList.add(newProgList[inx2]);
                ++inx2;
                continue;
            }
            if (p1[inx1].getProgramState() == 2) {
                int minutes = ReminderPlugin.getInstance().getReminderMinutesForProgram(p1[inx1]);
                this.markProgram(newProgList[inx2], minutes);
            }
            resultList.add(newProgList[inx2]);
            ++inx1;
            ++inx2;
        }
        if (inx2 < newProgList.length) {
            for (i = inx2; i < newProgList.length; ++i) {
                this.markProgram(newProgList[i], this.mDefaultReminderMinutes);
                newPrograms.add(newProgList[i]);
                resultList.add(newProgList[i]);
            }
        }
        if (inx1 < p1.length) {
            for (i = inx1; i < p1.length; ++i) {
                this.unmarkProgram(p1[i]);
            }
        }
        ArrayList<Program> removedPrograms = new ArrayList<Program>();
        for (Program program : this.mPrograms) {
            int found = 0;
            for (Program p : newProgList) {
                if (!program.getUniqueID().contentEquals(p.getUniqueID())) continue;
                found = 1;
                break;
            }
            if (found != 0) continue;
            removedPrograms.add(program);
        }
        if (!noNewProgramsUpdate) {
            this.mNewPrograms = newPrograms;
        } else {
            for (int i2 = this.mNewPrograms.size() - 1; i2 >= 0; --i2) {
                if (resultList.contains(this.mNewPrograms.get(i2))) continue;
                this.mNewPrograms.remove(i2);
            }
        }
        ProgramReceiveTarget[] programReceiveTargets = this.getForwardPlugins();
        if (this.mNewPrograms.size() > 0 && send && !noNewProgramsUpdate) {
            if (!dataUpdate) {
                for (ProgramReceiveTarget receiveTarget : programReceiveTargets) {
                    if (receiveTarget == null || receiveTarget.getReceifeIfForIdOfTarget() == null) continue;
                    int type = receiveTarget.getEventType();
                    if (type == 3) {
                        type = 1;
                    }
                    if (type == 2) continue;
                    receiveTarget.receivePrograms(type, this.mNewPrograms.toArray(new Program[0]));
                }
            } else {
                FavoritesPlugin.getInstance().addProgramsForSending(programReceiveTargets, this.mNewPrograms.toArray(new Program[this.mNewPrograms.size()]));
            }
        }
        if (!removedPrograms.isEmpty()) {
            Program[] programArray = removedPrograms.toArray(new Program[0]);
            ArrayList<ProgramReceiveTarget> supported = new ArrayList<ProgramReceiveTarget>();
            for (ProgramReceiveTarget receiveTarget : programReceiveTargets) {
                int type;
                if (receiveTarget == null || receiveTarget.getReceifeIfForIdOfTarget() == null || (type = receiveTarget.getEventType()) != 2 && type != 3) continue;
                supported.add(receiveTarget);
            }
            HashMap<String, ArrayList<Program>> toSend = FavoriteTreeModel.getInstance().findProgramsToSendForRemove(programArray, programReceiveTargets, this);
            for (ProgramReceiveTarget receiveTarget : supported) {
                ArrayList<Program> programs = toSend.get(FavoritesPlugin.getKeyForReceiveTarget(receiveTarget, false));
                if (programs == null || programs.isEmpty()) continue;
                receiveTarget.receivePrograms(2, programs.toArray(new Program[0]));
            }
        }
        this.mPrograms = resultList;
    }

    private void markProgram(Program p, int reminderMinutes) {
        if (this.mBlackList == null || !this.mBlackList.contains(p)) {
            String[] reminderServices;
            p.mark(FavoritesPluginProxy.getInstance());
            for (String reminderService : reminderServices = this.getReminderConfiguration().getReminderServices()) {
                if (!"window".equals(reminderService)) continue;
                ReminderPlugin.getInstance().addProgram(p, reminderMinutes);
            }
        }
    }

    private int unmarkProgram(Program p) {
        String[] reminderServices;
        if (!FavoriteTreeModel.getInstance().isContainedByOtherFavorites(this, p)) {
            p.unmark(FavoritesPluginProxy.getInstance());
        }
        int reminderMinutes = -42;
        for (String reminderService : reminderServices = this.getReminderConfiguration().getReminderServices()) {
            if (!"window".equals(reminderService)) continue;
            reminderMinutes = ReminderPlugin.getInstance().removeProgram(p);
        }
        return reminderMinutes;
    }

    public void refreshBlackList() {
        if (this.mBlackList == null) {
            return;
        }
        for (int i = this.mBlackList.size() - 1; i >= 0; --i) {
            Program programInList = this.mBlackList.remove(i);
            Program testProg = PluginManagerImpl.getInstance().getProgram(programInList.getDate(), programInList.getID());
            if (testProg == null || programInList.getTitle().toLowerCase().compareTo(testProg.getTitle().toLowerCase()) != 0) continue;
            this.mBlackList.add(testProg);
        }
    }

    public boolean isOnBlackList(Program program) {
        return this.mBlackList != null && this.mBlackList.contains(program);
    }

    public void addToBlackList(Program program) {
        if (this.mBlackList == null) {
            this.mBlackList = new ArrayList(1);
        }
        if (!this.mBlackList.contains(program)) {
            this.mBlackList.add(program);
            Collections.sort(this.mBlackList, ProgramUtilities.getProgramComparator());
            this.unmarkProgram(program);
            FavoritesPlugin.getInstance().updateRootNode(true);
            this.updateManageDialog();
        }
    }

    public void removeFromBlackList(Program program) {
        if (this.mBlackList == null) {
            return;
        }
        if (this.mBlackList.remove(program)) {
            this.markProgram(program, this.mDefaultReminderMinutes);
            FavoritesPlugin.getInstance().updateRootNode(true);
            this.updateManageDialog();
        }
    }

    private void updateManageDialog() {
        FavoritesPlugin.getInstance().favoriteSelectionChanged();
    }

    public Program[] getWhiteListPrograms() {
        return this.getWhiteListPrograms(false);
    }

    private void waitForDeferredPrograms() {
        while (this.mLoadDeferredProgramsThreadCount.get() > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Program[] getWhiteListPrograms(boolean onlyNotExpiredPrograms) {
        this.waitForDeferredPrograms();
        ArrayList<Program> tempProgramArr = new ArrayList<Program>();
        ArrayList<Program> arrayList = this.mPrograms;
        synchronized (arrayList) {
            for (Program p : this.mPrograms) {
                if (this.mBlackList != null && this.mBlackList.contains(p) || onlyNotExpiredPrograms && p.isExpired()) continue;
                tempProgramArr.add(p);
            }
        }
        Program[] retArray = tempProgramArr.toArray(new Program[tempProgramArr.size()]);
        Arrays.sort(retArray, ProgramUtilities.getProgramComparator());
        return retArray;
    }

    public Program[] getBlackListPrograms() {
        this.waitForDeferredPrograms();
        if (this.mBlackList == null) {
            return new Program[0];
        }
        return this.mBlackList.toArray(new Program[this.mBlackList.size()]);
    }

    public abstract FavoriteConfigurator createConfigurator();

    protected abstract void internalWriteData(ObjectOutputStream var1) throws IOException;

    protected Program[] internalSearchForPrograms() throws TvBrowserException {
        SearchFormSettings searchForm = this.mSearchFormSettings;
        ProgramSearcher searcher = searchForm.createSearcher();
        return searcher.search(searchForm.getFieldTypes(), new Date().addDays(-1), 1000, this.getChannels(), false);
    }

    public boolean containsReceiveTarget(ProgramReceiveTarget target) {
        if (this.mForwardPluginArr != null && target != null) {
            for (ProgramReceiveTarget tar : this.mForwardPluginArr) {
                if (!tar.getReceiveIfId().equals(target.getReceiveIfId()) || !tar.getTargetId().equals(target.getTargetId())) continue;
                return true;
            }
        }
        return false;
    }

    protected Channel[] getChannels() {
        Channel[] channelArr = this.getLimitationConfiguration().isLimitedByChannel() ? this.getLimitationConfiguration().getChannels() : Plugin.getPluginManager().getSubscribedChannels();
        return channelArr;
    }

    private boolean isLimitedByChannel(Program p) {
        boolean result = this.getLimitationConfiguration().isLimitedByChannel();
        if (result) {
            Channel[] chs;
            for (Channel ch : chs = this.getLimitationConfiguration().getChannels()) {
                if (!ch.equals(p.getChannel())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryToMatch(Program p) throws TvBrowserException {
        block33: {
            try {
                ArrayList<Program> arrayList;
                if (!this.matches(p) || this.filterByLimitations(p).length <= 0 || this.isLimitedByChannel(p)) break block33;
                boolean wasOnBlackList = false;
                if (this.mBlackList == null) {
                    arrayList = this.mRemovedBlacklistPrograms;
                    synchronized (arrayList) {
                        if (this.mRemovedBlacklistPrograms.remove(p)) {
                            ArrayList<Program> arrayList2 = this.mBlackList = new ArrayList();
                            synchronized (arrayList2) {
                                this.mBlackList.add(p);
                            }
                            wasOnBlackList = true;
                        }
                    }
                }
                arrayList = this.mBlackList;
                synchronized (arrayList) {
                    int blackListPos = this.mBlackList.indexOf(p);
                    ArrayList<Program> arrayList3 = this.mRemovedBlacklistPrograms;
                    synchronized (arrayList3) {
                        if (this.mRemovedBlacklistPrograms.remove(p) || blackListPos >= 0) {
                            if (blackListPos >= 0) {
                                this.mBlackList.remove(blackListPos);
                            }
                            this.mBlackList.add(p);
                            wasOnBlackList = true;
                        }
                    }
                }
                if (wasOnBlackList) break block33;
                arrayList = this.mPrograms;
                synchronized (arrayList) {
                    boolean newFound = false;
                    int pos = this.mPrograms.indexOf(p);
                    ReminderInfo info = null;
                    if (pos >= 0) {
                        this.mPrograms.remove(pos);
                        this.mPrograms.add(p);
                    }
                    boolean wasOnList = false;
                    Cloneable cloneable = this.mRemovedPrograms;
                    synchronized (cloneable) {
                        info = this.mRemovedPrograms.remove(this.getProgramKeyFor(p));
                        if (info != null) {
                            this.mPrograms.add(p);
                            int reminderMinutes = info.getReminderMinutes();
                            if (reminderMinutes == -42 && !info.equals(p)) {
                                reminderMinutes = this.mDefaultReminderMinutes;
                            }
                            this.markProgram(p, reminderMinutes);
                            wasOnList = true;
                        }
                    }
                    if (pos < 0 && !wasOnList) {
                        this.mPrograms.add(p);
                        this.markProgram(p, this.mDefaultReminderMinutes);
                        if (!p.isExpired()) {
                            cloneable = this.mNewPrograms;
                            synchronized (cloneable) {
                                this.mNewPrograms.add(p);
                            }
                            newFound = true;
                        }
                    }
                    if (newFound) {
                        ProgramReceiveTarget[] pluginArr = this.getForwardPlugins();
                        FavoritesPlugin.getInstance().addProgramsForSending(pluginArr, this.mNewPrograms.toArray(new Program[0]));
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public boolean matches(Program p) throws TvBrowserException {
        return this.getSearcher().matches(p, this.mSearchFormSettings.getFieldTypes());
    }

    public ProgramSearcher getSearcher() throws TvBrowserException {
        return this.mSearchFormSettings.createSearcher();
    }

    public String getSearchText() {
        return this.mSearchFormSettings.getSearchText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgram(Program p) {
        boolean wasInList = false;
        ArrayList<Program> arrayList = this.mPrograms;
        synchronized (arrayList) {
            if (this.mPrograms.remove(p)) {
                int reminderMinutes = this.unmarkProgram(p);
                wasInList = true;
                Cloneable cloneable = this.mRemovedPrograms;
                synchronized (cloneable) {
                    this.mRemovedPrograms.put(this.getProgramKeyFor(p), new ReminderInfo(p.getTitle(), reminderMinutes));
                }
                cloneable = this.mRemovedProgramsList;
                synchronized (cloneable) {
                    this.mRemovedProgramsList.add(p);
                }
            }
            this.mNewPrograms.remove(p);
        }
        if (!wasInList && this.mBlackList != null) {
            arrayList = this.mBlackList;
            synchronized (arrayList) {
                if (this.mBlackList != null && this.mBlackList.remove(p)) {
                    ArrayList<Program> arrayList2 = this.mRemovedBlacklistPrograms;
                    synchronized (arrayList2) {
                        this.mRemovedBlacklistPrograms.add(p);
                    }
                }
            }
        }
    }

    public void clearNewPrograms() {
        if (this.mNewProgramsWasRequested) {
            this.mNewPrograms = new ArrayList(0);
            this.mNewProgramsWasRequested = false;
        }
    }

    public Program[] clearRemovedPrograms() {
        Program[] result = this.mRemovedProgramsList.toArray(new Program[this.mRemovedProgramsList.size()]);
        this.mRemovedPrograms.clear();
        this.mRemovedProgramsList.clear();
        this.mRemovedBlacklistPrograms.clear();
        return result;
    }

    private String getProgramKeyFor(Program p) {
        return p.getUniqueID() + SEPARATOR + p.getTitle();
    }

    public void reValidateChannelLimitation() {
        this.mLimitationConfiguration.reValidateChannels();
    }

    public void revalidatePrograms() {
        new Thread("revalidate favorites"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Program prog;
                int i;
                this.setPriority(1);
                Date todayMinus2 = Date.getCurrentDate().addDays(-2);
                ArrayList<Program> arrayList = Favorite.this.mPrograms;
                synchronized (arrayList) {
                    for (i = Favorite.this.mPrograms.size() - 1; i >= 0; --i) {
                        try {
                            if (Favorite.this.mPrograms.get(i).getDate().compareTo(todayMinus2) <= 0) {
                                Program p = Favorite.this.mPrograms.remove(i);
                                Favorite.this.mNewPrograms.remove(p);
                                continue;
                            }
                            if (Favorite.this.mPrograms.get(i).getProgramState() != 1) continue;
                            prog = Favorite.this.mPrograms.remove(i);
                            int j = Favorite.this.mNewPrograms.indexOf(prog);
                            if (j >= 0) {
                                Favorite.this.mNewPrograms.remove(j);
                            }
                            prog = Plugin.getPluginManager().getProgram(prog.getDate(), prog.getID());
                            Favorite.this.mPrograms.add(i, prog);
                            Favorite.this.mNewPrograms.add(j, prog);
                            continue;
                        }
                        catch (Exception e) {
                            Program p = Favorite.this.mPrograms.remove(i);
                            Favorite.this.mNewPrograms.remove(p);
                        }
                    }
                }
                if (Favorite.this.mBlackList != null) {
                    arrayList = Favorite.this.mBlackList;
                    synchronized (arrayList) {
                        for (i = Favorite.this.mBlackList.size() - 1; i >= 0; --i) {
                            try {
                                if (Favorite.this.mBlackList.get(i).getDate().compareTo(todayMinus2) <= 0) {
                                    Favorite.this.mBlackList.remove(i);
                                    continue;
                                }
                                if (Favorite.this.mBlackList.get(i).getProgramState() != 1) continue;
                                prog = Favorite.this.mBlackList.remove(i);
                                Favorite.this.mBlackList.add(i, Plugin.getPluginManager().getProgram(prog.getDate(), prog.getID()));
                                continue;
                            }
                            catch (Exception e) {
                                Favorite.this.mBlackList.remove(i);
                            }
                        }
                    }
                }
            }
        }.start();
    }

    public void setProvideFilter(boolean provideFilter) {
        if (provideFilter && !this.mProvideFilter) {
            this.mFilterKey = System.currentTimeMillis();
        }
        this.mProvideFilter = provideFilter;
    }

    public boolean isProvidingFilter() {
        return this.mProvideFilter;
    }

    public boolean accept(Program p) {
        if (this.mProvideFilter) {
            return this.mPrograms.contains(p);
        }
        return false;
    }

    public boolean hasFilterForKey(long key) {
        return this.isProvidingFilter() && this.mFilterKey == key;
    }

    public long getFilterKey() {
        return this.mFilterKey;
    }

    public abstract boolean isValidSearch();

    public boolean updateFilterExclusion(ProgramFilter filter, boolean updatePrograms) {
        Exclusion[] exclusions = this.getExclusions();
        boolean result = false;
        for (Exclusion ex : exclusions) {
            if (ex.getFilter() == null || filter == null || !ex.getFilter().equals(filter) && !ex.getFilter().getName().equals(filter.getName())) continue;
            result = true;
            ex.setFilter(filter);
            break;
        }
        if (result && updatePrograms) {
            try {
                this.updatePrograms();
            }
            catch (TvBrowserException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean deleteFilterExclusion(ProgramFilter filter, boolean updatePrograms) {
        boolean result = false;
        if (this.mExclusionList != null) {
            int size = this.mExclusionList.size();
            for (int i = size - 1; i >= 0; --i) {
                Exclusion ex = this.mExclusionList.get(i);
                if (ex.getFilter() == null || !ex.getFilter().equals(filter) && !ex.getFilter().getName().equals(filter.getName())) continue;
                this.mExclusionList.remove(i);
            }
            boolean bl = result = size > this.mExclusionList.size();
            if (result && updatePrograms) {
                try {
                    this.updatePrograms();
                }
                catch (TvBrowserException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public void initializeFilterExclusions() {
        if (this.mExclusionList != null) {
            for (Exclusion ex : this.mExclusionList) {
                ex.getFilter();
            }
        }
    }

    private static final class DeferredProgram {
        private Date mDate;
        private String mId;

        private DeferredProgram(int version, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (version < 7) {
                this.mDate = Date.readData(in);
                this.mId = (String)in.readObject();
            } else {
                this.mId = in.readUTF();
            }
        }

        private Program[] getPrograms() {
            Program[] result = null;
            result = this.mDate != null ? Plugin.getPluginManager().getPrograms(this.mDate, this.mId) : Plugin.getPluginManager().getPrograms(this.mId);
            return result;
        }
    }

    private class ReminderInfo {
        private String mTitle;
        private int mMinutes;

        public ReminderInfo(String title, int minutes) {
            this.mTitle = title;
            this.mMinutes = minutes;
        }

        public int getReminderMinutes() {
            return this.mMinutes;
        }

        public boolean equals(Object o) {
            if (o instanceof Program) {
                Program test = (Program)o;
                return test.getTitle().trim().equalsIgnoreCase(this.mTitle.trim());
            }
            return this == o;
        }
    }
}

