/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramReceiveIf;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JOptionPane;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.misc.HashCodeUtilities;
import util.ui.UiUtilities;

public final class ProgramReceiveTarget
implements Comparable<ProgramReceiveTarget> {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ProgramReceiveTarget.class);
    public static final int TYPE_EVENT_UNDIFINED = 0;
    public static final int TYPE_EVENT_ADDED = 1;
    public static final int TYPE_EVENT_REMOVED = 2;
    private String mReceiveIfId;
    private String mTargetId;
    private String mTargetName;
    private int mSupportedEventType;
    private int mUsedEventType;

    public static ProgramReceiveTarget[] createDefaultTargetArrayForProgramReceiveIf(ProgramReceiveIf receiveIf) {
        return new ProgramReceiveTarget[]{new ProgramReceiveTarget(receiveIf, LOCALIZER.msg("defaultTarget", "Default target"), "NULL")};
    }

    public static ProgramReceiveTarget createDefaultTargetForProgramReceiveIfId(String receiveIfId) {
        return new ProgramReceiveTarget(0, receiveIfId, LOCALIZER.msg("defaultTarget", "Default target"), "NULL");
    }

    private ProgramReceiveTarget(int eventTypeSupported, String receiveIfId, String name, String targetId) {
        this.mSupportedEventType = eventTypeSupported;
        this.mReceiveIfId = receiveIfId;
        this.mTargetName = name;
        this.mTargetId = targetId;
        this.mUsedEventType = 0;
    }

    public ProgramReceiveTarget(ProgramReceiveIf receiveIf, String name, String targetId) {
        this(0, receiveIf.getId(), name, targetId);
    }

    public ProgramReceiveTarget(int eventTypeSupported, ProgramReceiveIf receiveIf, String name, String targetId) {
        this(eventTypeSupported, receiveIf.getId(), name, targetId);
    }

    public ProgramReceiveTarget(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.mReceiveIfId = in.readUTF();
        this.mTargetId = in.readUTF();
        this.mTargetName = in.readUTF();
        this.mUsedEventType = version >= 2 ? in.readInt() : 0;
        this.mSupportedEventType = version >= 3 ? in.readInt() : 0;
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(3);
        out.writeUTF(this.mReceiveIfId);
        out.writeUTF(this.mTargetId);
        out.writeUTF(this.mTargetName);
        out.writeInt(this.mUsedEventType);
        out.writeInt(this.mSupportedEventType);
    }

    public String getTargetName() {
        return this.mTargetName;
    }

    public String toString() {
        return this.getTargetName();
    }

    public String getReceiveIfId() {
        return this.mReceiveIfId;
    }

    public String getTargetId() {
        return this.mTargetId;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ProgramReceiveTarget) {
            return ((ProgramReceiveTarget)o).mReceiveIfId.compareTo(this.mReceiveIfId) == 0 && ((ProgramReceiveTarget)o).mTargetId.compareTo(this.mTargetId) == 0;
        }
        return false;
    }

    public int hashCode() {
        int result = HashCodeUtilities.hash(this.mReceiveIfId);
        result = HashCodeUtilities.hash(result, this.mTargetId);
        return result;
    }

    public ProgramReceiveIf getReceifeIfForIdOfTarget() {
        return Plugin.getPluginManager().getReceiceIfForId(this.mReceiveIfId);
    }

    public static boolean isDefaultProgramReceiveTargetForProgramReceiveIf(ProgramReceiveIf receiveIf, ProgramReceiveTarget receiveTarget) {
        if (receiveIf == null || receiveTarget == null) {
            return false;
        }
        return receiveIf.getId().compareTo(receiveTarget.mReceiveIfId) == 0 && receiveTarget.mTargetId.compareTo("NULL") == 0;
    }

    public boolean isReceiveTargetWithIdOfProgramReceiveIf(ProgramReceiveIf receiveIf, String id) {
        if (receiveIf == null || id == null) {
            return false;
        }
        return receiveIf.getId().compareTo(this.mReceiveIfId) == 0 && id.compareTo(this.mTargetId) == 0;
    }

    @Override
    public int compareTo(ProgramReceiveTarget other) {
        return this.getTargetName().compareTo(other.getTargetName());
    }

    @Deprecated(since="4.2.2")
    public void receivePrograms(Program[] programs) {
        this.receivePrograms(0, programs);
    }

    public boolean receivePrograms(int type, Program[] programs) {
        boolean result = false;
        ProgramReceiveIf plugin = this.getReceifeIfForIdOfTarget();
        if (plugin != null && plugin.canReceiveProgramsWithTarget()) {
            result = plugin.receivePrograms(type, programs, this);
        }
        return result;
    }

    public boolean receiveValues(int type, String[] values) {
        boolean result = false;
        ProgramReceiveIf plugin = this.getReceifeIfForIdOfTarget();
        if (plugin != null && plugin.canReceiveProgramsWithTarget()) {
            result = plugin.receiveValues(type, values, this);
        }
        return result;
    }

    public int getSupportedEventType() {
        return this.mSupportedEventType;
    }

    public int getEventType() {
        return this.mUsedEventType;
    }

    public void setEventType(int eventType) {
        this.mUsedEventType = eventType;
    }

    public static int getEventTypeForSendingAction(Component parent, ProgramReceiveTarget target) {
        int result;
        if (parent == null) {
            parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
        }
        if ((result = target.getSupportedEventType()) == 3) {
            Object[] options = new String[]{LOCALIZER.msg("undefined", "I don't know"), LOCALIZER.msg("added", "Added"), LOCALIZER.msg("removed", "Removed")};
            int selection = JOptionPane.showOptionDialog(parent, LOCALIZER.msg("message", "Were the programs to send added or removed?"), LOCALIZER.msg("title", "Type of sending?"), 1, 3, null, options, options[0]);
            switch (selection) {
                case 2: {
                    result = 2;
                    break;
                }
                case 1: {
                    result = 1;
                    break;
                }
                case 0: {
                    result = 0;
                }
            }
        }
        return result;
    }
}

