#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <stdlib.h>
#include <ncurses.h>
#include <pwd.h>
#include <string.h>
#include "ncdrawlib.h"
#include "nibbles.h"
#include "scoring.h"

int main(int argc, char *argv[])
{
unsigned int speed, delay, basedelay;
map *m;
player *p;
int key;
char *levelDir=NULL;
char *rcfile=NULL;
char *playerName=NULL;
struct passwd *userinfo;
int pos;

cmdline(argc,argv,&basedelay,&levelDir,&rcfile,&playerName);

delay = basedelay;

srand(time(NULL));
m = loadLevel(1,levelDir);
p = newPlayer(m);
initPlayer(p,m);

initDisplay();
init_pair(1, COLOR_WHITE, COLOR_BLACK);
init_pair(2, COLOR_GREEN, COLOR_RED);
init_pair(3, COLOR_GREEN, COLOR_BLACK);
init_pair(4, COLOR_YELLOW, COLOR_BLACK);
init_pair(5, COLOR_WHITE, COLOR_BLUE);
init_pair(6, COLOR_MAGENTA, COLOR_BLACK);
init_pair(7, COLOR_RED, COLOR_YELLOW);
init_pair(8, COLOR_YELLOW, COLOR_RED);
init_pair(9, COLOR_BLUE, COLOR_RED);

showCentreMessage(stdscr,"Nibble for Ncurses, Toby Jaffey, 1999");

drawMap(m,stdscr);
drawPlayer(p,stdscr);

speed = delay;
while((key = cursGetch(&speed))!='q')
	{
	usleep(speed);
	speed = delay;
	if (m->numApples == 0)
		{
		showCentreMessage(stdscr,"Well done. Level Completed");
		delay = (unsigned int)((float)delay * DELAYDEC);
		p->level++;
		m = loadLevel(p->level, levelDir);
		dissolve(stdscr);
		drawMap(m,stdscr);
		initPlayer(p,m);
		drawPlayer(p,stdscr);
		}
	switch(key)
		{
		case 'i':
		p->yd = -1;
		p->xd = 0;
		break;

		case 'j':
		p->xd = -1;
		p->yd = 0;
		break;

		case 'k':
		p->yd = 1;
		p->xd = 0;
		break;

		case 'l':
		p->yd = 0;
		p->xd = 1;
		break;
		}

	wipePlayer(p,stdscr);	// remove the old snake, but don't refresh()
	if (movePlayer(p,m))
		{
		p->lives--;
		drawMap(m,stdscr);
		initPlayer(p,m); // put him back to the start
		flushinp();
		}	
	drawPlayer(p,stdscr);
	if (p->lives<=0)
		{
		showCentreMessage(stdscr,"Game Over");
		break;
		}
	}	
closeDisplay();

if (playerName==NULL)
	{
	userinfo = getpwuid(getuid());
	if (userinfo!=NULL)
		playerName = strdup(userinfo->pw_name);
	else
		playerName = strdup("UNKNOWN");
	}
pos = add_high_score(playerName, basedelay, p->level, p->score);

if (pos==0)
	fprintf(stderr,"\nUnable to write highscore file %s\n\n",highscoref);
else
	if (pos != MAXHIGHSCORES+1)
		printf("\nYou got into position %d in the score table\nnibbles -s displays the scores\n\n",pos);

freePlayer(p);
freeMap(m);
return 0;
}

void showCentreMessage(WINDOW *win, char *str)
{
int maxx,maxy;
int len;

getmaxyx(win,maxy,maxx);
len = strlen(str);

rectangle(win,1,((maxx-len)/2)-1,(maxy/2)-2,len+4,5,' ',0);
rectangle(win,0,((maxx-len)/2)-1,(maxy/2)-2,len+4,5,'#',COLOR_PAIR(7));

attron(COLOR_PAIR(5));
mvwprintw(win,maxy/2,(maxx/2)-len/2,"%s",str);
attroff(COLOR_PAIR(5));

wrefresh(win);

sleep(1); // wait for a bit

flushinp();	// wait for a keypress
getch();
}

