#include <stdio.h>
#include <stdlib.h>
#include <ncurses.h>
#include "nibbles.h"

map *loadLevel(int level, char *levelDir)
{
map *m;
char name[256];

snprintf(name, 256, "%s/%d%s",levelDir,level,LEVELSUFFIX);
if ((m = loadMap(name))==NULL)
        {
	closeDisplay();
	fprintf(stderr,"\nLevel file %s not found\n",name);
        exit(-1);
        }
if (m->random)
	addApples(m,level*2);
return m;
}

map *loadMap(char *name)
{
FILE *fp;
map *m;
int width,height;
int random;
int i,j,c;

fp = fopen(name,"r");

if (fp==NULL)
	{
	fprintf(stderr,"Problem opening %s\n",name);
	return NULL;
	}

if (fscanf(fp,"%d,%d,%d\n",&width,&height,&random)!=3)
	{
	fprintf(stderr,"Top of level file doesn't read: num,num,num\n");
	return NULL;
	}

m = newMap(width,height);

m->random = random;

for(i=0;i<height;i++)
	{
	j=0;
	while ((c=fgetc(fp))!='\n')
		{
		if (c==EOF)
			{
			fprintf(stderr,"Premature EOF\n");
			freeMap(m);
			return NULL;
			}
		m->data[i*width+j] = (brick)c;
		if (c==START)
			{
			m->startx = j;
			m->starty = i;
			}
		if (c==APPLE) m->numApples++;
		j++;
		if (j>width)
			{
			fprintf(stderr,"Line %d is too long in %s\n",i,name);
			freeMap(m);
			return NULL;
			}
		}
	if (j<width)
		{
		fprintf(stderr,"Line %d is too short in %s\n",i,name);
		freeMap(m);
		return NULL;
		}
	}
if (m->startx == -1 || m->starty == -1)
	{
	fprintf(stderr,"No start position in map %s\n",name);
	return NULL;
	}
return m;
}

map *newMap(int width,int height)
{
map *m;

if ((m = (map *)malloc(sizeof(map)))==NULL)
	{
	fprintf(stderr,"Out of memory, destruction imminent\n");
	return 0;
	}
m->width = width;
m->height = height;
m->startx = -1;
m->starty = -1;
m->numApples = 0;
if ((m->data = (brick *)malloc( (sizeof(brick))*width*height ))==NULL)
	{
	fprintf(stderr,"Out of memory, destruction imminent\n");
	return 0;
	}
return m;
}

void freeMap(map *m)
{
if (m==NULL || m->data==NULL)
	{
	fprintf(stderr,"Can't free(NULL). Houston, we have a problem");
	}
free(m->data);
free(m);
}

void drawMap(map *m, WINDOW *w)
{
int i,j;

wclear(w);

for (j=0;j<m->height;j++)
        {
        for (i=0;i<m->width;i++)
                {
		switch(m->data[j*(m->width)+i])
			{
			case WALL:
			mvwaddch(w,j,i,WALLCHAR | COLOR_PAIR(5)); // BLUE #
			break;
			case EMPTY:
			case START:
			// nothing, empty
			mvwaddch(w,j,i,' ');
			break;
			case APPLE:
			mvwaddch(w,j,i,APPLECHAR | COLOR_PAIR(2)); // RED '@'
			break;
			}
                }
        }
wrefresh(w);
}

void addApples(map *m, int numApples)
{
int x,y,i;

m->numApples = numApples;

x = rand()%m->width;
y = rand()%m->height;

for (i=0;i<numApples;i++)
	{
	while (m->data[y*m->width+x]!=EMPTY)
		{
		x = rand()%m->width;
		y = rand()%m->height;
		}
	m->data[y*m->width+x] = APPLE;
	}
}



