/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_br extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bn = "bengali";
        final String metaValue_chr = "cherokee";
        final String metaValue_gu = "gujarati";
        final String metaValue_km = "khmer";
        final String metaValue_la = "latin";
        final String metaValue_ml = "malayalam";
        final String metaValue_or = "oriya";
        final String metaValue_te = "telougou";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "thai";
        final String metaValue_vai = "vai";
        final String metaValue_Hans = "eeunaet";
        final Object[][] data = new Object[][] {
            { "001", "Bed" },
            { "002", "Afrika" },
            { "003", "Norzhamerika" },
            { "005", "Suamerika" },
            { "009", "Oseania" },
            { "011", "Afrika ar Cʼhornôg" },
            { "013", "Kreizamerika" },
            { "014", "Afrika ar Reter" },
            { "015", "Afrika an Norzh" },
            { "017", "Afrika ar Cʼhreiz" },
            { "018", "Afrika ar Su" },
            { "019", "Amerikaoù" },
            { "021", "Amerika an Norzh" },
            { "029", "Karib" },
            { "030", "Azia ar Reter" },
            { "034", "Azia ar Su" },
            { "035", "Azia ar Gevred" },
            { "039", "Europa ar Su" },
            { "053", "Aostralazia" },
            { "054", "Melanezia" },
            { "057", "Rannved Mikronezia" },
            { "061", "Polinezia" },
            { "142", "Azia" },
            { "143", "Azia ar Cʼhreiz" },
            { "145", "Azia ar Cʼhornôg" },
            { "150", "Europa" },
            { "151", "Europa ar Reter" },
            { "154", "Europa an Norzh" },
            { "155", "Europa ar Cʼhornôg" },
            { "202", "Afrika issaharat" },
            { "419", "Amerika Latin" },
            { "AC", "Enez Ascension" },
            { "AD", "Andorra" },
            { "AE", "Emirelezhioù Arab Unanet" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua ha Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Arcʼhantina" },
            { "AS", "Samoa Amerikan" },
            { "AT", "Aostria" },
            { "AU", "Aostralia" },
            { "AW", "Aruba" },
            { "AX", "Inizi Åland" },
            { "AZ", "Azerbaidjan" },
            { "BA", "Bosnia ha Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karib Nederlandat" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "BT", "Bhoutan" },
            { "BV", "Enez Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Inizi Kokoz" },
            { "CD", "Kongo - Kinshasa" },
            { "CF", "Republik Kreizafrikan" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Suis" },
            { "CI", "Aod an Olifant" },
            { "CK", "Inizi Cook" },
            { "CL", "Chile" },
            { "CM", "Kameroun" },
            { "CN", "Sina" },
            { "CO", "Kolombia" },
            { "CP", "Enez Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kab-Glas" },
            { "CW", "Curaçao" },
            { "CX", "Enez Christmas" },
            { "CY", "Kiprenez" },
            { "CZ", "Tchekia" },
            { "DE", "Alamagn" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "DM", "Dominica" },
            { "DO", "Republik Dominikan" },
            { "DZ", "Aljeria" },
            { "EA", "Ceuta ha Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egipt" },
            { "EH", "Sahara ar Cʼhornôg" },
            { "ER", "Eritrea" },
            { "ES", "Spagn" },
            { "ET", "Etiopia" },
            { "EU", "Unaniezh Europa" },
            { "EZ", "takad an euro" },
            { "FI", "Finland" },
            { "FJ", "Fidji" },
            { "FK", "Inizi Falkland" },
            { "FM", "Mikronezia" },
            { "FO", "Inizi Faero" },
            { "FR", "Frañs" },
            { "GA", "Gabon" },
            { "GB", "Rouantelezh-Unanet" },
            { "GD", "Grenada" },
            { "GE", "Jorjia" },
            { "GF", "Gwiana cʼhall" },
            { "GG", "Gwernenez" },
            { "GH", "Ghana" },
            { "GI", "Jibraltar" },
            { "GL", "Greunland" },
            { "GM", "Gambia" },
            { "GN", "Ginea" },
            { "GP", "Gwadeloup" },
            { "GQ", "Ginea ar Cʼheheder" },
            { "GR", "Gres" },
            { "GS", "Inizi Georgia ar Su hag Inizi Sandwich ar Su" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Ginea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong RMD Sina" },
            { "HM", "Inizi Heard ha McDonald" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "HT", "Haiti" },
            { "HU", "Hungaria" },
            { "IC", "Inizi Kanariez" },
            { "ID", "Indonezia" },
            { "IE", "Iwerzhon" },
            { "IL", "Israel" },
            { "IM", "Enez Vanav" },
            { "IN", "India" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italia" },
            { "JE", "Jerzenez" },
            { "JM", "Jamaika" },
            { "JO", "Jordania" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komorez" },
            { "KN", "Saint Kitts ha Nevis" },
            { "KP", "Korea an Norzh" },
            { "KR", "Korea ar Su" },
            { "KW", "Koweit" },
            { "KY", "Inizi Cayman" },
            { "KZ", "Kazakstan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luksembourg" },
            { "LV", "Latvia" },
            { "LY", "Libia" },
            { "MA", "Maroko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Inizi Marshall" },
            { "MK", "Makedonia an Norzh" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "Macau RMD Sina" },
            { "MP", "Inizi Mariana an Norzh" },
            { "MQ", "Martinik" },
            { "MR", "Maouritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Moris" },
            { "MV", "Maldivez" },
            { "MW", "Malawi" },
            { "MX", "Mecʼhiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambik" },
            { "NA", "Namibia" },
            { "NC", "Kaledonia Nevez" },
            { "NE", "Niger" },
            { "NF", "Enez Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Izelvroioù" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Zeland-Nevez" },
            { "OM", "Oman" },
            { "PA", "Panamá" },
            { "PE", "Perou" },
            { "PF", "Polinezia Cʼhall" },
            { "PG", "Papoua Ginea-Nevez" },
            { "PH", "Filipinez" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "PM", "Sant-Pêr-ha-Mikelon" },
            { "PN", "Enez Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Tiriadoù Palestina" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oseania diabell" },
            { "RE", "Ar Reünion" },
            { "RO", "Roumania" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Rwanda" },
            { "SA", "Arabia Saoudat" },
            { "SB", "Inizi Salomon" },
            { "SC", "Sechelez" },
            { "SD", "Soudan" },
            { "SE", "Sveden" },
            { "SG", "Singapour" },
            { "SH", "Saint-Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Susoudan" },
            { "ST", "São Tomé ha Príncipe" },
            { "SV", "Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Inizi Turks ha Caicos" },
            { "TD", "Tchad" },
            { "TF", "Douaroù aostral Frañs" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunizia" },
            { "TO", "Tonga" },
            { "TR", "Turkia" },
            { "TT", "Trinidad ha Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraina" },
            { "UG", "Ouganda" },
            { "UM", "Inizi diabell ar Stadoù-Unanet" },
            { "UN", "Broadoù unanet" },
            { "US", "Stadoù-Unanet" },
            { "UY", "Uruguay" },
            { "UZ", "Ouzbekistan" },
            { "VA", "Vatikan" },
            { "VC", "Sant Visant hag ar Grenadinez" },
            { "VE", "Venezuela" },
            { "VG", "Inizi Gwercʼh Breizh-Veur" },
            { "VI", "Inizi Gwercʼh ar Stadoù-Unanet" },
            { "VN", "Viêt Nam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis ha Futuna" },
            { "WS", "Samoa" },
            { "XA", "pouez-mouezh gaou" },
            { "XB", "BiDi gaou" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Suafrika" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Rannved dianav" },
            { "aa", "afar" },
            { "ab", "abkhazeg" },
            { "ae", "avesteg" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhareg" },
            { "an", "aragoneg" },
            { "ar", "arabeg" },
            { "as", "asameg" },
            { "av", "avar" },
            { "ay", "aymara" },
            { "az", "azerbaidjaneg" },
            { "ba", "bachkir" },
            { "be", "belaruseg" },
            { "bg", "bulgareg" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", "tibetaneg" },
            { "br", "brezhoneg" },
            { "bs", "bosneg" },
            { "ca", "katalaneg" },
            { "ce", "tchetcheneg" },
            { "ch", "chamorru" },
            { "co", "korseg" },
            { "cr", "kri" },
            { "cs", "tchekeg" },
            { "cu", "slavoneg iliz" },
            { "cv", "tchouvatch" },
            { "cy", "kembraeg" },
            { "da", "daneg" },
            { "de", "alamaneg" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "gresianeg" },
            { "en", "saozneg" },
            { "eo", "esperanteg" },
            { "es", "spagnoleg" },
            { "et", "estoneg" },
            { "eu", "euskareg" },
            { "fa", "perseg" },
            { "ff", "fula" },
            { "fi", "finneg" },
            { "fj", "fidjieg" },
            { "fo", "faeroeg" },
            { "fr", "galleg" },
            { "fy", "frizeg ar Cʼhornôg" },
            { "ga", "iwerzhoneg" },
            { "gd", "skoseg" },
            { "gl", "galizeg" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manaveg" },
            { "ha", "haousa" },
            { "he", "hebraeg" },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "kroateg" },
            { "ht", "haitieg" },
            { "hu", "hungareg" },
            { "hy", "armenianeg" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonezeg" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yieg Sichuan" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islandeg" },
            { "it", "italianeg" },
            { "iu", "inuktitut" },
            { "ja", "japaneg" },
            { "jv", "javaneg" },
            { "ka", "jorjianeg" },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kwanyama" },
            { "kk", "kazak" },
            { "kl", "greunlandeg" },
            { "km", metaValue_km },
            { "kn", "kanareg" },
            { "ko", "koreaneg" },
            { "kr", "kanouri" },
            { "ks", "kashmiri" },
            { "ku", "kurdeg" },
            { "kv", "komieg" },
            { "kw", "kerneveureg" },
            { "ky", "kirgiz" },
            { "la", metaValue_la },
            { "lb", "luksembourgeg" },
            { "lg", "ganda" },
            { "li", "limbourgeg" },
            { "ln", "lingala" },
            { "lo", "laoseg" },
            { "lt", "lituaneg" },
            { "lu", "luba-katanga" },
            { "lv", "latvieg" },
            { "mg", "malgacheg" },
            { "mh", "marshall" },
            { "mi", "maori" },
            { "mk", "makedoneg" },
            { "ml", metaValue_ml },
            { "mn", "mongoleg" },
            { "mr", "marathi" },
            { "ms", "malayseg" },
            { "mt", "malteg" },
            { "my", "birmaneg" },
            { "na", "naurueg" },
            { "nb", "norvegeg bokmål" },
            { "nd", "ndebele an Norzh" },
            { "ne", "nepaleg" },
            { "ng", "ndonga" },
            { "nl", "nederlandeg" },
            { "nn", "norvegeg nynorsk" },
            { "no", "norvegeg" },
            { "nr", "ndebele ar Su" },
            { "nv", "navacʼho" },
            { "ny", "nyanja" },
            { "oc", "okitaneg" },
            { "oj", "ojibweg" },
            { "om", "oromoeg" },
            { "or", metaValue_or },
            { "os", "oseteg" },
            { "pa", "punjabi" },
            { "pi", "pali" },
            { "pl", "poloneg" },
            { "ps", "pachto" },
            { "pt", "portugaleg" },
            { "qu", "kechuaeg" },
            { "rm", "romañcheg" },
            { "rn", "rundi" },
            { "ro", "roumaneg" },
            { "ru", "rusianeg" },
            { "rw", "kinyarwanda" },
            { "sa", "sanskriteg" },
            { "sc", "sardeg" },
            { "sd", "sindhi" },
            { "se", "sámi an Norzh" },
            { "sg", "sango" },
            { "sh", "serb-kroateg" },
            { "si", "singhaleg" },
            { "sk", "slovakeg" },
            { "sl", "sloveneg" },
            { "sm", "samoan" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albaneg" },
            { "sr", "serbeg" },
            { "ss", "swati" },
            { "st", "sotho ar Su" },
            { "su", "sundaneg" },
            { "sv", "svedeg" },
            { "sw", "swahili" },
            { "ta", "tamileg" },
            { "te", metaValue_te },
            { "tg", "tadjik" },
            { "th", metaValue_th },
            { "ti", "tigrigna" },
            { "tk", "turkmeneg" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonga" },
            { "tr", "turkeg" },
            { "ts", "tsonga" },
            { "tt", "tatar" },
            { "tw", "twi" },
            { "ty", "tahitianeg" },
            { "ug", "ouigoureg" },
            { "uk", "ukraineg" },
            { "ur", "ourdou" },
            { "uz", "ouzbekeg" },
            { "ve", "venda" },
            { "vi", "vietnameg" },
            { "vo", "volapük" },
            { "wa", "walloneg" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yorouba" },
            { "za", "zhuang" },
            { "zh", "sinaeg" },
            { "zu", "zouloueg" },
            { "ace", "achineg" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adygeieg" },
            { "aeb", "arabeg Tunizia" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainoueg" },
            { "akk", "akadeg" },
            { "akz", "alabamaeg" },
            { "ale", "aleouteg" },
            { "aln", "gegeg" },
            { "alt", "altaieg ar Su" },
            { "ang", "hensaozneg" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "arameeg" },
            { "arn", "araoukaneg" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "arabeg Aljeria" },
            { "ars", "arabeg nadjiek" },
            { "arw", "arawakeg" },
            { "ary", "arabeg Maroko" },
            { "arz", "arabeg Egipt" },
            { "asa", "asu" },
            { "ase", "yezh sinoù Amerika" },
            { "ast", "asturianeg" },
            { "atj", "atikamekweg" },
            { "awa", "awadhi" },
            { "bal", "baloutchi" },
            { "ban", "balineg" },
            { "bar", "bavarieg" },
            { "bas", "basaa" },
            { "bej", "bedawieg" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgn", "baloutchi ar Cʼhornôg" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "bra", "braj" },
            { "brh", "brahweg" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "bouriat" },
            { "bug", "bugi" },
            { "byn", "blin" },
            { "cad", "caddo" },
            { "car", "karibeg" },
            { "cay", "kayougeg" },
            { "cch", "atsam" },
            { "ccp", "chakmaeg" },
            { "ceb", "cebuano" },
            { "cgg", "chigaeg" },
            { "chb", "chibcha" },
            { "chk", "chuuk" },
            { "chm", "marieg" },
            { "cho", "choktaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "kurdeg sorani" },
            { "clc", "chilkotineg" },
            { "cop", "kopteg" },
            { "crg", "michifeg" },
            { "crh", "turkeg Krimea" },
            { "crj", "krieg ar Gevred" },
            { "crk", "krieg ar cʼhompezennoù" },
            { "crl", "krieg ar Biz" },
            { "crm", "krieg ar cʼhornôg" },
            { "crr", "algonkeg Carolina" },
            { "crs", "kreoleg Sechelez" },
            { "csb", "kachoubeg" },
            { "csw", "krieg ar gwernioù" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "izelsorabeg" },
            { "dua", "douala" },
            { "dum", "nederlandeg krenn" },
            { "dyo", "diola" },
            { "dyu", "dyula" },
            { "dzg", "dazagaeg" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "henegipteg" },
            { "eka", "ekajuk" },
            { "elx", "elameg" },
            { "enm", "krennsaozneg" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipineg" },
            { "fit", "finneg traoñienn an Torne" },
            { "fon", "fon" },
            { "frc", "galleg cajun" },
            { "frm", "krenncʼhalleg" },
            { "fro", "hencʼhalleg" },
            { "frp", "arpitaneg" },
            { "frr", "frizeg an Norzh" },
            { "frs", "frizeg ar Reter" },
            { "fur", "frioulaneg" },
            { "gaa", "ga" },
            { "gag", "gagaouzeg" },
            { "gan", "sinaeg Gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gez", "gezeg" },
            { "gil", "gilberteg" },
            { "gmh", "krennalamaneg uhel" },
            { "goh", "henalamaneg uhel" },
            { "gor", "gorontalo" },
            { "got", "goteg" },
            { "grb", "grebo" },
            { "grc", "hencʼhresianeg" },
            { "gsw", "alamaneg Suis" },
            { "guz", "gusiieg" },
            { "gwi", "gwich’in" },
            { "hai", "haideg" },
            { "hak", "sinaeg Hakka" },
            { "haw", "hawaieg" },
            { "hax", "haideg ar Su" },
            { "hil", "hiligaynon" },
            { "hmn", "hmong" },
            { "hsb", "uhelsorabeg" },
            { "hsn", "sinaeg Xian" },
            { "hup", "hupa" },
            { "hur", "halkomelemeg" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut Kanada ar Cʼhornôg" },
            { "ilo", "ilokanoeg" },
            { "inh", "ingoucheg" },
            { "jam", "kreoleg Jamaika" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "yuzev-perseg" },
            { "jrb", "yuzev-arabeg" },
            { "kaa", "karakalpak" },
            { "kab", "kabileg" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kbd", "kabardeg" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kabuverdianu" },
            { "kfo", "koroeg" },
            { "kgp", "kaingangeg" },
            { "kha", "khasi" },
            { "kho", "khotaneg" },
            { "khq", "koyra chiini" },
            { "kkj", "kakoeg" },
            { "kln", "kalendjineg" },
            { "kmb", "kimbundu" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "kpe", "kpelle" },
            { "krc", "karatchay-balkar" },
            { "kri", "krio" },
            { "krl", "karelieg" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafiaeg" },
            { "ksh", "koluneg" },
            { "kum", "koumikeg" },
            { "kut", "kutenai" },
            { "kwk", "kwakwaleg" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgi" },
            { "lfn", "lingua franca nova" },
            { "lij", "ligurieg" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lol", "mongo" },
            { "lou", "kreoleg Louiziana" },
            { "loz", "lozi" },
            { "lrc", "loureg an Norzh" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "luy", "luyia" },
            { "lzh", "sinaeg lennegel" },
            { "mad", "madoureg" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "moriseg" },
            { "mga", "krenniwerzhoneg" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "metaʼ" },
            { "mic", "mikmakeg" },
            { "min", "minangkabau" },
            { "mnc", "manchou" },
            { "mni", "manipuri" },
            { "moe", "montagneg" },
            { "moh", "mohawk" },
            { "mos", "more" },
            { "mrj", "marieg ar Cʼhornôg" },
            { "mua", "moundangeg" },
            { "mul", "yezhoù lies" },
            { "mus", "muskogi" },
            { "mwl", "mirandeg" },
            { "myv", "erza" },
            { "mzn", "mazanderaneg" },
            { "nan", "sinaeg Min Nan" },
            { "nap", "napolitaneg" },
            { "naq", "nama" },
            { "nds", "alamaneg izel" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niue" },
            { "njo", "aoeg" },
            { "nmg", "ngoumbeg" },
            { "nnh", "ngiemboon" },
            { "nog", "nogay" },
            { "non", "hennorseg" },
            { "nov", "novial" },
            { "nqo", "nkoeg" },
            { "nso", "sotho an Norzh" },
            { "nus", "nouereg" },
            { "nwc", "newari klasel" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "ojb", "ojibweg ar Gwalarn" },
            { "ojc", "ojibweg ar cʼhreiz" },
            { "ojs", "ojibweg Severn" },
            { "ojw", "ojibweg ar Cʼhornôg" },
            { "oka", "okanaganeg" },
            { "osa", "osage" },
            { "ota", "turkeg otoman" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "pcd", "pikardeg" },
            { "pcm", "pidjin Nigeria" },
            { "pdc", "alamaneg Pennsylvania" },
            { "peo", "henberseg" },
            { "phn", "fenikianeg" },
            { "pis", "pidjin" },
            { "pms", "piemonteg" },
            { "pnt", "ponteg" },
            { "pon", "pohnpei" },
            { "pqm", "malisiteg-pasamawkodieg" },
            { "prg", "henbruseg" },
            { "pro", "henbrovañseg" },
            { "quc", "kʼicheʼ" },
            { "qug", "kichuaeg Chimborazo" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "rgn", "romagnoleg" },
            { "rhg", "rohingya" },
            { "rof", "rombo" },
            { "rom", "romanieg" },
            { "rup", "aroumaneg" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "yakouteg" },
            { "sam", "arameeg ar Samaritaned" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "sba", "ngambayeg" },
            { "sbp", "sangu" },
            { "scn", "sikilieg" },
            { "sco", "skoteg" },
            { "sdc", "sasareseg" },
            { "seh", "sena" },
            { "ses", "koyraboro senni" },
            { "sga", "heniwerzhoneg" },
            { "shi", "tacheliteg" },
            { "shn", "shan" },
            { "shu", "arabeg Tchad" },
            { "sid", "sidamo" },
            { "slh", "luchoutsideg ar Su" },
            { "sma", "sámi ar Su" },
            { "smj", "sámi Luleå" },
            { "smn", "sámi Inari" },
            { "sms", "sámi Skolt" },
            { "snk", "soninke" },
            { "sog", "sogdieg" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", "sahoeg" },
            { "suk", "sukuma" },
            { "sux", "sumereg" },
            { "swb", "komoreg" },
            { "syc", "sirieg klasel" },
            { "syr", "sirieg" },
            { "szl", "silezieg" },
            { "tce", "tutchoneg ar Su" },
            { "tcy", "touloueg" },
            { "tem", "temne" },
            { "teo", "tesoeg" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tig", "tigreaneg" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tlh", "klingon" },
            { "tli", "tinglit" },
            { "tmh", "tamacheg" },
            { "tog", "nyasa tonga" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "tru", "turoyoeg" },
            { "trv", "taroko" },
            { "tsi", "tsimshian" },
            { "ttm", "tutchoneg an Norzh" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawakeg" },
            { "tyv", "touva" },
            { "tzm", "tamazigteg Kreizatlas" },
            { "udm", "oudmourteg" },
            { "uga", "ougariteg" },
            { "umb", "umbundu" },
            { "und", "yezh dianav" },
            { "vai", metaValue_vai },
            { "vec", "venezieg" },
            { "vep", "vepseg" },
            { "vls", "flandrezeg ar c’hornôg" },
            { "vot", "votyakeg" },
            { "vro", "voroeg" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wuu", "sinaeg Wu" },
            { "xal", "kalmouk" },
            { "xmf", "megreleg" },
            { "xog", "sogaeg" },
            { "yao", "yao" },
            { "yap", "yapeg" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nengatoueg" },
            { "yue", "kantoneg" },
            { "zap", "zapoteg" },
            { "zbl", "arouezioù Bliss" },
            { "zea", "zelandeg" },
            { "zen", "zenaga" },
            { "zgh", "tamacheg Maroko standart" },
            { "zun", "zuni" },
            { "zxx", "diyezh" },
            { "zza", "zazakeg" },
            { "Adlm", "adlam" },
            { "Arab", "arabek" },
            { "Armi", "arameek impalaerel" },
            { "Armn", "armenianek" },
            { "Avst", "avestek" },
            { "Bali", "balinek" },
            { "Bamu", "bamounek" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brai", "Braille" },
            { "Bugi", "bougiek" },
            { "Cakm", "chakmaek" },
            { "Cans", "silabennaoueg engenidik unvan Kanada" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Copt", "koptek" },
            { "Cprt", "silabennaoueg kipriek" },
            { "Cyrl", "kirillek" },
            { "Cyrs", "kirillek henslavonek" },
            { "Deva", "devanagari" },
            { "Dupl", "berrskriverezh Duployé" },
            { "Egyp", "hieroglifoù egiptek" },
            { "Ethi", "etiopek" },
            { "Geor", "jorjianek" },
            { "Glag", "glagolitek" },
            { "Goth", "gotek" },
            { "Grek", "gresianek" },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han gant bopomofo" },
            { "Hang", "hangeul" },
            { "Hani", "sinalunioù (han)" },
            { "Hans", metaValue_Hans },
            { "Hant", "hengounel" },
            { "Hebr", "hebraek" },
            { "Hira", "hiragana" },
            { "Hluw", "hieroglifoù Anatolia" },
            { "Hrkt", "silabennaouegoù japanek" },
            { "Hung", "henhungarek" },
            { "Ital", "henitalek" },
            { "Jamo", "jamo" },
            { "Java", "javanek" },
            { "Jpan", "japanek" },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", "kannada" },
            { "Kore", "koreanek" },
            { "Laoo", "laosek" },
            { "Latg", "latin gouezelek" },
            { "Latn", metaValue_la },
            { "Lyci", "likiek" },
            { "Lydi", "lidiek" },
            { "Mani", "manikeek" },
            { "Maya", "hieroglifoù mayaek" },
            { "Mlym", metaValue_ml },
            { "Mong", "mongolek" },
            { "Mymr", "myanmar" },
            { "Narb", "henarabek an Norzh" },
            { "Ogam", "ogam" },
            { "Orya", metaValue_or },
            { "Phnx", "fenikianek" },
            { "Runr", "runek" },
            { "Samr", "samaritek" },
            { "Sarb", "henarabek ar Su" },
            { "Sinh", "singhalek" },
            { "Sund", "sundanek" },
            { "Syrc", "siriek" },
            { "Syre", "siriek Estrangelā" },
            { "Syrj", "siriek ar C’hornôg" },
            { "Syrn", "siriek ar Reter" },
            { "Taml", "tamilek" },
            { "Telu", metaValue_te },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", "tibetanek" },
            { "Ugar", "ougaritek" },
            { "Vaii", metaValue_vai },
            { "Xpeo", "persek kozh" },
            { "Xsux", "gennheñvel" },
            { "Zinh", "hêrezh" },
            { "Zmth", "notadur jedoniel" },
            { "Zsye", "fromlunioù" },
            { "Zsym", "arouezioù" },
            { "Zxxx", "anskrivet" },
            { "Zyyy", "boutin" },
            { "Zzzz", "skritur dianav" },
            { "de_AT", "alamaneg Aostria" },
            { "de_CH", "alamaneg uhel Suis" },
            { "en_AU", "saozneg Aostralia" },
            { "en_CA", "saozneg Kanada" },
            { "en_GB", "saozneg Breizh-Veur" },
            { "en_US", "saozneg Amerika" },
            { "es_ES", "spagnoleg Europa" },
            { "es_MX", "spagnoleg Mecʼhiko" },
            { "fa_AF", "dareg" },
            { "fr_CA", "galleg Kanada" },
            { "fr_CH", "galleg Suis" },
            { "nl_BE", "flandrezeg" },
            { "pt_BR", "portugaleg Brazil" },
            { "pt_PT", "portugaleg Europa" },
            { "ro_MD", "moldoveg" },
            { "sw_CD", "swahili Kongo" },
            { "%%1901", "reizhskrivadur alamanek hengounel" },
            { "%%1994", "reizhskrivadur resianek skoueriekaet" },
            { "%%1996", "reizhskrivadur alamanek 1996" },
            { "ar_001", "arabeg modern" },
            { "es_419", "spagnoleg Amerika latin" },
            { "key.ca", "deiziadur" },
            { "key.cf", "furmad moneiz" },
            { "key.co", "doare rummañ" },
            { "key.cu", "moneiz" },
            { "key.hc", "kelcʼhiad eurioù" },
            { "key.lb", "stil torr linenn" },
            { "key.ms", "reizhiad vuzuliañ" },
            { "key.nu", "niveroù" },
            { "nds_NL", "saksoneg izel" },
            { "%%ALUKU", "rannyezh aloukou" },
            { "%%BARLA", "rannyezhoù Barlavento kreoleg ar Cʼhab-Glas" },
            { "%%BISKE", "rannyezh San Giorgio/Bila" },
            { "%%BOONT", "boontling" },
            { "%%CORNU", "saozneg Kerne-Veur" },
            { "%%GALLO", "gallaoueg" },
            { "%%JAUER", "rannyezh romañchek Jauer" },
            { "%%KKCOR", "kerneveureg kumun" },
            { "%%KSCOR", "kerneveureg standart" },
            { "%%LIPAW", "rannyezh resianek Lipovaz" },
            { "%%NEDIS", "rannyezh Natisone" },
            { "%%NJIVA", "rannyezh Gniva/Njiva" },
            { "%%NULIK", "volapük modern" },
            { "%%OSOJS", "rannyezh Oseacco/Osojane" },
            { "%%PEANO", "Peano" },
            { "%%POSIX", "stlenneg" },
            { "%%PUTER", "rannyezh romañchek Puter" },
            { "%%RIGIK", "volapük klasel" },
            { "%%ROZAJ", "resianeg" },
            { "%%RUMGR", "romañcheg Grischun" },
            { "%%SAAHO", "saho" },
            { "%%SOLBA", "rannyezh Stolvizza/Solbica" },
            { "%%SOTAV", "rannyezhoù Sotavento kreoleg ar Cʼhab-Glas" },
            { "%%UCCOR", "kerneveureg unvan" },
            { "zh_Hans", "sinaeg eeunaet" },
            { "zh_Hant", "sinaeg hengounel" },
            { "%%AO1990", "emglev 1990 war ar reizhskrivadur portugalek" },
            { "%%ARANES", "araneg" },
            { "%%ASANTE", "achanti" },
            { "%%AUVERN", "arverneg" },
            { "%%CISAUP", "kizalpeg" },
            { "%%CREISS", "rannyezhoù Creissent" },
            { "%%DAJNKO", "lizherenneg Dajnko" },
            { "%%EKAVSK", "serbeg gant distagadur ekavian" },
            { "%%FONIPA", "lizherenneg fonetek etrebroadel" },
            { "%%FONUPA", "lizherenneg fonetek ouralek" },
            { "%%GASCON", "gwaskoneg" },
            { "%%GRITAL", "skritur okitanek Italia" },
            { "%%NDYUKA", "rannyezh Ndyuka" },
            { "%%NICARD", "nisardeg" },
            { "%%PAMAKA", "rannyezh Pamaka" },
            { "%%PINYIN", "romanekadur pinyin" },
            { "%%SCOUSE", "saozneg Liverpool (scouse)" },
            { "%%SIMPLE", metaValue_Hans },
            { "%%TARASK", "belaruseg Taraskievica" },
            { "%%UCRCOR", "kerneveureg unvan reizhet" },
            { "%%ULSTER", "rannyezh skotek Ulad" },
            { "%%UNIFON", "lizherenneg fonetek Unifon" },
            { "%%ABL1943", "doare reizhskrivañ 1943" },
            { "%%AKUAPEM", "akuapem" },
            { "%%ALALC97", "romanekadur ALA-LC 1997" },
            { "%%AREVELA", "armenianeg ar Reter" },
            { "%%AREVMDA", "armenianeg ar Cʼhornôg" },
            { "%%ARKAIKA", "henesperanteg" },
            { "%%BALANKA", "rannyezh aniiek Balanka" },
            { "%%BAUDDHA", "sanskriteg hiron boudaat" },
            { "%%BOHORIC", "lizherenneg Bohorič" },
            { "%%EMODENG", "saozneg rakvodern" },
            { "%%FONNAPA", "lizherenneg fonetek Norzh Amerika" },
            { "%%GRCLASS", "skritur okitanek klasel" },
            { "%%GRMISTR", "skritur okitanek mistralek" },
            { "%%HEPBURN", "romanekadur Hepburn" },
            { "%%ITIHASA", "sanskriteg itihâsa" },
            { "%%LAUKIKA", "sanskriteg klasel" },
            { "%%LEMOSIN", "rannyezh Limousin" },
            { "%%METELKO", "lizherenneg Metelko" },
            { "%%MONOTON", "gresianeg untonel" },
            { "%%PAHAWH2", "reizhskrivadur pahawh hmong lankad 2" },
            { "%%PAHAWH3", "reizhskrivadur pahawh hmong lankad 3" },
            { "%%PAHAWH4", "reizhskrivadur pahawh hmong doare diwezhañ" },
            { "%%POLYTON", "gresianeg liestonel" },
            { "%%PROVENC", "provañseg" },
            { "%%REVISED", "reizhskrivadur reizhet" },
            { "%%SURSILV", "rannyezh romañchek sursilvan" },
            { "%%SUTSILV", "rannyezh romañchek sutsilvan" },
            { "%%VAIDIKA", "sanskriteg vedek" },
            { "%%1606NICT", "krenncʼhalleg diwezhañ" },
            { "%%1694ACAD", "galleg rakvodern" },
            { "%%1959ACAD", "belaruseg akademek" },
            { "%%BAKU1926", "lizherenneg latin turkek unvan" },
            { "%%BASICENG", "saozneg diazez" },
            { "%%BISCAYAN", "rannyezh euskarek Bizkaia" },
            { "%%BORNHOLM", "rannyezh Bornholm" },
            { "%%COLB1945", "emglev 1945 war reizhskrivadur portugaleg Brazil" },
            { "%%FONKIRSH", "lizherenneg fonetek Kirshenbaum" },
            { "%%FONXSAMP", "treuzskrivadur X-SAMPA" },
            { "%%HOGNORSK", "uhelnorvegeg" },
            { "%%HSISTEMO", "esperanteg sistem H" },
            { "%%IJEKAVSK", "serbeg gant distagadur ijekavian" },
            { "%%IVANCHOV", "reizhskrivadur bulgarek Ivanchov" },
            { "%%JYUTPING", "romanekadur kantonek Jyutping" },
            { "%%KOCIEWIE", "rannyezh polonek Kociewie" },
            { "%%LENGADOC", "lengadokeg" },
            { "%%LUNA1918", "reizhskrivadur rusianek goude 1917" },
            { "%%NEWFOUND", "saozneg an Douar-Nevez" },
            { "%%OXENDICT", "skritur Oxford English Dictionary" },
            { "%%PETR1708", "reizhskrivadur rusianek 1708 Pêr I" },
            { "%%SCOTLAND", "saozneg standart Skos" },
            { "%%SPANGLIS", "spanglish" },
            { "%%SURMIRAN", "rannyezh romañchek surmiran" },
            { "%%SYNNEJYL", "rannyezh Jutland ar Su" },
            { "%%TONGYONG", "Tongyong Pinyin" },
            { "%%TUNUMIIT", "tunumiit" },
            { "%%VALENCIA", "valensianeg" },
            { "%%VALLADER", "rannyezh romañchek Vallader" },
            { "%%VECDRUKA", "vecā druka" },
            { "%%VIVARAUP", "vivaroalpeg" },
            { "%%WADEGILE", "romanekadur Wade-Giles" },
            { "%%XSISTEMO", "esperanteg sistem X" },
            { "type.ca.roc", "deiziadur Republik Sina" },
            { "type.co.eor", "reolennoù urzhiañ europat" },
            { "type.hc.h11", "reizhiad 12 eurvezh (0–11)" },
            { "type.hc.h12", "reizhiad 12 eurvezh (1–12)" },
            { "type.hc.h23", "reizhiad 24 eurvezh (0–23)" },
            { "type.hc.h24", "reizhiad 24 eurvezh (1–24)" },
            { "type.nu.ahom", "sifroù ahomek" },
            { "type.nu.arab", "sifroù arabek indian" },
            { "type.nu.armn", "niveroù armenianek" },
            { "type.nu.bali", "sifroù balinek" },
            { "type.nu.beng", "sifroù bengali" },
            { "type.nu.brah", "sifroù brahmi" },
            { "type.nu.cakm", "sifroù chakma" },
            { "type.nu.cham", "sifroù cham" },
            { "type.nu.cyrl", "niveroù kirillek" },
            { "type.nu.deva", "sifroù devanagari" },
            { "type.nu.diak", "sifroù Divehi Akuru" },
            { "type.nu.ethi", "niveroù etiopiat" },
            { "type.nu.geor", "niveroù jorjianek" },
            { "type.nu.gong", "sifroù gondi Gunjala" },
            { "type.nu.gonm", "sifroù gondi Masaram" },
            { "type.nu.grek", "niveroù gresianek" },
            { "type.nu.gujr", "sifroù gujarati" },
            { "type.nu.guru", "sifroù gurmukhi" },
            { "type.nu.hans", "niveroù sinaek eeunaet" },
            { "type.nu.hant", "niveroù sinaek hengounel" },
            { "type.nu.hebr", "niveroù hebraek" },
            { "type.nu.hmng", "sifroù Pahawh Hmong" },
            { "type.nu.hmnp", "sifroù Nyiakeng Puachue Hmong" },
            { "type.nu.java", "sifroù javanek" },
            { "type.nu.jpan", "niveroù japanek" },
            { "type.nu.kali", "sifroù Kayah Li" },
            { "type.nu.kawi", "sifroù kawi" },
            { "type.nu.khmr", "sifroù khmer" },
            { "type.nu.knda", "sifroù kanarek" },
            { "type.nu.lana", "sifroù Tai Tham Hora" },
            { "type.nu.laoo", "sifroù laosek" },
            { "type.nu.latn", "sifroù arabek ar Cʼhornôg" },
            { "type.nu.lepc", "sifroù lepcha" },
            { "type.nu.limb", "sifroù limbu" },
            { "type.nu.mlym", "sifroù malayalam" },
            { "type.nu.mong", "sifroù mongolek" },
            { "type.nu.mtei", "sifroù meitei mayek" },
            { "type.nu.mymr", "sifroù myanmar" },
            { "type.nu.nkoo", "sifroù nʼko" },
            { "type.nu.olck", "sifroù ol chiki" },
            { "type.nu.orya", "sifroù oriya" },
            { "type.nu.osma", "sifroù osmanya" },
            { "type.nu.shrd", "sifroù sharada" },
            { "type.nu.sind", "sifroù khudawadi" },
            { "type.nu.sinh", "sifroù singhalek lith" },
            { "type.nu.sora", "sifroù Sora Sompeng" },
            { "type.nu.sund", "sifroù sundanek" },
            { "type.nu.takr", "sifroù takri" },
            { "type.nu.talu", "sifroù tai lu nevez" },
            { "type.nu.taml", "niveroù tamilek hengounel" },
            { "type.nu.telu", "sifroù telougou" },
            { "type.nu.thai", "sifroù thai" },
            { "type.nu.tibt", "sifroù tibetan" },
            { "type.nu.tirh", "sifroù tirhuta" },
            { "type.nu.tnsa", "sifroù tasek" },
            { "type.nu.vaii", "sifroù vai" },
            { "type.nu.wara", "sifroù warang" },
            { "type.nu.wcho", "sifroù wantcho" },
            { "type.ca.dangi", "deiziadur dangi" },
            { "type.co.ducet", "urzh rummañ Unicode dre ziouer" },
            { "type.co.emoji", "urzh rummañ ar fromlunioù" },
            { "type.lb.loose", "stil torr linenn lezober" },
            { "type.nu.roman", "niveroù roman" },
            { "type.ca.coptic", "deiziadur kopt" },
            { "type.ca.hebrew", "deiziadur hebraek" },
            { "type.ca.indian", "deiziadur indian" },
            { "type.co.pinyin", "urzh rummañ pinyin" },
            { "type.co.search", "enklask hollek" },
            { "type.co.stroke", "urzh rummañ an tresoù" },
            { "type.co.unihan", "urzh rummañ UniHan" },
            { "type.co.zhuyin", "urzh rummañ Zhuyin" },
            { "type.lb.normal", "stil torr linenn boas" },
            { "type.lb.strict", "stil torr linenn strizh" },
            { "type.ms.metric", "reizhiad vetrek" },
            { "type.ca.chinese", "deiziadur sinaat" },
            { "type.ca.iso8601", "deiziadur ISO-8601" },
            { "type.ca.persian", "deiziadur persek" },
            { "type.cf.account", "furmad unanenn jediñ" },
            { "type.co.big5han", "urzh rummañ sinaek hengounel - Big5" },
            { "type.nu.arabext", "sifroù arabek indian astennet" },
            { "type.nu.armnlow", "niveroù armenianek bihan" },
            { "type.nu.greklow", "niveroù gresianek bihan" },
            { "type.nu.hanidec", "niveroù sinaek dekvedennek" },
            { "type.nu.hansfin", "niveroù sinaek eeunaet an arcʼhant" },
            { "type.nu.hantfin", "niveroù sinaek hengounel an arcʼhant" },
            { "type.nu.jpanfin", "niveroù japanek an arcʼhant" },
            { "type.nu.tamldec", "sifroù tamilek" },
            { "type.ca.buddhist", "deiziadur boudaat" },
            { "type.ca.ethiopic", "deiziadur etiopiat" },
            { "type.ca.japanese", "deiziadur japanat" },
            { "type.cf.standard", "furmad moneiz standart" },
            { "type.co.standard", "urzh rummañ standart" },
            { "type.ms.uksystem", "reizhiad vuzuliañ RU" },
            { "type.ms.ussystem", "reizhiad vuzuliañ SU" },
            { "type.nu.fullwide", "sifroù led plaen" },
            { "type.nu.lanatham", "sifroù Tai Tham Tham" },
            { "type.nu.mathbold", "sifroù tev matematikoù" },
            { "type.nu.mymrshan", "sifroù shan Myanmar" },
            { "type.nu.mymrtlng", "sifroù tai laing Myanmar" },
            { "type.nu.romanlow", "niveroù roman bihan" },
            { "type.ca.gregorian", "deiziadur gregorian" },
            { "type.co.gb2312han", "urzh rummañ sinaek eeunaet - GB2312" },
            { "type.co.phonebook", "urzh rummañ al levr-pellgomz" },
            { "ListKeyTypePattern", "{0} : {1}" },
            { "type.co.dictionary", "urzh rummañ ar geriadur" },
            { "type.co.traditional", "urzh rummañ hengounel" },
            { "type.ca.ethiopic-amete-alem", "deiziadur etiopiat Amete Alem" },
        };
        return data;
    }
}
