/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef IFFT_H
#define IFFT_H  1

#include "common.h"

/* Decimation factor for IFFT when working from the
 * RTL-SDR receiver IQ stream, to give an upper freq.
 * of 57600 Hz from a sampling rate of 288000 Hz */
#define IFFT_RTLSDR_DECIMATE    5

/* Decimation factor for IFFT when working from the
 * demodulated 2400 Hz APT sub-carrier */
#define IFFT_SUBCARRIER_DECIMATE    5

#endif

