// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"

namespace Rivet {


  /// @brief e+ e- -> 2pi+ 2pi-
  class DM1_1982_I168552 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(DM1_1982_I168552);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // Initialise and register projections
      declare(FinalState(), "FS");
      // Book histograms
      book(_npion, 1, 1, 1);
      for (const string& en : _npion.binning().edges<0>()) {
        double eval = stod(en)*GeV;
        if (isCompatibleWithSqrtS(eval)) {
          _sqs = en; break;
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");
      if (fs.particles().size()!=4) vetoEvent;
      for (const Particle& p : fs.particles()) {
        if (p.abspid() != PID::PIPLUS) vetoEvent;
      }
      _npion->fill(_sqs);
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_npion, crossSection()/sumOfWeights()/nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _npion;
    string _sqs = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(DM1_1982_I168552);
}
