{
"/* COMPATIBILITY \n"
"   - HLSL compilers\n"
"   - Cg   compilers\n"
"*/\n"
"\n"
"/*\n"
"   Dot Mask\n"
"   Authors: cgwg, Timothy Lottes\n"
"   License: GPL\n"
"   \n"
"   Note: This shader is just the dotmask functions from cgwg's CRT shader and crt-lottes.\n"
"*/\n"
"\n"
#include "../compat_includes.inc"
"uniform COMPAT_Texture2D(decal) : TEXUNIT0;\n"
"uniform float4x4 modelViewProj;\n"
"\n"
"struct out_vertex\n"
"{\n"
"	float4 position : COMPAT_POS;\n"
"	float2 texCoord : TEXCOORD0;\n"
"#ifndef HLSL_4\n"
"	float4 Color    : COLOR;\n"
"#endif\n"
"};\n"
"\n"
"out_vertex main_vertex(COMPAT_IN_VERTEX)\n"
"{\n"
"	out_vertex OUT;\n"
"#ifdef HLSL_4\n"
"	float4 position = VIN.position;\n"
"	float2 texCoord = VIN.texCoord;\n"
"#else\n"
"	OUT.Color = color;\n"
"#endif\n"
"	OUT.position = mul(modelViewProj, position);\n"
"	OUT.texCoord = texCoord;\n"
"	\n"
"	return OUT;\n"
"}\n"
"\n"
"#define mod_factor texCoord.x * texture_size.x * output_size.x / video_size.x\n"
"\n"
"#pragma parameter shadowMask \"Mask Style\" 4.0 0.0 4.0 1.0\n"
"#pragma parameter DOTMASK_STRENGTH \"CGWG Dot Mask Strength\" 0.2 0.0 1.0 0.01\n"
"#pragma parameter maskDark \"Lottes maskDark\" 0.7 0.0 2.0 0.1\n"
"#pragma parameter maskLight \"Lottes maskLight\" 1.2 0.0 2.0 0.1\n"
"#ifdef PARAMETER_UNIFORM\n"
"uniform float DOTMASK_STRENGTH;\n"
"uniform float maskDark;\n"
"uniform float maskLight;\n"
"uniform float shadowMask;\n"
"#else\n"
"#define DOTMASK_STRENGTH 0.3\n"
"#define maskDark 0.5\n"
"#define maskLight 1.5\n"
"#define shadowMask 3.0\n"
"#endif\n"
"\n"
"float3 Mask(float2 pos){\n"
"  float3 mask=float3(maskDark,maskDark,maskDark);\n"
"\n"
"  // Very compressed TV style shadow mask.\n"
"  if (shadowMask == 1) {\n"
"    float mask_line = maskLight;\n"
"    float odd = 0.0;\n"
"    if(frac(pos.x/6.0)<0.5)odd = 1.0;\n"
"    if(frac((pos.y+odd)/2.0)<0.5) mask_line = maskDark;  \n"
"    pos.x = frac(pos.x/3.0);\n"
"   \n"
"    if(pos.x<0.333)mask.r = maskLight;\n"
"    else if(pos.x<0.666)mask.g = maskLight;\n"
"    else mask.b = maskLight;\n"
"    mask *= mask_line;  \n"
"  } \n"
"\n"
"  // Aperture-grille.\n"
"  else if (shadowMask == 2) {\n"
"    pos.x=frac(pos.x/3.0);\n"
"\n"
"    if(pos.x<0.333)mask.r=maskLight;\n"
"    else if(pos.x<0.666)mask.g=maskLight;\n"
"    else mask.b=maskLight;\n"
"  } \n"
"\n"
"  // Stretched VGA style shadow mask (same as prior shaders).\n"
"  else if (shadowMask == 3) {\n"
"    pos.x+=pos.y*3.0;\n"
"    pos.x=frac(pos.x/6.0);\n"
"\n"
"    if(pos.x<0.333)mask.r=maskLight;\n"
"    else if(pos.x<0.666)mask.g=maskLight;\n"
"    else mask.b=maskLight;\n"
"  }\n"
"\n"
"  // VGA style shadow mask.\n"
"  else if (shadowMask == 4) {\n"
"    pos.xy=floor(pos.xy*float2(1.0,0.5));\n"
"    pos.x+=pos.y*3.0;\n"
"    pos.x=frac(pos.x/6.0);\n"
"\n"
"    if(pos.x<0.333)mask.r=maskLight;\n"
"    else if(pos.x<0.666)mask.g=maskLight;\n"
"    else mask.b=maskLight;\n"
"  }\n"
"\n"
"  return mask;}  \n"
"\n"
"float4 dotmask(float2 texture_size, float2 video_size, float2 output_size, float2 texCoord, COMPAT_Texture2D(decal))\n"
"{\n"
"   float3 res = COMPAT_Sample(decal, texCoord).rgb;\n"
"   \n"
"   float mask = 1.0 - DOTMASK_STRENGTH;\n"
"   \n"
"   // dot-mask emulation:\n"
"   // Output pixels are alternately tinted green and magenta.\n"
"   float3 dotMaskWeights = lerp(\n"
"                           float3(1.0, mask, 1.0),\n"
"                           float3(mask, 1.0, mask),\n"
"                           floor(fmod(mod_factor, 2.0)));\n"
"if (shadowMask == 0) {\n"
"   res *= dotMaskWeights;\n"
"}\n"
"else {\n"
"   res *= Mask(floor(texCoord.xy*(texture_size.xy/video_size.xy)*output_size.xy)+float2(0.5,0.5));\n"
"}\n"
"\n"
"      return float4(res, 1.0);\n"
"}\n"
"\n"
"float4 main_fragment(COMPAT_IN_FRAGMENT) : COMPAT_Output\n"
"{\n"
"	return dotmask(COMPAT_texture_size, COMPAT_video_size, COMPAT_output_size, VOUT.texCoord, decal);\n"
"}\n"
"COMPAT_END\n"
},
