"struct input\n"
"{\n"
"  float2 video_size;\n"
"  float2 texture_size;\n"
"  float2 output_size;\n"
"  float  frame_count;\n"
"  float  frame_direction;\n"
"};\n"
"#define COMPAT_video_size IN.video_size\n"
"#define COMPAT_texture_size IN.texture_size\n"
"#define COMPAT_output_size IN.output_size\n"
"#define COMPAT_frame_count IN.frame_count\n"
"#define COMPAT_frame_direction IN.frame_direction\n"

"#define COMPAT_Texture2D(tex) sampler2D tex\n"
"#define COMPAT_TexturePass2D(tex) tex\n"
"#define COMPAT_SampleLevelZero(tex, coord) tex2Dlod(tex, float4(coord, 0.0, 0.0))\n"
"#define COMPAT_SampleLevelZeroPoint(tex, coord) tex2Dlod(tex, float4(coord, 0.0, 0.0))\n"
"#define COMPAT_SampleLevelZeroOffset(tex, coord, offset) tex2Dlod(tex, float4(coord + offset, 0.0, 0.0))\n"
"#define COMPAT_Sample(tex, coord) tex2D(tex, coord)\n"
"#define COMPAT_SamplePoint(tex, coord) tex2D(tex, coord)\n"
"#define COMPAT_SampleOffset(tex, coord, offset) tex2D(tex, coord + offset)\n"
"#define COMPAT_FLATTEN [flatten]\n"
"#define COMPAT_BRANCH [branch]\n"
"#define COMPAT_Output COLOR\n"
"#define COMPAT_POS POSITION\n"
"#define COMPAT_END \n"

"struct orig\n"
"{\n"
"  float2 video_size;\n"
"  float2 texture_size;\n"
"  float2 output_size;\n"
"  sampler2D texture;\n"
"};\n"
"#define INITIALIZE_ORIG(c) \n"
"#define ORIG_Sample(coord) tex2D(ORIG, coord)\n"
"#define ORIG_SamplePoint(coord) tex2D(ORIG, coord)\n"
"#define ORIG_texture ORIG.texture\n"
"#define ORIG_video_size ORIG.video_size\n"
"#define ORIG_texture_size ORIG.texture_size\n"
"#define ORIG_output_size ORIG.output_size\n"

"struct prev\n"
"{\n"
"  float2 video_size;\n"
"  float2 texture_size;\n"
"  float2 output_size;\n"
"  sampler2D texture;\n"
"};\n"
"#define INITIALIZE_PASSPREV(c, d) \n"
"#define PASSPREV_Sample(c, coord) tex2D(PASSPREV##c, coord)\n"
"#define PASSPREV_SamplePoint(c, coord) tex2D(PASSPREV##c, coord)\n"
"#define PASSPREV_texture(c) PASSPREV##c.texture\n"

"struct in_vertex\n"
"{\n"
"  bool dummy;\n"
"};\n"
"#define COMPAT_IN_VERTEX in_vertex VIN, uniform input IN, float4 color : COLOR, float4 position : COMPAT_POS, float2 texCoord : TEXCOORD0, float2 t1 : TEXCOORD1\n"
"#define COMPAT_IN_FRAGMENT out_vertex VOUT, uniform input IN\n"
