/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.ttflib;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TtfTable {
    private int tag;
    private String tagString;
    private int checksum;
    private int offset;
    private int length;
    private byte[] data;

    TtfTable() {
    }

    void readHead(DataInputStream dataInputStream) throws IOException {
        this.tag = dataInputStream.readInt();
        byte[] byArray = new byte[]{(byte)(this.tag >> 24), (byte)(this.tag >> 16), (byte)(this.tag >> 8), (byte)(this.tag >> 0)};
        this.tagString = new String(byArray, "US-ASCII");
        this.checksum = dataInputStream.readInt();
        this.offset = dataInputStream.readInt();
        this.length = dataInputStream.readInt();
    }

    void readBody(DataInputStream dataInputStream, Map<Long, byte[]> map) throws IOException {
        long l;
        if (map != null && map.containsKey(l = (long)this.offset << 32 | (long)this.length)) {
            this.data = map.get(l);
            return;
        }
        dataInputStream.reset();
        dataInputStream.skipBytes(this.offset);
        byte[] byArray = new byte[this.length];
        dataInputStream.readFully(byArray);
        this.data = byArray;
        if (map != null) {
            long l2 = (long)this.offset << 32 | (long)this.length;
            map.put(l2, byArray);
        }
    }

    public int getTag() {
        return this.tag;
    }

    public String getTagString() {
        return this.tagString;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        return this.data;
    }
}

