/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.ttflib;

import com.kreative.unicode.ttflib.TtfTable;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TtfBase {
    private int scaler;
    private int count;
    private int searchRange;
    private int entrySelector;
    private int rangeShift;
    private List<TtfTable> tables;
    private Map<Integer, TtfTable> byTag;
    private Map<String, TtfTable> byTagString;

    TtfBase() {
    }

    void read(DataInputStream dataInputStream, Map<Long, byte[]> map) throws IOException {
        this.tables = new ArrayList<TtfTable>();
        this.byTag = new TreeMap<Integer, TtfTable>();
        this.byTagString = new TreeMap<String, TtfTable>();
        this.scaler = dataInputStream.readInt();
        this.count = dataInputStream.readShort();
        this.searchRange = dataInputStream.readShort();
        this.entrySelector = dataInputStream.readShort();
        this.rangeShift = dataInputStream.readShort();
        for (int i = 0; i < this.count; ++i) {
            TtfTable ttfTable = new TtfTable();
            ttfTable.readHead(dataInputStream);
            this.tables.add(ttfTable);
            this.byTag.put(ttfTable.getTag(), ttfTable);
            this.byTagString.put(ttfTable.getTagString(), ttfTable);
        }
        for (TtfTable ttfTable : this.tables) {
            ttfTable.readBody(dataInputStream, map);
        }
        this.tables = Collections.unmodifiableList(this.tables);
        this.byTag = Collections.unmodifiableMap(this.byTag);
        this.byTagString = Collections.unmodifiableMap(this.byTagString);
    }

    public int getScaler() {
        return this.scaler;
    }

    public int getCount() {
        return this.count;
    }

    public int getSearchRange() {
        return this.searchRange;
    }

    public int getEntrySelector() {
        return this.entrySelector;
    }

    public int getRangeShift() {
        return this.rangeShift;
    }

    public List<TtfTable> getTables() {
        return this.tables;
    }

    public Set<Integer> getTags() {
        return this.byTag.keySet();
    }

    public Set<String> getTagStrings() {
        return this.byTagString.keySet();
    }

    public TtfTable getTable(int n) {
        return this.byTag.get(n);
    }

    public TtfTable getTable(String string) {
        return this.byTagString.get(string);
    }

    public <T> T getTableAs(Class<T> clazz, int n) {
        TtfTable ttfTable = this.getTable(n);
        if (ttfTable == null) {
            return null;
        }
        try {
            return clazz.getConstructor(byte[].class).newInstance(new Object[]{ttfTable.getData()});
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <T> T getTableAs(Class<T> clazz, String string) {
        TtfTable ttfTable = this.getTable(string);
        if (ttfTable == null) {
            return null;
        }
        try {
            return clazz.getConstructor(byte[].class).newInstance(new Object[]{ttfTable.getData()});
        }
        catch (Exception exception) {
            return null;
        }
    }
}

