/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.ttfbin;

import com.kreative.unicode.ttflib.TtcFile;
import com.kreative.unicode.ttflib.TtcFont;
import com.kreative.unicode.ttflib.TtfTable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TtcUnpack {
    public static void main(String[] stringArray) {
        for (String string : stringArray) {
            System.out.println(string);
            try {
                File file = new File(string);
                TtcFile ttcFile = new TtcFile(file);
                List<TtcFont> list = ttcFile.getFonts();
                for (int i = 0; i < list.size(); ++i) {
                    TtcFont ttcFont = list.get(i);
                    List<TtfTable> list2 = ttcFont.getTables();
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    int n = 12 + 16 * list2.size();
                    for (TtfTable ttfTable : list2) {
                        arrayList.add(n);
                        n += ttfTable.getLength() + 3;
                        n &= 0xFFFFFFFC;
                    }
                    String string2 = file.getName() + "." + i + ".ttf";
                    System.out.println("\t" + (String)string2);
                    File object2 = new File(file.getParentFile(), string2);
                    FileOutputStream fileOutputStream = new FileOutputStream(object2);
                    DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
                    dataOutputStream.writeInt(ttcFont.getScaler());
                    dataOutputStream.writeShort(ttcFont.getCount());
                    dataOutputStream.writeShort(ttcFont.getSearchRange());
                    dataOutputStream.writeShort(ttcFont.getEntrySelector());
                    dataOutputStream.writeShort(ttcFont.getRangeShift());
                    for (int j = 0; j < list2.size(); ++j) {
                        dataOutputStream.writeInt(list2.get(j).getTag());
                        dataOutputStream.writeInt(list2.get(j).getChecksum());
                        dataOutputStream.writeInt((Integer)arrayList.get(j));
                        dataOutputStream.writeInt(list2.get(j).getLength());
                    }
                    for (TtfTable ttfTable : list2) {
                        dataOutputStream.write(ttfTable.getData());
                        int n2 = ttfTable.getLength() & 3;
                        if (n2 <= 0) continue;
                        while (n2 < 4) {
                            dataOutputStream.write(0);
                            ++n2;
                        }
                    }
                    dataOutputStream.close();
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println("\tERROR: " + iOException);
            }
        }
    }
}

