/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.puaa;

import com.kreative.bitsnpicas.puaa.PuaaCodec;
import com.kreative.bitsnpicas.puaa.PuaaCodecRegistry;
import com.kreative.bitsnpicas.truetype.PuaaTable;
import com.kreative.bitsnpicas.truetype.TrueTypeFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PuaaCompiler {
    private static final PuaaCodecRegistry registry = PuaaCodecRegistry.instance;

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length == 0) {
            PuaaCompiler.printHelp();
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList<File> arrayList3 = new ArrayList<File>();
        ArrayList<File> arrayList4 = arrayList;
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n++];
            if (bl && ((String)object).startsWith("-")) {
                if (((String)object).equals("--")) {
                    bl = false;
                    continue;
                }
                if (((String)object).equals("-d") && n < stringArray.length) {
                    arrayList.add(new File(stringArray[n++]));
                    continue;
                }
                if (((String)object).equals("-i") && n < stringArray.length) {
                    arrayList2.add(new File(stringArray[n++]));
                    continue;
                }
                if (((String)object).equals("-o") && n < stringArray.length) {
                    arrayList3.add(new File(stringArray[n++]));
                    continue;
                }
                if (((String)object).equals("-D")) {
                    arrayList4 = arrayList;
                    continue;
                }
                if (((String)object).equals("-I")) {
                    arrayList4 = arrayList2;
                    continue;
                }
                if (((String)object).equals("-O")) {
                    arrayList4 = arrayList3;
                    continue;
                }
                if (((String)object).equals("--help")) {
                    PuaaCompiler.printHelp();
                    continue;
                }
                System.err.println("Unknown option: " + (String)object);
                continue;
            }
            arrayList4.add(new File((String)object));
        }
        if (arrayList.isEmpty()) {
            return;
        }
        object = PuaaCompiler.read(arrayList);
        if (arrayList2.isEmpty() && arrayList3.isEmpty()) {
            File file = new File("puaa.out");
            PuaaCompiler.write((PuaaTable)object, file, file);
            return;
        }
        if (arrayList2.isEmpty() || arrayList3.isEmpty()) {
            for (File file : arrayList2) {
                PuaaCompiler.write((PuaaTable)object, file, file);
            }
            for (File file : arrayList3) {
                PuaaCompiler.write((PuaaTable)object, file, file);
            }
            return;
        }
        if (arrayList2.size() == 1 && arrayList3.size() == 1) {
            PuaaCompiler.write((PuaaTable)object, (File)arrayList2.get(0), (File)arrayList3.get(0));
            return;
        }
        if (arrayList2.size() > 1) {
            System.err.println("Too many input files.");
        }
        if (arrayList3.size() > 1) {
            System.err.println("Too many output files.");
        }
    }

    private static PuaaTable read(List<File> list) {
        PuaaTable puaaTable = new PuaaTable();
        for (File file : list) {
            System.out.print("Reading " + file.getName() + "...");
            try {
                PuaaCompiler.compile(puaaTable, file);
                System.out.println(" DONE");
            }
            catch (IOException iOException) {
                System.out.println(" ERROR: " + iOException);
            }
        }
        return puaaTable;
    }

    private static void write(PuaaTable puaaTable, File file, File file2) {
        System.out.print("Writing " + file2.getName() + "...");
        try {
            PuaaCompiler.inject(puaaTable, file, file2);
            System.out.println(" DONE");
        }
        catch (IOException iOException) {
            System.out.println(" ERROR: " + iOException);
        }
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("PuaaCompiler - Add Unicode Character Database properties to TrueType files.");
        System.out.println();
        System.out.println("  -d <path>     Specify UCD data file or directory.");
        System.out.println("  -i <path>     Specify source TrueType file.");
        System.out.println("  -o <path>     Specify destination TrueType file.");
        System.out.println("  -D            Process arguments as UCD data files.");
        System.out.println("  -I            Process arguments as source files.");
        System.out.println("  -O            Process arguments as destination files.");
        System.out.println("  --            Process remaining arguments as file names.");
        System.out.println();
        System.out.println("Source and destination may be the same file.");
        System.out.println("Other files specified must be in the format of the");
        System.out.println("Unicode Character Database and be named accordingly:");
        System.out.println();
        registry.printFileNames();
        System.out.println();
        System.out.println("Files other than those listed above will be ignored.");
        System.out.println();
    }

    public static void compile(PuaaTable puaaTable, File file) throws IOException {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (file2.getName().startsWith(".")) continue;
                PuaaCompiler.compile(puaaTable, file2);
            }
        } else {
            PuaaCodec puaaCodec = registry.getCodec(file.getName());
            if (puaaCodec != null) {
                Scanner scanner = new Scanner((InputStream)new FileInputStream(file), "UTF-8");
                puaaCodec.compile(puaaTable, scanner);
                scanner.close();
            }
        }
    }

    public static void inject(PuaaTable puaaTable, File file, File file2) throws IOException {
        Closeable closeable;
        byte[] byArray;
        TrueTypeFile trueTypeFile = new TrueTypeFile();
        long l = file.length();
        if (l > 0L) {
            if (l < 12L) {
                throw new IOException("file too small");
            }
            if (l > Integer.MAX_VALUE) {
                throw new IOException("file too large");
            }
            byArray = new byte[(int)l];
            closeable = new FileInputStream(file);
            ((FileInputStream)closeable).read(byArray);
            ((FileInputStream)closeable).close();
            trueTypeFile.interpret = false;
            trueTypeFile.decompile(byArray);
            trueTypeFile.remove(trueTypeFile.getByTableName("PUAA"));
        } else {
            trueTypeFile.scaler = 1347764545;
        }
        trueTypeFile.add(puaaTable);
        byArray = trueTypeFile.compile();
        closeable = new FileOutputStream(file2);
        ((FileOutputStream)closeable).write(byArray);
        ((OutputStream)closeable).flush();
        ((FileOutputStream)closeable).close();
    }
}

