/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.truetype.CbdtEntry;
import com.kreative.bitsnpicas.truetype.CbdtEntryFormat17;
import com.kreative.bitsnpicas.truetype.CbdtEntryFormat18;
import com.kreative.bitsnpicas.truetype.CbdtEntryFormat19;
import com.kreative.bitsnpicas.truetype.CmapSubtable;
import com.kreative.bitsnpicas.truetype.CmapTable;
import com.kreative.bitsnpicas.truetype.EbdtEntry;
import com.kreative.bitsnpicas.truetype.EbdtTable;
import com.kreative.bitsnpicas.truetype.EblcBitmapSize;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable1;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtableHeader;
import com.kreative.bitsnpicas.truetype.EblcTable;
import com.kreative.bitsnpicas.truetype.HheaTable;
import com.kreative.bitsnpicas.truetype.ListBasedEblcIndexSubtable;
import com.kreative.bitsnpicas.truetype.PostTable;
import com.kreative.bitsnpicas.truetype.PostTableEntry;
import com.kreative.bitsnpicas.truetype.SbitBigGlyphMetrics;
import com.kreative.bitsnpicas.truetype.SbitLineMetrics;
import com.kreative.bitsnpicas.truetype.SbitSmallGlyphMetrics;
import com.kreative.bitsnpicas.truetype.SbitTableType;
import com.kreative.bitsnpicas.truetype.TrueTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectCbdt {
    public static void main(String[] stringArray) {
        try {
            System.setProperty("apple.awt.UIElement", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = true;
        for (String string : stringArray) {
            if (string.equals("-g")) {
                bl = false;
                continue;
            }
            if (string.equals("-G")) {
                bl = true;
                continue;
            }
            File file = new File(string);
            System.out.print("Processing " + file.getAbsolutePath() + "... ");
            try {
                File file2 = new File(file.getParent(), file.getName() + ".cbdt.d");
                if (!file2.exists() || !file2.isDirectory()) {
                    System.out.println("no cbdt directory found.");
                    continue;
                }
                byte[] byArray = new byte[(int)file.length()];
                FileInputStream fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
                fileInputStream.close();
                TrueTypeFile trueTypeFile = new TrueTypeFile();
                trueTypeFile.decompile(byArray);
                CmapTable cmapTable = (CmapTable)trueTypeFile.getByTableName("cmap");
                CmapSubtable cmapSubtable = cmapTable == null ? null : cmapTable.getBestSubtable();
                PostTable postTable = (PostTable)trueTypeFile.getByTableName("post");
                HheaTable hheaTable = (HheaTable)trueTypeFile.getByTableName("hhea");
                EblcTable eblcTable = (EblcTable)trueTypeFile.getByTableName("CBLC");
                if (eblcTable == null) {
                    eblcTable = new EblcTable(SbitTableType.COLOR);
                    trueTypeFile.add(eblcTable);
                } else {
                    eblcTable.clear();
                }
                EbdtTable ebdtTable = (EbdtTable)trueTypeFile.getByTableName("CBDT");
                if (ebdtTable == null) {
                    ebdtTable = new EbdtTable(SbitTableType.COLOR);
                    trueTypeFile.add(ebdtTable);
                } else {
                    ebdtTable.clear();
                }
                for (File file3 : file2.listFiles()) {
                    int n;
                    Object object;
                    if (!file3.isDirectory() || file3.getName().startsWith(".")) continue;
                    File file4 = new File(file3, "metadata.txt");
                    EblcBitmapSize eblcBitmapSize = InjectCbdt.createBitmapSize(hheaTable);
                    HashMap<Integer, SbitSmallGlyphMetrics> hashMap = new HashMap<Integer, SbitSmallGlyphMetrics>();
                    HashMap<Integer, SbitBigGlyphMetrics> hashMap2 = new HashMap<Integer, SbitBigGlyphMetrics>();
                    if (file4.isFile()) {
                        InjectCbdt.parseMetadata(file4, eblcBitmapSize, hashMap, hashMap2, cmapSubtable, postTable);
                    }
                    TreeMap<Integer, CbdtEntry> treeMap = new TreeMap<Integer, CbdtEntry>();
                    for (File n3 : file3.listFiles()) {
                        int n2;
                        String string2;
                        object = n3.getName();
                        n = ((String)object).lastIndexOf(46);
                        if (n <= 0 || !"png".equalsIgnoreCase(string2 = ((String)object).substring(n + 1)) || (n2 = InjectCbdt.getGlyphIndex((String)(object = ((String)object).substring(0, n)), cmapSubtable, postTable)) <= 0) continue;
                        byte[] byArray2 = new byte[(int)n3.length()];
                        FileInputStream fileInputStream2 = new FileInputStream(n3);
                        fileInputStream2.read(byArray2);
                        fileInputStream2.close();
                        CbdtEntry cbdtEntry = InjectCbdt.createCbdtEntry(hashMap, hashMap2, n2);
                        cbdtEntry.imageData = byArray2;
                        treeMap.put(n2, cbdtEntry);
                    }
                    Object object2 = null;
                    for (Map.Entry entry : treeMap.entrySet()) {
                        int n3 = (Integer)entry.getKey();
                        if (eblcBitmapSize.startGlyphIndex <= 0 || n3 < eblcBitmapSize.startGlyphIndex) {
                            eblcBitmapSize.startGlyphIndex = n3;
                        }
                        if (eblcBitmapSize.endGlyphIndex <= 0 || n3 > eblcBitmapSize.endGlyphIndex) {
                            eblcBitmapSize.endGlyphIndex = n3;
                        }
                        object = (CbdtEntry)entry.getValue();
                        if (object2 != null && ((EblcIndexSubtable1)object2).header.lastGlyphIndex + 1 == n3 && ((EblcIndexSubtable1)object2).header.imageFormat == ((EbdtEntry)object).format()) {
                            ++((EblcIndexSubtable1)object2).header.lastGlyphIndex;
                        } else {
                            object2 = new EblcIndexSubtable1();
                            eblcBitmapSize.add(object2);
                            ((EblcIndexSubtable1)object2).header = new EblcIndexSubtableHeader();
                            ((EblcIndexSubtable1)object2).header.firstGlyphIndex = n3;
                            ((EblcIndexSubtable1)object2).header.lastGlyphIndex = n3;
                            ((EblcIndexSubtable1)object2).header.indexFormat = 1;
                            ((EblcIndexSubtable1)object2).header.imageFormat = ((EbdtEntry)object).format();
                            ((ListBasedEblcIndexSubtable)object2).add(ebdtTable.getNextKey());
                        }
                        n = (Integer)((ListBasedEblcIndexSubtable)object2).get(((ListBasedEblcIndexSubtable)object2).size() - 1);
                        ebdtTable.put(n, object);
                        ((ListBasedEblcIndexSubtable)object2).add(ebdtTable.getNextKey());
                    }
                    eblcTable.add(eblcBitmapSize);
                }
                ebdtTable.recalculate(eblcTable);
                if (bl) {
                    trueTypeFile.remove(trueTypeFile.getByTableName("loca"));
                    trueTypeFile.remove(trueTypeFile.getByTableName("glyf"));
                    trueTypeFile.remove(trueTypeFile.getByTableName("CFF "));
                    trueTypeFile.remove(trueTypeFile.getByTableName("CFF2"));
                }
                byArray = trueTypeFile.compile();
                String object = trueTypeFile.isOpenType() ? ".otf" : ".ttf";
                File file5 = new File(file.getParent(), file.getName() + ".cbdt" + object);
                FileOutputStream fileOutputStream = new FileOutputStream(file5);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
                System.out.println("done.");
            }
            catch (Exception exception) {
                System.out.println("failed (" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ").");
            }
        }
    }

    private static EblcBitmapSize createBitmapSize(HheaTable hheaTable) {
        EblcBitmapSize eblcBitmapSize = new EblcBitmapSize();
        eblcBitmapSize.hori = new SbitLineMetrics();
        eblcBitmapSize.vert = new SbitLineMetrics();
        if (hheaTable != null) {
            eblcBitmapSize.hori.ascender = eblcBitmapSize.vert.ascender = hheaTable.ascent;
            eblcBitmapSize.hori.descender = eblcBitmapSize.vert.descender = hheaTable.descent;
            eblcBitmapSize.hori.widthMax = eblcBitmapSize.vert.widthMax = hheaTable.advanceWidthMax;
            eblcBitmapSize.ppemX = eblcBitmapSize.ppemY = hheaTable.ascent - hheaTable.descent;
        } else {
            eblcBitmapSize.vert.ascender = 101;
            eblcBitmapSize.hori.ascender = 101;
            eblcBitmapSize.vert.descender = -27;
            eblcBitmapSize.hori.descender = -27;
            eblcBitmapSize.vert.widthMax = 136;
            eblcBitmapSize.hori.widthMax = 136;
            eblcBitmapSize.ppemY = 109;
            eblcBitmapSize.ppemX = 109;
        }
        eblcBitmapSize.bitDepth = 32;
        eblcBitmapSize.flags = 1;
        return eblcBitmapSize;
    }

    private static void parseMetadata(File file, EblcBitmapSize eblcBitmapSize, Map<Integer, SbitSmallGlyphMetrics> map, Map<Integer, SbitBigGlyphMetrics> map2, CmapSubtable cmapSubtable, PostTable postTable) throws IOException {
        Scanner scanner = new Scanner((InputStream)new FileInputStream(file), "UTF-8");
        boolean bl = false;
        int n = 0;
        SbitSmallGlyphMetrics sbitSmallGlyphMetrics = null;
        SbitBigGlyphMetrics sbitBigGlyphMetrics = null;
        boolean bl2 = false;
        while (scanner.hasNextLine()) {
            String string;
            String string2 = scanner.nextLine().trim();
            if (string2.length() <= 0 || string2.startsWith("#")) continue;
            String[] stringArray = string2.split(":", 2);
            String string3 = stringArray[0].trim().toLowerCase();
            String string4 = string = stringArray.length > 1 ? stringArray[1].trim() : null;
            if (bl) {
                if ("endglyph".equals(string3)) {
                    if (bl2) {
                        map2.put(n, sbitBigGlyphMetrics);
                    } else {
                        map.put(n, sbitSmallGlyphMetrics);
                    }
                    bl = false;
                    n = 0;
                    sbitSmallGlyphMetrics = null;
                    sbitBigGlyphMetrics = null;
                    bl2 = false;
                    continue;
                }
                if ("height".equals(string3)) {
                    try {
                        sbitSmallGlyphMetrics.height = sbitBigGlyphMetrics.height = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("width".equals(string3)) {
                    try {
                        sbitSmallGlyphMetrics.width = sbitBigGlyphMetrics.width = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("bearingx".equals(string3)) {
                    try {
                        sbitSmallGlyphMetrics.bearingX = Integer.parseInt(string);
                        bl2 = false;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("bearingy".equals(string3)) {
                    try {
                        sbitSmallGlyphMetrics.bearingY = Integer.parseInt(string);
                        bl2 = false;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("advance".equals(string3)) {
                    try {
                        sbitSmallGlyphMetrics.advance = Integer.parseInt(string);
                        bl2 = false;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("horibearingx".equals(string3)) {
                    try {
                        sbitBigGlyphMetrics.horiBearingX = Integer.parseInt(string);
                        bl2 = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("horibearingy".equals(string3)) {
                    try {
                        sbitBigGlyphMetrics.horiBearingY = Integer.parseInt(string);
                        bl2 = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("horiadvance".equals(string3)) {
                    try {
                        sbitBigGlyphMetrics.horiAdvance = Integer.parseInt(string);
                        bl2 = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("vertbearingx".equals(string3)) {
                    try {
                        sbitBigGlyphMetrics.vertBearingX = Integer.parseInt(string);
                        bl2 = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("vertbearingy".equals(string3)) {
                    try {
                        sbitBigGlyphMetrics.vertBearingY = Integer.parseInt(string);
                        bl2 = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (!"vertadvance".equals(string3)) continue;
                try {
                    sbitBigGlyphMetrics.vertAdvance = Integer.parseInt(string);
                    bl2 = true;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("glyph".equals(string3)) {
                bl = true;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = InjectCbdt.getGlyphIndex(string, cmapSubtable, postTable);
                }
                sbitSmallGlyphMetrics = new SbitSmallGlyphMetrics();
                sbitBigGlyphMetrics = new SbitBigGlyphMetrics();
                bl2 = false;
                continue;
            }
            if ("indexsubtablearrayoffset".equals(string3)) {
                try {
                    eblcBitmapSize.indexSubTableArrayOffset = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("indextablessize".equals(string3)) {
                try {
                    eblcBitmapSize.indexTablesSize = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("numberofindexsubtables".equals(string3)) {
                try {
                    eblcBitmapSize.numberOfIndexSubTables = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("colorref".equals(string3)) {
                try {
                    eblcBitmapSize.colorRef = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("horiascender".equals(string3)) {
                try {
                    eblcBitmapSize.hori.ascender = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("horidescender".equals(string3)) {
                try {
                    eblcBitmapSize.hori.descender = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("horiwidthmax".equals(string3)) {
                try {
                    eblcBitmapSize.hori.widthMax = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("horicaretslopenumerator".equals(string3)) {
                try {
                    eblcBitmapSize.hori.caretSlopeNumerator = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("horicaretslopedenominator".equals(string3)) {
                try {
                    eblcBitmapSize.hori.caretSlopeDenominator = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("horicaretoffset".equals(string3)) {
                try {
                    eblcBitmapSize.hori.caretOffset = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("horiminoriginsb".equals(string3)) {
                try {
                    eblcBitmapSize.hori.minOriginSB = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("horiminadvancesb".equals(string3)) {
                try {
                    eblcBitmapSize.hori.minAdvanceSB = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("horimaxbeforebl".equals(string3)) {
                try {
                    eblcBitmapSize.hori.maxBeforeBL = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("horiminafterbl".equals(string3)) {
                try {
                    eblcBitmapSize.hori.minAfterBL = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("vertascender".equals(string3)) {
                try {
                    eblcBitmapSize.vert.ascender = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("vertdescender".equals(string3)) {
                try {
                    eblcBitmapSize.vert.descender = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("vertwidthmax".equals(string3)) {
                try {
                    eblcBitmapSize.vert.widthMax = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("vertcaretslopenumerator".equals(string3)) {
                try {
                    eblcBitmapSize.vert.caretSlopeNumerator = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("vertcaretslopedenominator".equals(string3)) {
                try {
                    eblcBitmapSize.vert.caretSlopeDenominator = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("vertcaretoffset".equals(string3)) {
                try {
                    eblcBitmapSize.vert.caretOffset = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("vertminoriginsb".equals(string3)) {
                try {
                    eblcBitmapSize.vert.minOriginSB = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("vertminadvancesb".equals(string3)) {
                try {
                    eblcBitmapSize.vert.minAdvanceSB = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("vertmaxbeforebl".equals(string3)) {
                try {
                    eblcBitmapSize.vert.maxBeforeBL = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("vertminafterbl".equals(string3)) {
                try {
                    eblcBitmapSize.vert.minAfterBL = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("startglyphindex".equals(string3)) {
                try {
                    eblcBitmapSize.startGlyphIndex = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("endglyphindex".equals(string3)) {
                try {
                    eblcBitmapSize.endGlyphIndex = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("ppemx".equals(string3)) {
                try {
                    eblcBitmapSize.ppemX = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("ppemy".equals(string3)) {
                try {
                    eblcBitmapSize.ppemY = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("bitdepth".equals(string3)) {
                try {
                    eblcBitmapSize.bitDepth = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!"flags".equals(string3)) continue;
            try {
                eblcBitmapSize.flags = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        scanner.close();
    }

    private static int getGlyphIndex(String string, CmapSubtable cmapSubtable, PostTable postTable) {
        if (string.startsWith("glyph_")) {
            try {
                return Integer.parseInt(string.substring(6));
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        if (string.startsWith("char_")) {
            if (cmapSubtable == null) {
                return 0;
            }
            try {
                int n = Integer.parseInt(string.substring(5), 16);
                return cmapSubtable.getGlyphIndex(n);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        if (postTable == null) {
            return 0;
        }
        PostTableEntry postTableEntry = PostTableEntry.forCharacterName(InjectCbdt.unescape(string));
        if (postTable.contains(postTableEntry)) {
            return postTable.indexOf(postTableEntry);
        }
        return 0;
    }

    private static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            block0 : switch (c) {
                case '!': {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') {
                        stringBuffer.append('!');
                        break;
                    }
                    stringBuffer.append(Character.toLowerCase(c));
                    break;
                }
                case '^': {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') {
                        stringBuffer.append('^');
                        break;
                    }
                    stringBuffer.append(Character.toUpperCase(c));
                    break;
                }
                case '#': {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') {
                        stringBuffer.append('#');
                        break;
                    }
                    stringBuffer.append(Character.toTitleCase(c));
                    break;
                }
                case '=': {
                    c = stringCharacterIterator.next();
                    switch (c) {
                        case '\uffff': {
                            stringBuffer.append('=');
                            break block0;
                        }
                        case 'A': 
                        case 'a': {
                            stringBuffer.append('\'');
                            break block0;
                        }
                        case 'B': 
                        case 'b': {
                            stringBuffer.append('\\');
                            break block0;
                        }
                        case 'C': 
                        case 'c': {
                            stringBuffer.append(':');
                            break block0;
                        }
                        case 'D': 
                        case 'd': {
                            stringBuffer.append('$');
                            break block0;
                        }
                        case 'E': 
                        case 'e': {
                            stringBuffer.append('=');
                            break block0;
                        }
                        case 'F': 
                        case 'f': {
                            stringBuffer.append('/');
                            break block0;
                        }
                        case 'G': 
                        case 'g': {
                            stringBuffer.append('>');
                            break block0;
                        }
                        case 'H': 
                        case 'h': {
                            stringBuffer.append('?');
                            break block0;
                        }
                        case 'I': 
                        case 'i': {
                            stringBuffer.append('[');
                            break block0;
                        }
                        case 'J': 
                        case 'j': {
                            stringBuffer.append(']');
                            break block0;
                        }
                        case 'K': 
                        case 'k': {
                            stringBuffer.append(';');
                            break block0;
                        }
                        case 'L': 
                        case 'l': {
                            stringBuffer.append('<');
                            break block0;
                        }
                        case 'M': 
                        case 'm': {
                            stringBuffer.append('&');
                            break block0;
                        }
                        case 'N': 
                        case 'n': {
                            stringBuffer.append('+');
                            break block0;
                        }
                        case 'O': 
                        case 'o': {
                            stringBuffer.append('#');
                            break block0;
                        }
                        case 'P': 
                        case 'p': {
                            stringBuffer.append('%');
                            break block0;
                        }
                        case 'Q': 
                        case 'q': {
                            stringBuffer.append('\"');
                            break block0;
                        }
                        case 'R': 
                        case 'r': {
                            stringBuffer.append('^');
                            break block0;
                        }
                        case 'S': 
                        case 's': {
                            stringBuffer.append('*');
                            break block0;
                        }
                        case 'T': 
                        case 't': {
                            stringBuffer.append('~');
                            break block0;
                        }
                        case 'U': 
                        case 'u': {
                            stringBuffer.append('_');
                            break block0;
                        }
                        case 'V': 
                        case 'v': {
                            stringBuffer.append('|');
                            break block0;
                        }
                        case 'W': 
                        case 'w': {
                            stringBuffer.append('`');
                            break block0;
                        }
                        case 'X': 
                        case 'x': {
                            stringBuffer.append('!');
                            break block0;
                        }
                        case 'Y': 
                        case 'y': {
                            stringBuffer.append('{');
                            break block0;
                        }
                        case 'Z': 
                        case 'z': {
                            stringBuffer.append('}');
                            break block0;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    private static CbdtEntry createCbdtEntry(Map<Integer, SbitSmallGlyphMetrics> map, Map<Integer, SbitBigGlyphMetrics> map2, int n) {
        if (map.containsKey(n)) {
            CbdtEntryFormat17 cbdtEntryFormat17 = new CbdtEntryFormat17();
            cbdtEntryFormat17.glyphMetrics = map.get(n);
            return cbdtEntryFormat17;
        }
        if (map2.containsKey(n)) {
            CbdtEntryFormat18 cbdtEntryFormat18 = new CbdtEntryFormat18();
            cbdtEntryFormat18.glyphMetrics = map2.get(n);
            return cbdtEntryFormat18;
        }
        if (map.containsKey(0)) {
            CbdtEntryFormat17 cbdtEntryFormat17 = new CbdtEntryFormat17();
            cbdtEntryFormat17.glyphMetrics = map.get(0);
            return cbdtEntryFormat17;
        }
        if (map2.containsKey(0)) {
            CbdtEntryFormat18 cbdtEntryFormat18 = new CbdtEntryFormat18();
            cbdtEntryFormat18.glyphMetrics = map2.get(0);
            return cbdtEntryFormat18;
        }
        return new CbdtEntryFormat19();
    }
}

