/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.truetype.ColrTable;
import com.kreative.bitsnpicas.truetype.CpalTable;
import com.kreative.bitsnpicas.truetype.HeadTable;
import com.kreative.bitsnpicas.truetype.HheaTable;
import com.kreative.bitsnpicas.truetype.MaxpTable;
import com.kreative.bitsnpicas.truetype.NameTable;
import com.kreative.bitsnpicas.truetype.NameTableEntry;
import com.kreative.bitsnpicas.truetype.Os2Table;
import com.kreative.bitsnpicas.truetype.TrueTypeFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class DebugTTF {
    public static void main(String[] stringArray) {
        boolean bl = true;
        boolean bl2 = false;
        for (String string : stringArray) {
            if (bl && string.startsWith("-")) {
                if (string.equals("--")) {
                    bl = false;
                    continue;
                }
                if (string.equals("-c")) {
                    bl2 = true;
                    continue;
                }
                if (string.equals("-C")) {
                    bl2 = false;
                    continue;
                }
                System.err.println("Unknown option: " + string);
                continue;
            }
            System.out.println(string);
            try {
                Object object3;
                Object object2;
                int n;
                File file = new File(string);
                FileInputStream fileInputStream = new FileInputStream(file);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[0x100000];
                while ((n = fileInputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
                fileInputStream.close();
                TrueTypeFile trueTypeFile = new TrueTypeFile();
                trueTypeFile.decompile(byteArrayOutputStream.toByteArray());
                System.out.println("  head");
                HeadTable headTable = (HeadTable)trueTypeFile.getByTableName("head");
                if (headTable == null) {
                    System.out.println("    Not present.");
                } else {
                    object2 = new SimpleDateFormat();
                    System.out.println("    version:               " + DebugTTF.hex(headTable.version, 8));
                    System.out.println("    fontRevision:          " + headTable.getFontRevisionDouble());
                    System.out.println("    checkSum:              " + DebugTTF.hex(headTable.checkSum, 8));
                    System.out.println("    magicNumber:           " + DebugTTF.hex(headTable.magicNumber, 8));
                    System.out.println("    flags:                 " + DebugTTF.hex(headTable.flags, 4));
                    System.out.println("    unitsPerEm:            " + headTable.unitsPerEm);
                    System.out.println("    dateCreated:           " + ((DateFormat)object2).format(headTable.getDateCreatedCalendar().getTime()));
                    System.out.println("    dateModified:          " + ((DateFormat)object2).format(headTable.getDateModifiedCalendar().getTime()));
                    System.out.println("    xMin:                  " + headTable.xMin);
                    System.out.println("    yMin:                  " + headTable.yMin);
                    System.out.println("    xMax:                  " + headTable.xMax);
                    System.out.println("    yMax:                  " + headTable.yMax);
                    System.out.println("    macStyle:              " + DebugTTF.hex(headTable.macStyle, 2));
                    System.out.println("    lowestRecPPEM:         " + headTable.lowestRecPPEM);
                    System.out.println("    fontDirectionHint:     " + headTable.fontDirectionHint);
                    System.out.println("    indexToLocFormat:      " + headTable.indexToLocFormat);
                    System.out.println("    glyphDataFormat:       " + headTable.glyphDataFormat);
                }
                System.out.println("  hhea");
                object2 = (HheaTable)trueTypeFile.getByTableName("hhea");
                if (object2 == null) {
                    System.out.println("    Not present.");
                } else {
                    System.out.println("    version:               " + DebugTTF.hex(((HheaTable)object2).version, 8));
                    System.out.println("    ascent:                " + ((HheaTable)object2).ascent);
                    System.out.println("    descent:               " + ((HheaTable)object2).descent);
                    System.out.println("    lineGap:               " + ((HheaTable)object2).lineGap);
                    System.out.println("    advanceWidthMax:       " + ((HheaTable)object2).advanceWidthMax);
                    System.out.println("    minLSB:                " + ((HheaTable)object2).minLeftSideBearing);
                    System.out.println("    minRSB:                " + ((HheaTable)object2).minRightSideBearing);
                    System.out.println("    xMaxExtent:            " + ((HheaTable)object2).xMaxExtent);
                    System.out.println("    caretSlopeRise:        " + ((HheaTable)object2).caretSlopeRise);
                    System.out.println("    caretSlopeRun:         " + ((HheaTable)object2).caretSlopeRun);
                    System.out.println("    caretOffset:           " + ((HheaTable)object2).caretOffset);
                    System.out.println("    reserved1:             " + DebugTTF.hex(((HheaTable)object2).reserved1, 4));
                    System.out.println("    reserved2:             " + DebugTTF.hex(((HheaTable)object2).reserved2, 4));
                    System.out.println("    reserved3:             " + DebugTTF.hex(((HheaTable)object2).reserved3, 4));
                    System.out.println("    reserved4:             " + DebugTTF.hex(((HheaTable)object2).reserved4, 4));
                    System.out.println("    metricDataFormat:      " + ((HheaTable)object2).metricDataFormat);
                    System.out.println("    numLongHorMetrics:     " + ((HheaTable)object2).numLongHorMetrics);
                }
                System.out.println("  maxp");
                MaxpTable maxpTable = (MaxpTable)trueTypeFile.getByTableName("maxp");
                if (maxpTable == null) {
                    System.out.println("    Not present.");
                } else {
                    System.out.println("    version:               " + DebugTTF.hex(maxpTable.version, 8));
                    System.out.println("    numGlyphs:             " + maxpTable.numGlyphs);
                    System.out.println("    maxPoints:             " + maxpTable.maxPoints);
                    System.out.println("    maxContours:           " + maxpTable.maxContours);
                    System.out.println("    maxComponentPoints:    " + maxpTable.maxComponentPoints);
                    System.out.println("    maxComponentContours:  " + maxpTable.maxComponentContours);
                    System.out.println("    maxZones:              " + maxpTable.maxZones);
                    System.out.println("    maxTwilightPoints:     " + maxpTable.maxTwilightPoints);
                    System.out.println("    maxStorage:            " + maxpTable.maxStorage);
                    System.out.println("    maxFunctionDefs:       " + maxpTable.maxFunctionDefs);
                    System.out.println("    maxInstructionDefs:    " + maxpTable.maxInstructionDefs);
                    System.out.println("    maxStackElements:      " + maxpTable.maxStackElements);
                    System.out.println("    maxSizeOfInstructions: " + maxpTable.maxSizeOfInstructions);
                    System.out.println("    maxComponentElements:  " + maxpTable.maxComponentElements);
                    System.out.println("    maxComponentDepth:     " + maxpTable.maxComponentDepth);
                }
                System.out.println("  name");
                NameTable nameTable = (NameTable)trueTypeFile.getByTableName("name");
                if (nameTable == null) {
                    System.out.println("    Not present.");
                } else {
                    System.out.println("    Plat  Spec  Lang  Name  Size  String");
                    for (Object object3 : nameTable) {
                        System.out.print("    ");
                        System.out.print(DebugTTF.pad(((NameTableEntry)object3).platformID, 6));
                        System.out.print(DebugTTF.pad(((NameTableEntry)object3).platformSpecificID, 6));
                        System.out.print(DebugTTF.pad(((NameTableEntry)object3).languageID, 6));
                        System.out.print(DebugTTF.pad(((NameTableEntry)object3).nameID, 6));
                        System.out.print(DebugTTF.pad(((NameTableEntry)object3).nameData.length, 6));
                        try {
                            System.out.print("\"" + ((NameTableEntry)object3).getNameString() + "\"");
                        }
                        catch (Exception exception) {
                            System.out.print("<" + ((NameTableEntry)object3).nameData.length + ">");
                        }
                        if (((NameTableEntry)object3).padding != 0) {
                            System.out.print(" [" + ((NameTableEntry)object3).padding + "]");
                        }
                        System.out.println();
                    }
                }
                System.out.println("  OS/2");
                Os2Table os2Table = (Os2Table)trueTypeFile.getByTableName("OS/2");
                if (os2Table == null) {
                    System.out.println("    Not present.");
                } else {
                    System.out.println("    length:                " + os2Table.length);
                    System.out.println("    version:               " + os2Table.version);
                    System.out.println("    avgCharWidth:          " + os2Table.averageCharWidth);
                    System.out.println("    weightClass:           " + os2Table.weightClass);
                    System.out.println("    widthClass:            " + os2Table.widthClass);
                    System.out.println("    flags:                 " + DebugTTF.hex(os2Table.flags, 4));
                    System.out.println("    subscriptXSize:        " + os2Table.subscriptXSize);
                    System.out.println("    subscriptYSize:        " + os2Table.subscriptYSize);
                    System.out.println("    subscriptXOffset:      " + os2Table.subscriptXOffset);
                    System.out.println("    subscriptYOffset:      " + os2Table.subscriptYOffset);
                    System.out.println("    superscriptXSize:      " + os2Table.superscriptXSize);
                    System.out.println("    superscriptYSize:      " + os2Table.superscriptYSize);
                    System.out.println("    superscriptXOffset:    " + os2Table.superscriptXOffset);
                    System.out.println("    superscriptYOffset:    " + os2Table.superscriptYOffset);
                    System.out.println("    strikeoutWidth:        " + os2Table.strikeoutWidth);
                    System.out.println("    strikeoutPosition:     " + os2Table.strikeoutPosition);
                    System.out.println("    familyClass:           " + os2Table.familyClass);
                    System.out.println("    familySubClass:        " + os2Table.familySubClass);
                    System.out.println("    panoseFamilyType:      " + os2Table.panoseFamilyType);
                    System.out.println("    panoseSerifStyle:      " + os2Table.panoseSerifStyle);
                    System.out.println("    panoseWeight:          " + os2Table.panoseWeight);
                    System.out.println("    panoseProportion:      " + os2Table.panoseProportion);
                    System.out.println("    panoseContrast:        " + os2Table.panoseContrast);
                    System.out.println("    panoseStrokeVariation: " + os2Table.panoseStrokeVariation);
                    System.out.println("    panoseArmStyle:        " + os2Table.panoseArmStyle);
                    System.out.println("    panoseLetterform:      " + os2Table.panoseLetterform);
                    System.out.println("    panoseMidline:         " + os2Table.panoseMidline);
                    System.out.println("    panoseXHeight:         " + os2Table.panoseXHeight);
                    System.out.println("    unicodeRanges:         " + DebugTTF.hex(os2Table.unicodeRanges, 8));
                    System.out.println("    vendorID:              " + os2Table.getVendorIDString());
                    System.out.println("    fsSelection:           " + DebugTTF.hex(os2Table.fsSelection, 4));
                    System.out.println("    fsFirstCharIndex:      " + DebugTTF.hex(os2Table.fsFirstCharIndex, 4));
                    System.out.println("    fsLastCharIndex:       " + DebugTTF.hex(os2Table.fsLastCharIndex, 4));
                    if (os2Table.length >= 78) {
                        System.out.println("    typoAscent:            " + os2Table.typoAscent);
                        System.out.println("    typoDescent:           " + os2Table.typoDescent);
                        System.out.println("    typoLineGap:           " + os2Table.typoLineGap);
                        System.out.println("    winAscent:             " + os2Table.winAscent);
                        System.out.println("    winDescent:            " + os2Table.winDescent);
                        if (os2Table.length >= 86) {
                            System.out.println("    codePages:             " + DebugTTF.hex(os2Table.codePages, 8));
                            if (os2Table.length >= 96) {
                                System.out.println("    xHeight:               " + os2Table.xHeight);
                                System.out.println("    capHeight:             " + os2Table.capHeight);
                                System.out.println("    defaultChar:           " + DebugTTF.hex(os2Table.defaultChar, 4));
                                System.out.println("    breakChar:             " + DebugTTF.hex(os2Table.breakChar, 4));
                                System.out.println("    maxContext:            " + os2Table.maxContext);
                                if (os2Table.length >= 100) {
                                    System.out.println("    lowerOpticalPointSize: " + os2Table.getLowerOpticalPointSizeDouble());
                                    System.out.println("    upperOpticalPointSize: " + os2Table.getUpperOpticalPointSizeDouble());
                                }
                            }
                        }
                    }
                }
                if (!bl2) continue;
                System.out.println("  CPAL");
                object3 = (CpalTable)trueTypeFile.getByTableName("CPAL");
                if (object3 == null) {
                    System.out.println("    Not present.");
                } else {
                    System.out.println("    version:               " + ((CpalTable)object3).version);
                    System.out.println("    numPaletteEntries:     " + ((CpalTable)object3).numPaletteEntries);
                    System.out.println("    numPalettes:           " + ((CpalTable)object3).colorRecordIndices.length);
                    System.out.println("    numColorRecords:       " + ((CpalTable)object3).colorRecordsArray.length);
                    System.out.println("    colorRecordsArray:");
                    for (Object object4 : (ColrTable)((CpalTable)object3).colorRecordsArray) {
                        System.out.print(DebugTTF.color((int)object4));
                    }
                    System.out.println();
                    for (int i = 0; i < ((CpalTable)object3).colorRecordIndices.length; ++i) {
                        System.out.println("    palette #" + i + ":");
                        int n2 = ((CpalTable)object3).colorRecordIndices[i];
                        for (int j = 0; j < ((CpalTable)object3).numPaletteEntries; ++j) {
                            System.out.print(DebugTTF.color(((CpalTable)object3).colorRecordsArray[n2++]));
                        }
                        System.out.println();
                    }
                }
                System.out.println("  COLR");
                ColrTable colrTable = (ColrTable)trueTypeFile.getByTableName("COLR");
                if (colrTable == null) {
                    System.out.println("    Not present.");
                    continue;
                }
                System.out.println("    version:               " + colrTable.version);
                System.out.println("    numBaseGlyphRecords:   " + colrTable.baseGlyphRecords.length);
                System.out.println("    numLayerRecords:       " + colrTable.layerRecords.length);
            }
            catch (IOException iOException) {
                System.out.println("  Could not read.");
            }
        }
    }

    private static String color(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 0 & 0xFF;
        int n5 = n2 * 30 + n3 * 59 + n4 * 11;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u001b[48;2;" + n2 + ";" + n3 + ";" + n4 + "m");
        stringBuffer.append(n5 < 12750 ? "\u001b[97m" : "\u001b[30m");
        stringBuffer.append(" " + Integer.toHexString(n).toUpperCase() + " ");
        stringBuffer.append("\u001b[0m");
        return stringBuffer.toString();
    }

    private static String hex(int n, int n2) {
        String string = Integer.toHexString(n).toUpperCase();
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    private static String hex(int[] nArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int n2 : nArray) {
            stringBuffer.insert(0, DebugTTF.hex(n2, n));
        }
        return stringBuffer.toString();
    }

    private static String pad(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        while (stringBuffer.length() < n2) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

