/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class KbitsBitmapFontImporter
implements BitmapFontImporter {
    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        BitmapFont bitmapFont = this.importFont(dataInputStream);
        dataInputStream.close();
        byteArrayInputStream.close();
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        BitmapFont bitmapFont = this.importFont(new DataInputStream(inputStream));
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        BitmapFont bitmapFont = this.importFont(dataInputStream);
        dataInputStream.close();
        fileInputStream.close();
        return new BitmapFont[]{bitmapFont};
    }

    private BitmapFont importFont(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.readInt() != 1262644816) {
            throw new IOException("bad magic number");
        }
        if (dataInputStream.readInt() != 1651078259) {
            throw new IOException("bad magic number");
        }
        if (dataInputStream.readInt() != 1) {
            throw new IOException("bad version number");
        }
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        int n5 = dataInputStream.readInt();
        int n6 = dataInputStream.readInt();
        BitmapFont bitmapFont = new BitmapFont(n, n2, n3, n4, n6, n6, n5);
        block5: while (true) {
            int n7 = dataInputStream.readInt();
            switch (n7) {
                case 1851878757: {
                    if (dataInputStream.readInt() != 1) {
                        throw new IOException("bad version number");
                    }
                    int n8 = dataInputStream.readInt();
                    String string = dataInputStream.readUTF();
                    bitmapFont.setName(n8, string);
                    continue block5;
                }
                case 1667785074: {
                    if (dataInputStream.readInt() != 1) {
                        throw new IOException("bad version number");
                    }
                    int n9 = dataInputStream.readInt();
                    int n10 = dataInputStream.readInt();
                    int n11 = dataInputStream.readInt();
                    int n12 = dataInputStream.readInt();
                    int n13 = dataInputStream.readInt();
                    byte[][] byArrayArray = new byte[n13][];
                    for (int i = 0; i < n13; ++i) {
                        int n14 = dataInputStream.readInt();
                        byArrayArray[i] = new byte[n14];
                        dataInputStream.readFully(byArrayArray[i]);
                    }
                    BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph(byArrayArray, n11, n10, n12);
                    bitmapFont.putCharacter(n9, bitmapFontGlyph);
                    continue block5;
                }
                case 1718185518: {
                    bitmapFont.setCapHeight();
                    return bitmapFont;
                }
            }
            break;
        }
        throw new IOException("bad magic number");
    }
}

