/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Scanner;

public class BDFBitmapFontImporter
implements BitmapFontImporter {
    private static final String[][] CHARSET_REGISTRIES = new String[][]{{"JISX0208.1990", "JIS0208"}};
    private static final Charset FONT_SPECIFIC = new Charset("X", null){

        public boolean contains(Charset charset) {
            return false;
        }

        public CharsetDecoder newDecoder() {
            return null;
        }

        public CharsetEncoder newEncoder() {
            return null;
        }
    };

    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        return this.importFont(new Scanner((InputStream)new ByteArrayInputStream(byArray), "UTF-8"));
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        return this.importFont(new Scanner(inputStream, "UTF-8"));
    }

    public BitmapFont[] importFont(File file) throws IOException {
        return this.importFont(new Scanner((InputStream)new FileInputStream(file), "UTF-8"));
    }

    public BitmapFont[] importFont(Scanner scanner) throws IOException {
        ArrayList<BitmapFont> arrayList = new ArrayList<BitmapFont>();
        while (scanner.hasNextLine()) {
            String[] stringArray = scanner.nextLine().trim().split("\\s+", 2);
            if (!stringArray[0].equals("STARTFONT")) continue;
            arrayList.add(this.readFont(scanner));
        }
        return arrayList.toArray(new BitmapFont[arrayList.size()]);
    }

    private BitmapFont readFont(Scanner scanner) throws IOException {
        BitmapFont bitmapFont = new BitmapFont();
        Charset charset = null;
        while (scanner.hasNextLine()) {
            String[] stringArray = scanner.nextLine().trim().split("\\s+", 2);
            if (stringArray[0].equals("STARTCHAR")) {
                this.readChar(scanner, bitmapFont, charset);
                continue;
            }
            if (stringArray[0].equals("ENDFONT")) break;
            if (stringArray.length < 2) continue;
            if (stringArray[0].equals("FAMILY_NAME")) {
                bitmapFont.setName(1, BDFBitmapFontImporter.dequote(stringArray[1]));
                continue;
            }
            if (stringArray[0].equals("WEIGHT_NAME")) {
                bitmapFont.setName(2, BDFBitmapFontImporter.dequote(stringArray[1]));
                continue;
            }
            if (stringArray[0].equals("FONT_VERSION")) {
                bitmapFont.setName(5, BDFBitmapFontImporter.dequote(stringArray[1]));
                continue;
            }
            if (stringArray[0].equals("COPYRIGHT")) {
                bitmapFont.setName(0, BDFBitmapFontImporter.dequote(stringArray[1]));
                continue;
            }
            if (stringArray[0].equals("FOUNDRY")) {
                bitmapFont.setName(8, BDFBitmapFontImporter.dequote(stringArray[1]));
                continue;
            }
            if (stringArray[0].equals("FONT_ASCENT")) {
                try {
                    int n = Integer.parseInt(BDFBitmapFontImporter.dequote(stringArray[1]));
                    bitmapFont.setLineAscent(n);
                    bitmapFont.setEmAscent(n);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (stringArray[0].equals("FONT_DESCENT")) {
                try {
                    int n = Integer.parseInt(BDFBitmapFontImporter.dequote(stringArray[1]));
                    bitmapFont.setLineDescent(n);
                    bitmapFont.setEmDescent(n);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (stringArray[0].equals("X_HEIGHT")) {
                try {
                    int n = Integer.parseInt(BDFBitmapFontImporter.dequote(stringArray[1]));
                    bitmapFont.setXHeight(n);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (stringArray[0].equals("CAP_HEIGHT")) {
                try {
                    int n = Integer.parseInt(BDFBitmapFontImporter.dequote(stringArray[1]));
                    bitmapFont.setCapHeight(n);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!stringArray[0].equals("CHARSET_REGISTRY")) continue;
            String string = BDFBitmapFontImporter.dequote(stringArray[1]);
            if (string.equalsIgnoreCase("ISO10646")) {
                charset = null;
                continue;
            }
            if (string.equalsIgnoreCase("FontSpecific")) {
                charset = FONT_SPECIFIC;
                continue;
            }
            try {
                charset = Charset.forName(string);
            }
            catch (Exception exception) {
                charset = null;
                for (String[] stringArray2 : CHARSET_REGISTRIES) {
                    if (!string.equalsIgnoreCase(stringArray2[0])) continue;
                    try {
                        charset = Charset.forName(stringArray2[1]);
                        break;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (charset != null) continue;
                System.err.println("Warning: Unsupported CHARSET_REGISTRY: " + string);
            }
        }
        return bitmapFont;
    }

    private void readChar(Scanner scanner, BitmapFont bitmapFont, Charset charset) throws IOException {
        BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph();
        int n = -1;
        while (scanner.hasNextLine()) {
            int n2;
            Object object;
            String[] stringArray = scanner.nextLine().trim().split("\\s+", 2);
            if (stringArray[0].equals("BITMAP")) {
                if (!this.readBitmap(scanner, bitmapFontGlyph)) continue;
                break;
            }
            if (stringArray[0].equals("ENDCHAR")) break;
            if (stringArray.length < 2) continue;
            if (stringArray[0].equals("ENCODING")) {
                try {
                    n = Integer.parseInt(BDFBitmapFontImporter.dequote(stringArray[1]));
                    if (charset == FONT_SPECIFIC) {
                        n += 61440;
                        continue;
                    }
                    if (charset == null) continue;
                    object = new String(BDFBitmapFontImporter.toByteArray(n), charset);
                    if (((String)object).codePointCount(0, ((String)object).length()) == 1) {
                        n = ((String)object).codePointAt(0);
                        continue;
                    }
                    System.err.println("Warning: Undecodable ENCODING: " + n);
                    n = -1;
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                continue;
            }
            if (stringArray[0].equals("DWIDTH")) {
                try {
                    object = BDFBitmapFontImporter.dequote(stringArray[1]).split("\\s+");
                    n2 = Integer.parseInt(object[0]);
                    bitmapFontGlyph.setCharacterWidth(n2);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!stringArray[0].equals("BBX")) continue;
            try {
                object = BDFBitmapFontImporter.dequote(stringArray[1]).split("\\s+");
                n2 = ((String[])object).length > 0 ? Integer.parseInt((String)object[0]) : 0;
                int n3 = ((Object)object).length > 1 ? Integer.parseInt((String)object[1]) : 0;
                int n4 = ((Object)object).length > 2 ? Integer.parseInt((String)object[2]) : 0;
                int n5 = ((Object)object).length > 3 ? Integer.parseInt((String)object[3]) : 0;
                bitmapFontGlyph.setGlyph(new byte[n3][n2]);
                bitmapFontGlyph.setXY(n4, n3 + n5);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (n >= 0) {
            bitmapFont.putCharacter(n, bitmapFontGlyph);
        }
    }

    private boolean readBitmap(Scanner scanner, BitmapFontGlyph bitmapFontGlyph) {
        byte[][] byArray = bitmapFontGlyph.getGlyph();
        int n = 0;
        while (scanner.hasNextLine() && n < byArray.length) {
            String[] stringArray = scanner.nextLine().trim().split("\\s+", 2);
            if (stringArray[0].equals("ENDCHAR")) {
                return true;
            }
            BDFBitmapFontImporter.unpack(stringArray[0], byArray[n++]);
        }
        return false;
    }

    private static String dequote(String string) {
        if (string.length() < 2) {
            return string;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1).replaceAll("\"\"", "\"");
        }
        return string;
    }

    private static byte[] toByteArray(int n) {
        if ((n & 0xFFFFFF00) == 0) {
            return new byte[]{(byte)n};
        }
        if ((n & 0xFFFF0000) == 0) {
            return new byte[]{(byte)(n >> 8), (byte)n};
        }
        if ((n & 0xFF000000) == 0) {
            return new byte[]{(byte)(n >> 16), (byte)(n >> 8), (byte)n};
        }
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }

    private static void unpack(String string, byte[] byArray) {
        int n = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            block11: {
                int n2;
                block9: {
                    block10: {
                        block8: {
                            if (c < '0' || c > '9') break block8;
                            n2 = c - 48;
                            break block9;
                        }
                        if (c < 'A' || c > 'F') break block10;
                        n2 = c - 65 + 10;
                        break block9;
                    }
                    if (c < 'a' || c > 'f') break block11;
                    n2 = c - 97 + 10;
                }
                if (n < byArray.length) {
                    byArray[n++] = (byte)((n2 & 8) == 0 ? 0 : -1);
                }
                if (n < byArray.length) {
                    byArray[n++] = (byte)((n2 & 4) == 0 ? 0 : -1);
                }
                if (n < byArray.length) {
                    byArray[n++] = (byte)((n2 & 2) == 0 ? 0 : -1);
                }
                if (n < byArray.length) {
                    byArray[n++] = (byte)((n2 & 1) == 0 ? 0 : -1);
                }
            }
            c = stringCharacterIterator.next();
        }
    }
}

