/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.Base64OutputStream;
import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.GlyphPair;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class PlaydateBitmapFontExporter
implements BitmapFontExporter {
    private static final int MIN_CODE_POINT = 32;
    private static final int MAX_CODE_POINT = 262143;
    private static final Pattern FNT_FILE_PATTERN = Pattern.compile("^(.+)\\.fnt$", 2);
    private static final Pattern PNG_FILE_PATTERN = Pattern.compile("^(.+)-table-(\\d+)-(\\d+)\\.png$", 2);
    private boolean separate;

    private static File fntFile(File file, String string) {
        return new File(file, string + ".fnt");
    }

    private static File pngFile(File file, String string, int n, int n2) {
        return new File(file, string + "-table-" + n + "-" + n2 + ".png");
    }

    public PlaydateBitmapFontExporter(boolean bl) {
        this.separate = bl;
    }

    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"), true);
        this.exportFont(bitmapFont, printWriter, null, PlaydateBitmapFontExporter.getMetrics(bitmapFont));
        printWriter.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), true);
        this.exportFont(bitmapFont, printWriter, null, PlaydateBitmapFontExporter.getMetrics(bitmapFont));
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        int[] nArray = PlaydateBitmapFontExporter.getMetrics(bitmapFont);
        if (this.separate) {
            Matcher matcher = PNG_FILE_PATTERN.matcher(file.getName());
            if (matcher.matches()) {
                File file2 = PlaydateBitmapFontExporter.fntFile(file.getParentFile(), matcher.group(1));
                File file3 = PlaydateBitmapFontExporter.pngFile(file.getParentFile(), matcher.group(1), nArray[1], nArray[0]);
                this.exportFont(bitmapFont, file2, file3, nArray);
                return;
            }
            Matcher matcher2 = FNT_FILE_PATTERN.matcher(file.getName());
            if (matcher2.matches()) {
                File file4 = file;
                File file5 = PlaydateBitmapFontExporter.pngFile(file.getParentFile(), matcher2.group(1), nArray[1], nArray[0]);
                this.exportFont(bitmapFont, file4, file5, nArray);
                return;
            }
            File file6 = PlaydateBitmapFontExporter.fntFile(file.getParentFile(), file.getName());
            File file7 = PlaydateBitmapFontExporter.pngFile(file.getParentFile(), file.getName(), nArray[1], nArray[0]);
            this.exportFont(bitmapFont, file6, file7, nArray);
            return;
        }
        this.exportFont(bitmapFont, file, null, nArray);
    }

    private void exportFont(BitmapFont bitmapFont, File file, File file2, int[] nArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"), true);
        this.exportFont(bitmapFont, printWriter, file2, nArray);
        printWriter.close();
        fileOutputStream.close();
    }

    private void exportFont(BitmapFont bitmapFont, PrintWriter printWriter, File file, int[] nArray) throws IOException {
        Iterator<Map.Entry<Object, Object>> iterator;
        int n;
        int n2 = nArray[3];
        int n3 = nArray[2];
        int n4 = nArray[1];
        int n5 = nArray[0];
        if (n4 < 1 || n5 < 1) {
            throw new IOException("invalid cell size: " + n4 + ", " + n5);
        }
        int n6 = n2 < 16 ? n2 : 16;
        int n7 = (n2 + n6 - 1) / n6;
        if (n6 < 1 || n7 < 1) {
            throw new IOException("invalid cell count: " + n6 + ", " + n7);
        }
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        BufferedImage bufferedImage = new BufferedImage(n6 * n4, n7 * n5, 2);
        int[] nArray2 = new int[n4 * n5];
        int n8 = 0;
        int n9 = 0;
        for (n = 32; n <= 262143; ++n) {
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n);
            if (bitmapFontGlyph == null) continue;
            iterator = new BufferedImage(n4, n5, 2);
            Graphics2D entry2 = ((BufferedImage)((Object)iterator)).createGraphics();
            entry2.setColor(Color.black);
            bitmapFontGlyph.paint(entry2, 0.0, bitmapFont.getLineAscent(), 1.0);
            entry2.dispose();
            ((BufferedImage)((Object)iterator)).getRGB(0, 0, n4, n5, nArray2, 0, n4);
            bufferedImage.setRGB(n9 * n4, n8 * n5, n4, n5, nArray2, 0, n4);
            treeMap.put(n, bitmapFontGlyph.getCharacterWidth() - n3);
            if (++n9 < n6) continue;
            n9 = 0;
            if (++n8 < n7) continue;
            n8 = 0;
        }
        String string = bitmapFont.getName(4);
        if (string == null) {
            string = bitmapFont.getName(1);
        }
        if (string != null) {
            printWriter.println("--name=" + string);
        }
        n9 = bitmapFont.getLineAscent() - n5;
        n = bitmapFont.getXHeight();
        int n10 = bitmapFont.getCapHeight();
        printWriter.println("--metrics={\"baseline\":" + n9 + ",\"xHeight\":" + n + ",\"capHeight\":" + n10 + "}");
        if (file != null) {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        } else {
            iterator = new StringBuffer();
            Base64OutputStream base64OutputStream = new Base64OutputStream((StringBuffer)((Object)iterator));
            ImageIO.write((RenderedImage)bufferedImage, "png", base64OutputStream);
            base64OutputStream.close();
            printWriter.println("datalen=" + ((StringBuffer)((Object)iterator)).length());
            printWriter.println("data=" + ((StringBuffer)((Object)iterator)).toString());
            printWriter.println("width=" + n4);
            printWriter.println("height=" + n5);
        }
        printWriter.println("tracking=" + n3);
        for (Map.Entry entry : treeMap.entrySet()) {
            printWriter.println(PlaydateBitmapFontExporter.joinCodePoints((Integer)entry.getKey()) + "\t" + entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : bitmapFont.kernPairs(false).entrySet()) {
            Object object = ((GlyphPair)entry.getKey()).getLeft();
            Object object2 = ((GlyphPair)entry.getKey()).getRight();
            if (!(object instanceof Integer) || !(object2 instanceof Integer)) continue;
            int n11 = (Integer)object;
            int n12 = (Integer)object2;
            if (n11 < 32 || n11 > 262143 || n12 < 32 || n12 > 262143) continue;
            printWriter.println(PlaydateBitmapFontExporter.joinCodePoints(n11, n12) + "\t" + entry.getValue());
        }
    }

    private static int[] getMetrics(BitmapFont bitmapFont) {
        int n = bitmapFont.getLineAscent() + bitmapFont.getLineDescent() + bitmapFont.getLineGap();
        int n2 = 0;
        Integer n3 = null;
        int n4 = 0;
        for (int i = 32; i <= 262143; ++i) {
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(i);
            if (bitmapFontGlyph == null) continue;
            int n5 = bitmapFontGlyph.getGlyphOffset() + bitmapFontGlyph.getGlyphWidth();
            if (n2 < n5) {
                n2 = n5;
            }
            int n6 = bitmapFontGlyph.getCharacterWidth() - n5;
            if (n3 == null || n3 > n6) {
                n3 = n6;
            }
            ++n4;
        }
        if (n3 == null) {
            n3 = 1;
        }
        return new int[]{n, n2 + 1, n3, n4};
    }

    private static String joinCodePoints(int ... nArray) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 0) {
            return "";
        }
        if (nArray.length == 1 && nArray[0] == 32) {
            return "space";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        block3: for (int n : nArray) {
            if (bl && Character.digit(n, 16) >= 0) {
                stringBuffer.append("U+");
                stringBuffer.append(Integer.toHexString(n).toUpperCase());
                continue;
            }
            switch (Character.getType(n)) {
                case 0: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    stringBuffer.append("U+");
                    stringBuffer.append(Integer.toHexString(n).toUpperCase());
                    bl = true;
                    continue block3;
                }
                default: {
                    stringBuffer.append(Character.toChars(n));
                    bl = false;
                }
            }
        }
        return stringBuffer.toString();
    }
}

