/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.GlyphPair;
import com.kreative.bitsnpicas.VectorFont;
import com.kreative.bitsnpicas.VectorFontExporter;
import com.kreative.bitsnpicas.VectorFontGlyph;
import com.kreative.bitsnpicas.VectorPath;
import com.kreative.bitsnpicas.XMLUtility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KpcaxVectorFontExporter
implements VectorFontExporter {
    @Override
    public byte[] exportFontToBytes(VectorFont vectorFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"), true);
        this.exportFont(vectorFont, printWriter);
        printWriter.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void exportFontToStream(VectorFont vectorFont, OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), true);
        this.exportFont(vectorFont, printWriter);
    }

    @Override
    public void exportFontToFile(VectorFont vectorFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"), true);
        this.exportFont(vectorFont, printWriter);
        printWriter.close();
        fileOutputStream.close();
    }

    private void exportFont(VectorFont vectorFont, PrintWriter printWriter) throws IOException {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<!DOCTYPE kpcas PUBLIC \"-//Kreative//DTD BitsNPicasVector 1.0//EN\" \"http://www.kreativekorp.com/dtd/kpcax.dtd\">");
        printWriter.println("<kpcas>");
        for (Map.Entry<String, String> entry : KpcaxVectorFontExporter.getProperties(vectorFont).entrySet()) {
            printWriter.println(XMLUtility.wrap("prop", true, "id", entry.getKey(), "value", entry.getValue()));
        }
        for (Map.Entry<Object, String> entry : vectorFont.names(false).entrySet()) {
            printWriter.println(XMLUtility.wrap("name", true, "id", ((Integer)entry.getKey()).toString(), "value", entry.getValue()));
        }
        for (Map.Entry<Object, String> entry : vectorFont.characters(false).entrySet()) {
            printWriter.println(KpcaxVectorFontExporter.encodeGlyph(entry.getKey(), (VectorFontGlyph)((Object)entry.getValue())));
        }
        for (Map.Entry<Object, String> entry : vectorFont.namedGlyphs(false).entrySet()) {
            printWriter.println(KpcaxVectorFontExporter.encodeGlyph(entry.getKey(), (VectorFontGlyph)((Object)entry.getValue())));
        }
        for (Map.Entry<Object, Object> entry : vectorFont.kernPairs(false).entrySet()) {
            Object object = ((GlyphPair)entry.getKey()).getLeft();
            Object object2 = ((GlyphPair)entry.getKey()).getRight();
            printWriter.println(XMLUtility.wrap("k", true, object instanceof Integer ? "lu" : "ln", object.toString(), object2 instanceof Integer ? "ru" : "rn", object2.toString(), "o", ((Integer)entry.getValue()).toString()));
        }
        printWriter.println("</kpcas>");
    }

    private static Map<String, String> getProperties(VectorFont vectorFont) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("emAscent", Double.toString(vectorFont.getEmAscent2D()));
        linkedHashMap.put("emDescent", Double.toString(vectorFont.getEmDescent2D()));
        linkedHashMap.put("lineAscent", Double.toString(vectorFont.getLineAscent2D()));
        linkedHashMap.put("lineDescent", Double.toString(vectorFont.getLineDescent2D()));
        linkedHashMap.put("lineGap", Double.toString(vectorFont.getLineGap2D()));
        linkedHashMap.put("xHeight", Double.toString(vectorFont.getXHeight2D()));
        linkedHashMap.put("capHeight", Double.toString(vectorFont.getCapHeight2D()));
        return linkedHashMap;
    }

    private static String encodeGlyph(Object object, VectorFontGlyph vectorFontGlyph) throws IOException {
        return XMLUtility.wrap("g", true, object instanceof Integer ? "u" : "n", object.toString(), "w", Integer.toString(vectorFontGlyph.getCharacterWidth()), "d", KpcaxVectorFontExporter.encodeVectorData(vectorFontGlyph.getContours()));
    }

    public static String encodeVectorData(Collection<VectorPath> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (VectorPath vectorPath : collection) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ZZ ");
            }
            stringBuffer.append(vectorPath.toString());
        }
        return stringBuffer.toString();
    }
}

