/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit.importer;

import com.kreative.bitsnpicas.WindingOrder;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.edit.importer.RawImportEncodingList;
import com.kreative.bitsnpicas.importer.ImageBitmapFontImporter;
import com.kreative.unicode.data.NameDatabase;
import com.kreative.unicode.data.NameResolver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ImageBitmapFontImporterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final BufferedImage image;
    private final ImageBitmapFontImporter importer;
    private BufferedImage previewImage = null;
    private Point[] previewPoints = null;
    private final JLabel previewLabel = new JLabel();
    private final RawImportEncodingList eList = new RawImportEncodingList();
    private final EncodingTableModel eTableModel = new EncodingTableModel();
    private final JTable eTable = new JTable(this.eTableModel);
    private final NameDatabase ndb = NameDatabase.instance();

    public ImageBitmapFontImporterPanel(File file) throws IOException {
        this.file = file;
        this.image = ImageIO.read(file);
        this.importer = new ImageBitmapFontImporter();
        this.makeUI();
        this.updatePreview();
    }

    private void makeUI() {
        final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"White", "Black"});
        jComboBox.setEditable(false);
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.importer.startX, 0, this.image.getWidth(), 1);
        final SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(this.importer.startY, 0, this.image.getHeight(), 1);
        final SpinnerNumberModel spinnerNumberModel3 = new SpinnerNumberModel(this.importer.cellWidth, 1, this.image.getWidth(), 1);
        final SpinnerNumberModel spinnerNumberModel4 = new SpinnerNumberModel(this.importer.cellHeight, 1, this.image.getHeight(), 1);
        final SpinnerNumberModel spinnerNumberModel5 = new SpinnerNumberModel(this.importer.ascent, -this.image.getHeight(), this.image.getHeight(), 1);
        final SpinnerNumberModel spinnerNumberModel6 = new SpinnerNumberModel(this.importer.deltaX, 0, this.image.getWidth(), 1);
        final SpinnerNumberModel spinnerNumberModel7 = new SpinnerNumberModel(this.importer.deltaY, 0, this.image.getHeight(), 1);
        final SpinnerNumberModel spinnerNumberModel8 = new SpinnerNumberModel(this.importer.columnCount, 0, this.image.getWidth(), 1);
        final SpinnerNumberModel spinnerNumberModel9 = new SpinnerNumberModel(this.importer.rowCount, 0, this.image.getHeight(), 1);
        final JComboBox<WindingOrder> jComboBox2 = new JComboBox<WindingOrder>(WindingOrder.values());
        jComboBox2.setEditable(false);
        final JCheckBox jCheckBox = new JCheckBox("Invert");
        jCheckBox.setSelected(this.importer.invert);
        final SpinnerNumberModel spinnerNumberModel10 = new SpinnerNumberModel(this.importer.threshold, 0, 255, 1);
        JPanel jPanel = ImageBitmapFontImporterPanel.borderLayout(0, 0, ImageBitmapFontImporterPanel.boxLayout(2, ImageBitmapFontImporterPanel.jSpinner(spinnerNumberModel), new JLabel(" , "), ImageBitmapFontImporterPanel.jSpinner(spinnerNumberModel2)), "Before");
        JPanel jPanel2 = ImageBitmapFontImporterPanel.borderLayout(0, 0, ImageBitmapFontImporterPanel.jSpinner(spinnerNumberModel3), "Before");
        JPanel jPanel3 = ImageBitmapFontImporterPanel.borderLayout(0, 0, ImageBitmapFontImporterPanel.jSpinner(spinnerNumberModel4), "Before");
        JPanel jPanel4 = ImageBitmapFontImporterPanel.borderLayout(0, 0, ImageBitmapFontImporterPanel.jSpinner(spinnerNumberModel5), "Before");
        JPanel jPanel5 = ImageBitmapFontImporterPanel.borderLayout(0, 0, ImageBitmapFontImporterPanel.boxLayout(2, ImageBitmapFontImporterPanel.jSpinner(spinnerNumberModel6), new JLabel(" , "), ImageBitmapFontImporterPanel.jSpinner(spinnerNumberModel7)), "Before");
        JPanel jPanel6 = ImageBitmapFontImporterPanel.borderLayout(0, 0, ImageBitmapFontImporterPanel.jSpinner(spinnerNumberModel8), "Before");
        JPanel jPanel7 = ImageBitmapFontImporterPanel.borderLayout(0, 0, ImageBitmapFontImporterPanel.jSpinner(spinnerNumberModel9), "Before");
        JPanel jPanel8 = ImageBitmapFontImporterPanel.borderLayout(0, 0, ImageBitmapFontImporterPanel.boxLayout(2, ImageBitmapFontImporterPanel.jSpinner(spinnerNumberModel10), new JLabel(" "), jCheckBox), "Before");
        JPanel jPanel9 = ImageBitmapFontImporterPanel.gridLayout(0, 1, 4, 4, new JLabel("Matte:"), new JLabel("Offset:"), new JLabel("Char. Width:"), new JLabel("Char. Height:"), new JLabel("Ascent:"), new JLabel("Spacing:"), new JLabel("Columns:"), new JLabel("Rows:"), new JLabel("Order:"), new JLabel("Threshold:"));
        JPanel jPanel10 = ImageBitmapFontImporterPanel.gridLayout(0, 1, 4, 4, jComboBox, jPanel, jPanel2, jPanel3, jPanel4, jPanel5, jPanel6, jPanel7, jComboBox2, jPanel8);
        JPanel jPanel11 = ImageBitmapFontImporterPanel.borderLayout(8, 8, jPanel9, "Before", jPanel10, "Center");
        JScrollPane jScrollPane = new JScrollPane(this.previewLabel);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        this.previewLabel.setHorizontalAlignment(0);
        this.previewLabel.setVerticalAlignment(0);
        JPanel jPanel12 = ImageBitmapFontImporterPanel.borderLayout(12, 12, jPanel11, "First", jScrollPane, "Center");
        this.eTable.setDefaultRenderer(Point.class, new GlyphCellRenderer());
        ImageBitmapFontImporterPanel.setColumnWidth(this.eTable.getColumnModel().getColumn(1), 80);
        ImageBitmapFontImporterPanel.setColumnWidth(this.eTable.getColumnModel().getColumn(2), 80);
        JScrollPane jScrollPane2 = new JScrollPane(this.eTable);
        JPanel jPanel13 = ImageBitmapFontImporterPanel.borderLayout(8, 8, new JLabel("Encoding:"), "Before", this.eList, "Center");
        JPanel jPanel14 = ImageBitmapFontImporterPanel.borderLayout(4, 4, jPanel13, "First", jScrollPane2, "Center");
        JButton jButton = new JButton("Create");
        JPanel jPanel15 = ImageBitmapFontImporterPanel.flowLayout(jButton);
        JPanel jPanel16 = new JPanel(new BorderLayout(12, 12));
        jPanel16.add((Component)jPanel12, "Before");
        jPanel16.add((Component)jPanel14, "Center");
        jPanel16.add((Component)jPanel15, "Last");
        jPanel16.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.add(jPanel16);
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.matte = jComboBox.getSelectedIndex() - 1;
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.startX = spinnerNumberModel.getNumber().intValue();
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.startY = spinnerNumberModel2.getNumber().intValue();
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.cellWidth = spinnerNumberModel3.getNumber().intValue();
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.cellHeight = spinnerNumberModel4.getNumber().intValue();
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel5.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.ascent = spinnerNumberModel5.getNumber().intValue();
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel6.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.deltaX = spinnerNumberModel6.getNumber().intValue();
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel7.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.deltaY = spinnerNumberModel7.getNumber().intValue();
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel8.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.columnCount = spinnerNumberModel8.getNumber().intValue();
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel9.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.rowCount = spinnerNumberModel9.getNumber().intValue();
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        jComboBox2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.order = (WindingOrder)((Object)jComboBox2.getSelectedItem());
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.invert = jCheckBox.isSelected();
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel10.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.threshold = spinnerNumberModel10.getNumber().intValue();
                ImageBitmapFontImporterPanel.this.updatePreview();
            }
        });
        this.eList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ImageBitmapFontImporterPanel.this.eList.applySelectedEncoding(((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding);
                ImageBitmapFontImporterPanel.this.eTableModel.fireTableRowsUpdated(0, ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.size());
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.openFont(ImageBitmapFontImporterPanel.this.file, null, ImageBitmapFontImporterPanel.this.importer.importFont(ImageBitmapFontImporterPanel.this.image));
            }
        });
    }

    private void updatePreview() {
        int n;
        ImageBitmapFontImporter.PreviewResult previewResult = this.importer.preview(this.image);
        this.previewImage = previewResult.preview;
        this.previewPoints = previewResult.points;
        this.previewLabel.setIcon(new ImageIcon(previewResult.preview));
        List<Integer> list = this.eList.getSelectedEncoding();
        if (this.importer.encoding == null) {
            this.importer.encoding = new ArrayList<Integer>();
        }
        int n2 = previewResult.points.length;
        for (n = this.importer.encoding.size(); n < n2; ++n) {
            this.importer.encoding.add(list != null && n < list.size() ? list.get(n) : -1);
        }
        n = previewResult.points.length;
        for (n2 = this.importer.encoding.size(); n < n2; --n2) {
            this.importer.encoding.remove(n);
        }
        this.eTableModel.fireTableDataChanged();
        this.eTable.setRowHeight(Math.max(16, this.importer.cellHeight + 4));
        ImageBitmapFontImporterPanel.setColumnWidth(this.eTable.getColumnModel().getColumn(0), Math.max(20, this.importer.cellWidth + 8));
    }

    private static JPanel borderLayout(int n, int n2, Component component, String string) {
        JPanel jPanel = new JPanel(new BorderLayout(n, n2));
        jPanel.add(component, string);
        return jPanel;
    }

    private static JPanel borderLayout(int n, int n2, Component component, String string, Component component2, String string2) {
        JPanel jPanel = new JPanel(new BorderLayout(n, n2));
        jPanel.add(component, string);
        jPanel.add(component2, string2);
        return jPanel;
    }

    private static JPanel boxLayout(int n, Component ... componentArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, n));
        for (Component component : componentArray) {
            jPanel.add(component);
        }
        return jPanel;
    }

    private static JPanel flowLayout(Component ... componentArray) {
        JPanel jPanel = new JPanel(new FlowLayout());
        for (Component component : componentArray) {
            jPanel.add(component);
        }
        return jPanel;
    }

    private static JPanel gridLayout(int n, int n2, int n3, int n4, Component ... componentArray) {
        JPanel jPanel = new JPanel(new GridLayout(n, n2, n3, n4));
        for (Component component : componentArray) {
            jPanel.add(component);
        }
        return jPanel;
    }

    private static JSpinner jSpinner(SpinnerNumberModel spinnerNumberModel) {
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        Dimension dimension = jSpinner.getPreferredSize();
        dimension.width = 80;
        jSpinner.setMinimumSize(dimension);
        jSpinner.setPreferredSize(dimension);
        jSpinner.setMaximumSize(dimension);
        return jSpinner;
    }

    private static void setColumnWidth(TableColumn tableColumn, int n) {
        tableColumn.setMinWidth(n);
        tableColumn.setWidth(n);
        tableColumn.setMaxWidth(n);
    }

    private class GlyphCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private GlyphCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel && object instanceof Point) {
                JLabel jLabel = (JLabel)component;
                final Point point = (Point)object;
                jLabel.setText(null);
                jLabel.setIcon(new Icon(){

                    public int getIconHeight() {
                        return ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.cellHeight;
                    }

                    public int getIconWidth() {
                        return ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.cellWidth;
                    }

                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                        graphics.drawImage(ImageBitmapFontImporterPanel.this.previewImage, n, n2, n + ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.cellWidth, n2 + ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.cellHeight, point.x, point.y, point.x + ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.cellWidth, point.y + ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.cellHeight, null);
                    }
                });
            }
            return component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EncodingTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private EncodingTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Point.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Glyph";
                }
                case 1: {
                    return "Code Point";
                }
                case 2: {
                    return "Character";
                }
                case 3: {
                    return "Character Name";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            if (((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding == null) {
                return 0;
            }
            return ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    if (ImageBitmapFontImporterPanel.this.previewPoints == null) {
                        return null;
                    }
                    if (n < ImageBitmapFontImporterPanel.this.previewPoints.length) {
                        return ImageBitmapFontImporterPanel.this.previewPoints[n];
                    }
                    return null;
                }
                case 1: {
                    if (((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding == null) {
                        return null;
                    }
                    if (n < ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.size()) {
                        Integer n3 = ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.get(n);
                        if (n3 == null || n3 < 0) {
                            return null;
                        }
                        String string = Integer.toHexString(n3).toUpperCase();
                        while (string.length() < 4) {
                            string = "0" + string;
                        }
                        return string;
                    }
                    return null;
                }
                case 2: {
                    if (((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding == null) {
                        return null;
                    }
                    if (n < ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.size()) {
                        Integer n4 = ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.get(n);
                        if (n4 == null || n4 < 0) {
                            return null;
                        }
                        return String.valueOf(Character.toChars(n4));
                    }
                    return null;
                }
                case 3: {
                    if (((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding == null) {
                        return null;
                    }
                    if (n < ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.size()) {
                        Integer n5 = ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.get(n);
                        if (n5 == null || n5 < 0) {
                            return null;
                        }
                        return NameResolver.instance(n5).getName(n5);
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 || n2 == 2 || n2 == 3;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 1: {
                    if (((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding == null) {
                        return;
                    }
                    if (n < ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.size()) {
                        if (object == null || object.toString().length() == 0) {
                            ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.set(n, -1);
                            ImageBitmapFontImporterPanel.this.eList.setSelectedIndex(0);
                        } else {
                            try {
                                int n3 = Integer.parseInt(object.toString(), 16);
                                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.set(n, n3);
                                ImageBitmapFontImporterPanel.this.eList.setSelectedIndex(0);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    return;
                }
                case 2: {
                    if (((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding == null) {
                        return;
                    }
                    if (n < ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.size()) {
                        if (object == null || object.toString().length() == 0) {
                            ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.set(n, -1);
                            ImageBitmapFontImporterPanel.this.eList.setSelectedIndex(0);
                        } else {
                            int n4 = object.toString().codePointAt(0);
                            ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.set(n, n4);
                            ImageBitmapFontImporterPanel.this.eList.setSelectedIndex(0);
                        }
                    }
                    return;
                }
                case 3: {
                    if (((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding == null) {
                        return;
                    }
                    if (n < ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.size()) {
                        if (object == null || object.toString().length() == 0) {
                            ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.set(n, -1);
                            ImageBitmapFontImporterPanel.this.eList.setSelectedIndex(0);
                        } else {
                            NameDatabase.NameEntry nameEntry = ImageBitmapFontImporterPanel.this.ndb.find(object.toString());
                            if (nameEntry == null) {
                                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.set(n, -1);
                            } else {
                                ((ImageBitmapFontImporterPanel)ImageBitmapFontImporterPanel.this).importer.encoding.set(n, nameEntry.codePoint);
                            }
                            ImageBitmapFontImporterPanel.this.eList.setSelectedIndex(0);
                        }
                    }
                    return;
                }
            }
            this.fireTableRowsUpdated(n, n);
        }
    }
}

