/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontExporter;
import com.kreative.bitsnpicas.edit.CommonMenuItems;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.edit.SaveChangesDialog;
import com.kreative.bitsnpicas.edit.SaveInterface;
import com.kreative.bitsnpicas.edit.SaveRoutine;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveManager
extends WindowAdapter
implements SaveInterface {
    private JFrame frame;
    private File file;
    private FontExporter<?> format;
    private SaveRoutine routine;
    private Font<?> font;
    private boolean changed;

    public SaveManager(JFrame jFrame, File file, FontExporter<?> fontExporter, Font<?> font) {
        this.frame = jFrame;
        this.file = file;
        this.format = fontExporter;
        this.routine = null;
        this.font = font;
        this.changed = false;
        this.updateWindow();
    }

    public SaveManager(JFrame jFrame, SaveRoutine saveRoutine, Font<?> font) {
        this.frame = jFrame;
        this.file = null;
        this.format = null;
        this.routine = saveRoutine;
        this.font = font;
        this.changed = false;
        this.updateWindow();
    }

    @Override
    public void setChanged() {
        this.changed = true;
        this.updateWindow();
    }

    @Override
    public boolean save() {
        if (this.routine == null) {
            if (this.file == null || this.format == null) {
                return this.saveAs();
            }
            boolean bl = Main.saveFont(this.file, this.format, this.font);
            if (bl) {
                this.changed = false;
            }
            this.updateWindow();
            return bl;
        }
        boolean bl = this.routine.save(this.font);
        if (bl) {
            this.changed = false;
        }
        this.updateWindow();
        return bl;
    }

    @Override
    public boolean saveAs() {
        FontExporter<?> fontExporter = Main.getSaveFormat(this.font);
        if (fontExporter == null) {
            return false;
        }
        String string = Main.getSaveSuffix(this.font);
        if (string == null) {
            return false;
        }
        File file = Main.getSaveFile(string);
        if (file == null) {
            return false;
        }
        this.file = file;
        this.format = fontExporter;
        boolean bl = Main.saveFont(this.file, this.format, this.font);
        if (bl) {
            this.changed = false;
        }
        this.updateWindow();
        return bl;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (!this.changed || this.file == null && this.font.isEmpty()) {
            window.dispose();
        } else {
            switch (new SaveChangesDialog(window, this.font.toString()).showDialog()) {
                case SAVE: {
                    if (!this.save()) break;
                    window.dispose();
                    break;
                }
                case DONT_SAVE: {
                    window.dispose();
                    break;
                }
            }
        }
    }

    private void updateWindow() {
        String string = this.font.toString();
        if (this.file != null) {
            string = string + " from " + this.file.getName();
        }
        if (CommonMenuItems.IS_MAC_OS) {
            this.frame.getRootPane().putClientProperty("Window.documentFile", this.file);
            this.frame.getRootPane().putClientProperty("Window.documentModified", this.changed);
            this.frame.setTitle(string);
        } else {
            if (this.changed) {
                string = string + " \u2022";
            }
            this.frame.setTitle(string);
        }
    }
}

