/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontExporter;
import com.kreative.bitsnpicas.FontImporter;
import com.kreative.bitsnpicas.MacUtility;
import com.kreative.bitsnpicas.VectorFont;
import com.kreative.bitsnpicas.VectorFontExporter;
import com.kreative.bitsnpicas.VectorFontGlyph;
import com.kreative.bitsnpicas.edit.BitmapEditFrame;
import com.kreative.bitsnpicas.edit.BitmapListFrame;
import com.kreative.bitsnpicas.edit.CommonMenuItems;
import com.kreative.bitsnpicas.edit.FontListFrame;
import com.kreative.bitsnpicas.edit.GlyphEditFrame;
import com.kreative.bitsnpicas.edit.GlyphList;
import com.kreative.bitsnpicas.edit.GlyphListFrame;
import com.kreative.bitsnpicas.edit.GlyphLocator;
import com.kreative.bitsnpicas.edit.SaveManager;
import com.kreative.bitsnpicas.edit.SaveRoutine;
import com.kreative.bitsnpicas.edit.importer.ImportFormat;
import com.kreative.bitsnpicas.exporter.KbitxBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.KpcaxVectorFontExporter;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static String lastOpenDirectory = null;
    private static String lastSaveDirectory = null;

    public static void main(String[] stringArray) {
        Object object;
        String[] stringArray2;
        try {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Bits'n'Picas");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringArray2 = Class.class.getMethod("getModule", new Class[0]);
            object = stringArray2.invoke(Toolkit.getDefaultToolkit().getClass(), new Object[0]);
            Object object2 = stringArray2.invoke(Main.class, new Object[0]);
            Class<?> object3 = Class.forName("java.lang.Module");
            Method method = object3.getMethod("addOpens", String.class, object3);
            method.invoke(object, "sun.awt.X11", object2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringArray2 = Toolkit.getDefaultToolkit();
            object = stringArray2.getClass().getDeclaredField("awtAppClassName");
            ((Field)object).setAccessible(true);
            ((Field)object).set(stringArray2, "BitsNPicas");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CommonMenuItems.IS_MAC_OS) {
            try {
                Class.forName("com.kreative.bitsnpicas.edit.mac.MacDummyWindow").newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (stringArray.length == 0) {
            Main.newBitmapFont();
        } else {
            for (String string : stringArray) {
                Main.openFonts(new File(string));
            }
        }
        if (CommonMenuItems.IS_MAC_OS) {
            try {
                Class.forName("com.kreative.bitsnpicas.edit.mac.MyApplicationListener").newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static JFrame newBitmapFont() {
        BitmapFont bitmapFont = new BitmapFont(14, 2, 14, 2, 0, 0, 0);
        bitmapFont.autoFillNames();
        return Main.openFont(null, new KbitxBitmapFontExporter(), bitmapFont);
    }

    public static JFrame newVectorFont() {
        VectorFont vectorFont = new VectorFont(800.0, 200.0, 800.0, 200.0, 0.0, 0.0, 0.0);
        vectorFont.autoFillNames();
        return Main.openFont(null, new KpcaxVectorFontExporter(), vectorFont);
    }

    public static JFrame openFonts() {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, "Open", 0);
        if (lastOpenDirectory != null) {
            fileDialog.setDirectory(lastOpenDirectory);
        }
        fileDialog.setVisible(true);
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        fileDialog.dispose();
        frame.dispose();
        if (string == null || string2 == null) {
            return null;
        }
        lastOpenDirectory = string;
        File file = new File(lastOpenDirectory, string2);
        return Main.openFonts(file);
    }

    public static JFrame openFonts(File file) {
        try {
            ImportFormat importFormat = ImportFormat.forFile(file);
            if (importFormat != null) {
                Object object;
                FontImporter<?> fontImporter;
                if (importFormat.macResFork) {
                    file = MacUtility.getResourceFork(file);
                }
                if ((fontImporter = importFormat.createImporter()) != null && (object = fontImporter.importFont(file)) != null && ((Font[])object).length > 0) {
                    return Main.openFonts(file, importFormat.createExporter(), object);
                }
                object = importFormat.createOptionFrame(file);
                if (object != null) {
                    ((Window)object).setVisible(true);
                    return object;
                }
                JOptionPane.showMessageDialog(null, "The selected file did not contain any fonts.", "Open", 0);
                return null;
            }
            JOptionPane.showMessageDialog(null, "The selected file was not recognized as a font file readable by Bits'n'Picas.", "Open", 0);
            return null;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "An error occurred while reading the selected file.", "Open", 0);
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            JOptionPane.showMessageDialog(null, "The selected file requires KSFL, but KSFL is not in the classpath.", "Open", 0);
            return null;
        }
    }

    public static JFrame openFonts(File file, FontExporter<?> fontExporter, Font<?>[] fontArray) {
        if (fontArray.length > 1) {
            FontListFrame fontListFrame = new FontListFrame(file, fontExporter, fontArray);
            fontListFrame.setVisible(true);
            return fontListFrame;
        }
        if (fontArray.length > 0) {
            return Main.openFont(file, fontExporter, fontArray[0]);
        }
        JOptionPane.showMessageDialog(null, "The selected file did not contain any fonts.", "Open", 0);
        return null;
    }

    public static JFrame openFont(File file, FontExporter<?> fontExporter, Font<?> font) {
        if (font instanceof BitmapFont) {
            BitmapFontExporter bitmapFontExporter = (BitmapFontExporter)fontExporter;
            BitmapFont bitmapFont = (BitmapFont)font;
            BitmapListFrame bitmapListFrame = new BitmapListFrame(file, bitmapFontExporter, bitmapFont);
            bitmapListFrame.setVisible(true);
            return bitmapListFrame;
        }
        if (font instanceof VectorFont) {
            VectorFontExporter vectorFontExporter = (VectorFontExporter)fontExporter;
            VectorFont vectorFont = (VectorFont)font;
            GlyphListFrame<VectorFontGlyph> glyphListFrame = new GlyphListFrame<VectorFontGlyph>(file, vectorFontExporter, vectorFont);
            glyphListFrame.setVisible(true);
            return glyphListFrame;
        }
        JOptionPane.showMessageDialog(null, "The selected font was not recognized by the Bits'n'Picas editor.", "Open", 0);
        return null;
    }

    public static JFrame openFont(SaveRoutine saveRoutine, Font<?> font) {
        if (font instanceof BitmapFont) {
            BitmapFont bitmapFont = (BitmapFont)font;
            BitmapListFrame bitmapListFrame = new BitmapListFrame(saveRoutine, bitmapFont);
            bitmapListFrame.setVisible(true);
            return bitmapListFrame;
        }
        if (font instanceof VectorFont) {
            VectorFont vectorFont = (VectorFont)font;
            GlyphListFrame<VectorFontGlyph> glyphListFrame = new GlyphListFrame<VectorFontGlyph>(saveRoutine, vectorFont);
            glyphListFrame.setVisible(true);
            return glyphListFrame;
        }
        JOptionPane.showMessageDialog(null, "The selected font was not recognized by the Bits'n'Picas editor.", "Open", 0);
        return null;
    }

    public static JFrame openGlyph(Font<?> font, GlyphLocator<?> glyphLocator, GlyphList<?> glyphList, SaveManager saveManager) {
        if (font instanceof BitmapFont) {
            BitmapFont bitmapFont = (BitmapFont)font;
            GlyphLocator<BitmapFontGlyph> glyphLocator2 = glyphLocator;
            GlyphList<BitmapFontGlyph> glyphList2 = glyphList;
            if (glyphLocator2.getGlyph() == null) {
                glyphLocator2.setGlyph(new BitmapFontGlyph());
                glyphList2.glyphRepertoireChanged();
            }
            BitmapEditFrame bitmapEditFrame = new BitmapEditFrame(bitmapFont, glyphLocator2, glyphList2, saveManager);
            bitmapEditFrame.setVisible(true);
            return bitmapEditFrame;
        }
        if (font instanceof VectorFont) {
            VectorFont vectorFont = (VectorFont)font;
            GlyphLocator<BitmapFontGlyph> glyphLocator3 = glyphLocator;
            GlyphList<BitmapFontGlyph> glyphList3 = glyphList;
            if (glyphLocator3.getGlyph() == null) {
                glyphLocator3.setGlyph((BitmapFontGlyph)((Object)new VectorFontGlyph()));
                glyphList3.glyphRepertoireChanged();
            }
            GlyphEditFrame<BitmapFontGlyph> glyphEditFrame = new GlyphEditFrame<BitmapFontGlyph>(VectorFontGlyph.class, vectorFont, glyphLocator3, glyphList3, saveManager);
            glyphEditFrame.setVisible(true);
            return glyphEditFrame;
        }
        JOptionPane.showMessageDialog(null, "The selected font was not recognized by the Bits'n'Picas editor.", "Open", 0);
        return null;
    }

    public static String getSaveSuffix(Font<?> font) {
        if (font instanceof BitmapFont) {
            return ".kbitx";
        }
        if (font instanceof VectorFont) {
            return ".kpcax";
        }
        return null;
    }

    public static File getSaveFile(String string) {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, "Save", 1);
        if (lastSaveDirectory != null) {
            fileDialog.setDirectory(lastSaveDirectory);
        }
        fileDialog.setVisible(true);
        String string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        fileDialog.dispose();
        frame.dispose();
        if (string2 == null || string3 == null) {
            return null;
        }
        if (!string3.toLowerCase().endsWith(string.toLowerCase())) {
            string3 = string3 + string;
        }
        lastSaveDirectory = string2;
        return new File(lastSaveDirectory, string3);
    }

    public static FontExporter<?> getSaveFormat(Font<?> font) {
        if (font instanceof BitmapFont) {
            return new KbitxBitmapFontExporter();
        }
        if (font instanceof VectorFont) {
            return new KpcaxVectorFontExporter();
        }
        return null;
    }

    public static boolean saveFont(File file, FontExporter<?> fontExporter, Font<?> font) {
        if (font instanceof BitmapFont) {
            BitmapFontExporter bitmapFontExporter = (BitmapFontExporter)fontExporter;
            BitmapFont bitmapFont = (BitmapFont)font;
            bitmapFont.contractGlyphs();
            try {
                bitmapFontExporter.exportFontToFile(bitmapFont, file);
                return true;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "An error occurred while saving this file.", "Save", 0);
                return false;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                JOptionPane.showMessageDialog(null, "The selected format requires KSFL, but KSFL is not in the classpath.", "Save", 0);
                return false;
            }
        }
        if (font instanceof VectorFont) {
            VectorFontExporter vectorFontExporter = (VectorFontExporter)fontExporter;
            VectorFont vectorFont = (VectorFont)font;
            try {
                vectorFontExporter.exportFontToFile(vectorFont, file);
                return true;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "An error occurred while saving this file.", "Save", 0);
                return false;
            }
        }
        JOptionPane.showMessageDialog(null, "An error occurred while saving this file.", "Save", 0);
        return false;
    }
}

