/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WIBOutputStream
extends OutputStream {
    private final OutputStream out;
    private ByteArrayOutputStream dataRun = new ByteArrayOutputStream();
    private int rleCount = 0;
    private int rleData = 0;

    public WIBOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void write(int n) throws IOException {
        n &= 0xFF;
        if (this.rleCount < 1) {
            this.rleCount = 1;
            this.rleData = n;
        } else if (this.rleData == n) {
            ++this.rleCount;
        } else if (this.rleCount == 1) {
            this.dataRun.write(this.rleData);
            this.rleData = n;
        } else {
            this.writeRuns();
            this.rleCount = 1;
            this.rleData = n;
        }
    }

    public void finish() throws IOException {
        if (this.rleCount == 1) {
            this.dataRun.write(this.rleData);
            this.rleCount = 0;
        }
        this.writeRuns();
    }

    private void writeRuns() throws IOException {
        int n;
        int n2;
        byte[] byArray = this.dataRun.toByteArray();
        int n3 = byArray.length;
        if (n3 > 0) {
            n2 = 0;
            while (n3 >= 992) {
                this.out.write(255);
                this.out.write(byArray, n2, 992);
                n2 += 992;
                n3 -= 992;
            }
            if (n3 >= 32) {
                n = n3 >> 5;
                this.out.write(0xE0 | n);
                this.out.write(byArray, n2, n <<= 5);
                n2 += n;
                n3 -= n;
            }
            if (n3 > 1) {
                this.out.write(0xC0 | n3);
                this.out.write(byArray, n2, n3);
            }
            if (n3 == 1) {
                switch (byArray[n2]) {
                    case 0: {
                        this.out.write(1);
                        break;
                    }
                    case -1: {
                        this.out.write(65);
                        break;
                    }
                    default: {
                        this.out.write(129);
                        this.out.write(byArray[n2]);
                    }
                }
            }
            this.dataRun = new ByteArrayOutputStream();
        }
        if (this.rleCount > 0) {
            n2 = this.rleData == 0 ? 0 : (this.rleData == 255 ? 64 : 128);
            int n4 = n = this.rleData != 0 && this.rleData != 255 ? 1 : 0;
            while (this.rleCount >= 992) {
                this.out.write(n2 | 0x3F);
                if (n != 0) {
                    this.out.write(this.rleData);
                }
                this.rleCount -= 992;
            }
            if (this.rleCount >= 32) {
                int n5 = this.rleCount >> 5;
                this.out.write(n2 | 0x20 | n5);
                n5 <<= 5;
                if (n != 0) {
                    this.out.write(this.rleData);
                }
                this.rleCount -= n5;
            }
            if (this.rleCount > 0) {
                this.out.write(n2 | this.rleCount);
                if (n != 0) {
                    this.out.write(this.rleData);
                }
                this.rleCount = 0;
            }
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }
}

