/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class PathGraph
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -9041484459040713072L;
    private HashMap<ImmutablePoint, HashSet<ImmutablePoint>> graph = new HashMap();

    public PathGraph() {
    }

    public PathGraph(PathGraph pathGraph) {
        for (Map.Entry<ImmutablePoint, HashSet<ImmutablePoint>> entry : pathGraph.graph.entrySet()) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(entry.getValue());
            this.graph.put(entry.getKey(), hashSet);
        }
    }

    public void plot(int n, int n2, int n3) {
        ImmutablePoint immutablePoint = new ImmutablePoint(n2 * n, n3 * n);
        ImmutablePoint immutablePoint2 = new ImmutablePoint(n2 * n, n3 * n + n);
        ImmutablePoint immutablePoint3 = new ImmutablePoint(n2 * n + n, n3 * n + n);
        ImmutablePoint immutablePoint4 = new ImmutablePoint(n2 * n + n, n3 * n);
        this.add(immutablePoint, immutablePoint2);
        this.add(immutablePoint2, immutablePoint3);
        this.add(immutablePoint3, immutablePoint4);
        this.add(immutablePoint4, immutablePoint);
    }

    public void plot(int n, ImmutablePoint immutablePoint) {
        this.plot(n, immutablePoint.x, immutablePoint.y);
    }

    public void plot(int n, Point point) {
        this.plot(n, point.x, point.y);
    }

    public void plot(int n, int n2, int n3, int n4) {
        ImmutablePoint immutablePoint = new ImmutablePoint(n3 * n, n4 * n2);
        ImmutablePoint immutablePoint2 = new ImmutablePoint(n3 * n, n4 * n2 + n2);
        ImmutablePoint immutablePoint3 = new ImmutablePoint(n3 * n + n, n4 * n2 + n2);
        ImmutablePoint immutablePoint4 = new ImmutablePoint(n3 * n + n, n4 * n2);
        this.add(immutablePoint, immutablePoint2);
        this.add(immutablePoint2, immutablePoint3);
        this.add(immutablePoint3, immutablePoint4);
        this.add(immutablePoint4, immutablePoint);
    }

    public void plot(int n, int n2, ImmutablePoint immutablePoint) {
        this.plot(n, n2, immutablePoint.x, immutablePoint.y);
    }

    public void plot(int n, int n2, Point point) {
        this.plot(n, n2, point.x, point.y);
    }

    public void removeOverlap() {
        Iterator<ImmutablePoint> iterator = this.graph.keySet().iterator();
        block0: while (iterator.hasNext()) {
            ImmutablePoint immutablePoint = iterator.next();
            for (ImmutablePoint immutablePoint2 : this.graph.get(immutablePoint)) {
                if (!this.contains(immutablePoint2, immutablePoint)) continue;
                this.remove(immutablePoint, immutablePoint2);
                this.remove(immutablePoint2, immutablePoint);
                iterator = this.graph.keySet().iterator();
                continue block0;
            }
        }
    }

    public void simplifyPaths() {
        Iterator<ImmutablePoint> iterator = this.graph.keySet().iterator();
        block0: while (iterator.hasNext()) {
            ImmutablePoint immutablePoint = iterator.next();
            for (ImmutablePoint immutablePoint2 : this.graph.get(immutablePoint)) {
                int n = PathGraph.signum(immutablePoint2.y - immutablePoint.y);
                int n2 = PathGraph.signum(immutablePoint2.x - immutablePoint.x);
                ImmutablePoint immutablePoint3 = immutablePoint2;
                boolean bl = false;
                while (!bl) {
                    ImmutablePoint[] immutablePointArray;
                    bl = true;
                    for (ImmutablePoint immutablePoint4 : immutablePointArray = this.getAdjPoints(immutablePoint3)) {
                        int n3 = PathGraph.signum(immutablePoint4.y - immutablePoint3.y);
                        int n4 = PathGraph.signum(immutablePoint4.x - immutablePoint3.x);
                        if (n3 != n || n4 != n2) continue;
                        this.remove(immutablePoint3, immutablePoint4);
                        immutablePoint3 = immutablePoint4;
                        bl = false;
                    }
                }
                if (immutablePoint3 == immutablePoint2) continue;
                this.remove(immutablePoint, immutablePoint2);
                this.add(immutablePoint, immutablePoint3);
                iterator = this.graph.keySet().iterator();
                continue block0;
            }
        }
    }

    public Rectangle getBoundingRect() {
        ImmutablePoint[] immutablePointArray = this.getAllPoints();
        if (immutablePointArray.length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n = immutablePointArray[0].x;
        int n2 = immutablePointArray[0].y;
        int n3 = immutablePointArray[0].x;
        int n4 = immutablePointArray[0].y;
        for (ImmutablePoint immutablePoint : immutablePointArray) {
            if (immutablePoint.x < n) {
                n = immutablePoint.x;
            }
            if (immutablePoint.y < n2) {
                n2 = immutablePoint.y;
            }
            if (immutablePoint.x > n3) {
                n3 = immutablePoint.x;
            }
            if (immutablePoint.y <= n4) continue;
            n4 = immutablePoint.y;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public ImmutablePoint[][] getContours() {
        ImmutablePoint[] immutablePointArray;
        Vector vector = new Vector();
        PathGraph pathGraph = new PathGraph(this);
        while (!pathGraph.isEmpty()) {
            for (ImmutablePoint immutablePoint : immutablePointArray = pathGraph.getAllPoints()) {
                ImmutablePoint[] immutablePointArray2;
                if (!pathGraph.graph.containsKey(immutablePoint) || pathGraph.graph.get(immutablePoint).isEmpty()) continue;
                Vector<ImmutablePoint> vector2 = new Vector<ImmutablePoint>();
                int n = 0;
                int n2 = 0;
                ImmutablePoint immutablePoint2 = immutablePoint;
                vector2.add(immutablePoint2);
                while ((immutablePointArray2 = pathGraph.getAdjPoints(immutablePoint2)) != null && immutablePointArray2.length >= 1) {
                    ImmutablePoint immutablePoint3 = null;
                    if (n == 0 && n2 == 0) {
                        immutablePoint3 = immutablePointArray2[0];
                    } else {
                        int n3;
                        int n4;
                        for (ImmutablePoint immutablePoint4 : immutablePointArray2) {
                            n4 = PathGraph.signum(immutablePoint4.y - immutablePoint2.y);
                            n3 = PathGraph.signum(immutablePoint4.x - immutablePoint2.x);
                            if (n4 != -n || n3 != n2 || immutablePoint4.equals(immutablePoint2)) continue;
                            immutablePoint3 = immutablePoint4;
                            break;
                        }
                        if (immutablePoint3 == null) {
                            for (ImmutablePoint immutablePoint4 : immutablePointArray2) {
                                n4 = PathGraph.signum(immutablePoint4.y - immutablePoint2.y);
                                n3 = PathGraph.signum(immutablePoint4.x - immutablePoint2.x);
                                if (n4 != n2 || n3 != n || immutablePoint4.equals(immutablePoint2)) continue;
                                immutablePoint3 = immutablePoint4;
                                break;
                            }
                        }
                        if (immutablePoint3 == null) {
                            for (ImmutablePoint immutablePoint4 : immutablePointArray2) {
                                n4 = PathGraph.signum(immutablePoint4.y - immutablePoint2.y);
                                n3 = PathGraph.signum(immutablePoint4.x - immutablePoint2.x);
                                if (n4 != n || n3 != -n2 || immutablePoint4.equals(immutablePoint2)) continue;
                                immutablePoint3 = immutablePoint4;
                                break;
                            }
                        }
                        if (immutablePoint3 == null) {
                            for (ImmutablePoint immutablePoint4 : immutablePointArray2) {
                                if (immutablePoint4.equals(immutablePoint2)) continue;
                                immutablePoint3 = immutablePoint4;
                                break;
                            }
                        }
                        if (immutablePoint3 == null) break;
                    }
                    vector2.add(immutablePoint3);
                    pathGraph.remove(immutablePoint2, immutablePoint3);
                    if (immutablePoint.equals(immutablePoint3)) break;
                    n2 = PathGraph.signum(immutablePoint3.y - immutablePoint2.y);
                    n = PathGraph.signum(immutablePoint3.x - immutablePoint2.x);
                    immutablePoint2 = immutablePoint3;
                }
                if (vector2.isEmpty()) continue;
                vector.add(vector2);
            }
        }
        immutablePointArray = new ImmutablePoint[vector.size()][];
        for (int i = 0; i < vector.size(); ++i) {
            immutablePointArray[i] = ((Vector)vector.get(i)).toArray(new ImmutablePoint[0]);
        }
        return immutablePointArray;
    }

    public byte[] getGlyfData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Rectangle rectangle = this.getBoundingRect();
        ImmutablePoint[][] immutablePointArray = this.getContours();
        int[] nArray = new int[immutablePointArray.length];
        Vector<ImmutablePoint> vector = new Vector<ImmutablePoint>();
        for (int i = 0; i < immutablePointArray.length; ++i) {
            ImmutablePoint immutablePoint;
            ImmutablePoint immutablePoint2 = immutablePointArray[i][0];
            vector.add(immutablePoint2);
            for (int j = 1; j < immutablePointArray[i].length && !(immutablePoint = immutablePointArray[i][j]).equals(immutablePoint2); ++j) {
                vector.add(immutablePoint);
            }
            nArray[i] = vector.size() - 1;
        }
        try {
            int n;
            dataOutputStream.writeShort(immutablePointArray.length);
            dataOutputStream.writeShort(rectangle.x);
            dataOutputStream.writeShort(rectangle.y);
            dataOutputStream.writeShort(rectangle.x + rectangle.width);
            dataOutputStream.writeShort(rectangle.y + rectangle.height);
            for (int n2 : nArray) {
                dataOutputStream.writeShort(n2);
            }
            dataOutputStream.writeShort(0);
            for (n = vector.size(); n >= 256; n -= 256) {
                dataOutputStream.writeByte(9);
                dataOutputStream.writeByte(255);
            }
            if (n > 1) {
                dataOutputStream.writeByte(9);
                dataOutputStream.writeByte(n - 1);
            } else if (n == 1) {
                dataOutputStream.writeByte(1);
            }
            int n3 = 0;
            for (ImmutablePoint immutablePoint : vector) {
                dataOutputStream.writeShort(immutablePoint.x - n3);
                n3 = immutablePoint.x;
            }
            n3 = 0;
            for (ImmutablePoint immutablePoint : vector) {
                dataOutputStream.writeShort(immutablePoint.y - n3);
                n3 = immutablePoint.y;
            }
            while ((byteArrayOutputStream.size() & 3) != 0) {
                dataOutputStream.writeByte(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void add(int n, int n2, int n3, int n4) {
        this.add(new ImmutablePoint(n, n2), new ImmutablePoint(n3, n4));
    }

    public void add(ImmutablePoint immutablePoint, ImmutablePoint immutablePoint2) {
        if (this.graph.containsKey(immutablePoint)) {
            this.graph.get(immutablePoint).add(immutablePoint2);
        } else {
            HashSet<ImmutablePoint> hashSet = new HashSet<ImmutablePoint>();
            hashSet.add(immutablePoint2);
            this.graph.put(immutablePoint, hashSet);
        }
    }

    public void add(PathEdge pathEdge) {
        this.add(pathEdge.src, pathEdge.dst);
    }

    public void clear() {
        this.graph.clear();
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        return this.contains(new ImmutablePoint(n, n2), new ImmutablePoint(n3, n4));
    }

    public boolean contains(ImmutablePoint immutablePoint, ImmutablePoint immutablePoint2) {
        return this.graph.containsKey(immutablePoint) && this.graph.get(immutablePoint).contains(immutablePoint2);
    }

    public boolean contains(PathEdge pathEdge) {
        return this.contains(pathEdge.src, pathEdge.dst);
    }

    public ImmutablePoint[] getSrcPoints() {
        return this.graph.keySet().toArray(new ImmutablePoint[0]);
    }

    public ImmutablePoint[] getAllPoints() {
        HashSet<ImmutablePoint> hashSet = new HashSet<ImmutablePoint>();
        hashSet.addAll(this.graph.keySet());
        for (HashSet<ImmutablePoint> hashSet2 : this.graph.values()) {
            hashSet.addAll(hashSet2);
        }
        return hashSet.toArray(new ImmutablePoint[0]);
    }

    public ImmutablePoint[] getAdjPoints(ImmutablePoint immutablePoint) {
        if (this.graph.containsKey(immutablePoint)) {
            return this.graph.get(immutablePoint).toArray(new ImmutablePoint[0]);
        }
        return new ImmutablePoint[0];
    }

    public PathEdge[] getAllEdges() {
        HashSet<PathEdge> hashSet = new HashSet<PathEdge>();
        for (Map.Entry<ImmutablePoint, HashSet<ImmutablePoint>> entry : this.graph.entrySet()) {
            ImmutablePoint immutablePoint = entry.getKey();
            for (ImmutablePoint immutablePoint2 : entry.getValue()) {
                hashSet.add(new PathEdge(immutablePoint, immutablePoint2));
            }
        }
        return hashSet.toArray(new PathEdge[0]);
    }

    public PathEdge[] getAdjEdges(ImmutablePoint immutablePoint) {
        HashSet<PathEdge> hashSet = new HashSet<PathEdge>();
        if (this.graph.containsKey(immutablePoint)) {
            for (ImmutablePoint immutablePoint2 : this.graph.get(immutablePoint)) {
                hashSet.add(new PathEdge(immutablePoint, immutablePoint2));
            }
        }
        return hashSet.toArray(new PathEdge[0]);
    }

    public boolean isEmpty() {
        if (!this.graph.isEmpty()) {
            for (HashSet<ImmutablePoint> hashSet : this.graph.values()) {
                if (hashSet.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public void remove(int n, int n2, int n3, int n4) {
        this.remove(new ImmutablePoint(n, n2), new ImmutablePoint(n3, n4));
    }

    public void remove(ImmutablePoint immutablePoint, ImmutablePoint immutablePoint2) {
        if (this.graph.containsKey(immutablePoint)) {
            this.graph.get(immutablePoint).remove(immutablePoint2);
            if (this.graph.get(immutablePoint).size() < 1) {
                this.graph.remove(immutablePoint);
            }
        }
    }

    public void remove(PathEdge pathEdge) {
        this.remove(pathEdge.src, pathEdge.dst);
    }

    public boolean equals(Object object) {
        if (object instanceof PathGraph) {
            return this.graph.equals(((PathGraph)object).graph);
        }
        return this.graph.equals(object);
    }

    public int hashCode() {
        return this.graph.hashCode();
    }

    public String toString() {
        return this.graph.toString();
    }

    private static int signum(int n) {
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public static class PathEdge
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = -7710603668134471572L;
        private ImmutablePoint src;
        private ImmutablePoint dst;

        public PathEdge(ImmutablePoint immutablePoint, ImmutablePoint immutablePoint2) {
            this.src = immutablePoint;
            this.dst = immutablePoint2;
        }

        public ImmutablePoint getSrc() {
            return this.src;
        }

        public ImmutablePoint getDst() {
            return this.dst;
        }

        public PathEdge getReflection() {
            return new PathEdge(this.dst, this.src);
        }

        public boolean equals(Object object) {
            if (object instanceof PathEdge) {
                PathEdge pathEdge = (PathEdge)object;
                return this.src.equals(pathEdge.src) && this.dst.equals(pathEdge.dst);
            }
            return false;
        }

        public int hashCode() {
            return this.src.hashCode() ^ Integer.reverse(this.dst.hashCode());
        }

        public String toString() {
            return this.src.toString() + " -> " + this.dst.toString();
        }
    }

    public static class ImmutablePoint
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = -274454806715511788L;
        private int x;
        private int y;

        public ImmutablePoint(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public ImmutablePoint(ImmutablePoint immutablePoint) {
            this.x = immutablePoint.x;
            this.y = immutablePoint.y;
        }

        public ImmutablePoint(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Point getPoint() {
            return new Point(this.x, this.y);
        }

        public boolean equals(Object object) {
            if (object instanceof ImmutablePoint) {
                ImmutablePoint immutablePoint = (ImmutablePoint)object;
                return this.x == immutablePoint.x && this.y == immutablePoint.y;
            }
            if (object instanceof Point) {
                Point point = (Point)object;
                return this.x == point.x && this.y == point.y;
            }
            return false;
        }

        public int hashCode() {
            return this.x ^ Integer.reverseBytes(this.y);
        }

        public String toString() {
            return this.x + "," + this.y;
        }
    }
}

