/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import com.kreative.bitsnpicas.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IDGenerator {
    public abstract void setRange(int var1, int var2);

    public abstract int generateID(Font<?> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HashCode
    extends IDGenerator {
        private int min;
        private int max;

        public HashCode(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        @Override
        public void setRange(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        @Override
        public int generateID(Font<?> font) {
            int n = font.getName(1).hashCode() >>> 1;
            return n % (this.max - this.min) + this.min;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Random
    extends IDGenerator {
        private java.util.Random random = new java.util.Random();
        private int min;
        private int max;

        public Random(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        @Override
        public void setRange(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        @Override
        public int generateID(Font<?> font) {
            return this.random.nextInt(this.max - this.min) + this.min;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Sequential
    extends IDGenerator {
        private int id;
        private int min;
        private int max;

        public Sequential(int n, int n2, int n3) {
            this.id = n;
            this.min = n2;
            this.max = n3;
        }

        @Override
        public void setRange(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        @Override
        public int generateID(Font<?> font) {
            int n = this.id++;
            if (this.id >= this.max) {
                this.id = this.min;
            }
            return n;
        }
    }
}

