#!/bin/sh
# Ultra primitive config generator. Improvements (like parsing .desktop files or
# a proper implementation of the XDG icon convention) highly welcome.

gen_button () # $1 -> bin, $2 -> icon
{
	[ -z "${1}" ] && return;
	[ -z "${2}" ] && return;

	cat << EOF | sed "s|@icon@|${2}|g" | sed "s|@bin@|${1}|g"
	button
	{
		image-path          = "@icon@";
		command[mouse-left] = "@bin@";
	}

EOF
}

# Let's start by blurping out the configuration boilerplate
cat << EOF
# Autogenerated example config file.
# It uses a very rough and naive method for finding icons,
# so don't be surprised if those come out a bit weird.
# For details regarding the configuration please read lavalauncher(1)

global-settings
{
	watch-config-file = false;
}

bar
{
	alignment               = center;
	background-colour       = "#202020";
	border                  = 1 1 1 1;
	cursor-name             = pointer;
	exclusive-zone          = true;
	hidden-mode             = never;
	hidden-size             = 10;
	icon-padding            = 4;
	indicator-active-colour = "#606060";
	indicator-hover-colour  = "#606060";
	indicator-padding       = 0;
	indicator-style         = rounded-rectangle;
	layer                   = top;
	margin                  = 0;
	mode                    = default;
	namespace               = LavaLauncher;
	position                = bottom;
	radius                  = 5;
	size                    = 60;

	condition-resolution = wider-than-high;
	condition-scale      = all;
	condition-transform  = all;

	config
	{
		condition-resolution = higher-than-wide;
		radius               = 0;
		mode                 = full;
	}

EOF

# Now how about a terminal?
ICON="$(find /usr/share/icons/ -type f -name *term* | head -1)"
BIN="$(which alacritty foot xterm terminator gnome-terminal 2> /dev/null | head -1)"
gen_button "$BIN" "$ICON"

# Now how about a browser?
ICON="$(find /usr/share/icons/ -type f -name *web* | head -1)"
BIN="$(which firefox iceweasel chromium chrome 2> /dev/null | head -1)"
gen_button "$BIN" "$ICON"

# Now how about an editor?
ICON="$(find /usr/share/icons/ -type f -name *edit* | head -1)"
BIN="$(which emacs acme kate gedit mousepad 2> /dev/null | head -1)"
gen_button "$BIN" "$ICON"

# Now how about a filemanager?
ICON="$(find /usr/share/icons/ -type f -name *dire* | head -1)"
BIN="$(which nautilus nemo thunar pcmanfm 2> /dev/null | head -1)"
gen_button "$BIN" "$ICON"

# Now how about audio configuration?
ICON="$(find /usr/share/icons/ -type f -name *audio* | head -1)"
BIN="$(which pavucontrol 2> /dev/null | head -1)"
gen_button "$BIN" "$ICON"

# Now how about general configuration?
ICON="$(find /usr/share/icons/ -type f -name *conf* | head -1)"
BIN="$(which lxappearance dconf-editor 2> /dev/null | head -1)"
gen_button "$BIN" "$ICON"

# Now how about some games?
ICON="$(find /usr/share/icons/ -type f -name *gam* | head -1)"
BIN="$(which wesnoth supertuxkart gnome-mines gnome-chess 2> /dev/null | head -1)"
gen_button "$BIN" "$ICON"

# Now how about that one disk utility?
ICON="$(find /usr/share/icons/ -type f -name *disk* | head -1)"
BIN="$(which gnome-disks baobab 2> /dev/null | head -1)"
gen_button "$BIN" "$ICON"

# And let's end it here
echo "}"

