/*
    Falling Block Game
    Copyright (C) 1999-2002 Jared Krinke <http://derajdezine.vze.com/>


    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    This application is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this distribution; if not, write to:
    Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA02111-1307  USA

    Jared Krinke

    Deraj DeZine
    http://derajdezine.vze.com/
*/

#include "fbg.h"
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <SDL/SDL.h>
#include <iostream>
#include <string.h>
#include <string>
using namespace std;

// Default to fullscreen since Windows is bad about handling color depth
#ifdef WIN32
#define	FBG_DEFAULT_FULLSCREEN	true
#define FBG_DEFAULT_BPP	32
#else
#define	FBG_DEFAULT_FULLSCREEN	false
#define FBG_DEFAULT_BPP	-1
#endif

int main(int argc, char** argv) {
	bool fullscreen=FBG_DEFAULT_FULLSCREEN;
	int width=640;
	int height=480;
	int bpp=FBG_DEFAULT_BPP;
	int startLevel=0;
	int btype=-1;
	bool light=false;
	string prefix = "./";
	string theme = "";
	string music = "typea.it";

	// Parse command lines options
	cout << "Falling Block Game v" << VERSION << endl;
	cout << "http://derajdezine.vze.com/" << endl;
	for (int cur=1; cur < argc; cur++) {
		if (!strcmp(argv[cur], "-h") || !strcmp(argv[cur], "--help")) {
			cout << "Gameplay options" << endl;
			cout << "\t-l LEVEL\t" << "Start on specified level (0-9)" << endl;
			cout << "\t-b HEIGHT\t" << "B-Type garbage height (0-5)" << endl;
			cout << endl;
			cout << "Graphics options" << endl;
			cout << "\t-t THEME\t" << "Name of theme directory" << endl;
			cout << "\t--light\t" << "Run in \"light\" mode (uses very little CPU)" << endl;
			cout << "\t-f\t" << "Run in fullscreen mode" << endl;
			cout << "\t-w\t" << "Run in windowed mode" << endl;
			cout << "\t-r WxH\t" << "Run with specified resolution (ex. \"640x480\")" << endl;
			cout << "\t-d BPP\t" << "Run with specified bits per pixel (ex. 24)" << endl;
			cout << "\t-p PREFIX\t" << "Prefix to FBG directory (ex. \"./\")" << endl;
			cout << endl;
			cout << "Other options" << endl;
			cout << "\t-m\t" << "Play specified music" << endl;
			cout << "\t--no-music\t" << "Do not play music" << endl;
			exit(0);
		}
		else if (!strcmp(argv[cur], "-f")) {
			fullscreen = true;
		}
		else if (!strcmp(argv[cur], "-w")) {
			fullscreen = false;
		}
		else if (!strcmp(argv[cur], "-t")) {
			theme = argv[++cur];
		}
		else if (!strcmp(argv[cur], "--light")) {
			light = true;
		}
		else if (!strcmp(argv[cur], "-r")) {
			cur++;
			int firstX;
			for (firstX = 0; argv[cur][firstX] != 'x' && argv[cur][firstX] != 'X' && argv[cur][firstX] != '\0'; firstX++);
			argv[cur][firstX] = '\0';
			width = atoi(argv[cur]);
			height = width*3/4;
			if (atoi(&argv[cur][firstX+1]) != height) {
				cout << "ERROR:\tInvalid aspect ratio" << endl;
				exit(0);
			}
		}
		else if (!strcmp(argv[cur], "-d")) {
			bpp = atoi(argv[++cur]);
		}
		else if (!strcmp(argv[cur], "-l")) {
			startLevel = atoi(argv[++cur]);
			if (startLevel < 0 || startLevel > 9) {
				cout << "ERROR:\tStarting level must be 0-9" << endl;
				exit(0);
			}
		}
		else if (!strcmp(argv[cur], "-b")) {
			btype = atoi(argv[++cur]);
			if (btype < 0 || btype > 5) {
				cout << "ERROR:\tB-Type height must be 0-5" << endl;
				exit(0);
			}
		}
		else if (!strcmp(argv[cur], "-p")) {
			prefix = argv[++cur];
			if (prefix[prefix.size()-1] != '/') prefix += "/";
		}
		else if (!strcmp(argv[cur], "-m")) {
			music = argv[++cur];
		}
		else if (!strcmp(argv[cur], "--no-music")) {
			music = "";
		}
	}

	// Start Game
	fbgGame game(argv[0], theme, light, startLevel, btype, prefix, music != "" ? music.c_str() : NULL);
	if (!game.getRenderer()->init(fullscreen, width, height, bpp)) {game.getRenderer()->exit();exit(0);}	// Init Graphics

	// Timer system passed to SDL_Init in fbgOpenGLRenderer::init

	SDL_Event event;
	bool quit=false;
	// Wait for a key press to start the game
	bool keyPressed=false;
	game.setLastDrop(SDL_GetTicks());
	game.setState(BEGINWAIT);
	game.getRenderer()->draw();
	game.getRenderer()->draw();	// Draw twice for double buffering
	
	game.gameplayLoop();
}
