//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uifindinteractiondelegate?language=objc)
    pub unsafe trait UIFindInteractionDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "UIFindSession", feature = "UIResponder", feature = "UIView"))]
        /// Called when a find session is requested to begin by the user. Return an instance of a UIFindSession implementation to allow the
        /// find session to begin, otherwise return nil to prevent the system find panel from appearing.
        #[unsafe(method(findInteraction:sessionForView:))]
        #[unsafe(method_family = none)]
        unsafe fn findInteraction_sessionForView(
            &self,
            interaction: &UIFindInteraction,
            view: &UIView,
        ) -> Option<Retained<UIFindSession>>;

        #[cfg(feature = "UIFindSession")]
        /// Called when the search operation begins (and the system search UI appears).
        /// This would be a good time to decorate your view to indicate that a search operation is about to occur.
        /// System text elements will apply a dimming view around all non-highlighted search results, for instance.
        #[optional]
        #[unsafe(method(findInteraction:didBeginFindSession:))]
        #[unsafe(method_family = none)]
        unsafe fn findInteraction_didBeginFindSession(
            &self,
            interaction: &UIFindInteraction,
            session: &UIFindSession,
        );

        #[cfg(feature = "UIFindSession")]
        /// Called when the current search session has changed or ended. This would be a good time to remove all
        /// decorations applied to found search results, and any decorations added when the search operation began
        /// (such as a dimming view).
        #[optional]
        #[unsafe(method(findInteraction:didEndFindSession:))]
        #[unsafe(method_family = none)]
        unsafe fn findInteraction_didEndFindSession(
            &self,
            interaction: &UIFindInteraction,
            session: &UIFindSession,
        );
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uifindinteraction?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIFindInteraction;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIFindInteraction {}
);

#[cfg(feature = "UIInteraction")]
extern_conformance!(
    unsafe impl UIInteraction for UIFindInteraction {}
);

impl UIFindInteraction {
    extern_methods!(
        /// Returns YES if the find navigator panel is currently visible.
        #[unsafe(method(isFindNavigatorVisible))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFindNavigatorVisible(&self) -> bool;

        #[cfg(feature = "UIFindSession")]
        /// If there's a currently active find session (implying isFindNavigatorVisible is true), returns the active find session.
        #[unsafe(method(activeFindSession))]
        #[unsafe(method_family = none)]
        pub unsafe fn activeFindSession(&self) -> Option<Retained<UIFindSession>>;

        /// Assign this property to pre-populate the system find panel's search text field with a search query.
        #[unsafe(method(searchText))]
        #[unsafe(method_family = none)]
        pub unsafe fn searchText(&self) -> Option<Retained<NSString>>;

        /// Setter for [`searchText`][Self::searchText].
        #[unsafe(method(setSearchText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSearchText(&self, search_text: Option<&NSString>);

        /// If replacement is supported, assign this property to pre-populate the system find panel's replace text field with a replacement string.
        #[unsafe(method(replacementText))]
        #[unsafe(method_family = none)]
        pub unsafe fn replacementText(&self) -> Option<Retained<NSString>>;

        /// Setter for [`replacementText`][Self::replacementText].
        #[unsafe(method(setReplacementText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setReplacementText(&self, replacement_text: Option<&NSString>);

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement", feature = "block2"))]
        /// This provider is consulted when the search options menu is being populated. A default set of search options is provided, representing the options
        /// available in
        /// `UITextSearchOptions,`which can be either modified, augmented, or omitted.
        #[unsafe(method(optionsMenuProvider))]
        #[unsafe(method_family = none)]
        pub unsafe fn optionsMenuProvider(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<NSArray<UIMenuElement>>) -> *mut UIMenu>;

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement", feature = "block2"))]
        /// Setter for [`optionsMenuProvider`][Self::optionsMenuProvider].
        #[unsafe(method(setOptionsMenuProvider:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOptionsMenuProvider(
            &self,
            options_menu_provider: Option<
                &block2::DynBlock<dyn Fn(NonNull<NSArray<UIMenuElement>>) -> *mut UIMenu>,
            >,
        );

        /// See UIFindInteractionDelegate above.
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UIFindInteractionDelegate>>>;

        /// Creates a find interaction object with the specified delegate.
        #[unsafe(method(initWithSessionDelegate:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithSessionDelegate(
            this: Allocated<Self>,
            session_delegate: &ProtocolObject<dyn UIFindInteractionDelegate>,
        ) -> Retained<Self>;

        /// Shows the find navigator panel, if not already visible.
        ///
        ///
        /// Parameter `replaceVisible`: If the delegate supports text replacement, will make the replace text field
        /// visible on first appearance.
        #[unsafe(method(presentFindNavigatorShowingReplace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentFindNavigatorShowingReplace(&self, showing_replace: bool);

        /// Dismisses the find navigator panel.
        #[unsafe(method(dismissFindNavigator))]
        #[unsafe(method_family = none)]
        pub unsafe fn dismissFindNavigator(&self);

        /// Jump to the next found result in the document, relative to the currently highlighted result.
        #[unsafe(method(findNext))]
        #[unsafe(method_family = none)]
        pub unsafe fn findNext(&self);

        /// Jump to the previous found result in the document, relative to the currently highlighted result.
        #[unsafe(method(findPrevious))]
        #[unsafe(method_family = none)]
        pub unsafe fn findPrevious(&self);

        /// Calling this triggers an update of the UI to reflect changes to the currently shown result count or result index, as defined by UIFindSession.
        #[unsafe(method(updateResultCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateResultCount(&self);

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}
