ifeq ($(LTDL_DROP_IN_REPLACEMENT),yes)

LIBLTDL_SOLINK = $(OS_LIB_PREFIX)ltdl$(OS_LIB_SUFFIX)
LIBLTDL_ARLINK = $(OS_LIB_PREFIX)ltdl$(OS_ARCHIVE_EXT)
LIBLTDL_IMPLIB = $(OS_LIB_PREFIX)ltdl$(OS_IMPLIB_EXT)

install-headers-ltdl:
	mkdir -p $(DESTDIR)$(INCLUDEDIR)
	rm -f $(DESTDIR)$(INCLUDEDIR)/ltdl.h.tmp
	cp -p $(SOURCE_DIR)/include/ltdl.h $(DESTDIR)$(INCLUDEDIR)/ltdl.h.tmp
	mv $(DESTDIR)$(INCLUDEDIR)/ltdl.h.tmp $(DESTDIR)$(INCLUDEDIR)/ltdl.h

install-shared-ltdl:
	mkdir -p $(DESTDIR)$(LIBDIR)
	rm -f lib/libltdl.so.tmp
	ln -s $(DSO_SOLINK) lib/libltdl.so.tmp
	mv lib/libltdl.so.tmp $(DESTDIR)$(LIBDIR)/$(LIBLTDL_SOLINK)

install-static-ltdl:
	mkdir -p $(DESTDIR)$(LIBDIR)
	rm -f lib/libltdl.a.tmp
	ln -s $(STATIC_LIB_NAME) lib/libltdl.a.tmp
	mv lib/libltdl.a.tmp $(DESTDIR)$(LIBDIR)/$(LIBLTDL_ARLINK)

install-implib-ltdl:
	mkdir -p $(DESTDIR)$(LIBDIR)
	rm -f lib/libltdl.lib.a.tmp
	ln -s $(IMP_SOLINK) lib/libltdl.lib.a.tmp
	mv lib/libltdl.lib.a.tmp $(DESTDIR)$(LIBDIR)/$(LIBLTDL_IMPLIB)


install-headers:    install-headers-ltdl
install-static:     install-static-ltdl
install-shared:     install-shared-ltdl

ifeq ($(CC_BINFMT),PE)
install-shared:     install-implib-ltdl
endif

endif
