// Code generated by gocc; DO NOT EDIT.

package lexer

import (
	"io/ioutil"
	"unicode/utf8"

	"miller/src/parsing/token"
)

const (
	NoState    = -1
	NumStates  = 314
	NumSymbols = 541
)

type Lexer struct {
	src    []byte
	pos    int
	line   int
	column int
}

func NewLexer(src []byte) *Lexer {
	lexer := &Lexer{
		src:    src,
		pos:    0,
		line:   1,
		column: 1,
	}
	return lexer
}

func NewLexerFile(fpath string) (*Lexer, error) {
	src, err := ioutil.ReadFile(fpath)
	if err != nil {
		return nil, err
	}
	return NewLexer(src), nil
}

func (l *Lexer) Scan() (tok *token.Token) {
	tok = new(token.Token)
	if l.pos >= len(l.src) {
		tok.Type = token.EOF
		tok.Pos.Offset, tok.Pos.Line, tok.Pos.Column = l.pos, l.line, l.column
		return
	}
	start, startLine, startColumn, end := l.pos, l.line, l.column, 0
	tok.Type = token.INVALID
	state, rune1, size := 0, rune(-1), 0
	for state != -1 {
		if l.pos >= len(l.src) {
			rune1 = -1
		} else {
			rune1, size = utf8.DecodeRune(l.src[l.pos:])
			l.pos += size
		}

		nextState := -1
		if rune1 != -1 {
			nextState = TransTab[state](rune1)
		}
		state = nextState

		if state != -1 {

			switch rune1 {
			case '\n':
				l.line++
				l.column = 1
			case '\r':
				l.column = 1
			case '\t':
				l.column += 4
			default:
				l.column++
			}

			switch {
			case ActTab[state].Accept != -1:
				tok.Type = ActTab[state].Accept
				end = l.pos
			case ActTab[state].Ignore != "":
				start, startLine, startColumn = l.pos, l.line, l.column
				state = 0
				if start >= len(l.src) {
					tok.Type = token.EOF
				}

			}
		} else {
			if tok.Type == token.INVALID {
				end = l.pos
			}
		}
	}
	if end > start {
		l.pos = end
		tok.Lit = l.src[start:end]
	} else {
		tok.Lit = []byte{}
	}
	tok.Pos.Offset, tok.Pos.Line, tok.Pos.Column = start, startLine, startColumn

	return
}

func (l *Lexer) Reset() {
	l.pos = 0
}

/*
Lexer symbols:
0: '"'
1: '"'
2: '"'
3: '"'
4: 'i'
5: '0'
6: 'x'
7: '0'
8: 'b'
9: '.'
10: '.'
11: '-'
12: '.'
13: '.'
14: '-'
15: '.'
16: '.'
17: '-'
18: 'M'
19: '_'
20: 'P'
21: 'I'
22: 'M'
23: '_'
24: 'E'
25: 'I'
26: 'P'
27: 'S'
28: 'I'
29: 'F'
30: 'S'
31: 'I'
32: 'R'
33: 'S'
34: 'O'
35: 'P'
36: 'S'
37: 'O'
38: 'F'
39: 'S'
40: 'O'
41: 'R'
42: 'S'
43: 'O'
44: 'F'
45: 'L'
46: 'A'
47: 'T'
48: 'S'
49: 'E'
50: 'P'
51: 'N'
52: 'F'
53: 'N'
54: 'R'
55: 'F'
56: 'N'
57: 'R'
58: 'F'
59: 'I'
60: 'L'
61: 'E'
62: 'N'
63: 'A'
64: 'M'
65: 'E'
66: 'F'
67: 'I'
68: 'L'
69: 'E'
70: 'N'
71: 'U'
72: 'M'
73: 'E'
74: 'N'
75: 'V'
76: 'b'
77: 'e'
78: 'g'
79: 'i'
80: 'n'
81: 'd'
82: 'o'
83: 'e'
84: 'l'
85: 'i'
86: 'f'
87: 'e'
88: 'l'
89: 's'
90: 'e'
91: 'e'
92: 'n'
93: 'd'
94: 'f'
95: 'i'
96: 'l'
97: 't'
98: 'e'
99: 'r'
100: 'f'
101: 'o'
102: 'r'
103: 'i'
104: 'f'
105: 'i'
106: 'n'
107: 'w'
108: 'h'
109: 'i'
110: 'l'
111: 'e'
112: 'b'
113: 'r'
114: 'e'
115: 'a'
116: 'k'
117: 'c'
118: 'o'
119: 'n'
120: 't'
121: 'i'
122: 'n'
123: 'u'
124: 'e'
125: 'r'
126: 'e'
127: 't'
128: 'u'
129: 'r'
130: 'n'
131: 'f'
132: 'u'
133: 'n'
134: 'c'
135: 's'
136: 'u'
137: 'b'
138: 'r'
139: 'c'
140: 'a'
141: 'l'
142: 'l'
143: 'a'
144: 'r'
145: 'r'
146: 'b'
147: 'o'
148: 'o'
149: 'l'
150: 'f'
151: 'l'
152: 'o'
153: 'a'
154: 't'
155: 'i'
156: 'n'
157: 't'
158: 'm'
159: 'a'
160: 'p'
161: 'n'
162: 'u'
163: 'm'
164: 's'
165: 't'
166: 'r'
167: 'v'
168: 'a'
169: 'r'
170: 'u'
171: 'n'
172: 's'
173: 'e'
174: 't'
175: 'd'
176: 'u'
177: 'm'
178: 'p'
179: 'e'
180: 'd'
181: 'u'
182: 'm'
183: 'p'
184: 'e'
185: 'm'
186: 'i'
187: 't'
188: 'e'
189: 'm'
190: 'i'
191: 't'
192: 'p'
193: 'e'
194: 'm'
195: 'i'
196: 't'
197: 'f'
198: 'e'
199: 'p'
200: 'r'
201: 'i'
202: 'n'
203: 't'
204: 'e'
205: 'p'
206: 'r'
207: 'i'
208: 'n'
209: 't'
210: 'n'
211: 'p'
212: 'r'
213: 'i'
214: 'n'
215: 't'
216: 'p'
217: 'r'
218: 'i'
219: 'n'
220: 't'
221: 'n'
222: 't'
223: 'e'
224: 'e'
225: 's'
226: 't'
227: 'd'
228: 'o'
229: 'u'
230: 't'
231: 's'
232: 't'
233: 'd'
234: 'e'
235: 'r'
236: 'r'
237: '$'
238: '$'
239: '{'
240: '}'
241: '$'
242: '*'
243: '@'
244: '@'
245: '{'
246: '}'
247: '@'
248: '*'
249: 'a'
250: 'l'
251: 'l'
252: '%'
253: '%'
254: '%'
255: 'p'
256: 'a'
257: 'n'
258: 'i'
259: 'c'
260: '%'
261: '%'
262: '%'
263: ';'
264: '{'
265: '}'
266: '='
267: '>'
268: '>'
269: '>'
270: '|'
271: ','
272: '('
273: ')'
274: '$'
275: '['
276: ']'
277: '$'
278: '['
279: '['
280: '$'
281: '['
282: '['
283: '['
284: '@'
285: '['
286: '|'
287: '|'
288: '='
289: '^'
290: '^'
291: '='
292: '&'
293: '&'
294: '='
295: '?'
296: '?'
297: '='
298: '?'
299: '?'
300: '?'
301: '='
302: '|'
303: '='
304: '&'
305: '='
306: '^'
307: '='
308: '<'
309: '<'
310: '='
311: '>'
312: '>'
313: '='
314: '>'
315: '>'
316: '>'
317: '='
318: '+'
319: '='
320: '.'
321: '='
322: '-'
323: '='
324: '*'
325: '='
326: '/'
327: '='
328: '/'
329: '/'
330: '='
331: '%'
332: '='
333: '*'
334: '*'
335: '='
336: '?'
337: ':'
338: '|'
339: '|'
340: '^'
341: '^'
342: '&'
343: '&'
344: '?'
345: '?'
346: '?'
347: '?'
348: '?'
349: '='
350: '~'
351: '!'
352: '='
353: '~'
354: '='
355: '='
356: '!'
357: '='
358: '>'
359: '='
360: '<'
361: '<'
362: '='
363: '^'
364: '&'
365: '<'
366: '<'
367: '>'
368: '>'
369: '>'
370: '+'
371: '-'
372: '.'
373: '+'
374: '.'
375: '-'
376: '.'
377: '*'
378: '/'
379: '/'
380: '/'
381: '%'
382: '.'
383: '*'
384: '.'
385: '/'
386: '.'
387: '/'
388: '/'
389: '!'
390: '~'
391: '*'
392: '*'
393: '['
394: '['
395: '['
396: '['
397: '['
398: '['
399: '_'
400: ' '
401: '!'
402: '#'
403: '$'
404: '%'
405: '&'
406: '''
407: '\'
408: '('
409: ')'
410: '*'
411: '+'
412: ','
413: '-'
414: '.'
415: '/'
416: ':'
417: ';'
418: '<'
419: '='
420: '>'
421: '?'
422: '@'
423: '['
424: ']'
425: '^'
426: '_'
427: '`'
428: '{'
429: '|'
430: '}'
431: '~'
432: '\'
433: '\'
434: '\'
435: '"'
436: '\'
437: '['
438: '\'
439: ']'
440: '\'
441: 'b'
442: '\'
443: 'f'
444: '\'
445: 'n'
446: '\'
447: 'r'
448: '\'
449: 't'
450: '\'
451: 'x'
452: '\'
453: '.'
454: '\'
455: '0'
456: '\'
457: '1'
458: '\'
459: '2'
460: '\'
461: '3'
462: '\'
463: '4'
464: '\'
465: '5'
466: '\'
467: '6'
468: '\'
469: '7'
470: '\'
471: '8'
472: '\'
473: '9'
474: 'e'
475: 'E'
476: 't'
477: 'r'
478: 'u'
479: 'e'
480: 'f'
481: 'a'
482: 'l'
483: 's'
484: 'e'
485: ' '
486: '!'
487: '#'
488: '$'
489: '%'
490: '&'
491: '''
492: '\'
493: '('
494: ')'
495: '*'
496: '+'
497: ','
498: '-'
499: '.'
500: '/'
501: ':'
502: ';'
503: '<'
504: '='
505: '>'
506: '?'
507: '@'
508: '['
509: ']'
510: '^'
511: '_'
512: '`'
513: '|'
514: '~'
515: '\'
516: '{'
517: '\'
518: '}'
519: ' '
520: '\t'
521: '\n'
522: '\r'
523: '#'
524: '\n'
525: 'a'-'z'
526: 'A'-'Z'
527: '0'-'9'
528: '0'-'9'
529: 'a'-'f'
530: 'A'-'F'
531: '0'-'1'
532: 'A'-'Z'
533: 'a'-'z'
534: '0'-'9'
535: \u0100-\U0010ffff
536: 'A'-'Z'
537: 'a'-'z'
538: '0'-'9'
539: \u0100-\U0010ffff
540: .
*/
