// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) TypeSpec Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

#pragma once

#include "azure/keyvault/certificates/dll_import_export.hpp"

#include <azure/core/datetime.hpp>
#include <azure/core/internal/extendable_enumeration.hpp>
#include <azure/core/nullable.hpp>

#include <cstdint>
#include <map>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace Azure { namespace Security { namespace KeyVault { namespace Certificates {
  namespace _detail { namespace Models {
    /**
     * @brief Reflects the deletion recovery level currently in effect for secrets in the current
     * vault. If it contains 'Purgeable', the secret can be permanently deleted by a privileged
     * user; otherwise, only the system can purge the secret, at the end of the retention interval.
     *
     */
    class DeletionRecoveryLevel final
        : public Core::_internal::ExtendableEnumeration<DeletionRecoveryLevel> {
    public:
      /**
       * @brief Constructs a new DeletionRecoveryLevel instance.
       *
       **/
      DeletionRecoveryLevel() = default;

      /**
       * @brief Constructs a new DeletionRecoveryLevel instance from a string.
       * @param deletionRecoveryLevel String value to construct the new instance from.
       *
       **/
      explicit DeletionRecoveryLevel(std::string deletionRecoveryLevel)
          : ExtendableEnumeration(std::move(deletionRecoveryLevel))
      {
      }

      /// Denotes a vault state in which deletion is an irreversible operation, without the
      /// possibility for recovery. This level corresponds to no protection being available against
      /// a Delete operation; the data is irretrievably lost upon accepting a Delete operation at
      /// the entity level or higher (vault, resource group, subscription etc.)
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const DeletionRecoveryLevel Purgeable;

      /// Denotes a vault state in which deletion is recoverable, and which also permits immediate
      /// and permanent deletion (i.e. purge). This level guarantees the recoverability of the
      /// deleted entity during the retention interval (90 days), unless a Purge operation is
      /// requested, or the subscription is cancelled. System wil permanently delete it after 90
      /// days, if not recovered
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const DeletionRecoveryLevel
          RecoverablePurgeable;

      /// Denotes a vault state in which deletion is recoverable without the possibility for
      /// immediate and permanent deletion (i.e. purge). This level guarantees the recoverability of
      /// the deleted entity during the retention interval (90 days) and while the subscription is
      /// still available. System wil permanently delete it after 90 days, if not recovered
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const DeletionRecoveryLevel Recoverable;

      /// Denotes a vault and subscription state in which deletion is recoverable within retention
      /// interval (90 days), immediate and permanent deletion (i.e. purge) is not permitted, and in
      /// which the subscription itself  cannot be permanently canceled. System wil permanently
      /// delete it after 90 days, if not recovered
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const DeletionRecoveryLevel
          RecoverableProtectedSubscription;

      /// Denotes a vault state in which deletion is recoverable, and which also permits immediate
      /// and permanent deletion (i.e. purge when 7 <= SoftDeleteRetentionInDays < 90). This level
      /// guarantees the recoverability of the deleted entity during the retention interval, unless
      /// a Purge operation is requested, or the subscription is cancelled.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const DeletionRecoveryLevel
          CustomizedRecoverablePurgeable;

      /// Denotes a vault state in which deletion is recoverable without the possibility for
      /// immediate and permanent deletion (i.e. purge when 7 <= SoftDeleteRetentionInDays <
      /// 90).This level guarantees the recoverability of the deleted entity during the retention
      /// interval and while the subscription is still available.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const DeletionRecoveryLevel
          CustomizedRecoverable;

      /// Denotes a vault and subscription state in which deletion is recoverable, immediate and
      /// permanent deletion (i.e. purge) is not permitted, and in which the subscription itself
      /// cannot be permanently canceled when 7 <= SoftDeleteRetentionInDays < 90. This level
      /// guarantees the recoverability of the deleted entity during the retention interval, and
      /// also reflects the fact that the subscription itself cannot be cancelled.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const DeletionRecoveryLevel
          CustomizedRecoverableProtectedSubscription;
    };

    /**
     * @brief The type of key pair to be used for the certificate.
     *
     */
    class JsonWebKeyType final : public Core::_internal::ExtendableEnumeration<JsonWebKeyType> {
    public:
      /**
       * @brief Constructs a new JsonWebKeyType instance.
       *
       **/
      JsonWebKeyType() = default;

      /**
       * @brief Constructs a new JsonWebKeyType instance from a string.
       * @param jsonWebKeyType String value to construct the new instance from.
       *
       **/
      explicit JsonWebKeyType(std::string jsonWebKeyType)
          : ExtendableEnumeration(std::move(jsonWebKeyType))
      {
      }

      /// Elliptic Curve.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const JsonWebKeyType EC;

      /// Elliptic Curve with a private key which is not exportable from the HSM.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const JsonWebKeyType ECHsm;

      /// RSA (https://tools.ietf.org/html/rfc3447).
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const JsonWebKeyType Rsa;

      /// RSA with a private key which is not exportable from the HSM.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const JsonWebKeyType RsaHsm;

      /// Octet sequence (used to represent symmetric keys).
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const JsonWebKeyType Oct;

      /// Octet sequence with a private key which is not exportable from the HSM.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const JsonWebKeyType OctHsm;
    };

    /**
     * @brief Elliptic curve name. For valid values, see JsonWebKeyCurveName.
     *
     */
    class JsonWebKeyCurveName final
        : public Core::_internal::ExtendableEnumeration<JsonWebKeyCurveName> {
    public:
      /**
       * @brief Constructs a new JsonWebKeyCurveName instance.
       *
       **/
      JsonWebKeyCurveName() = default;

      /**
       * @brief Constructs a new JsonWebKeyCurveName instance from a string.
       * @param jsonWebKeyCurveName String value to construct the new instance from.
       *
       **/
      explicit JsonWebKeyCurveName(std::string jsonWebKeyCurveName)
          : ExtendableEnumeration(std::move(jsonWebKeyCurveName))
      {
      }

      /// The NIST P-256 elliptic curve, AKA SECG curve SECP256R1.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const JsonWebKeyCurveName
          PTwoHundredFiftySix;

      /// The NIST P-384 elliptic curve, AKA SECG curve SECP384R1.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const JsonWebKeyCurveName
          PThreeHundredEightyFour;

      /// The NIST P-521 elliptic curve, AKA SECG curve SECP521R1.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const JsonWebKeyCurveName
          PFiveHundredTwentyOne;

      /// The SECG SECP256K1 elliptic curve.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const JsonWebKeyCurveName P256k;
    };

    /**
     * @brief Supported usages of a certificate key.
     *
     */
    class KeyUsageType final : public Core::_internal::ExtendableEnumeration<KeyUsageType> {
    public:
      /**
       * @brief Constructs a new KeyUsageType instance.
       *
       **/
      KeyUsageType() = default;

      /**
       * @brief Constructs a new KeyUsageType instance from a string.
       * @param keyUsageType String value to construct the new instance from.
       *
       **/
      explicit KeyUsageType(std::string keyUsageType)
          : ExtendableEnumeration(std::move(keyUsageType))
      {
      }

      /// Indicates that the certificate key can be used as a digital signature.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const KeyUsageType DigitalSignature;

      /// Indicates that the certificate key can be used for authentication.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const KeyUsageType NonRepudiation;

      /// Indicates that the certificate key can be used for key encryption.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const KeyUsageType KeyEncipherment;

      /// Indicates that the certificate key can be used for data encryption.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const KeyUsageType DataEncipherment;

      /// Indicates that the certificate key can be used to determine key agreement, such as a key
      /// created using the Diffie-Hellman key agreement algorithm.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const KeyUsageType KeyAgreement;

      /// Indicates that the certificate key can be used to sign certificates.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const KeyUsageType KeyCertSign;

      /// Indicates that the certificate key can be used to sign a certificate revocation list.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const KeyUsageType CRLSign;

      /// Indicates that the certificate key can be used for encryption only.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const KeyUsageType EncipherOnly;

      /// Indicates that the certificate key can be used for decryption only.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const KeyUsageType DecipherOnly;
    };

    /**
     * @brief The type of the action.
     *
     */
    class CertificatePolicyAction final
        : public Core::_internal::ExtendableEnumeration<CertificatePolicyAction> {
    public:
      /**
       * @brief Constructs a new CertificatePolicyAction instance.
       *
       **/
      CertificatePolicyAction() = default;

      /**
       * @brief Constructs a new CertificatePolicyAction instance from a string.
       * @param certificatePolicyAction String value to construct the new instance from.
       *
       **/
      explicit CertificatePolicyAction(std::string certificatePolicyAction)
          : ExtendableEnumeration(std::move(certificatePolicyAction))
      {
      }

      /// A certificate policy that will email certificate contacts.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const CertificatePolicyAction
          EmailContacts;

      /// A certificate policy that will auto-renew a certificate.
      AZ_SECURITY_KEYVAULT_CERTIFICATES_DLLEXPORT static const CertificatePolicyAction AutoRenew;
    };

    /**
     * @brief The certificate management attributes.
     *
     */
    struct CertificateAttributes final
    {
      /// Determines whether the object is enabled.
      Nullable<bool> Enabled;

      /// Not before date in UTC.
      Nullable<DateTime> NotBefore;

      /// Expiry date in UTC.
      Nullable<DateTime> Expires;

      /// [out] Creation time in UTC.
      Nullable<DateTime> Created;

      /// [out] Last updated time in UTC.
      Nullable<DateTime> Updated;

      /// [out] softDelete data retention days. Value should be >=7 and <=90 when softDelete
      /// enabled, otherwise 0.
      Nullable<std::int32_t> RecoverableDays;

      /// [out] Reflects the deletion recovery level currently in effect for certificates in the
      /// current vault. If it contains 'Purgeable', the certificate can be permanently deleted by a
      /// privileged user; otherwise, only the system can purge the certificate, at the end of the
      /// retention interval.
      Nullable<DeletionRecoveryLevel> RecoveryLevel;
    };

    /**
     * @brief The certificate item containing certificate metadata.
     *
     */
    struct CertificateItem final
    {
      /// Certificate identifier.
      Nullable<std::string> Id;

      /// The certificate management attributes.
      Nullable<CertificateAttributes> Attributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;

      /// Thumbprint of the certificate.
      Nullable<std::vector<std::uint8_t>> X509Thumbprint;
    };

    /**
     * @brief Properties of the key pair backing a certificate.
     *
     */
    struct KeyProperties final
    {
      /// Indicates if the private key can be exported. Release policy must be provided when
      /// creating the first version of an exportable key.
      Nullable<bool> Exportable;

      /// The type of key pair to be used for the certificate.
      Nullable<JsonWebKeyType> KeyType;

      /// The key size in bits. For example: 2048, 3072, or 4096 for RSA.
      Nullable<std::int32_t> KeySize;

      /// Indicates if the same key pair will be used on certificate renewal.
      Nullable<bool> ReuseKey;

      /// Elliptic curve name. For valid values, see JsonWebKeyCurveName.
      Nullable<JsonWebKeyCurveName> Curve;
    };

    /**
     * @brief Properties of the key backing a certificate.
     *
     */
    struct SecretProperties final
    {
      /// The media type (MIME type).
      Nullable<std::string> ContentType;
    };

    /**
     * @brief The subject alternate names of a X509 object.
     *
     */
    struct SubjectAlternativeNames final
    {
      /// Email addresses.
      Nullable<std::vector<std::string>> Emails;

      /// Domain names.
      Nullable<std::vector<std::string>> DnsNames;

      /// User principal names.
      Nullable<std::vector<std::string>> Upns;
    };

    /**
     * @brief Properties of the X509 component of a certificate.
     *
     */
    struct X509CertificateProperties final
    {
      /// The subject name. Should be a valid X509 distinguished Name.
      Nullable<std::string> Subject;

      /// The enhanced key usage.
      Nullable<std::vector<std::string>> Ekus;

      /// The subject alternative names.
      Nullable<Models::SubjectAlternativeNames> SubjectAlternativeNames;

      /// Defines how the certificate's key may be used.
      Nullable<std::vector<KeyUsageType>> KeyUsage;

      /// The duration that the certificate is valid in months.
      Nullable<std::int32_t> ValidityInMonths;
    };

    /**
     * @brief A condition to be satisfied for an action to be executed.
     *
     */
    struct Trigger final
    {
      /// Percentage of lifetime at which to trigger. Value should be between 1 and 99.
      Nullable<std::int32_t> LifetimePercentage;

      /// Days before expiry to attempt renewal. Value should be between 1 and validity_in_months
      /// multiplied by 27. If validity_in_months is 36, then value should be between 1 and 972 (36
      /// * 27).
      Nullable<std::int32_t> DaysBeforeExpiry;
    };

    /**
     * @brief The action that will be executed.
     *
     */
    struct Action final
    {
      /// The type of the action.
      Nullable<CertificatePolicyAction> ActionType;
    };

    /**
     * @brief Action and its trigger that will be performed by Key Vault over the lifetime of a
     * certificate.
     *
     */
    struct LifetimeAction final
    {
      /// The condition that will execute the action.
      Nullable<Models::Trigger> Trigger;

      /// The action that will be executed.
      Nullable<Models::Action> Action;
    };

    /**
     * @brief Parameters for the issuer of the X509 component of a certificate.
     *
     */
    struct IssuerParameters final
    {
      /// Name of the referenced issuer object or reserved names; for example, 'Self' or 'Unknown'.
      Nullable<std::string> Name;

      /// Certificate type as supported by the provider (optional); for example 'OV-SSL', 'EV-SSL'
      Nullable<std::string> CertificateType;

      /// Indicates if the certificates generated under this policy should be published to
      /// certificate transparency logs.
      Nullable<bool> CertificateTransparency;
    };

    /**
     * @brief Management policy for a certificate.
     *
     */
    struct CertificatePolicy final
    {
      /// [out] The certificate id.
      Nullable<std::string> Id;

      /// Properties of the key backing a certificate.
      Nullable<Models::KeyProperties> KeyProperties;

      /// Properties of the secret backing a certificate.
      Nullable<Models::SecretProperties> SecretProperties;

      /// Properties of the X509 component of a certificate.
      Nullable<Models::X509CertificateProperties> X509CertificateProperties;

      /// Actions that will be performed by Key Vault over the lifetime of a certificate.
      Nullable<std::vector<LifetimeAction>> LifetimeActions;

      /// Parameters for the issuer of the X509 component of a certificate.
      Nullable<Models::IssuerParameters> IssuerParameters;

      /// The certificate attributes.
      Nullable<CertificateAttributes> Attributes;
    };

    /**
     * @brief A Deleted Certificate consisting of its previous id, attributes and its tags, as well
     * as information on when it will be purged.
     *
     */
    struct DeletedCertificateBundle final
    {
      /// [out] The certificate id.
      Nullable<std::string> Id;

      /// [out] The key id.
      Nullable<std::string> Kid;

      /// [out] The secret id.
      Nullable<std::string> Sid;

      /// [out] Thumbprint of the certificate.
      Nullable<std::vector<std::uint8_t>> X509Thumbprint;

      /// [out] The management policy.
      Nullable<CertificatePolicy> Policy;

      /// CER contents of x509 certificate.
      Nullable<std::vector<std::uint8_t>> Cer;

      /// The content type of the secret. eg. 'application/x-pem-file' or 'application/x-pkcs12',
      Nullable<std::string> ContentType;

      /// The certificate attributes.
      Nullable<CertificateAttributes> Attributes;

      /// Application specific metadata in the form of key-value pairs
      Nullable<std::map<std::string, std::string>> Tags;

      /// Specifies whether the certificate chain preserves its original order. The default value is
      /// false, which sets the leaf certificate at index 0.
      Nullable<bool> PreserveCertOrder;

      /// The url of the recovery object, used to identify and recover the deleted certificate.
      Nullable<std::string> RecoveryId;

      /// [out] The time when the certificate is scheduled to be purged, in UTC
      Nullable<DateTime> ScheduledPurgeDate;

      /// [out] The time when the certificate was deleted, in UTC
      Nullable<DateTime> DeletedDate;
    };

    /**
     * @brief The contact information for the vault certificates.
     *
     */
    struct Contact final
    {
      /// Email address.
      Nullable<std::string> EmailAddress;

      /// Name.
      Nullable<std::string> Name;

      /// Phone number.
      Nullable<std::string> Phone;
    };

    /**
     * @brief The contacts for the vault certificates.
     *
     */
    struct Contacts final
    {
      /// [out] Identifier for the contacts collection.
      Nullable<std::string> Id;

      /// The contact list for the vault certificates.
      Nullable<std::vector<Contact>> ContactList;
    };

    /**
     * @brief The certificate issuer item containing certificate issuer metadata.
     *
     */
    struct CertificateIssuerItem final
    {
      /// Certificate Identifier.
      Nullable<std::string> Id;

      /// The issuer provider.
      Nullable<std::string> Provider;
    };

    /**
     * @brief The credentials to be used for the certificate issuer.
     *
     */
    struct IssuerCredentials final
    {
      /// The user name/account name/account id.
      Nullable<std::string> AccountId;

      /// The password/secret/account key.
      Nullable<std::string> Password;
    };

    /**
     * @brief Details of the organization administrator of the certificate issuer.
     *
     */
    struct AdministratorDetails final
    {
      /// First name.
      Nullable<std::string> FirstName;

      /// Last name.
      Nullable<std::string> LastName;

      /// Email address.
      Nullable<std::string> EmailAddress;

      /// Phone number.
      Nullable<std::string> Phone;
    };

    /**
     * @brief Details of the organization of the certificate issuer.
     *
     */
    struct OrganizationDetails final
    {
      /// Id of the organization.
      Nullable<std::string> Id;

      /// Details of the organization administrator.
      Nullable<std::vector<AdministratorDetails>> AdminDetails;
    };

    /**
     * @brief The attributes of an issuer managed by the Key Vault service.
     *
     */
    struct IssuerAttributes final
    {
      /// Determines whether the issuer is enabled.
      Nullable<bool> Enabled;

      /// [out] Creation time in UTC.
      Nullable<DateTime> Created;

      /// [out] Last updated time in UTC.
      Nullable<DateTime> Updated;
    };

    /**
     * @brief The issuer for Key Vault certificate.
     *
     */
    struct IssuerBundle final
    {
      /// [out] Identifier for the issuer object.
      Nullable<std::string> Id;

      /// The issuer provider.
      Nullable<std::string> Provider;

      /// The credentials to be used for the issuer.
      Nullable<IssuerCredentials> Credentials;

      /// Details of the organization as provided to the issuer.
      Nullable<Models::OrganizationDetails> OrganizationDetails;

      /// Attributes of the issuer object.
      Nullable<IssuerAttributes> Attributes;
    };

    /**
     * @brief The certificate issuer set parameters.
     *
     */
    struct CertificateIssuerSetParameters final
    {
      /// The issuer provider.
      std::string Provider;

      /// The credentials to be used for the issuer.
      Nullable<IssuerCredentials> Credentials;

      /// Details of the organization as provided to the issuer.
      Nullable<Models::OrganizationDetails> OrganizationDetails;

      /// Attributes of the issuer object.
      Nullable<IssuerAttributes> Attributes;
    };

    /**
     * @brief The certificate issuer update parameters.
     *
     */
    struct CertificateIssuerUpdateParameters final
    {
      /// The issuer provider.
      Nullable<std::string> Provider;

      /// The credentials to be used for the issuer.
      Nullable<IssuerCredentials> Credentials;

      /// Details of the organization as provided to the issuer.
      Nullable<Models::OrganizationDetails> OrganizationDetails;

      /// Attributes of the issuer object.
      Nullable<IssuerAttributes> Attributes;
    };
    // codegen: replace ConfigurationClient declaration
    /**
     * @brief Keyvault error.
     *
     */
    struct KeyVaultErrorError final
    // codegen: end replace ConfigurationClient declaration
    {
      /// [out] The error code.
      Nullable<std::string> Code;

      /// [out] The error message.
      Nullable<std::string> Message;

      /// [out] The key vault server error.
      std::shared_ptr<KeyVaultErrorError> InnerError;
    };

    /**
     * @brief A certificate operation is returned in case of asynchronous requests.
     *
     */
    struct CertificateOperation final
    {
      /// [out] The certificate id.
      Nullable<std::string> Id;

      /// Parameters for the issuer of the X509 component of a certificate.
      Nullable<Models::IssuerParameters> IssuerParameters;

      /// The certificate signing request (CSR) that is being used in the certificate operation.
      Nullable<std::vector<std::uint8_t>> Csr;

      /// Indicates if cancellation was requested on the certificate operation.
      Nullable<bool> CancellationRequested;

      /// Status of the certificate operation.
      Nullable<std::string> Status;

      /// The status details of the certificate operation.
      Nullable<std::string> StatusDetails;

      /// Error encountered, if any, during the certificate operation.
      Nullable<KeyVaultErrorError> Error;

      /// Location which contains the result of the certificate operation.
      Nullable<std::string> Target;

      /// Specifies whether the certificate chain preserves its original order. The default value is
      /// false, which sets the leaf certificate at index 0.
      Nullable<bool> PreserveCertOrder;

      /// Identifier for the certificate operation.
      Nullable<std::string> RequestId;
    };

    /**
     * @brief The certificate create parameters.
     *
     */
    struct CertificateCreateParameters final
    {
      /// The management policy for the certificate.
      Nullable<Models::CertificatePolicy> CertificatePolicy;

      /// The attributes of the certificate (optional).
      Nullable<Models::CertificateAttributes> CertificateAttributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;

      /// Specifies whether the certificate chain preserves its original order. The default value is
      /// false, which sets the leaf certificate at index 0.
      Nullable<bool> PreserveCertOrder;
    };

    /**
     * @brief A certificate bundle consists of a certificate (X509) plus its attributes.
     *
     */
    struct CertificateBundle final
    {
      /// [out] The certificate id.
      Nullable<std::string> Id;

      /// [out] The key id.
      Nullable<std::string> Kid;

      /// [out] The secret id.
      Nullable<std::string> Sid;

      /// [out] Thumbprint of the certificate.
      Nullable<std::vector<std::uint8_t>> X509Thumbprint;

      /// [out] The management policy.
      Nullable<CertificatePolicy> Policy;

      /// CER contents of x509 certificate.
      Nullable<std::vector<std::uint8_t>> Cer;

      /// The content type of the secret. eg. 'application/x-pem-file' or 'application/x-pkcs12',
      Nullable<std::string> ContentType;

      /// The certificate attributes.
      Nullable<CertificateAttributes> Attributes;

      /// Application specific metadata in the form of key-value pairs
      Nullable<std::map<std::string, std::string>> Tags;

      /// Specifies whether the certificate chain preserves its original order. The default value is
      /// false, which sets the leaf certificate at index 0.
      Nullable<bool> PreserveCertOrder;
    };

    /**
     * @brief The certificate import parameters.
     *
     */
    struct CertificateImportParameters final
    {
      /// Base64 encoded representation of the certificate object to import. This certificate needs
      /// to contain the private key.
      std::string Base64EncodedCertificate;

      /// If the private key in base64EncodedCertificate is encrypted, the password used for
      /// encryption.
      Nullable<std::string> Password;

      /// The management policy for the certificate.
      Nullable<Models::CertificatePolicy> CertificatePolicy;

      /// The attributes of the certificate (optional).
      Nullable<Models::CertificateAttributes> CertificateAttributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;

      /// Specifies whether the certificate chain preserves its original order. The default value is
      /// false, which sets the leaf certificate at index 0.
      Nullable<bool> PreserveCertOrder;
    };

    /**
     * @brief The certificate update parameters.
     *
     */
    struct CertificateUpdateParameters final
    {
      /// The management policy for the certificate.
      Nullable<Models::CertificatePolicy> CertificatePolicy;

      /// The attributes of the certificate (optional).
      Nullable<Models::CertificateAttributes> CertificateAttributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;
    };

    /**
     * @brief The certificate operation update parameters.
     *
     */
    struct CertificateOperationUpdateParameter final
    {
      /// Indicates if cancellation was requested on the certificate operation.
      bool CancellationRequested = false;
    };

    /**
     * @brief The certificate merge parameters
     *
     */
    struct CertificateMergeParameters final
    {
      /// The certificate or the certificate chain to merge.
      std::vector<std::vector<std::uint8_t>> X509Certificates;

      /// The attributes of the certificate (optional).
      Nullable<Models::CertificateAttributes> CertificateAttributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;
    };

    /**
     * @brief The backup certificate result, containing the backup blob.
     *
     */
    struct BackupCertificateResult final
    {
      /// [out] The backup blob containing the backed up certificate.
      Nullable<std::vector<std::uint8_t>> Value;
    };

    /**
     * @brief The certificate restore parameters.
     *
     */
    struct CertificateRestoreParameters final
    {
      /// The backup blob associated with a certificate bundle.
      std::vector<std::uint8_t> CertificateBundleBackup;
    };

    /**
     * @brief The deleted certificate item containing metadata about the deleted certificate.
     *
     */
    struct DeletedCertificateItem final
    {
      /// Certificate identifier.
      Nullable<std::string> Id;

      /// The certificate management attributes.
      Nullable<CertificateAttributes> Attributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;

      /// Thumbprint of the certificate.
      Nullable<std::vector<std::uint8_t>> X509Thumbprint;

      /// The url of the recovery object, used to identify and recover the deleted certificate.
      Nullable<std::string> RecoveryId;

      /// [out] The time when the certificate is scheduled to be purged, in UTC
      Nullable<DateTime> ScheduledPurgeDate;

      /// [out] The time when the certificate was deleted, in UTC
      Nullable<DateTime> DeletedDate;
    };

    /**
     * @brief PurgeDeletedCertificate operation result.
     *
     */
    struct PurgeDeletedCertificateResult final
    {
    };
}}}}}} // namespace Azure::Security::KeyVault::Certificates::_detail::Models
