# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.9.1] - 2024-10-08

### <!-- 3 -->🆙 Bump

- Bump MSRV to 1.71.1
- Bump all dependencies and setup dependabot

### <!-- 4 -->⚙️ Other changes

- Generate CHANGELOG per crate

[0.9.1]: https://github.com/foundationdb-rs}/foundationdb-rs/compare/0.9.0..0.9.1

## [0.9.0] - 2024-03-15

### <!-- 0 -->🚀 added

- Add support for 730
- Bump fdb crate to 0.9.0 and sim to 0.2.0

### <!-- 3 -->🆙 Bump

- Chore: bump rust to 1.57
- Bump msrv
- Bump crates version
- Bump msrv for bindgen and env_logger
- Bump dependencies

### <!-- 4 -->⚙️ Other changes

- Build on docs.rs with the required features
- Prepare release
- Derive `Default` for `FdbOptionTy`.
- Cargo fmt
- Removing default fdb version

## [0.7.0] - 2022-07-11

### <!-- 0 -->🚀 added

- Add support for api 630
- Bump crate version, maintainers and documentation
- Bump rust edition to 2021
- Add support for api 700
- Initial commit to support fdb 7.1

### <!-- 1 -->🐛 Bug Fixes

- Fix integer cast possible undefined behavior
- Fix missing import
- Fix build for 620
- Fix options.rs generation with bindings 610/620
- Fix build with API 620
- Fix Cargo.toml repository links
- Fix #170: protect boot from undefined behavior
- Cargo clippy fixes
- Include fdb.options for 630

### <!-- 2 -->🚜 Refactor

- Remove Inflector dependency
- Remove failure dependency
- Remove clikengo link in Cargo.toml

### <!-- 3 -->🆙 Bump

- Bump version to 0.4.1
- Bump version to 5.0.1
- Bump deps

### <!-- 4 -->⚙️ Other changes

- Core: auto-generate all code at build time
- Cleanup the fdb version features from primary crate (#99)
- Rust edition 2018
- Async/await: complete rewrite of foundationdb
- Renamed foundationdb_sys import from fdb to fdb_sys for clarity
- Cleanup dependencies and rename Error as FdbError
- Embed 6.2.10 fdb_c.h and fdb.options
- Embed all supported version includes
- Default to locally available foundationdb include
- Move include inside crate folders
- Foundationdb-gen/sys README
- Cargo.toml badges & docs.rs metadata
- Use `#[non_exhaustive]` on RangeOption and generated enums
- Update fdb 620 includes to 6.2.20
- Update fdb 610 includes to 6.1.13
- Default to foundation 620 api
- Removing reference to master branch
- Prepare for 0.7.0

## [0.3.0] - 2018-11-16

### <!-- 0 -->🚀 added

- Add `Transaction::atomic_op`, #15
- Add `Transaction::get_range`, #14

### <!-- 1 -->🐛 Bug Fixes

- Fix stable compilation error

### <!-- 4 -->⚙️ Other changes

- Generate options types from fdb.options
- Use consts from sys crate
- Allow the association of other errors to FdbError
- Prepare 0.3 release

[unreleased]: https://github.com/foundationdb-rs}/foundationdb-rs/compare/v0.9.0..HEAD
[0.9.0]: https://github.com/foundationdb-rs}/foundationdb-rs/compare/v0.7.0..v0.9.0
[0.7.0]: https://github.com/foundationdb-rs}/foundationdb-rs/compare/v0.3.0..v0.7.0
[0.3.0]: https://github.com/foundationdb-rs}/foundationdb-rs/compare/0.2..v0.3.0

<!-- generated by git-cliff -->
