[38;2;117;113;94m// Copyright (c) Microsoft Corporation.  All Rights Reserved.  See License.txt in the project root for license information.[0m

[38;2;249;38;114mnamespace[0m[38;2;166;226;46m [0m[38;2;166;226;46mMicrosoft.FSharp.Core[0m

[38;2;248;248;242m    [0m[38;2;249;38;114mopen[0m[38;2;248;248;242m [0m[38;2;166;226;46mSystem[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mopen[0m[38;2;248;248;242m [0m[38;2;166;226;46mSystem[0m[38;2;166;226;46m.[0m[38;2;166;226;46mText[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mopen[0m[38;2;248;248;242m [0m[38;2;166;226;46mMicrosoft[0m[38;2;166;226;46m.[0m[38;2;166;226;46mFSharp[0m[38;2;166;226;46m.[0m[38;2;166;226;46mCore[0m[38;2;166;226;46m.[0m[38;2;166;226;46mLanguagePrimitives[0m[38;2;166;226;46m.[0m[38;2;166;226;46mIntrinsicOperators[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mopen[0m[38;2;248;248;242m [0m[38;2;166;226;46mMicrosoft[0m[38;2;166;226;46m.[0m[38;2;166;226;46mFSharp[0m[38;2;166;226;46m.[0m[38;2;166;226;46mCore[0m[38;2;166;226;46m.[0m[38;2;166;226;46mOperators[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mopen[0m[38;2;248;248;242m [0m[38;2;166;226;46mMicrosoft[0m[38;2;166;226;46m.[0m[38;2;166;226;46mFSharp[0m[38;2;166;226;46m.[0m[38;2;166;226;46mCore[0m[38;2;166;226;46m.[0m[38;2;166;226;46mOperators[0m[38;2;166;226;46m.[0m[38;2;166;226;46mChecked[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mopen[0m[38;2;248;248;242m [0m[38;2;166;226;46mMicrosoft[0m[38;2;166;226;46m.[0m[38;2;166;226;46mFSharp[0m[38;2;166;226;46m.[0m[38;2;166;226;46mCollections[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mopen[0m[38;2;248;248;242m [0m[38;2;166;226;46mMicrosoft[0m[38;2;166;226;46m.[0m[38;2;166;226;46mFSharp[0m[38;2;166;226;46m.[0m[38;2;166;226;46mPrimitives[0m[38;2;166;226;46m.[0m[38;2;166;226;46mBasics[0m

[38;2;248;248;242m    [0m[38;2;102;217;239m[<CompilationRepresentation[0m[38;2;249;38;114m([0m[38;2;102;217;239mCompilationRepresentationFlags.ModuleSuffix[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m    [0m[38;2;102;217;239m[<RequireQualifiedAccess>][0m
[38;2;248;248;242m    [0m[38;2;249;38;114mmodule[0m[38;2;166;226;46m [0m[38;2;166;226;46mString [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m        [0m[38;2;102;217;239m[<Literal>][0m
[38;2;248;248;242m        [0m[38;2;117;113;94m/// LOH threshold is calculated from Internal.Utilities.Library.LOH_SIZE_THRESHOLD_BYTES,[0m
[38;2;248;248;242m        [0m[38;2;117;113;94m/// and is equal to 80_000 / sizeof<char>[0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mLOH_CHAR_THRESHOLD[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m40_000[0m

[38;2;248;248;242m        [0m[38;2;102;217;239m[<CompiledName[0m[38;2;249;38;114m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mLength[0m[38;2;230;219;116m"[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mlength[0m[3;38;2;253;151;31m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mstr[0m[38;2;249;38;114m:[0m[38;2;166;226;46mstring[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;249;38;114mif[0m[38;2;248;248;242m isNull str [0m[38;2;249;38;114mthen[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;248;248;242m [0m[38;2;249;38;114melse[0m[38;2;248;248;242m str.Length[0m

[38;2;248;248;242m        [0m[38;2;102;217;239m[<CompiledName[0m[38;2;249;38;114m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mConcat[0m[38;2;230;219;116m"[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mconcat[0m[3;38;2;253;151;31m sep [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mstrings [0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[38;2;166;226;46mseq[0m[38;2;249;38;114m<[0m[38;2;166;226;46mstring[0m[38;2;249;38;114m>[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m  [0m

[38;2;248;248;242m            [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mconcatArray[0m[3;38;2;253;151;31m sep [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mstrings[0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[38;2;166;226;46mstring [0m[38;2;249;38;114m[[0m[38;2;249;38;114m][0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mmatch[0m[38;2;248;248;242m length sep [0m[38;2;249;38;114mwith[0m
[38;2;248;248;242m                [0m[38;2;249;38;114m|[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;248;248;242m [0m[38;2;249;38;114m->[0m[38;2;248;248;242m String.Concat strings[0m
[38;2;248;248;242m                [0m[38;2;117;113;94m// following line should be used when this overload becomes part of .NET Standard (it's only in .NET Core)[0m
[38;2;248;248;242m                [0m[38;2;117;113;94m//| 1 -> String.Join(sep.[0], strings, 0, strings.Length)[0m
[38;2;248;248;242m                [0m[38;2;249;38;114m|[0m[38;2;248;248;242m [0m[38;2;249;38;114m_[0m[38;2;248;248;242m [0m[38;2;249;38;114m->[0m[38;2;248;248;242m String.Join[0m[38;2;249;38;114m([0m[38;2;248;248;242msep[0m[38;2;249;38;114m,[0m[38;2;248;248;242m strings[0m[38;2;249;38;114m,[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m,[0m[38;2;248;248;242m strings.Length[0m[38;2;249;38;114m)[0m

[38;2;248;248;242m            [0m[38;2;249;38;114mmatch[0m[38;2;248;248;242m strings [0m[38;2;249;38;114mwith[0m
[38;2;248;248;242m            [0m[38;2;249;38;114m|[0m[38;2;248;248;242m [0m[38;2;249;38;114m:[0m[38;2;248;248;242m? array[0m[38;2;249;38;114m<[0m[38;2;248;248;242mstring[0m[38;2;249;38;114m>[0m[38;2;248;248;242m [0m[38;2;249;38;114mas[0m[38;2;248;248;242m arr [0m[38;2;249;38;114m->[0m[38;2;248;248;242m [0m
[38;2;248;248;242m                concatArray sep arr[0m

[38;2;248;248;242m            [0m[38;2;249;38;114m|[0m[38;2;248;248;242m [0m[38;2;249;38;114m:[0m[38;2;248;248;242m? list[0m[38;2;249;38;114m<[0m[38;2;248;248;242mstring[0m[38;2;249;38;114m>[0m[38;2;248;248;242m [0m[38;2;249;38;114mas[0m[38;2;248;248;242m lst [0m[38;2;249;38;114m->[0m[38;2;248;248;242m [0m
[38;2;248;248;242m                lst [0m
[38;2;248;248;242m                [0m[38;2;249;38;114m|>[0m[38;2;248;248;242m List.toArray [0m
[38;2;248;248;242m                [0m[38;2;249;38;114m|>[0m[38;2;248;248;242m concatArray sep[0m

[38;2;248;248;242m            [0m[38;2;249;38;114m|[0m[38;2;248;248;242m [0m[38;2;249;38;114m_[0m[38;2;248;248;242m [0m[38;2;249;38;114m->[0m
[38;2;248;248;242m                String.Join[0m[38;2;249;38;114m([0m[38;2;248;248;242msep[0m[38;2;249;38;114m,[0m[38;2;248;248;242m strings[0m[38;2;249;38;114m)[0m

[38;2;248;248;242m        [0m[38;2;102;217;239m[<CompiledName[0m[38;2;249;38;114m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mIterate[0m[38;2;230;219;116m"[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242miter[0m[3;38;2;253;151;31m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31maction [0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;166;226;46mchar [0m[38;2;249;38;114m->[0m[38;2;166;226;46m unit[0m[38;2;249;38;114m)[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mstr[0m[38;2;249;38;114m:[0m[38;2;166;226;46mstring[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114mnot[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mString.IsNullOrEmpty str[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mthen[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mfor[0m[38;2;248;248;242m i [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;248;248;242m [0m[38;2;249;38;114mto[0m[38;2;248;248;242m str.Length [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m [0m[38;2;249;38;114mdo[0m
[38;2;248;248;242m                    action str.[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m

[38;2;248;248;242m        [0m[38;2;102;217;239m[<CompiledName[0m[38;2;249;38;114m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mIterateIndexed[0m[38;2;230;219;116m"[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242miteri[0m[3;38;2;253;151;31m action [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mstr[0m[38;2;249;38;114m:[0m[38;2;166;226;46mstring[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114mnot[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mString.IsNullOrEmpty str[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mthen[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mf[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m OptimizedClosures.FSharpFunc[0m[38;2;249;38;114m<[0m[38;2;249;38;114m_[0m[38;2;249;38;114m,[0m[38;2;249;38;114m_[0m[38;2;249;38;114m,[0m[38;2;249;38;114m_[0m[38;2;249;38;114m>[0m[38;2;248;248;242m.Adapt[0m[38;2;249;38;114m([0m[38;2;248;248;242maction[0m[38;2;249;38;114m)[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mfor[0m[38;2;248;248;242m i [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;248;248;242m [0m[38;2;249;38;114mto[0m[38;2;248;248;242m str.Length [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m [0m[38;2;249;38;114mdo[0m
[38;2;248;248;242m                    f.Invoke[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m,[0m[38;2;248;248;242m str.[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m

[38;2;248;248;242m        [0m[38;2;102;217;239m[<CompiledName[0m[38;2;249;38;114m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mMap[0m[38;2;230;219;116m"[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mmap[0m[3;38;2;253;151;31m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mmapping[0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[38;2;166;226;46mchar [0m[38;2;249;38;114m->[0m[38;2;248;248;242m [0m[38;2;166;226;46mchar[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mstr[0m[38;2;249;38;114m:[0m[38;2;166;226;46mstring[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mif[0m[38;2;248;248;242m String.IsNullOrEmpty str [0m[38;2;249;38;114mthen[0m
[38;2;248;248;242m                String.Empty[0m
[38;2;248;248;242m            [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mresult[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m str.ToCharArray[0m[38;2;190;132;255m()[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet mutable[0m[38;2;248;248;242m [0m[38;2;248;248;242mi[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mfor[0m[38;2;248;248;242m c [0m[38;2;249;38;114min[0m[38;2;248;248;242m result [0m[38;2;249;38;114mdo[0m
[38;2;248;248;242m                    result.[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<-[0m[38;2;248;248;242m mapping c[0m
[38;2;248;248;242m                    i [0m[38;2;249;38;114m<-[0m[38;2;248;248;242m i [0m[38;2;249;38;114m+[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m

[38;2;248;248;242m                [0m[38;2;249;38;114mnew[0m[38;2;248;248;242m String[0m[38;2;249;38;114m([0m[38;2;248;248;242mresult[0m[38;2;249;38;114m)[0m

[38;2;248;248;242m        [0m[38;2;102;217;239m[<CompiledName[0m[38;2;249;38;114m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mMapIndexed[0m[38;2;230;219;116m"[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mmapi[0m[3;38;2;253;151;31m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mmapping[0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[38;2;166;226;46mint [0m[38;2;249;38;114m->[0m[38;2;248;248;242m [0m[38;2;166;226;46mchar [0m[38;2;249;38;114m->[0m[38;2;248;248;242m [0m[38;2;166;226;46mchar[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mstr[0m[38;2;249;38;114m:[0m[38;2;166;226;46mstring[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mlen[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m length str[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mif[0m[38;2;248;248;242m len [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;248;248;242m [0m[38;2;249;38;114mthen[0m[38;2;248;248;242m [0m
[38;2;248;248;242m                String.Empty[0m
[38;2;248;248;242m            [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mresult[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m str.ToCharArray[0m[38;2;190;132;255m()[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mf[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m OptimizedClosures.FSharpFunc[0m[38;2;249;38;114m<[0m[38;2;249;38;114m_[0m[38;2;249;38;114m,[0m[38;2;249;38;114m_[0m[38;2;249;38;114m,[0m[38;2;249;38;114m_[0m[38;2;249;38;114m>[0m[38;2;248;248;242m.Adapt[0m[38;2;249;38;114m([0m[38;2;248;248;242mmapping[0m[38;2;249;38;114m)[0m

[38;2;248;248;242m                [0m[38;2;249;38;114mlet mutable[0m[38;2;248;248;242m [0m[38;2;248;248;242mi[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mwhile[0m[38;2;248;248;242m i [0m[38;2;249;38;114m<[0m[38;2;248;248;242m len [0m[38;2;249;38;114mdo[0m
[38;2;248;248;242m                    result.[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<-[0m[38;2;248;248;242m f.Invoke[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m,[0m[38;2;248;248;242m result.[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;249;38;114m)[0m
[38;2;248;248;242m                    i [0m[38;2;249;38;114m<-[0m[38;2;248;248;242m i [0m[38;2;249;38;114m+[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m

[38;2;248;248;242m                [0m[38;2;249;38;114mnew[0m[38;2;248;248;242m String[0m[38;2;249;38;114m([0m[38;2;248;248;242mresult[0m[38;2;249;38;114m)[0m

[38;2;248;248;242m        [0m[38;2;102;217;239m[<CompiledName[0m[38;2;249;38;114m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mFilter[0m[38;2;230;219;116m"[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mfilter[0m[3;38;2;253;151;31m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mpredicate[0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[38;2;166;226;46mchar [0m[38;2;249;38;114m->[0m[38;2;248;248;242m [0m[38;2;166;226;46mbool[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mstr[0m[38;2;249;38;114m:[0m[38;2;166;226;46mstring[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mlen[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m length str[0m

[38;2;248;248;242m            [0m[38;2;249;38;114mif[0m[38;2;248;248;242m len [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;248;248;242m [0m[38;2;249;38;114mthen[0m[38;2;248;248;242m [0m
[38;2;248;248;242m                String.Empty[0m

[38;2;248;248;242m            [0m[38;2;249;38;114melif[0m[38;2;248;248;242m len [0m[38;2;249;38;114m>[0m[38;2;248;248;242m LOH[0m[38;2;249;38;114m_[0m[38;2;248;248;242mCHAR[0m[38;2;249;38;114m_[0m[38;2;248;248;242mTHRESHOLD [0m[38;2;249;38;114mthen[0m
[38;2;248;248;242m                [0m[38;2;117;113;94m// By using SB here, which is twice slower than the optimized path, we prevent LOH allocations [0m
[38;2;248;248;242m                [0m[38;2;117;113;94m// and 'stop the world' collections if the filtering results in smaller strings.[0m
[38;2;248;248;242m                [0m[38;2;117;113;94m// We also don't pre-allocate SB here, to allow for less mem pressure when filter result is small.[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mres[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m StringBuilder[0m[38;2;190;132;255m()[0m
[38;2;248;248;242m                str [0m[38;2;249;38;114m|>[0m[38;2;248;248;242m iter [0m[38;2;249;38;114m([0m[38;2;249;38;114mfun[0m[3;38;2;253;151;31m c [0m[38;2;249;38;114m->[0m[38;2;248;248;242m [0m[38;2;249;38;114mif[0m[38;2;248;248;242m predicate c [0m[38;2;249;38;114mthen[0m[38;2;248;248;242m res.Append c [0m[38;2;249;38;114m|>[0m[38;2;248;248;242m ignore[0m[38;2;249;38;114m)[0m
[38;2;248;248;242m                res.ToString[0m[38;2;190;132;255m()[0m

[38;2;248;248;242m            [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m                [0m[38;2;117;113;94m// Must do it this way, since array.fs is not yet in scope, but this is safe[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mtarget[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m Microsoft.FSharp.Primitives.Basics.Array.zeroCreateUnchecked len[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet mutable[0m[38;2;248;248;242m [0m[38;2;248;248;242mi[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mfor[0m[38;2;248;248;242m c [0m[38;2;249;38;114min[0m[38;2;248;248;242m str [0m[38;2;249;38;114mdo[0m
[38;2;248;248;242m                    [0m[38;2;249;38;114mif[0m[38;2;248;248;242m predicate c [0m[38;2;249;38;114mthen[0m[38;2;248;248;242m [0m
[38;2;248;248;242m                        target.[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<-[0m[38;2;248;248;242m c[0m
[38;2;248;248;242m                        i [0m[38;2;249;38;114m<-[0m[38;2;248;248;242m i [0m[38;2;249;38;114m+[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m

[38;2;248;248;242m                String[0m[38;2;249;38;114m([0m[38;2;248;248;242mtarget[0m[38;2;249;38;114m,[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m,[0m[38;2;248;248;242m i[0m[38;2;249;38;114m)[0m

[38;2;248;248;242m        [0m[38;2;102;217;239m[<CompiledName[0m[38;2;249;38;114m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mCollect[0m[38;2;230;219;116m"[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mcollect[0m[3;38;2;253;151;31m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mmapping[0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[38;2;166;226;46mchar [0m[38;2;249;38;114m->[0m[38;2;248;248;242m [0m[38;2;166;226;46mstring[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mstr[0m[38;2;249;38;114m:[0m[38;2;166;226;46mstring[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mif[0m[38;2;248;248;242m String.IsNullOrEmpty str [0m[38;2;249;38;114mthen[0m
[38;2;248;248;242m                String.Empty[0m
[38;2;248;248;242m            [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mres[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m StringBuilder str.Length[0m
[38;2;248;248;242m                str [0m[38;2;249;38;114m|>[0m[38;2;248;248;242m iter [0m[38;2;249;38;114m([0m[38;2;249;38;114mfun[0m[3;38;2;253;151;31m c [0m[38;2;249;38;114m->[0m[38;2;248;248;242m res.Append[0m[38;2;249;38;114m([0m[38;2;248;248;242mmapping c[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m|>[0m[38;2;248;248;242m ignore[0m[38;2;249;38;114m)[0m
[38;2;248;248;242m                res.ToString[0m[38;2;190;132;255m()[0m

[38;2;248;248;242m        [0m[38;2;102;217;239m[<CompiledName[0m[38;2;249;38;114m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mInitialize[0m[38;2;230;219;116m"[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242minit[0m[3;38;2;253;151;31m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mcount[0m[38;2;249;38;114m:[0m[38;2;166;226;46mint[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31minitializer[0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[38;2;166;226;46mint[0m[38;2;249;38;114m->[0m[38;2;248;248;242m [0m[38;2;166;226;46mstring[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mif[0m[38;2;248;248;242m count [0m[38;2;249;38;114m<[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;248;248;242m [0m[38;2;249;38;114mthen[0m[38;2;248;248;242m invalidArgInputMustBeNonNegative [0m[38;2;230;219;116m"[0m[38;2;230;219;116mcount[0m[38;2;230;219;116m"[0m[38;2;248;248;242m count[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mres[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m StringBuilder count[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mfor[0m[38;2;248;248;242m i [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;248;248;242m [0m[38;2;249;38;114mto[0m[38;2;248;248;242m count [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m [0m[38;2;249;38;114mdo[0m[38;2;248;248;242m [0m
[38;2;248;248;242m               res.Append[0m[38;2;249;38;114m([0m[38;2;248;248;242minitializer i[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m|>[0m[38;2;248;248;242m ignore[0m
[38;2;248;248;242m            res.ToString[0m[38;2;190;132;255m()[0m

[38;2;248;248;242m        [0m[38;2;102;217;239m[<CompiledName[0m[38;2;249;38;114m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mReplicate[0m[38;2;230;219;116m"[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mreplicate[0m[3;38;2;253;151;31m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mcount[0m[38;2;249;38;114m:[0m[38;2;166;226;46mint[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mstr[0m[38;2;249;38;114m:[0m[38;2;166;226;46mstring[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mif[0m[38;2;248;248;242m count [0m[38;2;249;38;114m<[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;248;248;242m [0m[38;2;249;38;114mthen[0m[38;2;248;248;242m invalidArgInputMustBeNonNegative [0m[38;2;230;219;116m"[0m[38;2;230;219;116mcount[0m[38;2;230;219;116m"[0m[38;2;248;248;242m count[0m

[38;2;248;248;242m            [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mlen[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m length str[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mif[0m[38;2;248;248;242m len [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;248;248;242m [0m[38;2;249;38;114m||[0m[38;2;248;248;242m count [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;248;248;242m [0m[38;2;249;38;114mthen[0m[38;2;248;248;242m [0m
[38;2;248;248;242m                String.Empty[0m

[38;2;248;248;242m            [0m[38;2;249;38;114melif[0m[38;2;248;248;242m len [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m [0m[38;2;249;38;114mthen[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mnew[0m[38;2;248;248;242m String[0m[38;2;249;38;114m([0m[38;2;248;248;242mstr.[0m[38;2;249;38;114m[[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;249;38;114m,[0m[38;2;248;248;242m count[0m[38;2;249;38;114m)[0m

[38;2;248;248;242m            [0m[38;2;249;38;114melif[0m[38;2;248;248;242m count [0m[38;2;249;38;114m<[0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m4[0m[38;2;248;248;242m [0m[38;2;249;38;114mthen[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mmatch[0m[38;2;248;248;242m count [0m[38;2;249;38;114mwith[0m
[38;2;248;248;242m                [0m[38;2;249;38;114m|[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m [0m[38;2;249;38;114m->[0m[38;2;248;248;242m str[0m
[38;2;248;248;242m                [0m[38;2;249;38;114m|[0m[38;2;248;248;242m [0m[38;2;190;132;255m2[0m[38;2;248;248;242m [0m[38;2;249;38;114m->[0m[38;2;248;248;242m String.Concat[0m[38;2;249;38;114m([0m[38;2;248;248;242mstr[0m[38;2;249;38;114m,[0m[38;2;248;248;242m str[0m[38;2;249;38;114m)[0m
[38;2;248;248;242m                [0m[38;2;249;38;114m|[0m[38;2;248;248;242m [0m[38;2;190;132;255m3[0m[38;2;248;248;242m [0m[38;2;249;38;114m->[0m[38;2;248;248;242m String.Concat[0m[38;2;249;38;114m([0m[38;2;248;248;242mstr[0m[38;2;249;38;114m,[0m[38;2;248;248;242m str[0m[38;2;249;38;114m,[0m[38;2;248;248;242m str[0m[38;2;249;38;114m)[0m
[38;2;248;248;242m                [0m[38;2;249;38;114m|[0m[38;2;248;248;242m [0m[38;2;249;38;114m_[0m[38;2;248;248;242m [0m[38;2;249;38;114m->[0m[38;2;248;248;242m String.Concat[0m[38;2;249;38;114m([0m[38;2;248;248;242mstr[0m[38;2;249;38;114m,[0m[38;2;248;248;242m str[0m[38;2;249;38;114m,[0m[38;2;248;248;242m str[0m[38;2;249;38;114m,[0m[38;2;248;248;242m str[0m[38;2;249;38;114m)[0m

[38;2;248;248;242m            [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m                [0m[38;2;117;113;94m// Using the primitive, because array.fs is not yet in scope. It's safe: both len and count are positive.[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mtarget[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m Microsoft.FSharp.Primitives.Basics.Array.zeroCreateUnchecked [0m[38;2;249;38;114m([0m[38;2;248;248;242mlen [0m[38;2;249;38;114m*[0m[38;2;248;248;242m count[0m[38;2;249;38;114m)[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242msource[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m str.ToCharArray[0m[38;2;190;132;255m()[0m

[38;2;248;248;242m                [0m[38;2;117;113;94m// O(log(n)) performance loop:[0m
[38;2;248;248;242m                [0m[38;2;117;113;94m// Copy first string, then keep copying what we already copied [0m
[38;2;248;248;242m                [0m[38;2;117;113;94m// (i.e., doubling it) until we reach or pass the halfway point[0m
[38;2;248;248;242m                Array.Copy[0m[38;2;249;38;114m([0m[38;2;248;248;242msource[0m[38;2;249;38;114m,[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m,[0m[38;2;248;248;242m target[0m[38;2;249;38;114m,[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m,[0m[38;2;248;248;242m len[0m[38;2;249;38;114m)[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet mutable[0m[38;2;248;248;242m [0m[38;2;248;248;242mi[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m len[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mwhile[0m[38;2;248;248;242m i [0m[38;2;249;38;114m*[0m[38;2;248;248;242m [0m[38;2;190;132;255m2[0m[38;2;248;248;242m [0m[38;2;249;38;114m<[0m[38;2;248;248;242m target.Length [0m[38;2;249;38;114mdo[0m
[38;2;248;248;242m                    Array.Copy[0m[38;2;249;38;114m([0m[38;2;248;248;242mtarget[0m[38;2;249;38;114m,[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m,[0m[38;2;248;248;242m target[0m[38;2;249;38;114m,[0m[38;2;248;248;242m i[0m[38;2;249;38;114m,[0m[38;2;248;248;242m i[0m[38;2;249;38;114m)[0m
[38;2;248;248;242m                    i [0m[38;2;249;38;114m<-[0m[38;2;248;248;242m i [0m[38;2;249;38;114m*[0m[38;2;248;248;242m [0m[38;2;190;132;255m2[0m

[38;2;248;248;242m                [0m[38;2;117;113;94m// finally, copy the remain half, or less-then half[0m
[38;2;248;248;242m                Array.Copy[0m[38;2;249;38;114m([0m[38;2;248;248;242mtarget[0m[38;2;249;38;114m,[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m,[0m[38;2;248;248;242m target[0m[38;2;249;38;114m,[0m[38;2;248;248;242m i[0m[38;2;249;38;114m,[0m[38;2;248;248;242m target.Length [0m[38;2;249;38;114m-[0m[38;2;248;248;242m i[0m[38;2;249;38;114m)[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mnew[0m[38;2;248;248;242m String[0m[38;2;249;38;114m([0m[38;2;248;248;242mtarget[0m[38;2;249;38;114m)[0m


[38;2;248;248;242m        [0m[38;2;102;217;239m[<CompiledName[0m[38;2;249;38;114m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mForAll[0m[38;2;230;219;116m"[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mforall[0m[3;38;2;253;151;31m predicate [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mstr[0m[38;2;249;38;114m:[0m[38;2;166;226;46mstring[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mif[0m[38;2;248;248;242m String.IsNullOrEmpty str [0m[38;2;249;38;114mthen[0m
[38;2;248;248;242m                [0m[38;2;190;132;255mtrue[0m
[38;2;248;248;242m            [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet[0m[38;2;249;38;114m rec[0m[38;2;248;248;242m [0m[38;2;248;248;242mcheck[0m[3;38;2;253;151;31m i [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mi [0m[38;2;249;38;114m>[0m[38;2;249;38;114m=[0m[38;2;248;248;242m str.Length[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m||[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mpredicate str.[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m&&[0m[38;2;248;248;242m check [0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m
[38;2;248;248;242m                check [0m[38;2;190;132;255m0[0m

[38;2;248;248;242m        [0m[38;2;102;217;239m[<CompiledName[0m[38;2;249;38;114m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mExists[0m[38;2;230;219;116m"[0m[38;2;249;38;114m)[0m[38;2;102;217;239m>][0m
[38;2;248;248;242m        [0m[38;2;249;38;114mlet[0m[38;2;248;248;242m [0m[38;2;248;248;242mexists[0m[3;38;2;253;151;31m predicate [0m[38;2;249;38;114m([0m[3;38;2;253;151;31mstr[0m[38;2;249;38;114m:[0m[38;2;166;226;46mstring[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m            [0m[38;2;249;38;114mif[0m[38;2;248;248;242m String.IsNullOrEmpty str [0m[38;2;249;38;114mthen[0m
[38;2;248;248;242m                [0m[38;2;190;132;255mfalse[0m
[38;2;248;248;242m            [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m                [0m[38;2;249;38;114mlet[0m[38;2;249;38;114m rec[0m[38;2;248;248;242m [0m[38;2;248;248;242mcheck[0m[3;38;2;253;151;31m i [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mi [0m[38;2;249;38;114m<[0m[38;2;248;248;242m str.Length[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m&&[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mpredicate str.[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m||[0m[38;2;248;248;242m check [0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m
[38;2;248;248;242m                check [0m[38;2;190;132;255m0[0m[38;2;248;248;242m  [0m
