SHELL=/bin/sh
#### Start of system configuration section. ####
srcdir = .
CC = tcc
CPPFLAGS = 
CFLAGS = $(CPPFLAGS) -A -Z -G
OPT = -f287 -mh -O
OPT2 = -f287 -mh -O
OPTAUX = 
LDFLAGS = -mh
LIBS = 
INSTALL = @INSTALL@
INSTALL_PROGRAM = @INSTALL_PROGRAM@
INSTALL_DATA = @INSTALL_DATA@
MAKEINFO = makeinfo
LIBOBJS = @LIBOBJS@

# Things you might add to DEFS:
# -DSTDC_HEADERS        If you have ANSI C headers and libraries.
# -DHAVE_STRING_H       If you don't have ANSI C headers but have string.h.
# -DHAVE_MEMORY_H       If you don't have ANSI C headers and have memory.h.
# -DHAVE_STRERROR       If you have strerror function.#
#
# -DUSE_XDR             If the Sun XDR library is available
# -DSPMD                For parallel execution
# -DBSP -DTCGMSG -DMPI -DSHMEM Must specify one of these library defs
# -DMPPMANY
DEFS = @DEFS@


prefix = @prefix@
exec_prefix = @exec_prefix@

# where the installed binary goes
bindir = $(exec_prefix)/bin


W32BIN=w32bin
PRFLAGS=-c "-DUSE_XDR -DSPMD -D__MSDOS__"
LINT=		lint
TAR=		tar
DCLAR=		dclar
ZIP=            zip
PFLAGS=		-P
EPFLAGS=	-2r
RM=             rm -f
A2FLAGS=
SHFILE=		$$file
FILES = accel algorith alloc ansi auxil beeman convert dump ewald force input \
	eigens kernel main matrix output quaterns rdf restart startup \
	values xdr parallel

CFILES= accel.c algorith.c alloc.c ansi.c auxil.c beeman.c convert.c dump.c ewald.c force.c input.c eigens.c kernel.c main.c matrix.c output.c quaterns.c rdf.c restart.c startup.c values.c xdr.c parallel.c 

OFILES= accel.o algorith.o alloc.o ansi.o auxil.o beeman.o convert.o dump.o ewald.o force.o input.o eigens.o kernel.o main.o matrix.o output.o quaterns.o rdf.o restart.o startup.o values.o xdr.o parallel.o 

LFILES= accel.ln algorith.ln alloc.ln ansi.ln auxil.ln beeman.ln convert.ln dump.ln ewald.ln force.ln input.ln eigens.ln kernel.ln main.ln matrix.ln output.ln quaterns.ln rdf.ln restart.ln startup.ln values.ln xdr.ln parallel.ln 

INFILES = 	control.water control.tip4p control.mgclh2o control.clay \
                control.argon control.tips2 control.quartz \
		tips2.in tip4p.in mgclh2o.in \
		argon.in quartz-vbst.in methane.in mcy.in \
		water-example.out tip4p-example.out \
		mgclh2o-example.out clay-example.out \
		argon-example.out tips2-example.out \
		quartz-example.out

SHAKS=	algorith alloc auxil ansi convert eigens kernel input matrix\
		quaterns restart startup values xdr ReadDCD utlsup molout

SHAKC= algorith.c alloc.c auxil.c ansi.c convert.c eigens.c kernel.c input.c matrix.c quaterns.c restart.c startup.c values.c xdr.c ReadDCD.c utlsup.c molout.c 

SHAKOBJS=algorith.o alloc.o auxil.o ansi.o convert.o eigens.o kernel.o input.o matrix.o quaterns.o restart.o startup.o values.o xdr.o ReadDCD.o utlsup.o molout.o 

UTILS = moldyext dumpanal dumpconv dumpext  manalyze bdist

UTILS2= mdshak msd mdavpos mdbond ransub mdvaf

UTILC= moldyext.c dumpanal.c dumpconv.c dumpext.c manalyze.c bdist.c mdshak.c msd.c mdavpos.c mdbond.c ransub.c mdvaf.c 

UTILO= moldyext.o dumpanal.o dumpconv.o dumpext.o manalyze.o bdist.o mdshak.o msd.o mdavpos.o mdbond.o ransub.o mdvaf.o ReadDCD.o utlsup.o molout.o 

EXTRA0 = $(UTILC) getopt.c ReadDCD.c ReadDCD.h configure.in config.h.in \
	 defconf.h aclocal.m4 config.guess config.sub list.h plotrdf \
	 utlsup.c utlsup.h molout.c elem.h

EXTRAS= $(EXTRA0) ewald-RIL.c configure Makefile.in install-sh 

HFILES=		structs.h defs.h messages.h xdr.h 
AHFILES=        string-subst.h time-subst.h stddef-subst.h stdlib-subst.h 
AHLINK= string.h time.h stddef.h stdlib.h 

FIGTEXPS=	fig_arralloc.ftx fig_dostep-a.ftx fig_dostep-b.ftx \
                fig_ewald.ftx fig_link-cell.ftx fig_main.ftx \
                fig_skewstart.ftx fig_startup-a.ftx fig_startup-b.ftx \
		fig_arralloc.ps fig_dostep-a.ps fig_dostep-b.ps \
                fig_ewald.ps fig_link-cell.ps fig_main.ps \
                fig_skewstart.ps fig_startup-a.ps fig_startup-b.ps    \
		fig_arralloc.pdf fig_dostep-a.pdf fig_dostep-b.pdf \
                fig_ewald.pdf fig_link-cell.pdf fig_main.pdf \
                fig_skewstart.pdf fig_startup-a.pdf fig_startup-b.pdf    \
		fig_arralloc-eepic.ftx fig_dostep-a-eepic.ftx \
		fig_dostep-b-eepic.ftx fig_ewald-eepic.ftx \
		fig_link-cell-eepic.ftx fig_main-eepic.ftx \
                fig_skewstart-eepic.ftx fig_startup-a-eepic.ftx \
		fig_startup-b-eepic.ftx

FIGS= figures/fig_arralloc.ftx figures/fig_dostep-a.ftx figures/fig_dostep-b.ftx figures/fig_ewald.ftx figures/fig_link-cell.ftx figures/fig_main.ftx figures/fig_skewstart.ftx figures/fig_startup-a.ftx figures/fig_startup-b.ftx figures/fig_arralloc.ps figures/fig_dostep-a.ps figures/fig_dostep-b.ps figures/fig_ewald.ps figures/fig_link-cell.ps figures/fig_main.ps figures/fig_skewstart.ps figures/fig_startup-a.ps figures/fig_startup-b.ps figures/fig_arralloc.pdf figures/fig_dostep-a.pdf figures/fig_dostep-b.pdf figures/fig_ewald.pdf figures/fig_link-cell.pdf figures/fig_main.pdf figures/fig_skewstart.pdf figures/fig_startup-a.pdf figures/fig_startup-b.pdf figures/fig_arralloc-eepic.ftx figures/fig_dostep-a-eepic.ftx figures/fig_dostep-b-eepic.ftx figures/fig_ewald-eepic.ftx figures/fig_link-cell-eepic.ftx figures/fig_main-eepic.ftx figures/fig_skewstart-eepic.ftx figures/fig_startup-a-eepic.ftx figures/fig_startup-b-eepic.ftx 

DOCCI=          READ.ME BENCHMARK COPYING RELNOTES moldy.tex moldy.sty moldy.perl
DOC=		$(DOCCI) moldy.bbl $(FIGS) 

VMSBUILD=	compile_moldy.com link_moldy.com defcomm.com\
		compile_utils.com link_utils.com compile.com

DOSBUILD=	Makefile.mak OFILES.RSP SHAKOBJS.RSP Makefile.w32

all:		moldy utilities Makefile

moldy:		$(OFILES) $(EXTRA_OBJ) $(HFILES)
		$(CC) -o moldy $(LDFLAGS) @OFILES.RSP $(EXTRA_OBJ)  $(LIBS)

moldyext:	moldyext.c $(LIBOBJS) $(HFILES)
		$(CC) $(CFLAGS) -o moldyext $(OPT) $(DEFS) $(LDFLAGS1) moldyext.c $(LIBOBJS) $(LDFLAGS) $(LIBS)

manalyze:	manalyze.c $(HFILES)
		$(CC) $(CFLAGS)  -o manalyze $(OPT) $(DEFS) $(LDFLAGS1) manalyze.c $(LDFLAGS) $(LIBS)

dumpanal:	dumpanal.c xdr.o $(HFILES)
		$(CC) $(CFLAGS) -o dumpanal $(OPT) $(DEFS) $(LDFLAGS1) dumpanal.c xdr.o  $(LDFLAGS) $(LIBS)

dumpext:	dumpext.c xdr.o utlsup.o matrix.o $(LIBOBJS) $(HFILES)
		$(CC) $(CFLAGS) -o dumpext $(OPT) $(DEFS) $(LDFLAGS1) dumpext.c xdr.o utlsup.o matrix.o $(LIBOBJS) $(LDFLAGS) $(LIBS)

dumpconv:	dumpconv.c xdr.o $(HFILES)
		$(CC) $(CFLAGS) -o dumpconv $(OPT) $(DEFS) $(LDFLAGS1) dumpconv.c xdr.o $(LDFLAGS) $(LIBS)

#mdtraj:		mdtraj.o $(SHAKOBJS) $(LIBOBJS) 
#		$(CC) -o mdtraj $(LDFLAGS) mdtraj.o $(SHAKOBJS) $(LIBOBJS) $(LIBS)

mdshak:		mdshak.o $(SHAKOBJS) $(LIBOBJS) 
		$(CC) -o mdshak $(LDFLAGS) mdshak.o @SHAKOBJS.RSP $(LIBOBJS) $(LIBS)

msd:		msd.o $(SHAKOBJS) $(LIBOBJS) 
		$(CC) -o msd $(LDFLAGS1) msd.o @SHAKOBJS.RSP $(LIBOBJS) $(LDFLAGS) $(LIBS)

mdvaf:		mdvaf.o $(SHAKOBJS) $(LIBOBJS) 
		$(CC) -o mdvaf $(LDFLAGS1) mdvaf.o @SHAKOBJS.RSP $(LIBOBJS) $(LDFLAGS) $(LIBS)
mdavpos:	mdavpos.o $(SHAKOBJS) $(LIBOBJS) 
		$(CC) -o mdavpos $(LDFLAGS1) mdavpos.o @SHAKOBJS.RSP $(LIBOBJS) $(LDFLAGS)  $(LIBS)

mdbond:	mdbond.o $(SHAKOBJS) $(LIBOBJS) 
		$(CC) -o mdbond $(LDFLAGS1) mdbond.o @SHAKOBJS.RSP $(LIBOBJS) $(LDFLAGS)  $(LIBS)

bdist:	bdist.c $(HFILES)
		$(CC) $(CFLAGS)  -o bdist $(OPT) $(DEFS) $(LDFLAGS1) bdist.c $(LIBOBJS) $(LDFLAGS) $(LIBS)

ransub:	ransub.o $(SHAKOBJS) $(LIBOBJS) 
		$(CC) -o ransub $(LDFLAGS1) ransub.o @SHAKOBJS.RSP $(LIBOBJS) $(LDFLAGS)  $(LIBS)

utilities:	$(UTILS) $(UTILS2)

Makefile:	Makefile.in configure config.guess config.sub
		./configure

configure:	configure.in aclocal.m4
		autoconf

$(FIGS):	
		(set -x;cd figures; \
		 transfig -L pstex -m 0.66; \
		 $(MAKE); \
		 mv *.ps ..;\
		 for file in *.tex; do mv $$file ../`basename $$file .tex`.ftx; done;\
		 transfig -L eepic -m 0.66;\
		 $(MAKE); \
		 for file in *.tex; do mv $$file ../`basename $$file .tex`-eepic.ftx; done;)

protoize:	$(CFILES) $(HFILES)
		protoize -k $(PRFLAGS) $(CFILES)

proto-mdshak:	mdshak.c $(SHAKC)
		protoize mdshak.c $(SHAKC)

install:	moldy $(UTILS) $(UTILS2) plotrdf
		for file in $?; do $(INSTALL) $$file $(bindir); done

Makefile.w32:	Makefile.in
		@PATH=/usr/5bin:${PATH};\
		echo	's/ -\<lm\>//\n'\
			's/@\(CC\)@/gcc/\n'\
			's/@\(CFLAGS\)@/-g/\n'\
			's/@\(OPT\)@/-O2 -ffast-math -mcpu=pentium -malign-double/\n'\
			's/@\(OPT2\)@/-O2 -ffast-math -mcpu=pentium -malign-double/\n'\
			's/@\(OPTAUX\)@/-funroll-loops/\n'\
			's/@\([A-Z][A-Z]*\)@//\n'\
			'/^.SUFFIXES/d' > makedos.sed
		sed -f makedos.sed ./Makefile.in > Makefile.mak
		@$(RM) makedos.sed

OFILES.RSP:	
		echo @OFILES.RSP   | sed -e 's/\.\<o\>/.obj/g'  > OFILES.RSP

SHAKOBJS.RSP:	
		echo @SHAKOBJS.RSP | sed -e 's/\.\<o\>/.obj/g'  > SHAKOBJS.RSP

cflow:		$(CFILES)
		cflow $(CFILES) > moldy.cflow
		cflow -r $(CFILES) > moldy.cflow.r

ci:		$(CFILES) $(HFILES) $(AHFILES) xmakefile $(EXTRA0) $(DOCCI)
		ci -u $(RCSFLAGS) $?

co:		$(CFILES) $(HFILES) $(AHFILES) xmakefile $(EXTRA0) $(DOCCI)

print:		$(CFILES) $(HFILES) $(AHFILES)
		for file in $(CFILES) $(HFILES) $(AHFILES) ;do\
			a2ps $(A2FLAGS) ${SHFILE} | lpr -l\
                        ;done
		touch print

lint:		
		$(LINT) $(XDR) $(LFLAGS) $(CFILES) -lm

lint-utils2:		
		$(LINT) $(XDR) $(LFLAGS) mdshak.c $(SHAKC) -lm
		$(LINT) $(XDR) $(LFLAGS) msd.c $(SHAKC) -lm
		$(LINT) $(XDR) $(LFLAGS) mdbond.c $(SHAKC) -lm
		$(LINT) $(XDR) $(LFLAGS) mdavpos.c $(SHAKC) -lm
		$(LINT) $(XDR) $(LFLAGS) ransub.c $(SHAKC) -lm
		$(LINT) $(XDR) $(LFLAGS) mdvaf.c $(SHAKC) -lm

lint-utils:	lint-utils2
		for file in moldyext.c dumpanal.c dumpconv.c dumpext.c manalyze.c bdist.c;do\
			$(LINT) $(XDR) $(LFLAGS) $$file\
                        ;done

tags:		$(CFILES) $(HFILES) 
		etags $(CFILES) $(HFILES)  

clean:		
		$(RM)    @OFILES.RSP $(LFILES) $(UTILO) $(LIBOBJS)\
			 moldy $(UTILS) $(UTILS2) \
			 moldy.ps moldy.dvi moldy.log moldy.blg \
                         moldy.cflow moldy.cflow.r

distclean:	clean
		$(RM)      moldy.com* moldy.tar* moldy.zip\
                           moldy.aux moldy.toc moldy.lof moldy.lot\
			   Makefile config.cache config.h config.status \
			   config.log $(AHLINK) \
			   $(DOSBUILD) $(VMSBUILD)

maintainer-clean:	distclean
		if ( [ -d RCS ] ) then\
                    rcsclean $(CFILES) $(HFILES) $(AHFILES) $(EXTRA0) $(DOC) \
                else \
                   echo "RCS directory not present."\
                        "You don't REALLY want to delete the sources do you?";\
		fi;\
		$(RM) Makefile.in configure   
#
#  Export options
#

moldy.tar:	$(CFILES) $(HFILES) $(AHFILES) \
		$(EXTRAS) $(INFILES) $(DOC) $(VMSBUILD) $(DOSBUILD)
		$(TAR) cf moldy.tar\
		$(CFILES)  $(HFILES) $(AHFILES) \
		$(EXTRAS) $(INFILES) $(DOC) $(VMSBUILD) $(DOSBUILD)

moldy.tar.Z:	moldy.tar
		compress -c moldy.tar > moldy.tar.Z

moldy.tar.gz:	moldy.tar
		gzip -c moldy.tar > moldy.tar.gz

moldy.zip:	$(CFILES) $(HFILES) $(AHFILES)  \
		$(EXTRAS) $(INFILES) $(DOC) $(VMSBUILD) $(DOSBUILD)
		$(ZIP) -l -q moldy.zip\
		$(CFILES)  $(HFILES) $(AHFILES) \
		$(EXTRAS) $(INFILES) $(DOC) $(VMSBUILD) $(DOSBUILD);\
		$(ZIP) -r -j  -q moldy.zip $(W32BIN)

compile_moldy.com:	Makefile.in
		./make_vms_compile $(FILES) > compile_moldy.com

link_moldy.com:		Makefile.in
		./make_vms_link moldy $(FILES) > link_moldy.com

compile_utils.com:	Makefile.in
		./make_vms_compile getopt ReadDCD $(UTILS) $(UTILS2) > compile_utils.com

link_utils.com:	Makefile.in
		$(RM) link_utils.com; \
		for file in $(UTILS); do ./make_vms_link $$file $$file getopt>> \
			link_utils.com; done
		for file in $(UTILS2); do \
			./make_vms_link $$file $$file getopt $(SHAKS) >> \
			link_utils.com; done

defcomm.com:	
		@echo '$$ dir = F$$TRNLNM("SYS$$DISK")+F$$DIRECTORY()' > defcomm.com
		@for prog in moldy $(UTILS) $(UTILS2); do \
		   echo "$$ $$prog :== $$'dir'$$prog" >> defcomm.com ;\
		done

compile.com:
		@/bin/echo >compile.com \
	'$$ write sys$$output "===========Building Moldy============"\n'\
	'$$ @compile_moldy\n'\
	'$$ @link_moldy\n'\
	'$$ write sys$$output "===========Building utilities========"\n'\
	'$$ @compile_utils\n'\
	'$$ @link_utils\n'\
	'$$ @defcomm\n'\
	'$$ write sys$$output "===========Done======================"'

moldy.com:	$(CFILES) $(HFILES) $(AHFILES) $(EXTRAS)\
		$(INFILES) Aaaa_Read.Me $(DOC) $(VMSBUILD) $(DOSBUILD)
		$(DCLAR) Aaaa_Read.Me compile.com $(CFILES) $(HFILES) $(AHFILES)\
		$(INFILES) $(EXTRAS) $(DOC) $(VMSBUILD)  $(DOSBUILD)\
			> moldy.com

moldy.com.Z:	moldy.com
		compress moldy.com

moldy.ps:	moldy.dvi
		TEXINPUTS=figures: dvips -Pamz -Pcmz -t a4 moldy -o moldy.ps

moldy.dvi:	moldy.tex moldy.bbl moldy.aux $(FIGS)
		TEXINPUTS=figures: latex moldy
		TEXINPUTS=figures: latex moldy
		@touch moldy.bbl

moldy.pdf:	moldy.tex moldy.bbl moldy.aux $(FIGS)
		TEXINPUTS=figures: TEXPSHEADERS=figures: pdflatex moldy
		TEXINPUTS=figures: TEXPSHEADERS=figures: pdflatex moldy
		@touch moldy.bbl

moldy.aux:	moldy.tex
		TEXINPUTS=figures:: latex moldy

$(LFILES):	$(HFILES) $(AHFILES)

#
#  Dependencies of objects on headers.
#
eigens.o quaterns.o:	defs.h

accel.o beeman.o convert.o input.o main.o output.o startup.o values.o parallel.o:	\
	structs.h defs.h messages.h

algorith.o alloc.o matrix.o:	defs.h messages.h

xdr.o restart.o dump.o:	structs.h defs.h messages.h xdr.h

ReadDCD.o:	ReadDCD.h

dumpext.o mdavpos.o mdbond.o mdshak.o mdvaf.o msd.o ransub.o: utlsup.h

ransub.o:	elem.h

mdbond.o bdist:	list.h
#
#  Special options for performance-critical modules
#
auxil.o:	auxil.c defs.h
	$(CC) $(DEFS) $(CFLAGS) $(OPTAUX) -c  $<

ewald.o:	ewald.c structs.h defs.h
	$(CC) $(DEFS) $(CFLAGS) $(OPT2) $(CFLAGSP) -c $(INLINE) $<

rdf.o:		rdf.c structs.h defs.h
	$(CC) $(DEFS) $(CFLAGS) $(OPT2) -c $<

kernel.o:	kernel.c structs.h defs.h
	$(CC) $(DEFS) $(CFLAGS) $(OPT2) $(CFLAGSP) -c $<

force.o:	force.c structs.h defs.h
	$(CC) $(DEFS) $(CFLAGS) $(OPT2) $(CFLAGSP) $(INLINE) -c $<

#
#  Rule for checking out source under RCS
#

ewald-RIL.c:
	 cvs co -p -r RIL moldy/src/ewald.c > ewald-RIL.c


.c.o:
	$(CC) $(DEFS) $(CFLAGS) $(OPT) -c $<
